/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsQuickListContentProvider
implements VcsQuickListContentProvider {
    @Nullable
    public List<AnAction> getVcsActions(@Nullable Project project, @Nullable AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null || !this.getVcsName().equals(activeVcs.getName())) {
            return null;
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        actions2.add((AnAction)new Separator(activeVcs.getDisplayName()));
        DvcsQuickListContentProvider.add("CheckinProject", manager, actions2);
        DvcsQuickListContentProvider.add("CheckinFiles", manager, actions2);
        DvcsQuickListContentProvider.add("ChangesView.Revert", manager, actions2);
        DvcsQuickListContentProvider.addSeparator(actions2);
        DvcsQuickListContentProvider.add("Vcs.ShowTabbedFileHistory", manager, actions2);
        DvcsQuickListContentProvider.add("Annotate", manager, actions2);
        DvcsQuickListContentProvider.add("Compare.SameVersion", manager, actions2);
        DvcsQuickListContentProvider.addSeparator(actions2);
        this.addVcsSpecificActions(manager, actions2);
        return actions2;
    }

    @NotNull
    protected abstract String getVcsName();

    protected abstract void addVcsSpecificActions(@NotNull ActionManager var1, @NotNull List<AnAction> var2);

    public boolean replaceVcsActionsFor(@NotNull AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeVcs", "com/intellij/dvcs/actions/DvcsQuickListContentProvider", "replaceVcsActionsFor"));
        }
        return this.getVcsName().equals(activeVcs.getName());
    }

    protected static void addSeparator(@NotNull List<AnAction> actions2) {
        if (actions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/dvcs/actions/DvcsQuickListContentProvider", "addSeparator"));
        }
        actions2.add((AnAction)new Separator());
    }

    protected static void add(String actionName, ActionManager manager, List<AnAction> actions2) {
        AnAction action = manager.getAction(actionName);
        assert (action != null) : "Can not find action " + actionName;
        actions2.add(action);
    }
}

