/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CheckBoxList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CompoundRunConfigurationSettingsEditor
extends SettingsEditor<CompoundRunConfiguration> {
    @NotNull
    private final Project myProject;
    private final CheckBoxList<RunConfiguration> myList;
    private List<RunConfiguration> myChecked;
    private final RunManagerImpl myRunManager;

    public CompoundRunConfigurationSettingsEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor", "<init>"));
        }
        this.myChecked = new ArrayList<RunConfiguration>();
        this.myProject = project;
        this.myRunManager = RunManagerImpl.getInstanceImpl(this.myProject);
        this.myList = new CheckBoxList<RunConfiguration>(){

            protected void adjustRendering(JCheckBox checkBox, int index, boolean selected, boolean hasFocus) {
                RunConfiguration configuration = (RunConfiguration)this.getItemAt(index);
                assert (configuration != null);
                checkBox.setText(configuration.getType().getDisplayName() + " '" + configuration.getName() + "'");
            }
        };
        this.myList.setVisibleRowCount(100);
    }

    private void updateModel(@NotNull CompoundRunConfiguration s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor", "updateModel"));
        }
        List<RunConfiguration> list = this.myRunManager.getAllConfigurationsList();
        Collections.sort(list, CompoundRunConfiguration.COMPARATOR);
        for (RunConfiguration configuration : list) {
            if (!this.canBeAdded(configuration, s)) continue;
            this.myList.addItem((Object)configuration, configuration.getName(), this.myChecked.contains(configuration));
        }
    }

    private boolean canBeAdded(@NotNull RunConfiguration candidate, @NotNull CompoundRunConfiguration root) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor", "canBeAdded"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor", "canBeAdded"));
        }
        if (candidate == root) {
            return false;
        }
        List<BeforeRunTask> tasks = this.myRunManager.getBeforeRunTasks(candidate);
        for (BeforeRunTask task : tasks) {
            RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runTask;
            RunnerAndConfigurationSettings settings;
            if (!(task instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || (settings = (runTask = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task).getSettings()) == null || this.canBeAdded(settings.getConfiguration(), root)) continue;
            return false;
        }
        if (candidate instanceof CompoundRunConfiguration) {
            Set<RunConfiguration> set = ((CompoundRunConfiguration)candidate).getSetToRun();
            for (RunConfiguration configuration : set) {
                if (this.canBeAdded(configuration, root)) continue;
                return false;
            }
        }
        return true;
    }

    protected void resetEditorFrom(CompoundRunConfiguration s) {
        this.myChecked.clear();
        this.myChecked.addAll(s.getSetToRun());
        this.updateModel(s);
    }

    protected void applyEditorTo(CompoundRunConfiguration s) throws ConfigurationException {
        HashSet<RunConfiguration> checked = new HashSet<RunConfiguration>();
        for (int i = 0; i < this.myList.getItemsCount(); ++i) {
            RunConfiguration configuration = (RunConfiguration)this.myList.getItemAt(i);
            if (!this.myList.isItemSelected((Object)configuration)) continue;
            checked.add(configuration);
        }
        Set<RunConfiguration> toRun = s.getSetToRun();
        toRun.clear();
        toRun.addAll(checked);
    }

    @NotNull
    protected JComponent createEditor() {
        CheckBoxList<RunConfiguration> checkBoxList = this.myList;
        if (checkBoxList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor", "createEditor"));
        }
        return checkBoxList;
    }
}

