/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchComponent;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.editorHeaderActions.EditorHeaderAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.Icon;

public class FindAllAction
extends EditorHeaderAction
implements DumbAware {
    public FindAllAction(EditorSearchComponent editorSearchComponent) {
        super(editorSearchComponent);
        Icon base = AllIcons.Actions.Find;
        Icon text = IconUtil.textToIcon((String)"ALL", (Component)editorSearchComponent, (float)JBUI.scale((float)6.0f));
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(base, 0);
        icon.setIcon(text, 1, 0, base.getIconHeight() - text.getIconHeight());
        this.getTemplatePresentation().setIcon((Icon)icon);
        this.getTemplatePresentation().setDescription("Export matches to Find tool window");
        this.getTemplatePresentation().setText("Find All");
        AnAction findUsages = ActionManager.getInstance().getAction("FindUsages");
        if (findUsages != null) {
            this.registerCustomShortcutSet(findUsages.getShortcutSet(), editorSearchComponent.getSearchField());
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Editor editor = this.getEditorSearchComponent().getEditor();
        Project project = editor.getProject();
        if (project != null && !project.isDisposed()) {
            e.getPresentation().setEnabled(this.getEditorSearchComponent().hasMatches() && PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) != null);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = this.getEditorSearchComponent().getEditor();
        Project project = editor.getProject();
        if (project != null && !project.isDisposed()) {
            FindModel model = FindManager.getInstance((Project)project).getFindInFileModel();
            FindModel realModel = model.clone();
            String text = this.getEditorSearchComponent().getTextInField();
            if (StringUtil.isEmpty((String)text)) {
                return;
            }
            realModel.setStringToFind(text);
            FindUtil.findAllAndShow(project, editor, realModel);
        }
    }
}

