/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.AWTEvent;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.SwingUtilities;

public final class IdePopupManager
implements IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.IdePopupManager");
    private final List<IdePopupEventDispatcher> myDispatchStack = ContainerUtil.createLockFreeCopyOnWriteList();

    boolean isPopupActive() {
        for (IdePopupEventDispatcher each : this.myDispatchStack) {
            if (each.getComponent() != null && each.getComponent().isShowing()) continue;
            this.myDispatchStack.remove(each);
        }
        return this.myDispatchStack.size() > 0;
    }

    @Override
    public boolean dispatch(final AWTEvent e) {
        LOG.assertTrue(this.isPopupActive());
        if (e.getID() == 208) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!IdePopupManager.this.isPopupActive()) {
                        return;
                    }
                    Window focused = ((WindowEvent)e).getOppositeWindow();
                    if (focused == null) {
                        focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                    }
                    if (focused == null) {
                        IdePopupManager.this.closeAllPopups();
                    }
                }
            });
        }
        if (e instanceof KeyEvent || e instanceof MouseEvent) {
            for (int i = this.myDispatchStack.size() - 1; i >= 0 && i < this.myDispatchStack.size(); --i) {
                boolean dispatched = this.myDispatchStack.get(i).dispatch(e);
                if (!dispatched) continue;
                return true;
            }
        }
        return false;
    }

    public void push(IdePopupEventDispatcher dispatcher) {
        if (!this.myDispatchStack.contains(dispatcher)) {
            this.myDispatchStack.add(dispatcher);
        }
    }

    public void remove(IdePopupEventDispatcher dispatcher) {
        this.myDispatchStack.remove(dispatcher);
    }

    public boolean closeAllPopups() {
        if (this.myDispatchStack.size() == 0) {
            return false;
        }
        boolean closed = true;
        for (IdePopupEventDispatcher each : this.myDispatchStack) {
            closed &= each.close();
        }
        return closed;
    }

    public boolean requestDefaultFocus(boolean forced) {
        if (!this.isPopupActive()) {
            return false;
        }
        return this.myDispatchStack.get(this.myDispatchStack.size() - 1).requestFocus();
    }
}

