/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IconProvider;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlatformUtils;
import java.util.Collection;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiDirectoryNode
extends BasePsiNode<PsiDirectory>
implements NavigatableWithText {
    public PsiDirectoryNode(Project project, PsiDirectory value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    protected boolean shouldShowModuleName() {
        return !PlatformUtils.isCidr();
    }

    @Override
    protected void updateImpl(PresentationData data) {
        String name;
        Project project = this.getProject();
        assert (project != null) : this;
        PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
        assert (psiDirectory != null) : this;
        VirtualFile directoryFile = psiDirectory.getVirtualFile();
        Object parentValue = this.getParentValue();
        if (ProjectRootsUtil.isModuleContentRoot(directoryFile, project)) {
            ProjectFileIndex fi = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Module module = fi.getModuleForFile(directoryFile);
            data.setPresentableText(directoryFile.getName());
            if (module != null) {
                if (!(parentValue instanceof Module)) {
                    if (!this.shouldShowModuleName()) {
                        data.addText(directoryFile.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (Comparing.equal((String)module.getName(), (String)directoryFile.getName())) {
                        data.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        data.addText(directoryFile.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        data.addText("[" + module.getName() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                } else {
                    data.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                if (parentValue instanceof Module || parentValue instanceof Project) {
                    String location = FileUtil.getLocationRelativeToUserHome((String)directoryFile.getPresentableUrl());
                    data.addText(" (" + location + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    ModuleSourceRootEditHandler handler;
                    SourceFolder sourceRoot = ProjectRootsUtil.getModuleSourceRoot(directoryFile, project);
                    if (sourceRoot != null && (handler = ModuleSourceRootEditHandler.getEditHandler(sourceRoot.getRootType())) != null) {
                        String rootTypeName = handler.getRootTypeName();
                        data.addText(" (" + rootTypeName.toLowerCase(Locale.getDefault()) + " root)", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
                this.setupIcon(data, psiDirectory);
                return;
            }
        }
        String string = name = parentValue instanceof Project ? psiDirectory.getVirtualFile().getPresentableUrl() : ProjectViewDirectoryHelper.getInstance(psiDirectory.getProject()).getNodeName(this.getSettings(), parentValue, psiDirectory);
        if (name == null) {
            this.setValue(null);
            return;
        }
        data.setPresentableText(name);
        if (ProjectRootsUtil.isLibraryRoot(directoryFile, project)) {
            data.setLocationString("library home");
        } else {
            data.setLocationString(ProjectViewDirectoryHelper.getInstance(project).getLocationString(psiDirectory));
        }
        this.setupIcon(data, psiDirectory);
    }

    protected void setupIcon(PresentationData data, PsiDirectory psiDirectory) {
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        if (PlatformUtils.isAppCode()) {
            Icon icon = IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)this.myProject);
            if (icon != null) {
                data.setIcon(this.patchIcon(icon, virtualFile));
            }
        } else {
            for (IconProvider provider : (IconProvider[])Extensions.getExtensions((ExtensionPointName)IconProvider.EXTENSION_POINT_NAME)) {
                Icon icon = provider.getIcon((PsiElement)psiDirectory, 0);
                if (icon == null) continue;
                data.setIcon(this.patchIcon(icon, virtualFile));
                return;
            }
        }
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        return ProjectViewDirectoryHelper.getInstance(this.myProject).getDirectoryChildren((PsiDirectory)this.getValue(), this.getSettings(), true);
    }

    public String getTestPresentation() {
        return "PsiDirectory: " + ((PsiDirectory)this.getValue()).getName();
    }

    public boolean isFQNameShown() {
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).isShowFQName(this.getSettings(), this.getParentValue(), (PsiDirectory)this.getValue());
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/PsiDirectoryNode", "contains"));
        }
        PsiDirectory value = (PsiDirectory)this.getValue();
        if (value == null) {
            return false;
        }
        VirtualFile directory = value.getVirtualFile();
        if (directory.getFileSystem() instanceof LocalFileSystem) {
            file = PathUtil.getLocalFile((VirtualFile)file);
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)file, (boolean)false)) {
            return false;
        }
        if (Registry.is((String)"ide.hide.excluded.files")) {
            Project project = value.getProject();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            return !fileIndex.isExcluded(file);
        }
        return !FileTypeRegistry.getInstance().isFileIgnored(file);
    }

    public VirtualFile getVirtualFile() {
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory == null) {
            return null;
        }
        return directory.getVirtualFile();
    }

    public boolean canRepresent(Object element) {
        if (super.canRepresent(element)) {
            return true;
        }
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory == null) {
            return false;
        }
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).canRepresent(element, directory);
    }

    @Override
    public boolean canNavigate() {
        VirtualFile file = this.getVirtualFile();
        Project project = this.getProject();
        ProjectSettingsService service = ProjectSettingsService.getInstance(this.myProject);
        return file != null && (ProjectRootsUtil.isModuleContentRoot(file, project) && service.canOpenModuleSettings() || ProjectRootsUtil.isModuleSourceRoot(file, project) && service.canOpenContentEntriesSettings() || ProjectRootsUtil.isLibraryRoot(file, project) && service.canOpenModuleLibrarySettings());
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)this.getValue()));
        if (module != null) {
            VirtualFile file = this.getVirtualFile();
            Project project = this.getProject();
            ProjectSettingsService service = ProjectSettingsService.getInstance(this.myProject);
            if (ProjectRootsUtil.isModuleContentRoot(file, project)) {
                service.openModuleSettings(module);
            } else if (ProjectRootsUtil.isLibraryRoot(file, project)) {
                OrderEntry orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)file, (Project)module.getProject());
                if (orderEntry != null) {
                    service.openLibraryOrSdkSettings(orderEntry);
                }
            } else {
                service.openContentEntriesSettings(module);
            }
        }
    }

    public String getNavigateActionText(boolean focusEditor) {
        VirtualFile file = this.getVirtualFile();
        Project project = this.getProject();
        if (file != null && project != null) {
            if (ProjectRootsUtil.isModuleContentRoot(file, project) || ProjectRootsUtil.isModuleSourceRoot(file, project)) {
                return "Open Module Settings";
            }
            if (ProjectRootsUtil.isLibraryRoot(file, project)) {
                return "Open Library Settings";
            }
        }
        return null;
    }

    public int getWeight() {
        ProjectView projectView = ProjectView.getInstance(this.myProject);
        if (projectView instanceof ProjectViewImpl && !((ProjectViewImpl)projectView).isFoldersAlwaysOnTop()) {
            return 20;
        }
        return this.isFQNameShown() ? 70 : 0;
    }

    public String getTitle() {
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory != null) {
            return PsiDirectoryFactory.getInstance(this.getProject()).getQualifiedName(directory, true);
        }
        return super.getTitle();
    }

    protected Icon patchIcon(Icon original, VirtualFile file) {
        Icon icon = original;
        Bookmark bookmarkAtFile = BookmarkManager.getInstance(this.myProject).findFileBookmark(file);
        if (bookmarkAtFile != null) {
            RowIcon composite = new RowIcon(2, RowIcon.Alignment.CENTER);
            composite.setIcon(icon, 0);
            composite.setIcon(bookmarkAtFile.getIcon(), 1);
            icon = composite;
        }
        if (!file.isWritable()) {
            icon = LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.LOCKED_ICON);
        }
        if (file.is(VFileProperty.SYMLINK)) {
            icon = LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.SYMLINK_ICON);
        }
        return icon;
    }

    public Comparable getSortKey() {
        if (ProjectAttachProcessor.canAttachToProject()) {
            VirtualFile file = this.getVirtualFile();
            if (Comparing.equal((Object)file, (Object)this.myProject.getBaseDir())) {
                return "";
            }
            return this.getTitle();
        }
        return null;
    }

    public Comparable getTypeSortKey() {
        String extension;
        VirtualFile file = this.getVirtualFile();
        if (file != null && (extension = file.getExtension()) != null) {
            return new PsiFileNode.ExtensionSortKey(extension);
        }
        return null;
    }

    public String getQualifiedNameSortKey() {
        PsiDirectoryFactory factory = PsiDirectoryFactory.getInstance(this.getProject());
        return factory.getQualifiedName((PsiDirectory)this.getValue(), true);
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 3;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        VirtualFile file = this.getVirtualFile();
        return file == null || file.getChildren().length > 0;
    }
}

