/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Color;
import java.util.HashSet;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class IntelliJLaf
extends DarculaLaf {
    @Override
    public String getName() {
        return "IntelliJ";
    }

    @Override
    protected String getPrefix() {
        return "intellijlaf";
    }

    @Override
    protected DefaultMetalTheme createMetalTheme() {
        return new IdeaBlueMetalTheme();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = super.getDefaults();
        if (SystemInfo.isMacOSYosemite) {
            IntelliJLaf.installMacOSXFonts(defaults);
        }
        return defaults;
    }

    private static void installMacOSXFonts(UIDefaults defaults) {
        String face = "HelveticaNeue-CondensedBlack";
        LafManagerImpl.initFontDefaults(defaults, face, 13);
        for (Object key : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value = defaults.get(key);
            if (!(value instanceof FontUIResource) || !(font = (FontUIResource)value).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key.toString().contains("Menu")) continue;
            defaults.put(key, new FontUIResource(face, font.getStyle(), font.getSize()));
        }
        FontUIResource buttonFont = new FontUIResource("HelveticaNeue-Medium", 0, 13);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = new FontUIResource("Lucida Grande", 0, 14);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
    }

    public static boolean isGraphite() {
        Color c = UIManager.getColor("controlHighlight");
        return c != null && c.getBlue() < 150;
    }
}

