/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class MacIntelliJButtonUI
extends DarculaButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static final Icon LEFT = DarculaLaf.loadIcon("buttonLeft.png");
    private static final Icon RIGHT = DarculaLaf.loadIcon("buttonRight.png");
    private static final Icon MIDDLE = DarculaLaf.loadIcon("buttonMiddle.png");
    private static final Icon LEFT_SELECTED = DarculaLaf.loadIcon("selectedButtonLeft.png");
    private static final Icon RIGHT_SELECTED = DarculaLaf.loadIcon("selectedButtonRight.png");
    private static final Icon MIDDLE_SELECTED = DarculaLaf.loadIcon("selectedButtonMiddle.png");
    private static final Icon LEFT_FOCUSED = DarculaLaf.loadIcon("focusedButtonLeft.png");
    private static final Icon RIGHT_FOCUSED = DarculaLaf.loadIcon("focusedButtonRight.png");
    private static final Icon MIDDLE_FOCUSED = DarculaLaf.loadIcon("focusedButtonMiddle.png");
    private static final Icon LEFT_SELECTED_FOCUSED = DarculaLaf.loadIcon("focusedSelectedButtonLeft.png");
    private static final Icon RIGHT_SELECTED_FOCUSED = DarculaLaf.loadIcon("focusedSelectedButtonRight.png");
    private static final Icon MIDDLE_SELECTED_FOCUSED = DarculaLaf.loadIcon("focusedSelectedButtonMiddle.png");
    private static final Icon HELP_BUTTON = DarculaLaf.loadIcon("helpButton.png");
    private static final Icon HELP_BUTTON_FOCUSED = DarculaLaf.loadIcon("focusedHelpButton.png");

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJButtonUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (MacIntelliJButtonUI.isHelpButton(c)) {
            Icon icon = c.hasFocus() ? HELP_BUTTON_FOCUSED : HELP_BUTTON;
            int x = (w - icon.getIconWidth()) / 2;
            int y = (h - icon.getIconHeight()) / 2;
            icon.paintIcon(c, g, x, y);
        } else {
            AbstractButton b = (AbstractButton)c;
            String text = this.layout(b, SwingUtilities2.getFontMetrics((JComponent)b, g), b.getWidth(), b.getHeight());
            boolean isDefault = b instanceof JButton && ((JButton)b).isDefaultButton();
            boolean isFocused = c.hasFocus();
            if (MacIntelliJButtonUI.isSquare(c)) {
                g.setColor((Color)Gray.xFF);
                g.fillRect(1, 1, w - 2, h - 2);
                g.setColor((Color)Gray.xB4);
                g.drawRect(1, 1, w - 2, h - 2);
            } else {
                int y;
                int x = isFocused ? 0 : 2;
                int n = y = isFocused ? 0 : (h - MacIntelliJButtonUI.viewRect.height) / 2;
                Icon icon = isDefault ? (isFocused ? LEFT_SELECTED_FOCUSED : LEFT_SELECTED) : (isFocused ? LEFT_FOCUSED : LEFT);
                icon.paintIcon(b, g, x, y);
                int stop = w - (isFocused ? 0 : 2) - (isFocused ? RIGHT_FOCUSED.getIconWidth() : RIGHT.getIconWidth());
                Graphics gg = g.create(0, 0, w, h);
                gg.setClip(x += icon.getIconWidth(), y, stop - x, h);
                Icon icon2 = isDefault ? (isFocused ? MIDDLE_SELECTED_FOCUSED : MIDDLE_SELECTED) : (icon = isFocused ? MIDDLE_FOCUSED : MIDDLE);
                while (x < stop) {
                    icon.paintIcon(b, gg, x, y);
                    x += icon.getIconWidth();
                }
                gg.dispose();
                icon = isDefault ? (isFocused ? RIGHT_SELECTED_FOCUSED : RIGHT_SELECTED) : (isFocused ? RIGHT_FOCUSED : RIGHT);
                icon.paintIcon(b, g, stop, y);
                this.clearTextShiftOffset();
            }
            if (b.getIcon() != null) {
                this.paintIcon(g, c, iconRect);
            }
            if (text != null && !text.isEmpty()) {
                View v = (View)c.getClientProperty("html");
                if (v != null) {
                    v.paint(g, textRect);
                } else {
                    this.paintText(g, b, textRect, text);
                }
            }
        }
    }

    private String layout(AbstractButton b, FontMetrics fm, int width, int height) {
        Insets i = b.getInsets();
        MacIntelliJButtonUI.viewRect.x = i.left;
        MacIntelliJButtonUI.viewRect.y = i.top;
        MacIntelliJButtonUI.viewRect.width = width - (i.right + MacIntelliJButtonUI.viewRect.x);
        MacIntelliJButtonUI.viewRect.height = height - (i.bottom + MacIntelliJButtonUI.viewRect.y);
        MacIntelliJButtonUI.textRect.height = 0;
        MacIntelliJButtonUI.textRect.width = 0;
        MacIntelliJButtonUI.textRect.y = 0;
        MacIntelliJButtonUI.textRect.x = 0;
        MacIntelliJButtonUI.iconRect.height = 0;
        MacIntelliJButtonUI.iconRect.width = 0;
        MacIntelliJButtonUI.iconRect.y = 0;
        MacIntelliJButtonUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        return new Dimension(size.width + 16, 27);
    }
}

