/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.util.ActionRunner;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformPackageUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.util.PlatformPackageUtil");

    @Nullable
    private static String findLongestExistingPackage(Project project, String packageName, GlobalSearchScope scope) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        DirectoryIndex index = DirectoryIndex.getInstance(project);
        String nameToMatch = packageName;
        while (true) {
            Query<VirtualFile> vFiles;
            PsiDirectory directory;
            if ((directory = PlatformPackageUtil.getWritableModuleDirectory(vFiles = index.getDirectoriesByPackageName(nameToMatch, false), scope, manager)) != null) {
                return index.getPackageName(directory.getVirtualFile());
            }
            int lastDotIndex = nameToMatch.lastIndexOf(46);
            if (lastDotIndex < 0) break;
            nameToMatch = nameToMatch.substring(0, lastDotIndex);
        }
        return null;
    }

    @Nullable
    private static PsiDirectory getWritableModuleDirectory(@NotNull Query<VirtualFile> vFiles, GlobalSearchScope scope, PsiManager manager) {
        if (vFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFiles", "com/intellij/ide/util/PlatformPackageUtil", "getWritableModuleDirectory"));
        }
        for (VirtualFile vFile : vFiles) {
            PsiDirectory directory;
            if (!scope.contains(vFile) || (directory = manager.findDirectory(vFile)) == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(final @NotNull Project project, @Nullable Module module, GlobalSearchScope scope, String packageName, PsiDirectory baseDir, boolean askUserToCreate, ThreeState chooseFlag) throws IncorrectOperationException {
        String rootPackage;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/PlatformPackageUtil", "findOrCreateDirectoryForPackage"));
        }
        PsiDirectory psiDirectory = null;
        if (chooseFlag == ThreeState.UNSURE && !"".equals(packageName) && (rootPackage = PlatformPackageUtil.findLongestExistingPackage(project, packageName, scope)) != null) {
            int beginIndex = rootPackage.length() + 1;
            packageName = beginIndex < packageName.length() ? packageName.substring(beginIndex) : "";
            String postfixToShow = packageName.replace('.', File.separatorChar);
            if (packageName.length() > 0) {
                postfixToShow = File.separatorChar + postfixToShow;
            }
            if ((psiDirectory = DirectoryChooserUtil.selectDirectory(project, PlatformPackageUtil.getPackageDirectories(project, rootPackage, scope), baseDir, postfixToShow)) == null) {
                return null;
            }
        }
        if (psiDirectory == null) {
            if (chooseFlag == ThreeState.NO && baseDir != null) {
                VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(baseDir.getVirtualFile());
                psiDirectory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
            } else {
                if (module != null && !PlatformPackageUtil.checkSourceRootsConfigured(module)) {
                    return null;
                }
                final GlobalSearchScope scope_ = scope;
                List dirs = ContainerUtil.mapNotNull((Object[])ProjectRootManager.getInstance((Project)project).getContentSourceRoots(), (Function)new Function<VirtualFile, PsiDirectory>(){

                    public PsiDirectory fun(VirtualFile virtualFile) {
                        return scope_.contains(virtualFile) ? PsiManager.getInstance((Project)project).findDirectory(virtualFile) : null;
                    }
                });
                psiDirectory = DirectoryChooserUtil.selectDirectory(project, dirs.toArray(new PsiDirectory[dirs.size()]), baseDir, File.separatorChar + packageName.replace('.', File.separatorChar));
                if (psiDirectory == null) {
                    return null;
                }
                VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(psiDirectory.getVirtualFile());
                psiDirectory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
            }
        }
        String restOfName = packageName;
        boolean askedToCreate = false;
        while (restOfName.length() > 0) {
            final String name = PlatformPackageUtil.getLeftPart(restOfName);
            PsiDirectory foundExistingDirectory = psiDirectory.findSubdirectory(name);
            if (foundExistingDirectory == null) {
                if (!askedToCreate && askUserToCreate) {
                    int toCreate;
                    if (!ApplicationManager.getApplication().isUnitTestMode() && (toCreate = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"prompt.create.non.existing.package", (Object[])new Object[]{packageName}), (String)IdeBundle.message((String)"title.package.not.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                        return null;
                    }
                    askedToCreate = true;
                }
                final PsiDirectory psiDirectory_ = psiDirectory;
                try {
                    psiDirectory = (PsiDirectory)ActionRunner.runInsideWriteAction((ActionRunner.InterruptibleRunnableWithResult)new ActionRunner.InterruptibleRunnableWithResult<PsiDirectory>(){

                        public PsiDirectory run() throws Exception {
                            return psiDirectory_.createSubdirectory(name);
                        }
                    });
                }
                catch (IncorrectOperationException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new IncorrectOperationException((Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            } else {
                psiDirectory = foundExistingDirectory;
            }
            restOfName = PlatformPackageUtil.cutLeftPart(restOfName);
        }
        return psiDirectory;
    }

    public static GlobalSearchScope adjustScope(PsiDirectory baseDir, GlobalSearchScope scope, boolean skipSourceDirsForBaseTestDirectory, boolean skipTestDirsForBaseSourceDirectory) {
        if (baseDir != null) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)baseDir.getProject()).getFileIndex();
            if (fileIndex.isInTestSourceContent(baseDir.getVirtualFile())) {
                if (skipSourceDirsForBaseTestDirectory) {
                    return scope.intersectWith(GlobalSearchScopes.projectTestScope((Project)baseDir.getProject()));
                }
            } else if (skipTestDirsForBaseSourceDirectory) {
                return scope.intersectWith(GlobalSearchScopes.projectProductionScope((Project)baseDir.getProject()));
            }
        }
        return scope;
    }

    private static PsiDirectory[] getPackageDirectories(Project project, String rootPackage, final GlobalSearchScope scope) {
        final PsiManager manager = PsiManager.getInstance((Project)project);
        FilteredQuery query = DirectoryIndex.getInstance(scope.getProject()).getDirectoriesByPackageName(rootPackage, true);
        query = new FilteredQuery(query, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                return scope.contains(virtualFile);
            }
        });
        List directories = ContainerUtil.mapNotNull((Collection)query.findAll(), (Function)new Function<VirtualFile, PsiDirectory>(){

            public PsiDirectory fun(VirtualFile virtualFile) {
                return manager.findDirectory(virtualFile);
            }
        });
        return directories.toArray(new PsiDirectory[directories.size()]);
    }

    private static boolean checkSourceRootsConfigured(Module module) {
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (sourceRoots.length == 0) {
            Messages.showErrorDialog((Project)module.getProject(), (String)ProjectBundle.message((String)"module.source.roots.not.configured.error", (Object[])new Object[]{module.getName()}), (String)ProjectBundle.message((String)"module.source.roots.not.configured.title", (Object[])new Object[0]));
            ProjectSettingsService.getInstance(module.getProject()).showModuleConfigurationDialog(module.getName(), CommonContentEntriesEditor.NAME);
            sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            if (sourceRoots.length == 0) {
                return false;
            }
        }
        return true;
    }

    private static String getLeftPart(String packageName) {
        int index = packageName.indexOf(46);
        return index > -1 ? packageName.substring(0, index) : packageName;
    }

    private static String cutLeftPart(String packageName) {
        int index = packageName.indexOf(46);
        return index > -1 ? packageName.substring(index + 1) : "";
    }

    @Nullable
    public static PsiDirectory findPossiblePackageDirectoryInModule(Module module, GlobalSearchScope scope, String packageName) {
        VirtualFile[] sourceRoots;
        PsiDirectory[] psiDirectories;
        String rootPackage;
        if (!"".equals(packageName) && (rootPackage = PlatformPackageUtil.findLongestExistingPackage(module.getProject(), packageName, scope)) != null && (psiDirectories = PlatformPackageUtil.getPackageDirectories(module.getProject(), rootPackage, scope)).length > 0) {
            return psiDirectories[0];
        }
        if (!PlatformPackageUtil.checkSourceRootsConfigured(module)) {
            return null;
        }
        for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            PsiDirectory directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(sourceRoot);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getDirectory(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file = FileContextUtil.getContextFile(element);
        return file == null ? null : file.getContainingDirectory();
    }
}

