/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.Patches;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoFileAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.EdtSortingModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseByNameBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ChooseByNameBase");
    protected final Project myProject;
    protected final ChooseByNameModel myModel;
    protected ChooseByNameItemProvider myProvider;
    protected final String myInitialText;
    private boolean mySearchInAnyPlace;
    protected Component myPreviouslyFocusedComponent;
    private boolean myInitialized;
    protected final JPanelProvider myTextFieldPanel;
    protected final MyTextField myTextField;
    private final CardLayout myCard;
    private final JPanel myCardContainer;
    protected JCheckBox myCheckBox;
    private JComponent myToolArea;
    protected JScrollPane myListScrollPane;
    private final MyListModel<Object> myListModel;
    protected final JList myList;
    private final List<Pair<String, Integer>> myHistory;
    private final List<Pair<String, Integer>> myFuture;
    protected ChooseByNamePopupComponent.Callback myActionListener;
    protected final Alarm myAlarm;
    private final ListUpdater myListUpdater;
    private boolean myDisposedFlag;
    private ActionCallback myPostponedOkAction;
    private final String[][] myNames;
    private volatile CalcElementsThread myCalcElementsThread;
    private static int VISIBLE_LIST_SIZE_LIMIT = 10;
    private int myListSizeIncreasing;
    private int myMaximumListSizeLimit;
    @NonNls
    private static final String NOT_FOUND_IN_PROJECT_CARD = "syslib";
    @NonNls
    private static final String NOT_FOUND_CARD = "nfound";
    @NonNls
    private static final String CHECK_BOX_CARD = "chkbox";
    @NonNls
    private static final String SEARCHING_CARD = "searching";
    private final int myRebuildDelay;
    private final Alarm myHideAlarm;
    private boolean myShowListAfterCompletionKeyStroke;
    protected JBPopup myTextPopup;
    protected JBPopup myDropdownPopup;
    private boolean myClosedByShiftEnter;
    protected final int myInitialIndex;
    private String myFindUsagesTitle;
    private ShortcutSet myCheckBoxShortcut;
    protected boolean myInitIsDone;
    static final boolean ourLoadNamesEachTime = FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    private boolean myFixLostTyping;
    private boolean myAlwaysHasMore;
    public static final String EXTRA_ELEM = "...";
    public static final String NON_PREFIX_SEPARATOR = "non-prefix matches:";
    private static final String ACTION_NAME = "Show All in View";

    public boolean checkDisposed() {
        if (this.myDisposedFlag && this.myPostponedOkAction != null && !this.myPostponedOkAction.isProcessed()) {
            this.myPostponedOkAction.setRejected();
        }
        return this.myDisposedFlag;
    }

    public void setDisposed(boolean disposedFlag) {
        this.myDisposedFlag = disposedFlag;
        if (disposedFlag) {
            this.setNamesSync(true, null);
            this.setNamesSync(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNamesSync(boolean checkboxState, @Nullable String[] value) {
        String[][] stringArray = this.myNames;
        synchronized (this.myNames) {
            this.myNames[checkboxState ? 1 : 0] = value;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected ChooseByNameBase(Project project, @NotNull ChooseByNameModel model, String initialText, PsiElement context) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        this(project, model, new DefaultChooseByNameItemProvider(context), initialText, 0);
    }

    protected ChooseByNameBase(Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, String initialText) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        this(project, model, provider, initialText, 0);
    }

    protected ChooseByNameBase(Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, String initialText, int initialIndex) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        this.mySearchInAnyPlace = false;
        this.myTextFieldPanel = new JPanelProvider();
        this.myTextField = new MyTextField();
        this.myCard = new CardLayout();
        this.myCardContainer = new JPanel(this.myCard);
        this.myListModel = new MyListModel();
        this.myList = new JBList(this.myListModel);
        this.myHistory = ContainerUtil.newArrayList();
        this.myFuture = ContainerUtil.newArrayList();
        this.myAlarm = new Alarm();
        this.myListUpdater = new ListUpdater();
        this.myDisposedFlag = false;
        this.myNames = new String[2][];
        this.myListSizeIncreasing = 30;
        this.myMaximumListSizeLimit = 30;
        this.myHideAlarm = new Alarm();
        this.myShowListAfterCompletionKeyStroke = false;
        this.myClosedByShiftEnter = false;
        this.myFixLostTyping = true;
        this.myAlwaysHasMore = false;
        this.myProject = project;
        this.myModel = model;
        this.myInitialText = initialText;
        this.myProvider = provider;
        this.myInitialIndex = initialIndex;
        this.mySearchInAnyPlace = Registry.is((String)"ide.goto.middle.matching") && model.useMiddleMatching();
        this.myRebuildDelay = Registry.intValue((String)"ide.goto.rebuild.delay");
        this.myTextField.setText(this.myInitialText);
        this.myInitIsDone = true;
    }

    public void setShowListAfterCompletionKeyStroke(boolean showListAfterCompletionKeyStroke) {
        this.myShowListAfterCompletionKeyStroke = showListAfterCompletionKeyStroke;
    }

    public boolean isSearchInAnyPlace() {
        return this.mySearchInAnyPlace;
    }

    public void setSearchInAnyPlace(boolean searchInAnyPlace) {
        this.mySearchInAnyPlace = searchInAnyPlace;
    }

    public boolean isClosedByShiftEnter() {
        return this.myClosedByShiftEnter;
    }

    public boolean isOpenInCurrentWindowRequested() {
        return this.isClosedByShiftEnter();
    }

    public void setToolArea(JComponent toolArea) {
        if (this.myToolArea != null) {
            throw new IllegalStateException("Tool area is modifiable only before invoke()");
        }
        this.myToolArea = toolArea;
    }

    public void setFindUsagesTitle(@Nullable String findUsagesTitle) {
        this.myFindUsagesTitle = findUsagesTitle;
    }

    public void invoke(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
        this.initUI(callback, modalityState, allowMultipleSelection);
    }

    @NotNull
    public ChooseByNameModel getModel() {
        ChooseByNameModel chooseByNameModel = this.myModel;
        if (chooseByNameModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getModel"));
        }
        return chooseByNameModel;
    }

    protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, final boolean allowMultipleSelection) {
        this.myPreviouslyFocusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
        this.myActionListener = callback;
        this.myTextFieldPanel.setLayout(new BoxLayout(this.myTextFieldPanel, 1));
        JPanel hBox = new JPanel();
        hBox.setLayout(new BoxLayout(hBox, 0));
        JPanel caption2Tools = new JPanel(new BorderLayout());
        if (this.myModel.getPromptText() != null) {
            JLabel label = new JLabel(this.myModel.getPromptText());
            if (UIUtil.isUnderAquaLookAndFeel()) {
                label.setBorder(new CompoundBorder(new EmptyBorder(0, 9, 0, 0), label.getBorder()));
            }
            label.setFont(UIUtil.getLabelFont().deriveFont(1));
            caption2Tools.add((Component)label, "West");
        }
        caption2Tools.add((Component)hBox, "East");
        this.myCardContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        String checkBoxName = this.myModel.getCheckBoxName();
        this.myCheckBox = new JCheckBox(checkBoxName != null ? checkBoxName + (this.myCheckBoxShortcut != null ? " (" + KeymapUtil.getShortcutsText((Shortcut[])this.myCheckBoxShortcut.getShortcuts()) + ")" : "") : "");
        this.myCheckBox.setAlignmentX(4.0f);
        if (!SystemInfo.isMac) {
            this.myCheckBox.setBorder(null);
        }
        this.myCheckBox.setSelected(this.myModel.loadInitialCheckBoxState());
        if (checkBoxName == null) {
            this.myCheckBox.setVisible(false);
        }
        this.addCard(this.myCheckBox, CHECK_BOX_CARD);
        this.addCard(new HintLabel(this.myModel.getNotInMessage()), NOT_FOUND_IN_PROJECT_CARD);
        this.addCard(new HintLabel(IdeBundle.message((String)"label.choosebyname.no.matches.found", (Object[])new Object[0])), NOT_FOUND_CARD);
        JPanel searching = new JPanel(new BorderLayout(5, 0));
        searching.add((Component)new AsyncProcessIcon(SEARCHING_CARD), "West");
        searching.add((Component)new HintLabel(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0])), "Center");
        this.addCard(searching, SEARCHING_CARD);
        this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
        if (this.isCheckboxVisible()) {
            hBox.add(this.myCardContainer);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ShowFindUsagesAction(){

            public PsiElement[][] getElements() {
                Object[] objects = ChooseByNameBase.this.myListModel.toArray();
                ArrayList<PsiElement> prefixMatchElements = new ArrayList<PsiElement>(objects.length);
                ArrayList nonPrefixMatchElements = new ArrayList(objects.length);
                ArrayList<PsiElement> curElements = prefixMatchElements;
                for (Object object : objects) {
                    if (object instanceof PsiElement) {
                        curElements.add((PsiElement)object);
                        continue;
                    }
                    if (object instanceof DataProvider) {
                        PsiElement psi = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData((DataProvider)object);
                        if (psi == null) continue;
                        curElements.add(psi);
                        continue;
                    }
                    if (object != ChooseByNameBase.NON_PREFIX_SEPARATOR) continue;
                    curElements = nonPrefixMatchElements;
                }
                return new PsiElement[][]{PsiUtilCore.toPsiElementArray(prefixMatchElements), PsiUtilCore.toPsiElementArray(nonPrefixMatchElements)};
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(0);
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setBorder(null);
        if (this.myToolArea == null) {
            this.myToolArea = new JLabel(EmptyIcon.create((int)1, (int)24));
        }
        hBox.add(this.myToolArea);
        hBox.add(toolbarComponent);
        this.myTextFieldPanel.add(caption2Tools);
        final ActionMap actionMap = new ActionMap();
        actionMap.setParent(this.myTextField.getActionMap());
        actionMap.put("copy-to-clipboard", new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$2", "actionPerformed"));
                }
                if (ChooseByNameBase.this.myTextField.getSelectedText() != null) {
                    actionMap.getParent().get("copy-to-clipboard").actionPerformed(e);
                    return;
                }
                Object chosenElement = ChooseByNameBase.this.getChosenElement();
                if (chosenElement instanceof PsiElement) {
                    CopyReferenceAction.doCopy((PsiElement)chosenElement, ChooseByNameBase.this.myProject);
                }
            }
        });
        this.myTextField.setActionMap(actionMap);
        this.myTextFieldPanel.add(this.myTextField);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        boolean presentationMode = UISettings.getInstance().PRESENTATION_MODE;
        int size = presentationMode ? UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE - 4 : scheme.getEditorFontSize();
        Font editorFont = new Font(scheme.getEditorFontName(), 0, size);
        this.myTextField.setFont(editorFont);
        if (checkBoxName != null && this.myCheckBox != null && this.myCheckBoxShortcut != null) {
            new AnAction("change goto check box", null, null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$3", "actionPerformed"));
                    }
                    ChooseByNameBase.this.myCheckBox.setSelected(!ChooseByNameBase.this.myCheckBox.isSelected());
                }
            }.registerCustomShortcutSet(this.myCheckBoxShortcut, (JComponent)this.myTextField);
        }
        if (this.isCloseByFocusLost()) {
            this.myTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(final @NotNull FocusEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$4", "focusLost"));
                    }
                    ChooseByNameBase.this.cancelListUpdater();
                    ChooseByNameBase.this.myHideAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            JBPopup popup = JBPopupFactory.getInstance().getChildFocusedPopup(e.getComponent());
                            if (popup != null) {
                                popup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

                                    public void onClosed(@NotNull LightweightWindowEvent event) {
                                        if (event == null) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/gotoByName/ChooseByNameBase$4$1$1", "onClosed"));
                                        }
                                        if (event.isOk()) {
                                            ChooseByNameBase.this.hideHint();
                                        }
                                    }
                                });
                            } else {
                                Component root;
                                JComponent toolWindowComponent;
                                ToolWindowManager toolWindowManager;
                                ToolWindow toolWindow;
                                Component oppositeComponent = e.getOppositeComponent();
                                if (oppositeComponent == ChooseByNameBase.this.myCheckBox) {
                                    IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                                    return;
                                }
                                if (oppositeComponent != null && !(oppositeComponent instanceof JFrame) && ChooseByNameBase.this.myList.isShowing() && (oppositeComponent == ChooseByNameBase.this.myList || SwingUtilities.isDescendingFrom(ChooseByNameBase.this.myList, oppositeComponent))) {
                                    IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                                    return;
                                }
                                if (oppositeComponent != null && ChooseByNameBase.this.myProject != null && !ChooseByNameBase.this.myProject.isDisposed() && (toolWindow = (toolWindowManager = ToolWindowManager.getInstance((Project)ChooseByNameBase.this.myProject)).getToolWindow(toolWindowManager.getActiveToolWindowId())) != null && SwingUtilities.isDescendingFrom(oppositeComponent, toolWindowComponent = toolWindow.getComponent())) {
                                    return;
                                }
                                EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                                if (queue instanceof IdeEventQueue && ((IdeEventQueue)queue).wasRootRecentlyClicked(oppositeComponent) && ((root = SwingUtilities.getRoot(ChooseByNameBase.this.myTextField)) == null || root.isShowing())) {
                                    ChooseByNameBase.this.hideHint();
                                }
                            }
                        }
                    }, 5);
                }
            });
        }
        if (this.myCheckBox != null) {
            this.myCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(@NotNull ItemEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$5", "itemStateChanged"));
                    }
                    ChooseByNameBase.this.rebuildList(false);
                }
            });
            this.myCheckBox.setFocusable(false);
        }
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ChooseByNameBase.this.clearPostponedOkAction(false);
                ChooseByNameBase.this.rebuildList(false);
            }
        });
        final Set<KeyStroke> upShortcuts = ChooseByNameBase.getShortcuts("EditorUp");
        final Set<KeyStroke> downShortcuts = ChooseByNameBase.getShortcuts("EditorDown");
        this.myTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$7", "keyPressed"));
                }
                if (e.getKeyCode() == 10 && (e.getModifiers() & 1) != 0) {
                    ChooseByNameBase.this.myClosedByShiftEnter = true;
                    ChooseByNameBase.this.close(true);
                }
                if (!ChooseByNameBase.this.myListScrollPane.isVisible()) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                int keyCode = upShortcuts.contains(stroke) ? 38 : (downShortcuts.contains(stroke) ? 40 : e.getKeyCode());
                switch (keyCode) {
                    case 40: {
                        ListScrollingUtil.moveDown((JList)ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 38: {
                        ListScrollingUtil.moveUp((JList)ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 33: {
                        ListScrollingUtil.movePageUp((JList)ChooseByNameBase.this.myList);
                        break;
                    }
                    case 34: {
                        ListScrollingUtil.movePageDown((JList)ChooseByNameBase.this.myList);
                        break;
                    }
                    case 9: {
                        ChooseByNameBase.this.close(true);
                        break;
                    }
                    case 10: {
                        if (ChooseByNameBase.this.myList.getSelectedValue() != ChooseByNameBase.EXTRA_ELEM) break;
                        ChooseByNameBase.this.myMaximumListSizeLimit = ChooseByNameBase.this.myMaximumListSizeLimit + ChooseByNameBase.this.myListSizeIncreasing;
                        ChooseByNameBase.this.rebuildList(ChooseByNameBase.this.myList.getSelectedIndex(), ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
                        e.consume();
                    }
                }
                if (ChooseByNameBase.this.myList.getSelectedValue() == ChooseByNameBase.NON_PREFIX_SEPARATOR) {
                    if (keyCode == 38 || keyCode == 33) {
                        ListScrollingUtil.moveUp((JList)ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                    } else {
                        ListScrollingUtil.moveDown((JList)ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                    }
                }
            }
        });
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent actionEvent) {
                if (actionEvent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionEvent", "com/intellij/ide/util/gotoByName/ChooseByNameBase$8", "actionPerformed"));
                }
                ChooseByNameBase.this.doClose(true);
            }
        });
        this.myList.setFocusable(false);
        this.myList.setSelectionMode(allowMultipleSelection ? 2 : 0);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$9", "onClick"));
                }
                if (!ChooseByNameBase.this.myTextField.hasFocus()) {
                    IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                }
                if (clickCount == 2) {
                    int selectedIndex = ChooseByNameBase.this.myList.getSelectedIndex();
                    Rectangle selectedCellBounds = ChooseByNameBase.this.myList.getCellBounds(selectedIndex, selectedIndex);
                    if (selectedCellBounds != null && selectedCellBounds.contains(e.getPoint())) {
                        if (ChooseByNameBase.this.myList.getSelectedValue() == ChooseByNameBase.EXTRA_ELEM) {
                            ChooseByNameBase.this.myMaximumListSizeLimit = ChooseByNameBase.this.myMaximumListSizeLimit + ChooseByNameBase.this.myListSizeIncreasing;
                            ChooseByNameBase.this.rebuildList(selectedIndex, ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
                        } else {
                            ChooseByNameBase.this.doClose(true);
                        }
                    }
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myList);
        this.myList.setCellRenderer(this.myModel.getListCellRenderer());
        this.myList.setFont(editorFont);
        this.myList.addListSelectionListener(new ListSelectionListener(){
            private int myPreviousSelectionIndex = 0;

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$10", "valueChanged"));
                }
                if (ChooseByNameBase.this.myList.getSelectedValue() != ChooseByNameBase.NON_PREFIX_SEPARATOR) {
                    this.myPreviousSelectionIndex = ChooseByNameBase.this.myList.getSelectedIndex();
                    ChooseByNameBase.this.chosenElementMightChange();
                    ChooseByNameBase.this.updateDocumentation();
                } else if (allowMultipleSelection) {
                    ChooseByNameBase.this.myList.setSelectedIndex(this.myPreviousSelectionIndex);
                }
            }
        });
        this.myListScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myList);
        this.myListScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        this.myTextFieldPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.showTextFieldPanel();
        this.myInitialized = true;
        if (modalityState != null) {
            this.rebuildList(this.myInitialIndex, 0, modalityState, null);
        }
    }

    private void addCard(JComponent comp, String cardId) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)comp, "East");
        this.myCardContainer.add((Component)wrapper, cardId);
    }

    public void setCheckBoxShortcut(ShortcutSet shortcutSet) {
        this.myCheckBoxShortcut = shortcutSet;
    }

    @NotNull
    private static Set<KeyStroke> getShortcuts(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getShortcuts"));
        }
        HashSet<KeyStroke> result = new HashSet<KeyStroke>();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(actionId);
        if (shortcuts == null) {
            HashSet<KeyStroke> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getShortcuts"));
            }
            return hashSet;
        }
        for (Shortcut shortcut : shortcuts) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            result.add(keyboardShortcut.getFirstKeyStroke());
        }
        HashSet<KeyStroke> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getShortcuts"));
        }
        return hashSet;
    }

    private void hideHint() {
        if (!this.myTextFieldPanel.focusRequested()) {
            this.doClose(false);
            this.myTextFieldPanel.hideHint();
        }
    }

    public void rebuildList(boolean initial) {
        this.rebuildList(initial ? this.myInitialIndex : 0, this.myRebuildDelay, ModalityState.current(), null);
    }

    private void updateDocumentation() {
        JBPopup hint = this.myTextFieldPanel.getHint();
        Object element = this.getChosenElement();
        if (hint != null) {
            Object o;
            if (element instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)element);
            } else if (element instanceof DataProvider && (o = ((DataProvider)element).getData(CommonDataKeys.PSI_ELEMENT.getName())) instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)o);
            }
        }
    }

    public String transformPattern(String pattern) {
        return pattern;
    }

    protected void doClose(boolean ok) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.closeForbidden(ok)) {
            return;
        }
        if (this.postponeCloseWhenListReady(ok)) {
            return;
        }
        this.cancelListUpdater();
        this.close(ok);
        this.clearPostponedOkAction(ok);
        this.myListModel.clear();
    }

    protected boolean closeForbidden(boolean ok) {
        return false;
    }

    protected void cancelListUpdater() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.checkDisposed()) {
            return;
        }
        CalcElementsThread calcElementsThread = this.myCalcElementsThread;
        if (calcElementsThread != null) {
            calcElementsThread.cancel();
            this.backgroundCalculationFinished(Collections.emptyList(), 0);
        }
        this.myListUpdater.cancelAll();
    }

    private boolean postponeCloseWhenListReady(boolean ok) {
        if (!this.isToFixLostTyping()) {
            return false;
        }
        String text = this.getTrimmedText();
        if (ok && this.myCalcElementsThread != null && !text.isEmpty()) {
            this.myPostponedOkAction = new ActionCallback();
            IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(this.myPostponedOkAction);
            return true;
        }
        return false;
    }

    @NotNull
    public String getTrimmedText() {
        String string = StringUtil.trimLeading((String)StringUtil.notNullize((String)this.myTextField.getText()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getTrimmedText"));
        }
        return string;
    }

    public void setFixLostTyping(boolean fixLostTyping) {
        this.myFixLostTyping = fixLostTyping;
    }

    protected boolean isToFixLostTyping() {
        return this.myFixLostTyping && Registry.is((String)"actionSystem.fixLostTyping");
    }

    @NotNull
    private synchronized String[] ensureNamesLoaded(boolean checkboxState) {
        String[] cached = this.getNamesSync(checkboxState);
        if (cached != null) {
            if (cached == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "ensureNamesLoaded"));
            }
            return cached;
        }
        if (checkboxState && this.myModel instanceof ContributorsBasedGotoByModel && ((ContributorsBasedGotoByModel)this.myModel).sameNamesForProjectAndLibraries() && this.getNamesSync(false) != null) {
            String[] allNames = this.getNamesSync(false);
            this.setNamesSync(true, allNames);
            if (allNames == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "ensureNamesLoaded"));
            }
            return allNames;
        }
        String[] result = this.myModel.getNames(checkboxState);
        assert (result != null) : "Model " + this.myModel + "(" + this.myModel.getClass() + ") returned null names";
        this.setNamesSync(checkboxState, result);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "ensureNamesLoaded"));
        }
        return result;
    }

    @NotNull
    public String[] getNames(boolean checkboxState) {
        if (ourLoadNamesEachTime) {
            this.setNamesSync(checkboxState, null);
            String[] stringArray = this.ensureNamesLoaded(checkboxState);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getNames"));
            }
            return stringArray;
        }
        String[] stringArray = this.getNamesSync(checkboxState);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getNames"));
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getNamesSync(boolean checkboxState) {
        String[][] stringArray = this.myNames;
        synchronized (this.myNames) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.myNames[checkboxState ? 1 : 0];
        }
    }

    @NotNull
    protected Set<Object> filter(@NotNull Set<Object> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "filter"));
        }
        Set<Object> set = elements;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "filter"));
        }
        return set;
    }

    protected abstract boolean isCheckboxVisible();

    protected abstract boolean isShowListForEmptyPattern();

    protected abstract boolean isCloseByFocusLost();

    protected void showTextFieldPanel() {
        Window window;
        JLayeredPane layeredPane = this.getLayeredPane();
        Dimension preferredTextFieldPanelSize = this.myTextFieldPanel.getPreferredSize();
        int x = (layeredPane.getWidth() - preferredTextFieldPanelSize.width) / 2;
        int paneHeight = layeredPane.getHeight();
        int y = paneHeight / 3 - preferredTextFieldPanelSize.height / 2;
        VISIBLE_LIST_SIZE_LIMIT = Math.max(10, (paneHeight - (y + preferredTextFieldPanelSize.height)) / (preferredTextFieldPanelSize.height / 2) - 1);
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myTextFieldPanel, (JComponent)this.myTextField);
        builder.setLocateWithinScreenBounds(false);
        builder.setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                ChooseByNameBase.this.myTextPopup = null;
                ChooseByNameBase.this.close(false);
                return Boolean.TRUE;
            }
        }).setFocusable(true).setRequestFocus(true).setModalContext(false).setCancelOnClickOutside(false);
        Point point = new Point(x, y);
        SwingUtilities.convertPointToScreen(point, layeredPane);
        Rectangle bounds = new Rectangle(point, new Dimension(preferredTextFieldPanelSize.width + 20, preferredTextFieldPanelSize.height));
        this.myTextPopup = builder.createPopup();
        this.myTextPopup.setSize(bounds.getSize());
        this.myTextPopup.setLocation(bounds.getLocation());
        MnemonicHelper.init((Component)this.myTextFieldPanel);
        if (this.myProject != null && !this.myProject.isDefault()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this.myTextPopup);
        }
        Disposer.register((Disposable)this.myTextPopup, (Disposable)new Disposable(){

            public void dispose() {
                ChooseByNameBase.this.cancelListUpdater();
            }
        });
        this.myTextPopup.show((Component)layeredPane);
        if (this.myTextPopup instanceof AbstractPopup && (window = ((AbstractPopup)this.myTextPopup).getPopupWindow()) instanceof JDialog) {
            ((JDialog)window).getRootPane().putClientProperty("no.window.actions", Boolean.TRUE);
        }
    }

    private JLayeredPane getLayeredPane() {
        JLayeredPane layeredPane;
        Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
        Component parent = UIUtil.findUltimateParent((Component)window);
        if (parent instanceof JFrame) {
            layeredPane = ((JFrame)parent).getLayeredPane();
        } else if (parent instanceof JDialog) {
            layeredPane = ((JDialog)parent).getLayeredPane();
        } else {
            throw new IllegalStateException("cannot find parent window: project=" + this.myProject + (this.myProject != null ? "; open=" + this.myProject.isOpen() : "") + "; window=" + window);
        }
        return layeredPane;
    }

    protected void rebuildList(final int pos, int delay, final @NotNull ModalityState modalityState, final @Nullable Runnable postRunnable) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "rebuildList"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myInitialized) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (delay > 0) {
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ChooseByNameBase.this.rebuildList(pos, 0, modalityState, postRunnable);
                }
            }, delay, ModalityState.stateForComponent((Component)this.myTextField));
            return;
        }
        this.myListUpdater.cancelAll();
        CalcElementsThread calcElementsThread = this.myCalcElementsThread;
        if (calcElementsThread != null) {
            calcElementsThread.cancel();
        }
        String text = this.getTrimmedText();
        if (!this.canShowListForEmptyPattern() && text.isEmpty()) {
            this.myListModel.clear();
            this.hideList();
            this.myTextFieldPanel.hideHint();
            this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
            return;
        }
        ListCellRenderer cellRenderer = this.myList.getCellRenderer();
        if (cellRenderer instanceof ExpandedItemListCellRendererWrapper) {
            cellRenderer = ((ExpandedItemListCellRendererWrapper)cellRenderer).getWrappee();
        }
        if (cellRenderer instanceof MatcherHolder) {
            String pattern = this.transformPattern(text);
            Matcher matcher = ChooseByNameBase.buildPatternMatcher(this.isSearchInAnyPlace() ? "*" + pattern : pattern);
            ((MatcherHolder)cellRenderer).setPatternMatcher(matcher);
        }
        this.scheduleCalcElements(text, this.myCheckBox.isSelected(), modalityState, new Consumer<Set<?>>(){

            public void consume(Set<?> elements) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                ChooseByNameBase.this.backgroundCalculationFinished(elements, pos);
                if (postRunnable != null) {
                    postRunnable.run();
                }
            }
        });
    }

    private void backgroundCalculationFinished(Collection<?> result, int toSelect) {
        this.myCalcElementsThread = null;
        this.setElementsToList(toSelect, result);
        this.myList.repaint();
        this.chosenElementMightChange();
        if (result.isEmpty()) {
            this.myTextFieldPanel.hideHint();
        }
    }

    public void scheduleCalcElements(String text, boolean checkboxState, ModalityState modalityState, Consumer<Set<?>> callback) {
        new CalcElementsThread(text, checkboxState, callback, modalityState, false).scheduleThread();
    }

    private boolean isShowListAfterCompletionKeyStroke() {
        return this.myShowListAfterCompletionKeyStroke;
    }

    private void setElementsToList(int pos, @NotNull Collection<?> elements) {
        Object[] newElements;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "setElementsToList"));
        }
        this.myListUpdater.cancelAll();
        if (this.checkDisposed()) {
            return;
        }
        if (elements.isEmpty()) {
            this.myListModel.clear();
            this.myTextField.setForeground((Color)JBColor.red);
            this.myListUpdater.cancelAll();
            this.hideList();
            this.clearPostponedOkAction(false);
            return;
        }
        Object[] oldElements = this.myListModel.toArray();
        List<ModelDiff.Cmd> commands = ModelDiff.createDiffCmds(this.myListModel, oldElements, newElements = elements.toArray());
        if (commands == null) {
            this.myListUpdater.doPostponedOkIfNeeded();
            return;
        }
        this.myTextField.setForeground(UIUtil.getTextFieldForeground());
        if (commands.isEmpty()) {
            if (pos <= 0) {
                pos = this.detectBestStatisticalPosition();
            }
            ListScrollingUtil.selectItem((JList)this.myList, (int)Math.min(pos, this.myListModel.size() - 1));
            this.myList.setVisibleRowCount(Math.min(VISIBLE_LIST_SIZE_LIMIT, this.myList.getModel().getSize()));
            this.showList();
            this.myTextFieldPanel.repositionHint();
        } else {
            this.showList();
            this.myListUpdater.appendToModel(commands, pos);
        }
    }

    private int detectBestStatisticalPosition() {
        if (this.myModel instanceof Comparator) {
            return 0;
        }
        int best = 0;
        int bestPosition = 0;
        int bestMatch = Integer.MIN_VALUE;
        int count = this.myListModel.getSize();
        Matcher matcher = ChooseByNameBase.buildPatternMatcher(this.transformPattern(this.getTrimmedText()));
        String statContext = this.statisticsContext();
        for (int i = 0; i < count; ++i) {
            String text;
            Object modelElement = this.myListModel.getElementAt(i);
            String string = text = EXTRA_ELEM.equals(modelElement) || NON_PREFIX_SEPARATOR.equals(modelElement) ? null : this.myModel.getFullName(modelElement);
            if (text == null) continue;
            String shortName = this.myModel.getElementName(modelElement);
            int match = shortName != null && matcher instanceof MinusculeMatcher ? ((MinusculeMatcher)matcher).matchingDegree(shortName) : Integer.MIN_VALUE;
            int stats = StatisticsManager.getInstance().getUseCount(new StatisticsInfo(statContext, text));
            if (match <= bestMatch && (match != bestMatch || stats <= best)) continue;
            best = stats;
            bestPosition = i;
            bestMatch = match;
        }
        if (bestPosition < count - 1 && this.myListModel.getElementAt(bestPosition) == NON_PREFIX_SEPARATOR) {
            ++bestPosition;
        }
        return bestPosition;
    }

    @NotNull
    @NonNls
    protected String statisticsContext() {
        String string = "choose_by_name#" + this.myModel.getPromptText() + "#" + this.myCheckBox.isSelected() + "#" + this.getTrimmedText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "statisticsContext"));
        }
        return string;
    }

    private void clearPostponedOkAction(boolean success) {
        if (this.myPostponedOkAction != null) {
            if (success) {
                this.myPostponedOkAction.setDone();
            } else {
                this.myPostponedOkAction.setRejected();
            }
        }
        this.myPostponedOkAction = null;
    }

    public boolean hasPostponedAction() {
        return this.myPostponedOkAction != null;
    }

    protected abstract void showList();

    protected abstract void hideList();

    protected abstract void close(boolean var1);

    @Nullable
    public Object getChosenElement() {
        List<Object> elements = this.getChosenElements();
        return elements != null && elements.size() == 1 ? elements.get(0) : null;
    }

    protected List<Object> getChosenElements() {
        return ContainerUtil.filter((Object[])this.myList.getSelectedValues(), (Condition)new Condition<Object>(){

            public boolean value(Object o) {
                return o != ChooseByNameBase.EXTRA_ELEM && o != ChooseByNameBase.NON_PREFIX_SEPARATOR;
            }
        });
    }

    protected void chosenElementMightChange() {
    }

    public ChooseByNameItemProvider getProvider() {
        return this.myProvider;
    }

    protected void handlePaste(String str) {
        if (!this.myInitIsDone) {
            return;
        }
        if (this.myModel instanceof GotoClassModel2 && ChooseByNameBase.isFileName(str)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GotoFileAction gotoFile = new GotoFileAction();
                    AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)ChooseByNameBase.this.myTextField), "unknown", gotoFile.getTemplatePresentation(), ActionManager.getInstance(), 0);
                    event.setInjectedContext(gotoFile.isInInjectedContext());
                    gotoFile.actionPerformed(event);
                }
            });
        }
    }

    private static boolean isFileName(String name) {
        int index = name.lastIndexOf(46);
        if (index > 0) {
            String ext = name.substring(index + 1);
            if (ext.contains(":")) {
                ext = ext.substring(0, ext.indexOf(58));
            }
            if (FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(ext) != UnknownFileType.INSTANCE) {
                return true;
            }
        }
        return false;
    }

    public static Component renderNonPrefixSeparatorComponent(Color backgroundColor) {
        JPanel panel = new JPanel(new BorderLayout());
        JSeparator separator = new JSeparator(0);
        panel.add((Component)separator, "Center");
        if (!UIUtil.isUnderAquaBasedLookAndFeel()) {
            panel.setBorder(new EmptyBorder(3, 0, 2, 0));
        }
        panel.setBackground(backgroundColor);
        return panel;
    }

    public boolean canShowListForEmptyPattern() {
        return this.isShowListForEmptyPattern() || this.isShowListAfterCompletionKeyStroke() && this.lastKeyStrokeIsCompletion();
    }

    protected boolean lastKeyStrokeIsCompletion() {
        return this.myTextField.isCompletionKeyStroke();
    }

    private static Matcher buildPatternMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "buildPatternMatcher"));
        }
        return NameUtil.buildMatcher((String)pattern, (int)0, (boolean)true, (boolean)true, (boolean)pattern.toLowerCase().equals(pattern));
    }

    public int getMaximumListSizeLimit() {
        return this.myMaximumListSizeLimit;
    }

    public void setMaximumListSizeLimit(int maximumListSizeLimit) {
        this.myMaximumListSizeLimit = maximumListSizeLimit;
    }

    public void setListSizeIncreasing(int listSizeIncreasing) {
        this.myListSizeIncreasing = listSizeIncreasing;
    }

    public boolean isAlwaysHasMore() {
        return this.myAlwaysHasMore;
    }

    public void setAlwaysHasMore(boolean enabled) {
        this.myAlwaysHasMore = enabled;
    }

    public JTextField getTextField() {
        return this.myTextField;
    }

    private abstract class ShowFindUsagesAction
    extends AnAction {
        public ShowFindUsagesAction() {
            super(ChooseByNameBase.ACTION_NAME, ChooseByNameBase.ACTION_NAME, AllIcons.General.AutohideOff);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "actionPerformed"));
            }
            ChooseByNameBase.this.cancelListUpdater();
            final UsageViewPresentation presentation = new UsageViewPresentation();
            final String text = ChooseByNameBase.this.getTrimmedText();
            String prefixPattern = ChooseByNameBase.this.myFindUsagesTitle + " '" + text + "'";
            String nonPrefixPattern = ChooseByNameBase.this.myFindUsagesTitle + " '*" + text + "*'";
            presentation.setCodeUsagesString(prefixPattern);
            presentation.setUsagesInGeneratedCodeString(prefixPattern + " in generated code");
            presentation.setDynamicUsagesString(nonPrefixPattern);
            presentation.setTabName(prefixPattern);
            presentation.setTabText(prefixPattern);
            presentation.setTargetsNodeText("Unsorted " + StringUtil.toLowerCase((String)prefixPattern.toLowerCase()));
            Object[][] elements = this.getElements();
            final ArrayList<PsiElement> targets = new ArrayList<PsiElement>();
            final ArrayList<Usage> usages = new ArrayList<Usage>();
            this.fillUsages(Arrays.asList(elements[0]), usages, targets, false);
            this.fillUsages(Arrays.asList(elements[1]), usages, targets, true);
            if (ChooseByNameBase.this.myListModel.contains(ChooseByNameBase.EXTRA_ELEM)) {
                final boolean everywhere = ChooseByNameBase.this.myCheckBox.isSelected();
                final LinkedHashSet prefixMatchElementsArray = new LinkedHashSet();
                final LinkedHashSet nonPrefixMatchElementsArray = new LinkedHashSet();
                ChooseByNameBase.this.hideHint();
                ProgressManager.getInstance().run((Task)new Task.Modal(ChooseByNameBase.this.myProject, prefixPattern, true){
                    private CalcElementsThread myCalcUsagesThread;

                    public void run(final @NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction$1", "run"));
                        }
                        ChooseByNameBase.this.ensureNamesLoaded(everywhere);
                        indicator.setIndeterminate(true);
                        final TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(indicator);
                        this.myCalcUsagesThread = new CalcElementsThread(text, everywhere, null, ModalityState.NON_MODAL, false){

                            @Override
                            protected boolean isOverflow(@NotNull Set<Object> elementsArray) {
                                if (elementsArray == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsArray", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction$1$1", "isOverflow"));
                                }
                                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                                if (elementsArray.size() > 1000 - ChooseByNameBase.this.myMaximumListSizeLimit && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                    int usageCount = elementsArray.size() + ChooseByNameBase.this.myMaximumListSizeLimit;
                                    UsageViewManagerImpl.showTooManyUsagesWarning((Project)this.getProject(), (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)indicator, (UsageViewPresentation)presentation, (int)usageCount, null);
                                }
                                return false;
                            }
                        };
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                boolean anyPlace = ChooseByNameBase.this.isSearchInAnyPlace();
                                ChooseByNameBase.this.setSearchInAnyPlace(false);
                                myCalcUsagesThread.addElementsByPattern(text, prefixMatchElementsArray, indicator, everywhere);
                                ChooseByNameBase.this.setSearchInAnyPlace(anyPlace);
                                if (anyPlace && !indicator.isCanceled()) {
                                    myCalcUsagesThread.addElementsByPattern(text, nonPrefixMatchElementsArray, indicator, everywhere);
                                    nonPrefixMatchElementsArray.removeAll(prefixMatchElementsArray);
                                }
                                indicator.setText("Prepare...");
                                ShowFindUsagesAction.this.fillUsages(prefixMatchElementsArray, usages, targets, false);
                                ShowFindUsagesAction.this.fillUsages(nonPrefixMatchElementsArray, usages, targets, true);
                            }
                        });
                    }

                    public void onSuccess() {
                        ShowFindUsagesAction.this.showUsageView(targets, usages, presentation);
                    }

                    public void onCancel() {
                        this.myCalcUsagesThread.cancel();
                    }
                });
            } else {
                ChooseByNameBase.this.hideHint();
                this.showUsageView(targets, usages, presentation);
            }
        }

        private void fillUsages(Collection<Object> matchElementsArray, List<Usage> usages, List<PsiElement> targets, final boolean separateGroup) {
            for (Object o : matchElementsArray) {
                if (!(o instanceof PsiElement)) continue;
                PsiElement element = (PsiElement)o;
                if (element.getTextRange() != null) {
                    usages.add((Usage)new UsageInfo2UsageAdapter(new UsageInfo(element){

                        public boolean isDynamicUsage() {
                            return separateGroup || super.isDynamicUsage();
                        }
                    }));
                    continue;
                }
                targets.add(element);
            }
        }

        private void showUsageView(@NotNull List<PsiElement> targets, @NotNull List<Usage> usages, @NotNull UsageViewPresentation presentation) {
            if (targets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "showUsageView"));
            }
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "showUsageView"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "showUsageView"));
            }
            UsageTarget[] usageTargets = targets.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets));
            UsageViewManager.getInstance((Project)ChooseByNameBase.this.myProject).showUsages(usageTargets, usages.toArray(new Usage[usages.size()]), presentation);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "update"));
            }
            if (ChooseByNameBase.this.myFindUsagesTitle == null || ChooseByNameBase.this.myProject == null) {
                e.getPresentation().setVisible(false);
                return;
            }
            Object[][] elements = this.getElements();
            e.getPresentation().setEnabled(elements != null && elements[0].length + elements[1].length > 0);
        }

        public abstract Object[][] getElements();
    }

    private static class HintLabel
    extends JLabel {
        private HintLabel(String text) {
            super(text, 4);
            this.setForeground(Color.darkGray);
        }
    }

    private class CalcElementsThread
    implements ReadTask {
        private final String myPattern;
        private volatile boolean myCheckboxState;
        private volatile boolean myScopeExpanded;
        private final Consumer<Set<?>> myCallback;
        private final ModalityState myModalityState;
        private final ProgressIndicator myProgress;
        private final Alarm myShowCardAlarm;

        CalcElementsThread(String pattern, boolean checkboxState, @NotNull Consumer<Set<?>> callback, ModalityState modalityState, boolean scopeExpanded) {
            if (modalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "<init>"));
            }
            this.myProgress = new ProgressIndicatorBase();
            this.myShowCardAlarm = new Alarm();
            this.myPattern = pattern;
            this.myCheckboxState = checkboxState;
            this.myCallback = callback;
            this.myModalityState = modalityState;
            this.myScopeExpanded = scopeExpanded;
        }

        void scheduleThread() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ChooseByNameBase.this.myCalcElementsThread = this;
            this.showCard(ChooseByNameBase.SEARCHING_CARD, 200);
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myProgress, this);
        }

        @Override
        public void computeInReadAction(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "computeInReadAction"));
            }
            if (ChooseByNameBase.this.myProject != null && ChooseByNameBase.this.myProject.isDisposed()) {
                return;
            }
            final LinkedHashSet<Object> elements = new LinkedHashSet<Object>();
            if (!ourLoadNamesEachTime) {
                ChooseByNameBase.this.ensureNamesLoaded(this.myCheckboxState);
            }
            this.addElementsByPattern(this.myPattern, elements, this.myProgress, this.myCheckboxState);
            if (this.myProgress.isCanceled()) {
                this.myShowCardAlarm.cancelAllRequests();
                return;
            }
            if (elements.isEmpty() && !this.myCheckboxState) {
                this.myScopeExpanded = true;
                this.myCheckboxState = true;
                if (!ourLoadNamesEachTime) {
                    ChooseByNameBase.this.ensureNamesLoaded(true);
                }
                this.addElementsByPattern(this.myPattern, elements, this.myProgress, true);
            }
            String cardToShow = elements.isEmpty() ? ChooseByNameBase.NOT_FOUND_CARD : (this.myScopeExpanded ? ChooseByNameBase.NOT_FOUND_IN_PROJECT_CARD : ChooseByNameBase.CHECK_BOX_CARD);
            this.showCard(cardToShow, 0);
            final boolean edt = ChooseByNameBase.this.myModel instanceof EdtSortingModel;
            final Set filtered = !edt ? ChooseByNameBase.this.filter(elements) : Collections.emptySet();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ChooseByNameBase.this.checkDisposed() && !CalcElementsThread.this.myProgress.isCanceled()) {
                        CalcElementsThread currentBgProcess = ChooseByNameBase.this.myCalcElementsThread;
                        LOG.assertTrue(currentBgProcess == CalcElementsThread.this, (Object)currentBgProcess);
                        CalcElementsThread.this.myCallback.consume((Object)(edt ? ChooseByNameBase.this.filter(elements) : filtered));
                    }
                }
            }, this.myModalityState);
        }

        @Override
        public void onCanceled(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "onCanceled"));
            }
            LOG.assertTrue(ChooseByNameBase.this.myCalcElementsThread == this, (Object)ChooseByNameBase.this.myCalcElementsThread);
            new CalcElementsThread(this.myPattern, this.myCheckboxState, this.myCallback, this.myModalityState, this.myScopeExpanded).scheduleThread();
        }

        private void addElementsByPattern(@NotNull String pattern, final @NotNull Set<Object> elements, final @NotNull ProgressIndicator indicator, boolean everywhere) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "addElementsByPattern"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "addElementsByPattern"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "addElementsByPattern"));
            }
            long start = System.currentTimeMillis();
            ChooseByNameBase.this.myProvider.filterElements(ChooseByNameBase.this, pattern, everywhere, indicator, new Processor<Object>(){

                public boolean process(Object o) {
                    if (indicator.isCanceled()) {
                        return false;
                    }
                    elements.add(o);
                    if (CalcElementsThread.this.isOverflow(elements)) {
                        elements.add(ChooseByNameBase.EXTRA_ELEM);
                        return false;
                    }
                    return true;
                }
            });
            if (ChooseByNameBase.this.myAlwaysHasMore) {
                elements.add(ChooseByNameBase.EXTRA_ELEM);
            }
            if (ContributorsBasedGotoByModel.LOG.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ContributorsBasedGotoByModel.LOG.debug("addElementsByPattern(" + pattern + "): " + (end - start) + "ms; " + elements.size() + " elements");
            }
        }

        private void showCard(final String card, int delay) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myShowCardAlarm.cancelAllRequests();
            this.myShowCardAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (!CalcElementsThread.this.myProgress.isCanceled()) {
                        ChooseByNameBase.this.myCard.show(ChooseByNameBase.this.myCardContainer, card);
                    }
                }
            }, delay, this.myModalityState);
        }

        protected boolean isOverflow(@NotNull Set<Object> elementsArray) {
            if (elementsArray == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsArray", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "isOverflow"));
            }
            return elementsArray.size() >= ChooseByNameBase.this.myMaximumListSizeLimit;
        }

        private void cancel() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myProgress.cancel();
        }
    }

    protected final class MyTextField
    extends JTextField
    implements PopupOwner,
    TypeSafeDataProvider {
        private final KeyStroke myCompletionKeyStroke;
        private final KeyStroke forwardStroke;
        private final KeyStroke backStroke;
        private boolean completionKeyStrokeHappened;

        private MyTextField() {
            super(40);
            this.completionKeyStrokeHappened = false;
            if (!UIUtil.isUnderGTKLookAndFeel()) {
                if (!(this.getUI() instanceof DarculaTextFieldUI)) {
                    this.setUI(DarculaTextFieldUI.createUI(this));
                }
                this.setBorder(new DarculaTextBorder());
            }
            this.enableEvents(8L);
            this.myCompletionKeyStroke = this.getShortcut("CodeCompletion");
            this.forwardStroke = this.getShortcut("Forward");
            this.backStroke = this.getShortcut("Back");
            this.setFocusTraversalKeysEnabled(false);
            this.putClientProperty("JTextField.variant", "search");
            this.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    super.insertString(offs, str, a);
                    if (str != null && str.length() > 1) {
                        ChooseByNameBase.this.handlePaste(str);
                    }
                }
            });
        }

        @Nullable
        private KeyStroke getShortcut(String actionCodeCompletion) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionCodeCompletion)) {
                if (!(shortcut instanceof KeyboardShortcut)) continue;
                return ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            }
            return null;
        }

        public void calcData(DataKey key, @NotNull DataSink sink) {
            if (sink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "calcData"));
            }
            if (LangDataKeys.POSITION_ADJUSTER_POPUP.equals(key)) {
                if (ChooseByNameBase.this.myDropdownPopup != null && ChooseByNameBase.this.myDropdownPopup.isVisible()) {
                    sink.put(key, (Object)ChooseByNameBase.this.myDropdownPopup);
                }
            } else if (LangDataKeys.PARENT_POPUP.equals(key) && ChooseByNameBase.this.myTextPopup != null && ChooseByNameBase.this.myTextPopup.isVisible()) {
                sink.put(key, (Object)ChooseByNameBase.this.myTextPopup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processKeyEvent(@NotNull KeyEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "processKeyEvent"));
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            if (this.myCompletionKeyStroke != null && keyStroke.equals(this.myCompletionKeyStroke)) {
                this.completionKeyStrokeHappened = true;
                e.consume();
                final String pattern = ChooseByNameBase.this.getTrimmedText();
                int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                ChooseByNameBase.this.myHistory.add(Pair.create((Object)pattern, (Object)oldPos));
                Runnable postRunnable = new Runnable(){

                    @Override
                    public void run() {
                        MyTextField.this.fillInCommonPrefix(pattern);
                    }
                };
                ChooseByNameBase.this.rebuildList(0, 0, ModalityState.current(), postRunnable);
                return;
            }
            if (this.backStroke != null && keyStroke.equals(this.backStroke)) {
                e.consume();
                if (!ChooseByNameBase.this.myHistory.isEmpty()) {
                    String oldText = ChooseByNameBase.this.getTrimmedText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    Pair last = (Pair)ChooseByNameBase.this.myHistory.remove(ChooseByNameBase.this.myHistory.size() - 1);
                    ChooseByNameBase.this.myTextField.setText((String)last.first);
                    ChooseByNameBase.this.myFuture.add(Pair.create((Object)oldText, (Object)oldPos));
                    ChooseByNameBase.this.rebuildList(0, 0, ModalityState.current(), null);
                }
                return;
            }
            if (this.forwardStroke != null && keyStroke.equals(this.forwardStroke)) {
                e.consume();
                if (!ChooseByNameBase.this.myFuture.isEmpty()) {
                    String oldText = ChooseByNameBase.this.getTrimmedText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    Pair next = (Pair)ChooseByNameBase.this.myFuture.remove(ChooseByNameBase.this.myFuture.size() - 1);
                    ChooseByNameBase.this.myTextField.setText((String)next.first);
                    ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
                    ChooseByNameBase.this.rebuildList(0, 0, ModalityState.current(), null);
                }
                return;
            }
            int position = ChooseByNameBase.this.myTextField.getCaretPosition();
            int code = keyStroke.getKeyCode();
            int modifiers = keyStroke.getModifiers();
            try {
                super.processKeyEvent(e);
            }
            catch (NullPointerException e1) {
                if (!Patches.SUN_BUG_ID_6322854) {
                    throw e1;
                }
            }
            finally {
                if ((code == 38 || code == 40) && modifiers == 0) {
                    ChooseByNameBase.this.myTextField.setCaretPosition(position);
                }
            }
        }

        private void fillInCommonPrefix(@NotNull String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "fillInCommonPrefix"));
            }
            if (StringUtil.isEmpty((String)pattern) && !ChooseByNameBase.this.canShowListForEmptyPattern()) {
                return;
            }
            List<String> list = ChooseByNameBase.this.myProvider.filterNames(ChooseByNameBase.this, ChooseByNameBase.this.getNames(ChooseByNameBase.this.myCheckBox.isSelected()), pattern);
            if (this.isComplexPattern(pattern)) {
                return;
            }
            String oldText = ChooseByNameBase.this.getTrimmedText();
            int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
            String commonPrefix = null;
            if (!list.isEmpty()) {
                for (String name : list) {
                    String string = name.toLowerCase();
                    if (commonPrefix == null) {
                        commonPrefix = string;
                        continue;
                    }
                    while (!commonPrefix.isEmpty() && !string.startsWith(commonPrefix)) {
                        commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
                    }
                    if (!commonPrefix.isEmpty()) continue;
                    break;
                }
                commonPrefix = list.get(0).substring(0, commonPrefix.length());
                for (int i = 1; i < list.size(); ++i) {
                    String string = list.get(i).substring(0, commonPrefix.length());
                    if (string.equals(commonPrefix)) continue;
                    commonPrefix = commonPrefix.toLowerCase();
                    break;
                }
            }
            if (commonPrefix == null) {
                commonPrefix = "";
            }
            if (!StringUtil.startsWithIgnoreCase((String)commonPrefix, (String)pattern)) {
                commonPrefix = pattern;
            }
            String newPattern = commonPrefix;
            ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
            ChooseByNameBase.this.myTextField.setText(newPattern);
            ChooseByNameBase.this.myTextField.setCaretPosition(newPattern.length());
            ChooseByNameBase.this.rebuildList(false);
        }

        private boolean isComplexPattern(@NotNull String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "isComplexPattern"));
            }
            if (pattern.indexOf(42) >= 0) {
                return true;
            }
            for (String s : ChooseByNameBase.this.myModel.getSeparators()) {
                if (!pattern.contains(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Point getBestPopupPosition() {
            return new Point(ChooseByNameBase.this.myTextFieldPanel.getWidth(), this.getHeight());
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "paintComponent"));
            }
            GraphicsUtil.setupAntialiasing((Graphics)g);
            super.paintComponent(g);
        }

        public boolean isCompletionKeyStroke() {
            return this.completionKeyStrokeHappened;
        }
    }

    private class ListUpdater {
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private static final int DELAY = 10;
        private static final int MAX_BLOCKING_TIME = 30;
        private final List<ModelDiff.Cmd> myCommands = Collections.synchronizedList(new ArrayList());

        private ListUpdater() {
        }

        public void cancelAll() {
            this.myCommands.clear();
            this.myAlarm.cancelAllRequests();
        }

        public void appendToModel(@NotNull List<ModelDiff.Cmd> commands, final int selectionPos) {
            if (commands == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ListUpdater", "appendToModel"));
            }
            this.myAlarm.cancelAllRequests();
            this.myCommands.addAll(commands);
            if (this.myCommands.isEmpty() || ChooseByNameBase.this.checkDisposed()) {
                return;
            }
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (ChooseByNameBase.this.checkDisposed()) {
                        return;
                    }
                    long startTime = System.currentTimeMillis();
                    while (!ListUpdater.this.myCommands.isEmpty() && System.currentTimeMillis() - startTime < 30L) {
                        ModelDiff.Cmd cmd = (ModelDiff.Cmd)ListUpdater.this.myCommands.remove(0);
                        cmd.apply();
                    }
                    ChooseByNameBase.this.myList.setVisibleRowCount(Math.min(VISIBLE_LIST_SIZE_LIMIT, ChooseByNameBase.this.myList.getModel().getSize()));
                    if (!ListUpdater.this.myCommands.isEmpty()) {
                        ListUpdater.this.myAlarm.addRequest((Runnable)this, 10);
                    } else {
                        ListUpdater.this.doPostponedOkIfNeeded();
                    }
                    if (!ChooseByNameBase.this.checkDisposed()) {
                        ChooseByNameBase.this.showList();
                        ChooseByNameBase.this.myTextFieldPanel.repositionHint();
                        if (!ChooseByNameBase.this.myListModel.isEmpty()) {
                            int pos = selectionPos <= 0 ? ChooseByNameBase.this.detectBestStatisticalPosition() : selectionPos;
                            ListScrollingUtil.selectItem((JList)ChooseByNameBase.this.myList, (int)Math.min(pos, ChooseByNameBase.this.myListModel.size() - 1));
                        }
                    }
                }
            }, 10);
        }

        private void doPostponedOkIfNeeded() {
            if (ChooseByNameBase.this.myPostponedOkAction != null) {
                if (ChooseByNameBase.this.getChosenElement() != null) {
                    ChooseByNameBase.this.doClose(true);
                }
                ChooseByNameBase.this.clearPostponedOkAction(ChooseByNameBase.this.checkDisposed());
            }
        }
    }

    private static class MyListModel<T>
    extends DefaultListModel
    implements ModelDiff.Model<T> {
        private MyListModel() {
        }

        @Override
        public void addToModel(int idx, T element) {
            if (idx < this.size()) {
                this.add(idx, element);
            } else {
                this.addElement(element);
            }
        }

        @Override
        public void removeRangeFromModel(int start, int end) {
            if (start < this.size() && this.size() != 0) {
                this.removeRange(start, Math.min(end, this.size() - 1));
            }
        }
    }

    public class JPanelProvider
    extends JPanel
    implements DataProvider {
        private JBPopup myHint = null;
        private boolean myFocusRequested = false;

        JPanelProvider() {
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.SEARCH_INPUT_TEXT.is(dataId)) {
                return ChooseByNameBase.this.myTextField == null ? null : ChooseByNameBase.this.myTextField.getText();
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ChooseByNameBase.this.myModel.getHelpId();
            }
            if (ChooseByNameBase.this.myCalcElementsThread != null) {
                return null;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                Object element = ChooseByNameBase.this.getChosenElement();
                if (element instanceof PsiElement) {
                    return element;
                }
                if (element instanceof DataProvider) {
                    return ((DataProvider)element).getData(dataId);
                }
            } else if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                List<Object> chosenElements = ChooseByNameBase.this.getChosenElements();
                if (chosenElements != null) {
                    ArrayList<PsiElement> result = new ArrayList<PsiElement>(chosenElements.size());
                    for (Object element : chosenElements) {
                        if (!(element instanceof PsiElement)) continue;
                        result.add((PsiElement)element);
                    }
                    return PsiUtilCore.toPsiElementArray(result);
                }
            } else {
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
                    return this.getBounds();
                }
                if (PlatformDataKeys.SEARCH_INPUT_TEXT.is(dataId)) {
                    return ChooseByNameBase.this.myTextField == null ? null : ChooseByNameBase.this.myTextField.getText();
                }
            }
            return null;
        }

        public void registerHint(JBPopup h) {
            if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
                this.myHint.cancel();
            }
            this.myHint = h;
        }

        public boolean focusRequested() {
            boolean focusRequested = this.myFocusRequested;
            this.myFocusRequested = false;
            return focusRequested;
        }

        @Override
        public void requestFocus() {
            this.myFocusRequested = true;
        }

        public void unregisterHint() {
            this.myHint = null;
        }

        public void hideHint() {
            if (this.myHint != null) {
                this.myHint.cancel();
            }
        }

        @Nullable
        public JBPopup getHint() {
            return this.myHint;
        }

        public void updateHint(PsiElement element) {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
            if (updateProcessor != null) {
                updateProcessor.updatePopup(element);
            }
        }

        public void repositionHint() {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupPositionManager.positionPopupInBestPosition(this.myHint, null, null);
        }
    }
}

