/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionPopupMenuImpl
implements ActionPopupMenu,
ApplicationActivationListener {
    private final MyMenu myMenu;
    private final ActionManagerImpl myManager;
    private MessageBusConnection myConnection;
    private final Application myApp;
    private IdeFrame myFrame;
    @Nullable
    private Getter<DataContext> myDataContextProvider;

    public ActionPopupMenuImpl(String place, @NotNull ActionGroup group, ActionManagerImpl actionManager, @Nullable PresentationFactory factory) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl", "<init>"));
        }
        this.myManager = actionManager;
        this.myMenu = new MyMenu(place, group, factory);
        this.myApp = ApplicationManager.getApplication();
    }

    public JPopupMenu getComponent() {
        return this.myMenu;
    }

    public void setDataContextProvider(@Nullable Getter<DataContext> dataContextProvider) {
        this.myDataContextProvider = dataContextProvider;
    }

    public void applicationActivated(IdeFrame ideFrame) {
    }

    public void applicationDeactivated(IdeFrame ideFrame) {
        if (this.myFrame == ideFrame) {
            this.myMenu.setVisible(false);
        }
    }

    private class MyMenu
    extends JBPopupMenu {
        private final String myPlace;
        private final ActionGroup myGroup;
        private DataContext myContext;
        private final PresentationFactory myPresentationFactory;

        public MyMenu(@NotNull String place, @Nullable ActionGroup group, PresentationFactory factory) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl$MyMenu", "<init>"));
            }
            this.myPlace = place;
            this.myGroup = group;
            this.myPresentationFactory = factory != null ? factory : new MenuItemPresentationFactory();
            this.addPopupMenuListener(new MyPopupMenuListener());
        }

        public void show(Component component, int x, int y) {
            GraphicsDevice[] devices;
            if (!component.isShowing()) {
                throw new IllegalArgumentException("component must be shown on the screen");
            }
            this.removeAll();
            int x2 = Math.max(0, Math.min(x, component.getWidth() - 1));
            int y2 = Math.max(0, Math.min(y, component.getHeight() - 1));
            this.myContext = ActionPopupMenuImpl.this.myDataContextProvider != null ? (DataContext)ActionPopupMenuImpl.this.myDataContextProvider.get() : DataManager.getInstance().getDataContext(component, x2, y2);
            Utils.fillMenu(this.myGroup, (JComponent)((Object)this), true, this.myPresentationFactory, this.myContext, this.myPlace, false, false);
            if (this.getComponentCount() == 0) {
                return;
            }
            Dimension preferredSize = this.getPreferredSize();
            Point p = component.getLocationOnScreen();
            int _x = p.x + x;
            int _y = p.y + y;
            GraphicsConfiguration targetGraphicsConfiguration = null;
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice device : devices = env.getScreenDevices()) {
                GraphicsConfiguration graphicsConfiguration = device.getDefaultConfiguration();
                Rectangle r = graphicsConfiguration.getBounds();
                if (r.x > _x || _x > r.x + r.width || r.y > _y || _y > r.y + r.height) continue;
                targetGraphicsConfiguration = graphicsConfiguration;
                break;
            }
            if (targetGraphicsConfiguration == null && devices.length > 0) {
                targetGraphicsConfiguration = env.getDefaultScreenDevice().getDefaultConfiguration();
            }
            if (targetGraphicsConfiguration == null) {
                throw new IllegalStateException("It's impossible to determine target graphics environment for point (" + _x + "," + _y + ")");
            }
            Rectangle targetRectangle = ScreenUtil.getScreenRectangle(targetGraphicsConfiguration);
            if (_x + preferredSize.width > targetRectangle.x + targetRectangle.width) {
                x -= preferredSize.width;
            }
            if (_y + preferredSize.height > targetRectangle.y + targetRectangle.height) {
                int invisibleHeight = _y + preferredSize.height - targetRectangle.y - targetRectangle.height;
                y -= invisibleHeight;
            }
            if (ActionPopupMenuImpl.this.myApp != null && ActionPopupMenuImpl.this.myApp.isActive()) {
                Component frame = UIUtil.findUltimateParent((Component)component);
                if (frame instanceof IdeFrame) {
                    ActionPopupMenuImpl.this.myFrame = (IdeFrame)frame;
                }
                ActionPopupMenuImpl.this.myConnection = ActionPopupMenuImpl.this.myApp.getMessageBus().connect();
                ActionPopupMenuImpl.this.myConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)ActionPopupMenuImpl.this);
            }
            super.show(component, x, y);
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                ReflectionUtil.resetField((Object)((Object)this), (String)"invoker");
            }
        }

        private class MyPopupMenuListener
        implements PopupMenuListener {
            private MyPopupMenuListener() {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.disposeMenu();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.disposeMenu();
            }

            private void disposeMenu() {
                ActionPopupMenuImpl.this.myManager.removeActionPopup(ActionPopupMenuImpl.this);
                MyMenu.this.removeAll();
                if (ActionPopupMenuImpl.this.myConnection != null) {
                    ActionPopupMenuImpl.this.myConnection.disconnect();
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MyMenu.this.removeAll();
                Utils.fillMenu(MyMenu.this.myGroup, (JComponent)((Object)MyMenu.this), !UISettings.getInstance().DISABLE_MNEMONICS, MyMenu.this.myPresentationFactory, MyMenu.this.myContext, MyMenu.this.myPlace, false, false);
                ActionPopupMenuImpl.this.myManager.addActionPopup(ActionPopupMenuImpl.this);
            }
        }
    }
}

