/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.CompositeDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingData;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.LogicalToOffsetCalculationStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingUtil;
import com.intellij.openapi.editor.impl.softwrap.mapping.OffsetToLogicalCalculationStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListener;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapDataProviderKeys;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapsDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabulationDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.VisualToLogicalCalculationStrategy;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingSoftWrapDataMapper
implements SoftWrapAwareDocumentParsingListener,
Dumpable {
    private static final Logger LOG = Logger.getInstance((String)("#" + CachingSoftWrapDataMapper.class.getName()));
    private final List<CacheEntry> myCache;
    private final List<CacheEntry> myAffectedByUpdateCacheEntries;
    private final List<SoftWrapImpl> myAffectedByUpdateSoftWraps;
    private final LogicalToOffsetCalculationStrategy myLogicalToOffsetStrategy;
    private final OffsetToLogicalCalculationStrategy myOffsetToLogicalStrategy;
    private final VisualToLogicalCalculationStrategy myVisualToLogicalStrategy;
    private final EditorEx myEditor;
    private final SoftWrapsStorage myStorage;
    private final CacheEntry mySearchKey;

    public CachingSoftWrapDataMapper(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "<init>"));
        }
        this.myCache = new ArrayList<CacheEntry>();
        this.myAffectedByUpdateCacheEntries = new ArrayList<CacheEntry>();
        this.myAffectedByUpdateSoftWraps = new ArrayList<SoftWrapImpl>();
        this.myEditor = editor;
        this.myStorage = storage;
        this.mySearchKey = new CacheEntry(0, editor);
        this.myLogicalToOffsetStrategy = new LogicalToOffsetCalculationStrategy(editor, storage, this.myCache);
        this.myOffsetToLogicalStrategy = new OffsetToLogicalCalculationStrategy(editor, storage, this.myCache);
        this.myVisualToLogicalStrategy = new VisualToLogicalCalculationStrategy(editor, storage, this.myCache);
    }

    @NotNull
    public LogicalPosition visualToLogical(@NotNull VisualPosition visual) throws IllegalStateException {
        if (visual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visual", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "visualToLogical"));
        }
        if (this.myCache.isEmpty()) {
            LogicalPosition logicalPosition = new LogicalPosition(visual.line, visual.column, 0, 0, 0, 0, 0);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "visualToLogical"));
            }
            return logicalPosition;
        }
        this.myVisualToLogicalStrategy.init(visual, this.myCache);
        LogicalPosition logicalPosition = this.calculate(this.myVisualToLogicalStrategy);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "visualToLogical"));
        }
        return logicalPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        this.myOffsetToLogicalStrategy.init(offset, this.myCache);
        LogicalPosition logicalPosition = this.calculate(this.myOffsetToLogicalStrategy);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition logical) throws IllegalStateException {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logical", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "logicalPositionToOffset"));
        }
        this.myLogicalToOffsetStrategy.init(logical);
        return this.calculate(this.myLogicalToOffsetStrategy);
    }

    boolean matchesOldSoftWrap(SoftWrap newSoftWrap, int lengthDiff) {
        return Collections.binarySearch(this.myAffectedByUpdateSoftWraps, new SoftWrapImpl(new TextChangeImpl(newSoftWrap.getText(), newSoftWrap.getStart() - lengthDiff, newSoftWrap.getEnd() - lengthDiff), newSoftWrap.getIndentInColumns(), newSoftWrap.getIndentInPixels()), new Comparator<SoftWrapImpl>(){

            @Override
            public int compare(SoftWrapImpl o1, SoftWrapImpl o2) {
                int offsetDiff = o1.getStart() - o2.getStart();
                if (offsetDiff != 0) {
                    return offsetDiff;
                }
                int textDiff = o1.getText().toString().compareTo(o2.getText().toString());
                if (textDiff != 0) {
                    return textDiff;
                }
                int colIndentDiff = o1.getIndentInColumns() - o2.getIndentInColumns();
                if (colIndentDiff != 0) {
                    return colIndentDiff;
                }
                return o1.getIndentInPixels() - o2.getIndentInPixels();
            }
        }) >= 0;
    }

    public int getVisualLineStartOffset(int visualLine) {
        int index = this.getCacheEntryIndexForVisualLine(visualLine);
        if (index >= 0) {
            return this.myCache.get((int)index).startOffset;
        }
        int previousIndex = -index - 2;
        if (previousIndex < 0) {
            return this.getLogicalLineStartOffset(visualLine);
        }
        CacheEntry prevEntry = this.myCache.get(previousIndex);
        return this.getLogicalLineStartOffset(prevEntry.endLogicalLine + visualLine - prevEntry.visualLine);
    }

    private int getLogicalLineStartOffset(int logicalLine) {
        DocumentEx document = this.myEditor.getDocument();
        return logicalLine >= document.getLineCount() ? document.getTextLength() : document.getLineStartOffset(logicalLine);
    }

    public int getPreviousVisualLineStartOffset(int offset) {
        DocumentEx document = this.myEditor.getDocument();
        int cacheIndex = MappingUtil.getCacheEntryIndexForOffset(offset, document, this.myCache);
        if (cacheIndex < 0) {
            return document.getLineStartOffset(document.getLineNumber(offset));
        }
        if (cacheIndex == 0) {
            return this.myCache.get((int)cacheIndex).startOffset;
        }
        CacheEntry thisEntry = this.myCache.get(cacheIndex);
        CacheEntry prevEntry = this.myCache.get(cacheIndex - 1);
        return thisEntry.startOffset == prevEntry.endOffset ? prevEntry.startOffset : thisEntry.startOffset;
    }

    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logical, @NotNull VisualPosition softWrapUnawareVisual) throws IllegalStateException {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logical", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "logicalToVisualPosition"));
        }
        if (softWrapUnawareVisual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "softWrapUnawareVisual", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "logicalToVisualPosition"));
        }
        if (logical.visualPositionAware) {
            return logical.toVisualPosition();
        }
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        int maxOffset = this.myEditor.logicalPositionToOffset(logical);
        int endIndex = this.myStorage.getSoftWrapIndex(maxOffset);
        if (endIndex < 0) {
            endIndex = -endIndex - 2;
        }
        if (endIndex < 0 || endIndex >= softWraps.size()) {
            return softWrapUnawareVisual;
        }
        int lineDiff = 0;
        int column = -1;
        int targetLogicalLineStartOffset = this.myEditor.logicalPositionToOffset(new LogicalPosition(logical.line, 0));
        for (int i = endIndex; i >= 0; --i) {
            SoftWrap softWrap = softWraps.get(i);
            if (softWrap == null) {
                assert (false);
                continue;
            }
            if (column < 0 && softWrap.getStart() >= targetLogicalLineStartOffset) {
                column = softWrap.getIndentInColumns() + SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).toVisualColumnSymbolsNumber(softWrap.getStart(), maxOffset, softWrap.getIndentInPixels());
                ++lineDiff;
                continue;
            }
            lineDiff += i + 1;
            break;
        }
        int columnToUse = column >= 0 ? column : softWrapUnawareVisual.column;
        return new VisualPosition(softWrapUnawareVisual.line + lineDiff, columnToUse);
    }

    public void release() {
        this.myCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T calculate(@NotNull MappingStrategy<T> strategy) throws IllegalStateException {
        CompositeDataProvider provider;
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "calculate"));
        }
        T eagerMatch = strategy.eagerMatch();
        if (eagerMatch != null) {
            return eagerMatch;
        }
        EditorPosition position = strategy.buildInitialPosition();
        FoldingModelEx foldingModel = this.myEditor.getFoldingModel();
        boolean foldingState = foldingModel.isFoldingEnabled();
        foldingModel.setFoldingEnabled(true);
        try {
            provider = new CompositeDataProvider(new SoftWrapsDataProvider(this.myStorage), new FoldingDataProvider(this.myEditor.getFoldingModel().fetchTopLevel()), this.getTabulationDataProvider(position.visualLine));
        }
        finally {
            foldingModel.setFoldingEnabled(foldingState);
        }
        provider.advance(position.offset);
        while (provider.hasData()) {
            Pair data = provider.getData();
            T result = null;
            int sortingKey = provider.getSortingKey();
            if (position.offset <= sortingKey && (result = (T)strategy.advance(position, sortingKey)) != null) {
                return result;
            }
            switch ((SoftWrapDataProviderKeys)((Object)data.first)) {
                case SOFT_WRAP: {
                    result = strategy.processSoftWrap(position, (SoftWrap)data.second);
                    break;
                }
                case COLLAPSED_FOLDING: {
                    result = strategy.processFoldRegion(position, (FoldRegion)data.second);
                    break;
                }
                case TABULATION: {
                    result = strategy.processTabulation(position, (TabData)data.second);
                }
            }
            if (result != null) {
                return result;
            }
            provider.next();
        }
        return strategy.build(position);
    }

    private TabulationDataProvider getTabulationDataProvider(int visualLine) throws IllegalStateException {
        this.mySearchKey.visualLine = visualLine;
        int i = Collections.binarySearch(this.myCache, this.mySearchKey);
        List<TabData> tabs = i >= 0 ? this.myCache.get(i).getTabData() : Collections.emptyList();
        return new TabulationDataProvider(tabs);
    }

    @Override
    public void onVisualLineStart(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onVisualLineStart"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, true);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setLineStartPosition(position);
    }

    @Override
    public void onVisualLineEnd(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onVisualLineEnd"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, false);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setLineEndPosition(position);
    }

    @Override
    public void onCollapsedFoldRegion(@NotNull FoldRegion foldRegion, int widthInColumns, int visualLine) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onCollapsedFoldRegion"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(visualLine, false);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.store(new FoldingData(foldRegion, widthInColumns), foldRegion.getStartOffset());
    }

    @Override
    public void beforeSoftWrapLineFeed(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "beforeSoftWrapLineFeed"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, false);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setLineEndPosition(position);
    }

    @Override
    public void afterSoftWrapLineFeed(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "afterSoftWrapLineFeed"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, true);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setLineStartPosition(position);
    }

    @Override
    public void revertToOffset(int offset, int visualLine) {
        CacheEntry entry = this.getCacheEntryForVisualLine(visualLine, false);
        if (entry != null) {
            entry.removeAllDataAtOrAfter(offset);
        }
    }

    @Override
    public void onTabulation(@NotNull EditorPosition position, int widthInColumns) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onTabulation"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, false);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.storeTabData(new TabData(widthInColumns, position.offset));
    }

    @Override
    public void recalculationEnds() {
    }

    @Nullable
    private CacheEntry getCacheEntryForVisualLine(int visualLine, boolean createIfNecessary) {
        if (!this.myCache.isEmpty()) {
            CacheEntry lastEntry = this.myCache.get(this.myCache.size() - 1);
            if (lastEntry.visualLine == visualLine) {
                return lastEntry;
            }
            if (lastEntry.visualLine < visualLine && createIfNecessary) {
                CacheEntry result = new CacheEntry(visualLine, this.myEditor);
                this.myCache.add(result);
                return result;
            }
        }
        int cacheEntryIndex = this.getCacheEntryIndexForVisualLine(visualLine);
        CacheEntry result = null;
        if (cacheEntryIndex < 0) {
            cacheEntryIndex = -cacheEntryIndex - 1;
            if (createIfNecessary) {
                result = new CacheEntry(visualLine, this.myEditor);
                this.myCache.add(cacheEntryIndex, result);
            }
        } else {
            result = this.myCache.get(cacheEntryIndex);
        }
        return result;
    }

    private int getCacheEntryIndexForVisualLine(int visualLine) {
        int start = 0;
        int end = this.myCache.size() - 1;
        int cacheEntryIndex = -1;
        while (start <= end) {
            int i = end + start >>> 1;
            CacheEntry cacheEntry = this.myCache.get(i);
            if (cacheEntry.visualLine < visualLine) {
                start = i + 1;
                continue;
            }
            if (cacheEntry.visualLine > visualLine) {
                end = i - 1;
                continue;
            }
            cacheEntryIndex = i;
            break;
        }
        return cacheEntryIndex < 0 ? -start - 1 : cacheEntryIndex;
    }

    @Override
    public void onCacheUpdateStart(@NotNull IncrementalCacheUpdateEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onCacheUpdateStart"));
        }
        int startOffset = event.getStartOffset();
        int startIndex = MappingUtil.getCacheEntryIndexForOffset(startOffset, this.myEditor.getDocument(), this.myCache);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        this.myAffectedByUpdateCacheEntries.clear();
        if (startIndex < this.myCache.size()) {
            List<CacheEntry> affectedEntries = this.myCache.subList(startIndex, this.myCache.size());
            this.myAffectedByUpdateCacheEntries.addAll(affectedEntries);
            affectedEntries.clear();
        }
        this.myAffectedByUpdateSoftWraps.clear();
        this.myAffectedByUpdateSoftWraps.addAll(this.myStorage.removeStartingFrom(startOffset + 1));
    }

    @Override
    public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onRecalculationEnd"));
        }
        int softWrappedLinesDiff = this.advanceSoftWrapOffsets(event);
        this.applyStateChange(event, softWrappedLinesDiff);
    }

    @Override
    public void reset() {
        this.myCache.clear();
        this.myAffectedByUpdateCacheEntries.clear();
        this.myAffectedByUpdateSoftWraps.clear();
    }

    private int advanceSoftWrapOffsets(@NotNull IncrementalCacheUpdateEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "advanceSoftWrapOffsets"));
        }
        int lengthDiff = event.getLengthDiff();
        int recalcEndOffsetTranslated = event.getActualEndOffset() - lengthDiff;
        int firstIndex = -1;
        int softWrappedLinesDiff = this.myStorage.getNumberOfSoftWrapsInRange(event.getStartOffset() + 1, this.myEditor.getDocument().getTextLength());
        boolean softWrapsChanged = softWrappedLinesDiff > 0;
        for (int i = 0; i < this.myAffectedByUpdateSoftWraps.size(); ++i) {
            SoftWrap softWrap = this.myAffectedByUpdateSoftWraps.get(i);
            if (firstIndex < 0) {
                if (softWrap.getStart() > recalcEndOffsetTranslated) {
                    firstIndex = i;
                    if (lengthDiff == 0) {
                        break;
                    }
                } else {
                    --softWrappedLinesDiff;
                    softWrapsChanged = true;
                }
            }
            if (firstIndex < 0 || i < firstIndex) continue;
            ((SoftWrapImpl)softWrap).advance(lengthDiff);
        }
        if (firstIndex >= 0) {
            List<SoftWrapImpl> updated = this.myAffectedByUpdateSoftWraps.subList(firstIndex, this.myAffectedByUpdateSoftWraps.size());
            SoftWrapImpl lastSoftWrap = this.getLastSoftWrap();
            if (lastSoftWrap != null && lastSoftWrap.getStart() >= updated.get(0).getStart()) {
                LOG.error("Invalid soft wrap recalculation", new Attachment[]{new Attachment("state.txt", this.myEditor.getSoftWrapModel().toString())});
            }
            this.myStorage.addAll(updated);
        }
        this.myAffectedByUpdateSoftWraps.clear();
        if (softWrapsChanged) {
            this.myStorage.notifyListenersAboutChange();
        }
        return softWrappedLinesDiff;
    }

    private void applyStateChange(@NotNull IncrementalCacheUpdateEvent event, int softWrappedLinesDiff) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "applyStateChange"));
        }
        CacheEntry lastEntry = this.myCache.isEmpty() ? null : this.myCache.get(this.myCache.size() - 1);
        int lengthDiff = event.getLengthDiff();
        int recalcEndOffsetTranslated = event.getActualEndOffset() - lengthDiff;
        int startIndex = MappingUtil.getCacheEntryIndexForOffset(event.getStartOffset(), this.myEditor.getDocument(), this.myCache);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        int foldedLinesDiff = 0;
        for (int i = startIndex; i < this.myCache.size(); ++i) {
            CacheEntry entry = this.myCache.get(i);
            foldedLinesDiff += entry.endFoldedLines - entry.startFoldedLines;
        }
        int logicalLinesDiff = event.getLogicalLinesDiff();
        int firstIndex = -1;
        int borderLogicalLine = lastEntry == null ? -1 : lastEntry.endLogicalLine;
        int borderColumnDiff = 0;
        int borderFoldedColumnDiff = 0;
        int borderSoftWrapColumnDiff = 0;
        int borderSoftWrapLinesBeforeDiff = 0;
        int borderSoftWrapLinesCurrentDiff = 0;
        int affectedEntriesCount = this.myAffectedByUpdateCacheEntries.size();
        for (int i = 0; i < affectedEntriesCount; ++i) {
            CacheEntry entry = this.myAffectedByUpdateCacheEntries.get(i);
            if (firstIndex < 0) {
                if (entry.startOffset < recalcEndOffsetTranslated) {
                    foldedLinesDiff -= entry.endFoldedLines - entry.startFoldedLines;
                    continue;
                }
                firstIndex = i;
                if (lastEntry != null && entry.startLogicalLine + logicalLinesDiff == borderLogicalLine) {
                    borderColumnDiff = lastEntry.endLogicalColumn - entry.startLogicalColumn;
                    borderSoftWrapLinesBeforeDiff = lastEntry.endSoftWrapLinesBefore - entry.startSoftWrapLinesBefore;
                    borderSoftWrapLinesCurrentDiff = lastEntry.endSoftWrapLinesCurrent - entry.startSoftWrapLinesCurrent + 1;
                    borderFoldedColumnDiff = lastEntry.endFoldingColumnDiff - entry.startFoldingColumnDiff;
                    borderSoftWrapColumnDiff = -borderColumnDiff - borderFoldedColumnDiff;
                }
                if (lengthDiff == 0 && logicalLinesDiff == 0 && foldedLinesDiff == 0 && softWrappedLinesDiff == 0 && borderColumnDiff == 0 && borderSoftWrapColumnDiff == 0 && borderFoldedColumnDiff == 0 && borderSoftWrapLinesBeforeDiff == 0 && borderSoftWrapLinesCurrentDiff == 0) break;
            }
            if (firstIndex < 0 || i < firstIndex) continue;
            entry.visualLine += logicalLinesDiff + softWrappedLinesDiff - foldedLinesDiff;
            entry.startLogicalLine += logicalLinesDiff;
            entry.endLogicalLine += logicalLinesDiff;
            entry.advance(lengthDiff);
            entry.startFoldedLines += foldedLinesDiff;
            entry.endFoldedLines += foldedLinesDiff;
            if (entry.startLogicalLine == borderLogicalLine) {
                entry.startLogicalColumn += borderColumnDiff;
                entry.startSoftWrapLinesBefore += borderSoftWrapLinesBeforeDiff;
                entry.startSoftWrapLinesCurrent += borderSoftWrapLinesCurrentDiff;
                entry.startSoftWrapColumnDiff += borderSoftWrapColumnDiff;
                entry.startFoldingColumnDiff += borderFoldedColumnDiff;
            } else {
                entry.startSoftWrapLinesBefore += softWrappedLinesDiff;
            }
            if (entry.endLogicalLine == borderLogicalLine) {
                entry.endLogicalColumn += borderColumnDiff;
                entry.endSoftWrapLinesBefore += borderSoftWrapLinesBeforeDiff;
                entry.endSoftWrapLinesCurrent += borderSoftWrapLinesCurrentDiff;
                entry.endSoftWrapColumnDiff += borderSoftWrapColumnDiff;
                entry.endFoldingColumnDiff += borderFoldedColumnDiff;
                continue;
            }
            entry.endSoftWrapLinesBefore += softWrappedLinesDiff;
        }
        if (firstIndex >= 0) {
            if (lastEntry != null) {
                CacheEntry nextEntry = this.myAffectedByUpdateCacheEntries.get(firstIndex);
                if (lastEntry.visualLine >= nextEntry.visualLine) {
                    LOG.error("Invalid soft wrap cache update", new Attachment[]{new Attachment("state.txt", this.myEditor.getSoftWrapModel().toString())});
                }
            }
            if (this.myAffectedByUpdateCacheEntries.get((int)(affectedEntriesCount - 1)).endOffset > this.myEditor.getDocument().getTextLength()) {
                LOG.error("Invalid soft wrap cache entries emerged", new Attachment[]{new Attachment("state.txt", this.myEditor.getSoftWrapModel().toString())});
            }
            this.myCache.addAll(this.myAffectedByUpdateCacheEntries.subList(firstIndex, this.myAffectedByUpdateCacheEntries.size()));
        }
        this.myAffectedByUpdateCacheEntries.clear();
    }

    @Nullable
    SoftWrapImpl getLastSoftWrap() {
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        return softWraps.isEmpty() ? null : softWraps.get(softWraps.size() - 1);
    }

    @NotNull
    public String dumpState() {
        String string = "Current cache: " + this.myCache.toString() + ", entries affected by current update: " + this.myAffectedByUpdateCacheEntries + ", soft wraps affected by current update: " + this.myAffectedByUpdateSoftWraps;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "dumpState"));
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    public void rawAdd(int visualLine, int startOffset, int endOffset, int startLogicalLine, int startLogicalColumn, int endLogicalLine, int endLogicalColumn, int endVisualColumn, @NotNull List<Pair<Integer, FoldRegion>> foldRegions, @NotNull List<Pair<Integer, Integer>> tabData) {
        if (foldRegions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegions", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "rawAdd"));
        }
        if (tabData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabData", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "rawAdd"));
        }
        CacheEntry entry = new CacheEntry(visualLine, this.myEditor);
        entry.startOffset = startOffset;
        entry.endOffset = endOffset;
        entry.startLogicalLine = startLogicalLine;
        assert (startLogicalLine == this.myEditor.getDocument().getLineNumber(startOffset));
        entry.startLogicalColumn = startLogicalColumn;
        entry.endLogicalLine = endLogicalLine;
        assert (endLogicalLine == this.myEditor.getDocument().getLineNumber(endOffset));
        entry.endLogicalColumn = endLogicalColumn;
        entry.endVisualColumn = endVisualColumn;
        for (Pair<Integer, FoldRegion> pair : foldRegions) {
            FoldingData foldData = new FoldingData((FoldRegion)pair.second, (Integer)pair.first);
            entry.store(foldData, ((FoldRegion)pair.second).getStartOffset());
        }
        for (Pair pair : tabData) {
            entry.storeTabData(new TabData((Integer)pair.second, (Integer)pair.first));
        }
        this.myCache.add(entry);
    }

    void removeLastCacheEntry() {
        LOG.assertTrue(!this.myCache.isEmpty());
        this.myCache.remove(this.myCache.size() - 1);
    }

    public List<CacheEntry> getCache() {
        return this.myCache;
    }
}

