/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NotNull;

public class GenericKeymapManager
extends DefaultKeymap {
    @Override
    public String getDefaultKeymapName() {
        if (SystemInfo.isMac) {
            return "Mac OS X 10.5+";
        }
        if (SystemInfo.isXWindow) {
            return "Default for XWin";
        }
        return "$default";
    }

    @Override
    public String getKeymapPresentableName(@NotNull KeymapImpl keymap) {
        if (keymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymap", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getKeymapPresentableName"));
        }
        String name = keymap.getName();
        if (this.getDefaultKeymapName().equals(name)) {
            return "Default";
        }
        if ("$default".equals(name)) {
            return "IntelliJ IDEA Classic" + (SystemInfo.isMac ? " (Windows)" : "");
        }
        if ("Mac OS X".equals(name)) {
            return "IntelliJ IDEA Classic (OS X)";
        }
        return name;
    }
}

