/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.Converter01;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapImpl
extends ExternalizableSchemeAdapter
implements Keymap {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.keymap.KeymapImpl");
    @NonNls
    private static final String KEY_MAP = "keymap";
    @NonNls
    private static final String KEYBOARD_SHORTCUT = "keyboard-shortcut";
    @NonNls
    private static final String KEYBOARD_GESTURE_SHORTCUT = "keyboard-gesture-shortcut";
    @NonNls
    private static final String KEYBOARD_GESTURE_KEY = "keystroke";
    @NonNls
    private static final String KEYBOARD_GESTURE_MODIFIER = "modifier";
    @NonNls
    private static final String KEYSTROKE_ATTRIBUTE = "keystroke";
    @NonNls
    private static final String FIRST_KEYSTROKE_ATTRIBUTE = "first-keystroke";
    @NonNls
    private static final String SECOND_KEYSTROKE_ATTRIBUTE = "second-keystroke";
    @NonNls
    private static final String ACTION = "action";
    @NonNls
    private static final String VERSION_ATTRIBUTE = "version";
    @NonNls
    private static final String PARENT_ATTRIBUTE = "parent";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String ID_ATTRIBUTE = "id";
    @NonNls
    private static final String MOUSE_SHORTCUT = "mouse-shortcut";
    @NonNls
    private static final String SHIFT = "shift";
    @NonNls
    private static final String CONTROL = "control";
    @NonNls
    private static final String META = "meta";
    @NonNls
    private static final String ALT = "alt";
    @NonNls
    private static final String ALT_GRAPH = "altGraph";
    @NonNls
    private static final String DOUBLE_CLICK = "doubleClick";
    @NonNls
    private static final String VIRTUAL_KEY_PREFIX = "VK_";
    @NonNls
    private static final String EDITOR_ACTION_PREFIX = "Editor";
    private KeymapImpl myParent;
    private boolean myCanModify = true;
    private final THashMap<String, OrderedSet<Shortcut>> myActionId2ListOfShortcuts = new THashMap();
    private Map<KeyStroke, List<String>> myKeystroke2ListOfIds = null;
    private Map<KeyboardModifierGestureShortcut, List<String>> myGesture2ListOfIds = null;
    private Map<MouseShortcut, List<String>> myMouseShortcut2ListOfIds = null;
    private static final Map<Integer, String> ourNamesForKeycodes;
    private static final Shortcut[] ourEmptyShortcutsArray;
    private final List<Keymap.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private KeymapManagerEx myKeymapManager;

    public String getPresentableName() {
        return this.getName();
    }

    public KeymapImpl deriveKeymap() {
        if (this.canModify()) {
            return this.copy();
        }
        KeymapImpl newKeymap = new KeymapImpl();
        newKeymap.myParent = this;
        newKeymap.myName = null;
        newKeymap.myCanModify = this.canModify();
        return newKeymap;
    }

    @NotNull
    public KeymapImpl copy() {
        KeymapImpl keymapImpl = this.copyTo(new KeymapImpl());
        if (keymapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapImpl", "copy"));
        }
        return keymapImpl;
    }

    @NotNull
    public KeymapImpl copyTo(final @NotNull KeymapImpl otherKeymap) {
        if (otherKeymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherKeymap", "com/intellij/openapi/keymap/impl/KeymapImpl", "copyTo"));
        }
        otherKeymap.myParent = this.myParent;
        otherKeymap.myName = this.myName;
        otherKeymap.myCanModify = this.canModify();
        otherKeymap.cleanShortcutsCache();
        otherKeymap.myActionId2ListOfShortcuts.clear();
        otherKeymap.myActionId2ListOfShortcuts.ensureCapacity(this.myActionId2ListOfShortcuts.size());
        this.myActionId2ListOfShortcuts.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, OrderedSet<Shortcut>>(){

            public boolean execute(String actionId, OrderedSet<Shortcut> shortcuts) {
                otherKeymap.myActionId2ListOfShortcuts.put((Object)actionId, (Object)new OrderedSet(shortcuts));
                return true;
            }
        });
        KeymapImpl keymapImpl = otherKeymap;
        if (keymapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapImpl", "copyTo"));
        }
        return keymapImpl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Keymap)) {
            return false;
        }
        KeymapImpl secondKeymap = (KeymapImpl)((Object)object);
        if (!Comparing.equal((String)this.myName, (String)secondKeymap.myName)) {
            return false;
        }
        if (this.myCanModify != secondKeymap.myCanModify) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)this.myParent), (Object)((Object)secondKeymap.myParent))) {
            return false;
        }
        return Comparing.equal(this.myActionId2ListOfShortcuts, secondKeymap.myActionId2ListOfShortcuts);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.myName != null) {
            hashCode += this.myName.hashCode();
        }
        return hashCode;
    }

    public Keymap getParent() {
        return this.myParent;
    }

    public boolean canModify() {
        return this.myCanModify;
    }

    public void setCanModify(boolean val) {
        this.myCanModify = val;
    }

    protected Shortcut[] getParentShortcuts(String actionId) {
        return this.myParent.getShortcuts(actionId);
    }

    public void addShortcut(String actionId, Shortcut shortcut) {
        this.addShortcutSilently(actionId, shortcut, true);
        this.fireShortcutChanged(actionId);
    }

    private void addShortcutSilently(String actionId, Shortcut shortcut, boolean checkParentShortcut) {
        OrderedSet list = (OrderedSet)this.myActionId2ListOfShortcuts.get((Object)actionId);
        if (list == null) {
            list = new OrderedSet();
            this.myActionId2ListOfShortcuts.put((Object)actionId, (Object)list);
            Object[] boundShortcuts = this.getBoundShortcuts(actionId);
            if (boundShortcuts != null) {
                ContainerUtil.addAll((Collection)list, (Object[])boundShortcuts);
            } else if (this.myParent != null) {
                ContainerUtil.addAll((Collection)list, (Object[])this.getParentShortcuts(actionId));
            }
        }
        list.add((Object)shortcut);
        if (checkParentShortcut && this.myParent != null && KeymapImpl.areShortcutsEqual(this.getParentShortcuts(actionId), this.getShortcuts(actionId))) {
            this.myActionId2ListOfShortcuts.remove((Object)actionId);
        }
        this.cleanShortcutsCache();
    }

    private void cleanShortcutsCache() {
        this.myKeystroke2ListOfIds = null;
        this.myMouseShortcut2ListOfIds = null;
    }

    public void removeAllActionShortcuts(String actionId) {
        Shortcut[] allShortcuts;
        for (Shortcut shortcut : allShortcuts = this.getShortcuts(actionId)) {
            this.removeShortcut(actionId, shortcut);
        }
    }

    public void removeShortcut(String actionId, Shortcut toDelete) {
        OrderedSet list = (OrderedSet)this.myActionId2ListOfShortcuts.get((Object)actionId);
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Shortcut each = (Shortcut)it.next();
                if (!toDelete.equals(each)) continue;
                it.remove();
                if (this.myParent != null && KeymapImpl.areShortcutsEqual(this.getParentShortcuts(actionId), this.getShortcuts(actionId)) || this.myParent == null && list.isEmpty()) {
                    this.myActionId2ListOfShortcuts.remove((Object)actionId);
                }
                break;
            }
        } else {
            Shortcut[] inherited = this.getBoundShortcuts(actionId);
            if (inherited == null && this.myParent != null) {
                inherited = this.getParentShortcuts(actionId);
            }
            if (inherited != null) {
                boolean affected = false;
                OrderedSet newShortcuts = new OrderedSet(inherited.length);
                for (Shortcut eachInherited : inherited) {
                    if (toDelete.equals(eachInherited)) {
                        affected = true;
                        continue;
                    }
                    newShortcuts.add((Object)eachInherited);
                }
                if (affected) {
                    this.myActionId2ListOfShortcuts.put((Object)actionId, (Object)newShortcuts);
                }
            }
        }
        this.cleanShortcutsCache();
        this.fireShortcutChanged(actionId);
    }

    private Map<KeyStroke, List<String>> getKeystroke2ListOfIds() {
        if (this.myKeystroke2ListOfIds != null) {
            return this.myKeystroke2ListOfIds;
        }
        this.myKeystroke2ListOfIds = new THashMap();
        for (String id : ContainerUtil.concat((Iterable[])new Iterable[]{this.myActionId2ListOfShortcuts.keySet(), this.getKeymapManager().getBoundActions()})) {
            this.addKeystrokesMap(id, this.myKeystroke2ListOfIds);
        }
        return this.myKeystroke2ListOfIds;
    }

    private Map<KeyboardModifierGestureShortcut, List<String>> getGesture2ListOfIds() {
        if (this.myGesture2ListOfIds == null) {
            this.myGesture2ListOfIds = new THashMap();
            this.fillShortcut2ListOfIds(this.myGesture2ListOfIds, KeyboardModifierGestureShortcut.class);
        }
        return this.myGesture2ListOfIds;
    }

    private <T extends Shortcut> void fillShortcut2ListOfIds(Map<T, List<String>> map, Class<T> shortcutClass) {
        for (String id : ContainerUtil.concat((Iterable[])new Iterable[]{this.myActionId2ListOfShortcuts.keySet(), this.getKeymapManager().getBoundActions()})) {
            this.addAction2ShortcutsMap(id, map, shortcutClass);
        }
    }

    private Map<MouseShortcut, List<String>> getMouseShortcut2ListOfIds() {
        if (this.myMouseShortcut2ListOfIds == null) {
            this.myMouseShortcut2ListOfIds = new THashMap();
            this.fillShortcut2ListOfIds(this.myMouseShortcut2ListOfIds, MouseShortcut.class);
        }
        return this.myMouseShortcut2ListOfIds;
    }

    private <T extends Shortcut> void addAction2ShortcutsMap(String actionId, Map<T, List<String>> strokesMap, Class<T> shortcutClass) {
        OrderedSet<Shortcut> listOfShortcuts = this._getShortcuts(actionId);
        for (Shortcut shortcut : listOfShortcuts) {
            if (!shortcutClass.isAssignableFrom(shortcut.getClass())) continue;
            Shortcut t = shortcut;
            List<String> listOfIds = strokesMap.get(t);
            if (listOfIds == null) {
                listOfIds = new ArrayList<String>();
                strokesMap.put(t, listOfIds);
            }
            if (listOfIds.contains(actionId)) continue;
            listOfIds.add(actionId);
        }
    }

    private void addKeystrokesMap(String actionId, Map<KeyStroke, List<String>> strokesMap) {
        OrderedSet<Shortcut> listOfShortcuts = this._getShortcuts(actionId);
        for (Shortcut shortcut : listOfShortcuts) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyStroke firstKeyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            List<String> listOfIds = strokesMap.get(firstKeyStroke);
            if (listOfIds == null) {
                listOfIds = new ArrayList<String>();
                strokesMap.put(firstKeyStroke, listOfIds);
            }
            if (listOfIds.contains(actionId)) continue;
            listOfIds.add(actionId);
        }
    }

    private OrderedSet<Shortcut> _getShortcuts(String actionId) {
        KeymapManagerEx keymapManager = this.getKeymapManager();
        OrderedSet listOfShortcuts = (OrderedSet)this.myActionId2ListOfShortcuts.get((Object)actionId);
        if (listOfShortcuts != null) {
            return listOfShortcuts;
        }
        listOfShortcuts = new OrderedSet();
        String actionBinding = keymapManager.getActionBinding(actionId);
        if (actionBinding != null) {
            listOfShortcuts.addAll(this._getShortcuts(actionBinding));
        }
        return listOfShortcuts;
    }

    protected String[] getParentActionIds(KeyStroke firstKeyStroke) {
        return this.myParent.getActionIds(firstKeyStroke);
    }

    protected String[] getParentActionIds(KeyboardModifierGestureShortcut gesture) {
        return this.myParent.getActionIds(gesture);
    }

    private String[] getActionIds(KeyboardModifierGestureShortcut shortcut) {
        String[] ids;
        Map<KeyboardModifierGestureShortcut, List<String>> map = this.getGesture2ListOfIds();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<KeyboardModifierGestureShortcut, List<String>> entry : map.entrySet()) {
            if (!shortcut.startsWith((Shortcut)entry.getKey())) continue;
            list.addAll((Collection)entry.getValue());
        }
        if (this.myParent != null && (ids = this.getParentActionIds(shortcut)).length > 0) {
            for (String id : ids) {
                if (this.myActionId2ListOfShortcuts.containsKey((Object)id)) continue;
                list.add(id);
            }
        }
        return KeymapImpl.sortInOrderOfRegistration(ArrayUtil.toStringArray(list));
    }

    public String[] getActionIds(KeyStroke firstKeyStroke) {
        String[] ids;
        List<String> list = this.getKeystroke2ListOfIds().get(firstKeyStroke);
        if (this.myParent != null && (ids = this.getParentActionIds(firstKeyStroke)).length > 0) {
            boolean originalListInstance = true;
            for (String id : ids) {
                if (this.myActionId2ListOfShortcuts.containsKey((Object)id) || this.myActionId2ListOfShortcuts.containsKey((Object)this.getActionBinding(id))) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                    originalListInstance = false;
                } else if (originalListInstance) {
                    list = new ArrayList<String>(list);
                    originalListInstance = false;
                }
                if (list.contains(id)) continue;
                list.add(id);
            }
        }
        if (list == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return KeymapImpl.sortInOrderOfRegistration(ArrayUtil.toStringArray(list));
    }

    public String[] getActionIds(KeyStroke firstKeyStroke, KeyStroke secondKeyStroke) {
        String[] ids = this.getActionIds(firstKeyStroke);
        ArrayList<String> actualBindings = new ArrayList<String>();
        block0: for (String id : ids) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = this.getShortcuts(id)) {
                if (!(shortcut instanceof KeyboardShortcut) || !Comparing.equal((Object)firstKeyStroke, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()) || !Comparing.equal((Object)secondKeyStroke, (Object)((KeyboardShortcut)shortcut).getSecondKeyStroke())) continue;
                actualBindings.add(id);
                continue block0;
            }
        }
        return ArrayUtil.toStringArray(actualBindings);
    }

    public String[] getActionIds(Shortcut shortcut) {
        if (shortcut instanceof KeyboardShortcut) {
            KeyboardShortcut kb = (KeyboardShortcut)shortcut;
            KeyStroke first = kb.getFirstKeyStroke();
            KeyStroke second = kb.getSecondKeyStroke();
            return second != null ? this.getActionIds(first, second) : this.getActionIds(first);
        }
        if (shortcut instanceof MouseShortcut) {
            return this.getActionIds((MouseShortcut)shortcut);
        }
        if (shortcut instanceof KeyboardModifierGestureShortcut) {
            return this.getActionIds((KeyboardModifierGestureShortcut)shortcut);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected String[] getParentActionIds(MouseShortcut shortcut) {
        return this.myParent.getActionIds(shortcut);
    }

    public String[] getActionIds(MouseShortcut shortcut) {
        String[] ids;
        List<String> list = this.getMouseShortcut2ListOfIds().get(shortcut);
        if (this.myParent != null && (ids = this.getParentActionIds(shortcut)).length > 0) {
            boolean originalListInstance = true;
            for (String id : ids) {
                if (this.myActionId2ListOfShortcuts.containsKey((Object)id)) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                    originalListInstance = false;
                } else if (originalListInstance) {
                    list = new ArrayList<String>(list);
                }
                list.add(id);
            }
        }
        if (list == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return KeymapImpl.sortInOrderOfRegistration(ArrayUtil.toStringArray(list));
    }

    private static String[] sortInOrderOfRegistration(String[] ids) {
        Arrays.sort(ids, ActionManagerEx.getInstanceEx().getRegistrationOrderComparator());
        return ids;
    }

    public boolean isActionBound(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/KeymapImpl", "isActionBound"));
        }
        return this.getKeymapManager().getBoundActions().contains(actionId);
    }

    @Nullable
    public String getActionBinding(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/KeymapImpl", "getActionBinding"));
        }
        return this.getKeymapManager().getActionBinding(actionId);
    }

    @NotNull
    public Shortcut[] getShortcuts(String actionId) {
        Shortcut[] boundShortcuts;
        OrderedSet shortcuts = (OrderedSet)this.myActionId2ListOfShortcuts.get((Object)actionId);
        if (shortcuts == null && (boundShortcuts = this.getBoundShortcuts(actionId)) != null) {
            if (boundShortcuts == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapImpl", "getShortcuts"));
            }
            return boundShortcuts;
        }
        if (shortcuts == null) {
            if (this.myParent != null) {
                Shortcut[] shortcutArray = this.getParentShortcuts(actionId);
                if (shortcutArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapImpl", "getShortcuts"));
                }
                return shortcutArray;
            }
            if (ourEmptyShortcutsArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapImpl", "getShortcuts"));
            }
            return ourEmptyShortcutsArray;
        }
        Shortcut[] shortcutArray = shortcuts.isEmpty() ? ourEmptyShortcutsArray : (Shortcut[])shortcuts.toArray((Object[])new Shortcut[shortcuts.size()]);
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapImpl", "getShortcuts"));
        }
        return shortcutArray;
    }

    @Nullable
    private Shortcut[] getOwnShortcuts(String actionId) {
        OrderedSet own = (OrderedSet)this.myActionId2ListOfShortcuts.get((Object)actionId);
        if (own == null) {
            return null;
        }
        return own.isEmpty() ? ourEmptyShortcutsArray : (Shortcut[])own.toArray((Object[])new Shortcut[own.size()]);
    }

    @Nullable
    private Shortcut[] getBoundShortcuts(String actionId) {
        KeymapManagerEx keymapManager = this.getKeymapManager();
        boolean hasBoundedAction = keymapManager.getBoundActions().contains(actionId);
        if (hasBoundedAction) {
            return this.getOwnShortcuts(keymapManager.getActionBinding(actionId));
        }
        return null;
    }

    private KeymapManagerEx getKeymapManager() {
        if (this.myKeymapManager == null) {
            this.myKeymapManager = KeymapManagerEx.getInstanceEx();
        }
        return this.myKeymapManager;
    }

    public void readExternal(Element keymapElement, Keymap[] existingKeymaps) throws InvalidDataException {
        String parentName;
        if (!KEY_MAP.equals(keymapElement.getName())) {
            throw new InvalidDataException("unknown element: " + keymapElement);
        }
        if (keymapElement.getAttributeValue(VERSION_ATTRIBUTE) == null) {
            Converter01.convert(keymapElement);
        }
        if ((parentName = keymapElement.getAttributeValue(PARENT_ATTRIBUTE)) != null) {
            for (Keymap existingKeymap : existingKeymaps) {
                if (!parentName.equals(existingKeymap.getName())) continue;
                this.myParent = (KeymapImpl)existingKeymap;
                this.myCanModify = true;
                break;
            }
        }
        this.myName = keymapElement.getAttributeValue(NAME_ATTRIBUTE);
        HashMap id2shortcuts = new HashMap();
        boolean skipInserts = SystemInfo.isMac && !ApplicationManager.getApplication().isUnitTestMode();
        for (Object o : keymapElement.getChildren()) {
            Element actionElement = (Element)o;
            if (ACTION.equals(actionElement.getName())) {
                String id = actionElement.getAttributeValue(ID_ATTRIBUTE);
                if (id == null) {
                    throw new InvalidDataException("Attribute 'id' cannot be null; Keymap's name=" + this.myName);
                }
                id2shortcuts.put(id, new ArrayList(1));
                for (Object o1 : actionElement.getChildren()) {
                    ArrayList shortcuts;
                    KeyboardShortcut shortcut;
                    Element shortcutElement = (Element)o1;
                    if (KEYBOARD_SHORTCUT.equals(shortcutElement.getName())) {
                        KeyStroke firstKeyStroke;
                        String firstKeyStrokeStr = shortcutElement.getAttributeValue(FIRST_KEYSTROKE_ATTRIBUTE);
                        if (skipInserts && firstKeyStrokeStr.contains("INSERT")) continue;
                        if (firstKeyStrokeStr != null) {
                            firstKeyStroke = ActionManagerEx.getKeyStroke((String)firstKeyStrokeStr);
                            if (firstKeyStroke == null) {
                                throw new InvalidDataException("Cannot parse first-keystroke: '" + firstKeyStrokeStr + "'; " + "Action's id=" + id + "; Keymap's name=" + this.myName);
                            }
                        } else {
                            throw new InvalidDataException("Attribute 'first-keystroke' cannot be null; Action's id=" + id + "; Keymap's name=" + this.myName);
                        }
                        KeyStroke secondKeyStroke = null;
                        String secondKeyStrokeStr = shortcutElement.getAttributeValue(SECOND_KEYSTROKE_ATTRIBUTE);
                        if (secondKeyStrokeStr != null && (secondKeyStroke = ActionManagerEx.getKeyStroke((String)secondKeyStrokeStr)) == null) {
                            throw new InvalidDataException("Wrong second-keystroke: '" + secondKeyStrokeStr + "'; Action's id=" + id + "; Keymap's name=" + this.myName);
                        }
                        shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
                        shortcuts = (ArrayList)id2shortcuts.get(id);
                        shortcuts.add(shortcut);
                        continue;
                    }
                    if (KEYBOARD_GESTURE_SHORTCUT.equals(shortcutElement.getName())) {
                        KeyStroke stroke = null;
                        String strokeText = shortcutElement.getAttributeValue("keystroke");
                        if (strokeText != null) {
                            stroke = ActionManagerEx.getKeyStroke((String)strokeText);
                        }
                        String modifierText = shortcutElement.getAttributeValue(KEYBOARD_GESTURE_MODIFIER);
                        KeyboardGestureAction.ModifierType modifier = null;
                        if (KeyboardGestureAction.ModifierType.dblClick.toString().equalsIgnoreCase(modifierText)) {
                            modifier = KeyboardGestureAction.ModifierType.dblClick;
                        } else if (KeyboardGestureAction.ModifierType.hold.toString().equalsIgnoreCase(modifierText)) {
                            modifier = KeyboardGestureAction.ModifierType.hold;
                        }
                        if (stroke == null) {
                            throw new InvalidDataException("Wrong keystroke=" + strokeText + " action id=" + id + " keymap=" + this.myName);
                        }
                        if (modifier == null) {
                            throw new InvalidDataException("Wrong modifier=" + modifierText + " action id=" + id + " keymap=" + this.myName);
                        }
                        shortcut = KeyboardModifierGestureShortcut.newInstance((KeyboardGestureAction.ModifierType)modifier, (KeyStroke)stroke);
                        shortcuts = (ArrayList)id2shortcuts.get(id);
                        shortcuts.add(shortcut);
                        continue;
                    }
                    if (MOUSE_SHORTCUT.equals(shortcutElement.getName())) {
                        String keystrokeString = shortcutElement.getAttributeValue("keystroke");
                        if (keystrokeString == null) {
                            throw new InvalidDataException("Attribute 'keystroke' cannot be null; Action's id=" + id + "; Keymap's name=" + this.myName);
                        }
                        try {
                            MouseShortcut shortcut2 = KeymapUtil.parseMouseShortcut((String)keystrokeString);
                            ArrayList shortcuts2 = (ArrayList)id2shortcuts.get(id);
                            shortcuts2.add(shortcut2);
                            continue;
                        }
                        catch (InvalidDataException exc) {
                            throw new InvalidDataException("Wrong mouse-shortcut: '" + keystrokeString + "'; Action's id=" + id + "; Keymap's name=" + this.myName);
                        }
                    }
                    throw new InvalidDataException("unknown element: " + shortcutElement + "; Keymap's name=" + this.myName);
                }
                continue;
            }
            throw new InvalidDataException("unknown element: " + actionElement + "; Keymap's name=" + this.myName);
        }
        for (String id : id2shortcuts.keySet()) {
            this.myActionId2ListOfShortcuts.put((Object)id, (Object)new OrderedSet(2));
            ArrayList shortcuts = (ArrayList)id2shortcuts.get(id);
            for (Shortcut shortcut : shortcuts) {
                this.addShortcutSilently(id, shortcut, false);
            }
        }
    }

    public Element writeExternal() {
        Element keymapElement = new Element(KEY_MAP);
        keymapElement.setAttribute(VERSION_ATTRIBUTE, Integer.toString(1));
        keymapElement.setAttribute(NAME_ATTRIBUTE, this.myName);
        if (this.myParent != null) {
            keymapElement.setAttribute(PARENT_ATTRIBUTE, this.myParent.getName());
        }
        this.writeOwnActionIds(keymapElement);
        return keymapElement;
    }

    private void writeOwnActionIds(Element keymapElement) {
        Object[] ownActionIds = this.getOwnActionIds();
        Arrays.sort(ownActionIds);
        for (Object actionId : ownActionIds) {
            Shortcut[] shortcuts;
            Element actionElement = new Element(ACTION);
            actionElement.setAttribute(ID_ATTRIBUTE, (String)actionId);
            for (Shortcut shortcut : shortcuts = this.getShortcuts((String)actionId)) {
                Element element;
                if (shortcut instanceof KeyboardShortcut) {
                    KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
                    element = new Element(KEYBOARD_SHORTCUT);
                    element.setAttribute(FIRST_KEYSTROKE_ATTRIBUTE, KeymapImpl.getKeyShortcutString(keyboardShortcut.getFirstKeyStroke()));
                    if (keyboardShortcut.getSecondKeyStroke() != null) {
                        element.setAttribute(SECOND_KEYSTROKE_ATTRIBUTE, KeymapImpl.getKeyShortcutString(keyboardShortcut.getSecondKeyStroke()));
                    }
                    actionElement.addContent(element);
                    continue;
                }
                if (shortcut instanceof MouseShortcut) {
                    MouseShortcut mouseShortcut = (MouseShortcut)shortcut;
                    element = new Element(MOUSE_SHORTCUT);
                    element.setAttribute("keystroke", KeymapImpl.getMouseShortcutString(mouseShortcut));
                    actionElement.addContent(element);
                    continue;
                }
                if (shortcut instanceof KeyboardModifierGestureShortcut) {
                    KeyboardModifierGestureShortcut gesture = (KeyboardModifierGestureShortcut)shortcut;
                    element = new Element(KEYBOARD_GESTURE_SHORTCUT);
                    element.setAttribute(KEYBOARD_GESTURE_SHORTCUT, KeymapImpl.getKeyShortcutString(gesture.getStroke()));
                    element.setAttribute(KEYBOARD_GESTURE_MODIFIER, gesture.getType().name());
                    actionElement.addContent(element);
                    continue;
                }
                throw new IllegalStateException("unknown shortcut class: " + shortcut);
            }
            keymapElement.addContent(actionElement);
        }
    }

    private static boolean areShortcutsEqual(Shortcut[] shortcuts1, Shortcut[] shortcuts2) {
        if (shortcuts1.length != shortcuts2.length) {
            return false;
        }
        for (Shortcut shortcut : shortcuts1) {
            Shortcut parentShortcutEqual = null;
            for (Shortcut parentShortcut : shortcuts2) {
                if (!shortcut.equals(parentShortcut)) continue;
                parentShortcutEqual = parentShortcut;
                break;
            }
            if (parentShortcutEqual != null) continue;
            return false;
        }
        return true;
    }

    public static String getKeyShortcutString(KeyStroke keyStroke) {
        StringBuilder buf = new StringBuilder();
        int modifiers = keyStroke.getModifiers();
        if ((modifiers & 1) != 0) {
            buf.append(SHIFT);
            buf.append(' ');
        }
        if ((modifiers & 2) != 0) {
            buf.append(CONTROL);
            buf.append(' ');
        }
        if ((modifiers & 4) != 0) {
            buf.append(META);
            buf.append(' ');
        }
        if ((modifiers & 8) != 0) {
            buf.append(ALT);
            buf.append(' ');
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(ALT_GRAPH);
            buf.append(' ');
        }
        buf.append(ourNamesForKeycodes.get(keyStroke.getKeyCode()));
        return buf.toString();
    }

    private static String getMouseShortcutString(MouseShortcut shortcut) {
        StringBuilder buffer = new StringBuilder();
        int modifiers = shortcut.getModifiers();
        if ((0x40 & modifiers) > 0) {
            buffer.append(SHIFT);
            buffer.append(' ');
        }
        if ((0x80 & modifiers) > 0) {
            buffer.append(CONTROL);
            buffer.append(' ');
        }
        if ((0x100 & modifiers) > 0) {
            buffer.append(META);
            buffer.append(' ');
        }
        if ((0x200 & modifiers) > 0) {
            buffer.append(ALT);
            buffer.append(' ');
        }
        if ((0x2000 & modifiers) > 0) {
            buffer.append(ALT_GRAPH);
            buffer.append(' ');
        }
        buffer.append("button").append(shortcut.getButton()).append(' ');
        if (shortcut.getClickCount() > 1) {
            buffer.append(DOUBLE_CLICK);
        }
        return buffer.toString().trim();
    }

    public String[] getOwnActionIds() {
        return this.myActionId2ListOfShortcuts.keySet().toArray(new String[this.myActionId2ListOfShortcuts.size()]);
    }

    public void clearOwnActionsIds() {
        this.myActionId2ListOfShortcuts.clear();
        this.cleanShortcutsCache();
    }

    public boolean hasOwnActionId(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/KeymapImpl", "hasOwnActionId"));
        }
        return this.myActionId2ListOfShortcuts.containsKey((Object)actionId);
    }

    public void clearOwnActionsId(String actionId) {
        this.myActionId2ListOfShortcuts.remove((Object)actionId);
        this.cleanShortcutsCache();
    }

    public String[] getActionIds() {
        String[] ownActionIds;
        ArrayList<String> ids = new ArrayList<String>();
        if (this.myParent != null) {
            Object[] parentIds = this.getParentActionIds();
            ContainerUtil.addAll(ids, (Object[])parentIds);
        }
        for (String id : ownActionIds = this.getOwnActionIds()) {
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        return ArrayUtil.toStringArray(ids);
    }

    protected String[] getParentActionIds() {
        return this.myParent.getActionIds();
    }

    public Map<String, ArrayList<KeyboardShortcut>> getConflicts(String actionId, KeyboardShortcut keyboardShortcut) {
        String[] actionIds;
        HashMap result = new HashMap();
        for (String id : actionIds = this.getActionIds(keyboardShortcut.getFirstKeyStroke())) {
            Shortcut[] shortcuts;
            String useShortcutOf;
            if (id.equals(actionId) || actionId.startsWith(EDITOR_ACTION_PREFIX) && id.equals("$" + actionId.substring(6)) || StringUtil.startsWithChar((CharSequence)actionId, (char)'$') && id.equals(EDITOR_ACTION_PREFIX + actionId.substring(1)) || (useShortcutOf = this.myKeymapManager.getActionBinding(id)) != null && useShortcutOf.equals(actionId)) continue;
            for (Shortcut shortcut1 : shortcuts = this.getShortcuts(id)) {
                KeyboardShortcut shortcut;
                if (!(shortcut1 instanceof KeyboardShortcut) || !(shortcut = (KeyboardShortcut)shortcut1).getFirstKeyStroke().equals(keyboardShortcut.getFirstKeyStroke()) || keyboardShortcut.getSecondKeyStroke() != null && shortcut.getSecondKeyStroke() != null && !keyboardShortcut.getSecondKeyStroke().equals(shortcut.getSecondKeyStroke())) continue;
                ArrayList<KeyboardShortcut> list = (ArrayList<KeyboardShortcut>)result.get((Object)id);
                if (list == null) {
                    list = new ArrayList<KeyboardShortcut>();
                    result.put((Object)id, list);
                }
                list.add(shortcut);
            }
        }
        return result;
    }

    public void addShortcutChangeListener(Keymap.Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeShortcutChangeListener(Keymap.Listener listener) {
        this.myListeners.remove(listener);
    }

    private void fireShortcutChanged(String actionId) {
        for (Keymap.Listener listener : this.myListeners) {
            listener.onShortcutChanged(actionId);
        }
    }

    public String[] getAbbreviations() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void addAbbreviation(String actionId, String abbreviation) {
    }

    public void removeAbbreviation(String actionId, String abbreviation) {
    }

    public String toString() {
        return this.getPresentableName();
    }

    static {
        ourEmptyShortcutsArray = new Shortcut[0];
        ourNamesForKeycodes = new HashMap();
        try {
            Field[] fields;
            for (Field field : fields = KeyEvent.class.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!fieldName.startsWith(VIRTUAL_KEY_PREFIX)) continue;
                int keyCode = field.getInt(KeyEvent.class);
                ourNamesForKeycodes.put(keyCode, fieldName.substring(3));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }
}

