/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.stores.DirectoryBasedStorage;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.OptionsPackage$SchemeManagerImpl$0799e9b5;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeManagerImpl;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IntProgression;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.internal.InternalPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0014\u001a)\t2k\u00195f[\u0016l\u0015M\\1hKJLU\u000e\u001d7\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&Tqa\u001c9uS>t7OC\u0001U\u0015\u0019\u00196\r[3nK*\tQI\u0003\u000bFqR,'O\\1mSj\f'\r\\3TG\",W.\u001a\u0006\u000f'\u000eDW-\\3t\u001b\u0006t\u0017mZ3s\u0015I\u0019\u0016MZ3Xe&$XMU3rk\u0016\u001cHo\u001c:\u000b\u0007Y47O\u0003\u0004=S:LGO\u0010\u0006\tM&dWm\u00159fG*11\u000b\u001e:j]\u001eTaa[8uY&t'\"\u00039s_\u000e,7o]8s\u0015=\u00196\r[3nKB\u0013xnY3tg>\u0014(b\u0003:pC6Lgn\u001a+za\u0016T1BU8b[&tw\rV=qK*Q1m\\7q_:,g\u000e^:\u000b\u0011A\u0014xN^5eKJTab\u0015;sK\u0006l\u0007K]8wS\u0012,'O\u0003\u0003j[Bd'BB:u_J,7OC\u0006j_\u0012K'/Z2u_JL(\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\u0005Y\u0006twMC\u0007dkJ\u0014XM\u001c;TG\",W.\u001a\u0006\u0012GV\u0014(/\u001a8u'\u000eDW-\\3OC6,'\"\u00033je\u0016\u001cGo\u001c:z\u0015-1\u0016N\u001d;vC24\u0015\u000e\\3\u000b\u001b\u0019LG.Z:U_\u0012+G.\u001a;f\u0015!!\u0006*Y:i'\u0016$(bA4ok*)AO]8wK*i\"/Z1e\u001f:d\u00170\u0012=uKJt\u0017\r\\5{C\ndWmU2iK6,7O\u0003\u0005U\u0011\u0006\u001c\b.T1q\u0015=\u00198\r[3nK\u0016CH/\u001a8tS>t'\u0002D:dQ\u0016lW\rV8J]\u001a|'\u0002D#yi\u0016\u0014h.\u00197J]\u001a|'bB:dQ\u0016lWm\u001d\u0006\n\u0003J\u0014\u0018-\u001f'jgRTA!\u001e;jY*yQ\u000f\u001d3bi\u0016,\u0005\u0010^3og&|gNC\u0004C_>dW-\u00198\u000b\u0019\u0005$GMT3x'\u000eDW-\\3\u000b\rM\u001c\u0007.Z7f\u0015=\u0011X\r\u001d7bG\u0016,\u00050[:uS:<'\u0002B+oSRTqaY1o%\u0016\fGM\u0003\u0003oC6,'\u0002D\"iCJ\u001cV-];f]\u000e,'bD2mK\u0006\u0014\u0018\t\u001c7TG\",W.Z:\u000b)\r|G\u000e\\3di\u0016C\u0018n\u001d;j]\u001et\u0015-\\3t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\fI\u0016dW\r^3GS2,7OC\u0002eSJTa!\u001a:s_J\u001c(bC'vi\u0006\u0014G.\u001a'jgRT\u0011\u0002\u00165s_^\f'\r\\3\u000b\t1K7\u000f\u001e\u0006#M&tG-\u0012=uKJt\u0017\r\\5{C\ndWmU2iK6,')\u001f$jY\u0016t\u0015-\\3\u000b\u0011\u0019LG.\u001a(b[\u0016T\u0001CZ5oIN\u001b\u0007.Z7f\u0005ft\u0015-\\3\u000b\u0015M\u001c\u0007.Z7f\u001d\u0006lWMC\thKR\fE\u000e\\*dQ\u0016lWMT1nKNTQbZ3u\u00032d7k\u00195f[\u0016\u001c(bF6pi2LgN\f6w[:\u0002F.\u0019;g_JlG+\u001f9f\u0015A9W\r^\"veJ,g\u000e^*dQ\u0016lWM\u0003\u0007hKR$\u0015N]3di>\u0014\u0018P\u0003\thKR4\u0015\u000e\\3FqR,gn]5p]*A\u0011\r\u001c7po\u0006s\u0017PC\u0006hKR4\u0015\u000e\\3OC6,'\u0002E4fiJ{w\u000e\u001e#je\u0016\u001cGo\u001c:z\u0015!9W\r^*uCR,'\"B*uCR,'b\u0005\"bg\u0016\u001c6\r[3nKB\u0013xnY3tg>\u0014(\"\u0007\"bg\u0016\u001c6\r[3nKB\u0013xnY3tg>\u0014He\u0015;bi\u0016T!#[:NKR\fG-\u0019;b\u000b\u0012LG/\u00192mK*!\u0011n]'z\u0015\u00111\u0017\u000e\\3\u000b\u000b\u00154XM\u001c;\u000b!YK'\u000f^;bY\u001aKG.Z#wK:$(\"E5t\u001fZ,'o\u001e:ji\u0016|e\u000eT8bI*qQ\r_5ti&twmU2iK6,'\"C5t%\u0016t\u0017-\\3e\u0015Eaw.\u00193Ck:$G.\u001a3TG\",W.\u001a\u0006\re\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u0006\ne\u0016\fX/Z:u_JT1!\u00118z\u0015%\u0019wN\u001c<feR|'O\u0003\nUQJ|w/\u00192mK\u000e{gN^3si>\u0014(bB#mK6,g\u000e\u001e\u0006\u0004_J<'\u0002\u00026e_6Taa\u00142kK\u000e$(B\u00037pC\u0012\u001c6\r[3nK*)\u0011N\u001c9vi*Y\u0011J\u001c9viN#(/Z1n\u0015)!WO]5oO2{\u0017\r\u001a\u0006\fY>\fGmU2iK6,7O\u0003\nsK\u0006$7k\u00195f[\u00164%o\\7GS2,'B\u0002:fY>\fGM\u0003\fsK6|g/\u001a#je\u0016\u001cGo\u001c:z\u0013\u001a,U\u000e\u001d;z\u00151\u0011X-\\8wKN\u001b\u0007.Z7f\u0015I\u0011X\r^1j]\u0016CH/\u001a:oC2LeNZ8\u000b\u00159,woU2iK6,7O\u0003\u0003tCZ,'BC:bm\u0016\u001c6\r[3nK*ia.Y7f\u000f\u0016tWM]1u_JT1#\u00168jcV,g*Y7f\u000f\u0016tWM]1u_JTA\u0001^3yi*!2/\u001a;DkJ\u0014XM\u001c;TG\",W.\u001a(b[\u0016T!b]3u'\u000eDW-\\3t\u0015=\u0011X-\\8wK\u000e{g\u000eZ5uS>t'\"C\"p]\u0012LG/[8o\u0015!!xn\u0015;sS:<'BD:dQ\u0016$W\u000f\\3EK2,G/\u001a\u0006\u001f'\u000eDW-\\3NC:\fw-\u001a:J[BdG%\u0012=uKJt\u0017\r\\%oM>T?A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\r!\u0019\u0001C\u0002\r\u0001\u0015\u0019A1\u0001\u0005\u0005\u0019\u0001)1\u0001b\u0001\t\n1\u0001QA\u0001\u0003\u0002\u0011\u0017)1\u0001\u0002\u0003\t\u000b1\u0001Q!\u0001E\b\u000b\r!Q\u0001C\u0004\r\u0001\u0015\u0019A1\u0001E\t\u0019\u0001)!\u0001B\u0001\t\u0015\u0015\u0019AQ\u0002E\n\u0019\u0001)!\u0001\"\u0004\t\u0018\u0015\u0011Aq\u0002\u0005\r\u000b\r!\u0001\u0002C\u0006\r\u0001\u0015\t\u00012D\u0003\u0003\t%Aa\"B\u0002\u0005\u0014!iA\u0002A\u0003\u0003\t%Ai\"\u0002\u0002\u0005\u0016!9QA\u0001C\u0002\u0011#)!\u0001\"\u0004\t\u0014\u0015\u0011A\u0001\u0003\u0005\f\u000b\t!\u0019\u0002C\u0007\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\u0011A\t\u0003\u0004\u0001\u0006\u0005\u0011!\u0001\u0012E\u0003\u0002\u0011I)!\u0001B\b\t&\u0015\u0019Aq\u0004E\u0012\u0019\u0001)!\u0001b\b\t$\u0015\u0019Aq\u0004E\u0014\u0019\u0001)!\u0001b\b\t(\u0015\u0019AA\u0001\u0005\u0016\u0019\u0001)!\u0001B\u0005\t.\u0015\u0019AQ\u0005\u0005\u0017\u0019\u0001)!\u0001\"\n\t-\u0015\u0019A!\u0002E\u0018\u0019\u0001)1\u0001B\u0003\t41\u0001Qa\u0001\u0003\u0006\u0011ma\u0001!\u0002\u0002\u0005\u0016!YRa\u0001\u0003\u0006\u0011sa\u0001!\u0002\u0002\u0005&!eRa\u0001\u0003\u0006\u0011{a\u0001!B\u0002\u0005\u000b!yB\u0002A\u0003\u0003\tKAy$\u0002\u0002\u0005\u0004!!Qa\u0001\u0003\u0006\u0011\u007fa\u0001!B\u0002\u0005\u0004!=C\u0002A\u0003\u0004\tgAq\u0005\u0004\u0001\u0006\u0005\u0011\r\u0001\u0002K\u0003\u0004\t\u0011A)\u0006\u0004\u0001\u0006\u0005\u0011!\u0001RK\u0003\u0004\t\u0015Aa\u0006\u0004\u0001\u0006\u0005\u0011\u0005\u0001RF\u0003\u0004\tsAq\u0006\u0004\u0001\u0006\u0003!\u0001TA\u0001C\u001e\u0011C*1\u0001\u0002\u0010\t`1\u0001QA\u0001C\u000b\u0011E*!\u0001\"\u000f\t_\u0015\u0019A1\u0003E3\u0019\u0001)!\u0001b\u0005\tf\u0015\u0011A\u0011\b\u0005:\u000b\r!\u0011\u0005#\u001d\r\u0001\u0015\u0011A!\tE9\u000b\t!\u0011\u0001#\f\u0006\u0007\u0011\u0015\u0003b\u000f\u0007\u0001\u000b\t!)\u0005C\u001e\u0006\u0005\u0011\r\u0001\u0012\u0010\u0003\u0004\u0019\t)R\u0001\u0002\u0001\t\u0006U\u0011Q!\u0001E\u0003+\u0015!\t\u0001c\u0002\u0016\u0005\u0015\t\u0001bA\r\r\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0011DA\u0003\u0002\u0011\u0013aR#L\u0007\u0005\u00034Ar\"\t\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001G\u0001+\u000e!Qa\u0001\u0003\u0010\u0013\u0005AY\"\f\u0007\u0005\u00034Az\"I\u0002\u0006\u0003!-A\u0012A+\u0004\t\u0015\u0019AqD\u0005\u0002\u0011-iC\u0002Ba\r1A\t3!B\u0001\t\u001d1\u0005Qk\u0001\u0003\u0006\u0007\u0011\u0001\u0012\"\u0001E\u000f[-!\u0011\r\u0002M\u0007C\t)\u0011\u0001c\u0003V\u0007\u0011)1\u0001\"\u0004\n\u0003!YQf\u0004\u0003b\ta\t\u0012EB\u0003\u0002\u0011AI1!\u0003\u0002\u0006\u0003!-Qk\u0001\u0003\u0006\u0007\u0011\t\u0012\"\u0001E\u0011[-!\u0011\r\u0002M\rC\t)\u0011\u0001\u0003\u0006V\u0007\u0011)1\u0001\"\u0007\n\u0003!iQ\u0006\u0005\u0003b\taA\u0011eB\u0003\u0002\u0011\u0019IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0012A+\u0004\t\u0015\u0019A\u0001C\u0005\u0002\u0011/iC\u0002B1\u00051+\t3!B\u0001\t\u00121\u0005Qk\u0001\u0003\u0006\u0007\u0011U\u0011\"\u0001E\r[Q!\u0011\r\u0002\r\u0014C-)\u0011\u0001C\t\n\u0007%\u0011Q!\u0001E\u0006\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005Qk\u0001\u0003\u0006\u0007\u0011\u0019\u0012\"\u0001E\u0012[-!\u0011\r\u0002\r\nC\t)\u0011\u0001C\u0004V\u0007\u0011)1\u0001B\u0005\n\u0003!aQf\u0003\u0003b\ta!\u0012EA\u0003\u0002\u0011\u0017)6\u0001B\u0003\u0004\tQI\u0011\u0001C\u0006.)\u0011\tG\u0001'\u000b\"\u0017\u0015\t\u0001\"E\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0002%\u0019\u0011BA\u0003\u0002\u0011I)6\u0001B\u0003\u0004\tSI\u0011\u0001c\t.!\u0011\tG\u0001g\u000b\"\u000f\u0015\t\u0001bE\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001U\u001bA!B\u0002\u0005,%\t\u0001rE\u0017\f\t\u0005$\u0001dF\u0011\u0003\u000b\u0005AA#V\u0002\u0005\u000b\r!q#C\u0001\u0005\u00025nBa\u0003\r\u0019;\u001f!\u0001\u0001#\r\u000e\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0001QT\u0002\u0003\u0001\u0011ei!!B\u0001\t)A\u001b\t!\t\u0002\u0006\u0003!%\u0012kA\u0004\u00051%\tA\u0001A\u0007\u0002\u00117i\u0011\u0001\"\u0001.'\u0011\t\u0001DGO\u0007\t\u0001A)$\u0004\u0002\u0006\u0003!)\u0002k\u0001\u0001\"\u0005\u0015\t\u0001\u0002F)\u0004\u000b\u0011Q\u0012\"\u0001C\u0001\u001b\u0005AY#l\u0005\u0005\u0017a]\u0012EA\u0003\u0002\u0011S\t6a\u0001C\u001c\u0013\u0005!\u0001!\f\u000f\u0005\u0003aaRt\u0003\u0003\u0001\u0011Wiq!B\u0001\t-%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001U\u0002\u0001C\u0019)\u0011\u0001\u0003\f\n\u0007%\u0011Q!\u0001E\u0006#\u000e)A\u0001H\u0005\u0002\u0011[i\u0011\u0001#\f.D\u0011\t\u0001$HO\b\t\u0001AY$D\u0002\u0006\u0003!qA\u0012\u0001)\u0004\u0001uUA\u0001\u0001\u0005\u001f\u001b\u0019)\u0011\u0001C\f\n\u0007%\u0011Q!\u0001E\u0018!\u000e\u0005\u0011EA\u0003\u0002\u0011S\t6a\u0002\u0003\u001e\u0013\u0005!\u0001!D\u0001\t\u001e5\t\u0001\u0002G\u0017\u0016\t\u0005A\u0002%(\u0004\u0005\u0001!\u0005SBA\u0003\u0002\u0011\u0017\u00016\u0001A\u0011\u0005\u000b\t!\t\u0001#\u0001\r\u0002E\u001bQ\u0001\u0002\u0011\n\u0003!ER\"\u0001\u0005\f[U!1\u0002G\u0011\u001e\u000e\u0011\u0001\u00012I\u0007\u0003\u000b\u0005AY\u0001U\u0002\u0001C\u0011)!\u0001\"\u0001\t\u00011\u0005\u0011kA\u0003\u0005C%\t\u00012D\u0007\u0002\u0011-i[\u0002B\u0006\u0019E\u00052Q!\u0001\u0005\u0017\u0013\rI!!B\u0001\t\fE\u001b1\u0001\u0002\u0012\n\u0003!5R\u0016\n\u0003\f1\u000b\nS$B\u0001\t/%Q\u0011\"C\u0003\u0003\t\u0003A\u0001\u0001E\u0012\u0016\t\u0015\u0011A\u0011\u0001\u0005\u0001\u0019\u0003\u00012%\u0006\b\u0006\u0003!I\u0012BC\u0005\n\u000b\t!\t\u0001\u0003\u0001\u0011GU!QA\u0001C\u0001\u0011\u0001a\t\u0001$\u0001R\u0007\r!)%C\u0001\t15^Aa\u0003M$C\u0011)!\u0001\"\u0001\t\u00011\u0005\u0011kA\u0002\u0005H%\t\u00012DW\u000b\t\u0005AB%I\u0002\u0006\u0003!qA\u0012A)\u0004\u0007\u0011!\u0013\"\u0001E\u000f[s!\u0011\u0001'\u0013\u001e\u000e\u0011\u0001\u0001\u0012I\u0007\u0003\u000b\u0005AQ\u0003U\u0002\u0001;\u001b!\u0001\u0001C\u0013\u000e\u0005\u0015\t\u0001\u0002\u0006)\u0004\u0002\u0005\u0012Q!\u0001E\u0006#\u000e9A\u0011J\u0005\u0002\u0011-i\u0011\u0001c\u000b\u000e\u0003\u0011\u0005Q\u0006\u0006\u0003\u00021\u0017jj\u0001\u0002\u0001\t25\u0011Q!\u0001\u0005\u0004!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0017a\t!U\u0002\u0006\t\u0017J\u0011\u0001C\u0006\u000e\u0003!ER6\u0003\u0003\f1\u0019\n#!B\u0001\t\u0015E\u001b1\u0001\u0002\u0014\n\u0003!iQ\u0006\u0006\u0003\u00021\u001bjz\u0001\u0002\u0001\t25\u0019QA\u0001C\u0001\u0011\u0003\u00016\u0001A\u0011\u0003\u000b\u0005A!$U\u0002\u0006\t\u001bJ\u0011\u0001#\u000e\u000e\u0003!ER\u0006\u0006\u0003\f1#jz\u0001\u0002\u0001\t25\u0019QA\u0001C\u0001\u0011\u0003\u00016\u0001A\u0011\u0003\u000b\u0005AA#U\u0002\u0006\t#J\u0011\u0001\"\u0001\u000e\u0003!ERf\u0005\u0003\u00021%jj\u0001\u0002\u0001\tT5\u0011Q!\u0001\u0005\u000f!\u000e\u0001\u0011EA\u0003\u0002\u0011Q\t6!\u0002\u0003*\u0013\u0005!\t!D\u0001\t\u001e5\u001aB!\u0001\r*;\u001b!\u0001\u0001\u0003\u0016\u000e\u0005\u0015\t\u0001b\u0007)\u0004\u0001\u0005\u0012Q!\u0001\u0005\u0015#\u000e)A!K\u0005\u0002\t\u0003i\u0011\u0001c\u000e.)\u0011\t\u0001dKO\b\t\u0001A9&D\u0002\u0006\u0005\u0011\u0005\u0001\u0012\u0001)\u0004\u0001\u0005\u0012Q!\u0001\u0005\u0015#\u000e)AaK\u0005\u0002\t\u0003i\u0011\u0001#\r.'\u0011\t\u0001\u0004LO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!\u0019\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\u0002F)\u0004\u000b\u0011a\u0013\"\u0001C\u0001\u001b\u0005A\t$L\u001a\u0005\u0017aeST\u0002\u0003\u0001\u00115j!!B\u0001\t\fA\u001b\u0001!(\u0004\u0005\u0001!mSBA\u0003\u0002\u0011q\u00016\u0011AO\u0014\t\u0001Ai&D\b\u0006\u0003!i\u0012bA\u0005\u0003\u000b\u0005Ai$\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001\u0013\rI!!B\u0001\t0A\u001b\u0011!\t\u0002\u0006\u0003!%\u0012kA\u0005\u0005Z%\tA\u0001A\u0007\u0002\u0011-i\u0011\u0001C\u0010\u000e\u0003!}R\u0006\u000b\u0003\u00021Gjj\u0001\u0002\u0001\tB5\u0011Q!\u0001\u0005\u0016!\u000e\u0001QT\u0002\u0003\u0001\u0011Ij!!B\u0001\tAA\u001b\t!(\u0004\u0005\u0001!\u0019TBA\u0003\u0002\u0011Q\u00016!A\u0011\u0005\u000b\t!\t\u0001#\u0001\r\u0002E\u001b\u0011\u0002b\u0019\n\u0003!ER\"\u0001E\u0016\u001b\u0005A\t%D\u0001\u0005\u00025vAa\u0003M4C\u001d)\u0011\u0001\u0003\f\n\t%\u0019QA\u0001C\u0001\u0011\u0003\t6a\u0001C4\u0013\u0005Ai#,\u0010\u0005\u0003a!TT\u0002\u0003\u0001\u0011'j!!B\u0001\t\u001dA\u001b\u0001!(\u0004\u0005\u0001!\u0019TBA\u0003\u0002\u0011Q\u00016\u0011A\u0011\u0005\u000b\t!\t\u0001#\u0001\r\u0002E\u001bq\u0001\u0002\u001b\n\u0003!ER\"\u0001E\u000f\u001b\u0005!\t!l\u0005\u0005\u0007a%\u0014EA\u0003\u0002\u0011S\t6a\u0001C5\u0013\u0005!\u0001!,\u0011\u0005\u0003a)TT\u0002\u0003\u0001\u0011wi!!B\u0001\t\u001dA\u001b\u0001!(\u0006\u0005\u0001!qRBB\u0003\u0002\u0011]I1!\u0003\u0002\u0006\u0003!=\u0002k!\u0001\"\u0005\u0015\t\u0001\u0012F)\u0004\u000f\u0011)\u0014\"\u0001\u0003\u0001\u001b\u0005Ai\"D\u0001\t15\"Ba\u0003M6;\u001f!\u0001\u0001#\r\u000e\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0001\u0011EA\u0003\u0002\u0011S\t6!\u0002C6\u0013\u0005!\u0001!D\u0001\t\u001c5BB!\u0001\r7;/!\u0001\u0001#\u001c\u000e\u000f\u0015\t\u0001\"G\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\u0001!\t\u0002\u0006\u0003!%\u0012kA\u0003\u0005m%\tA\u0001A\u0007\u0002\u0011ais\u0003\u0002\u0001\u0019ouUA\u0001\u0001\u0005\u001f\u001b\u0019)\u0011\u0001C\f\n\u0007%\u0011Q!\u0001E\u0018!\u000e\u0001\u0011EA\u0003\u0002\u0011S\t6!\u0002\u00038\u0013\u0005!\u0001!D\u0001\t15nB!\u0001M8;\u001f!\u0001\u0001#\r\u000e\u0007\u0015\u0011A\u0011\u0001E\u0001!\u000e\u0001QT\u0002\u0003\u0001\u0011aj!!B\u0001\tDA\u001b\t!\t\u0002\u0006\u0003!%\u0012kA\u0004\u0005p%\tA\u0001A\u0007\u0002\u0011ci\u0011\u0001\u0003\u0012.)\u0011Y\u00014OO\b\t\u0001A\u0019%D\u0002\u0006\u0003!-A\u0012\u0001)\u0004\u0001\u0005\u0012Q!\u0001E\u0015#\u000e)A1O\u0005\u0002\t\u0001i\u0011\u0001C\u0006.P\u0011Y\u0001DOO\f\t\u0001Ai'D\u0004\u0006\u0003!I\u0012\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001Q\u0007\u0001iJ\u0002\u0002\u0001\tv5AQ!\u0001\u0005$\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001A\u0012\u0001)\u0004\u0002\u0005\u0012Q!\u0001E\u0015#\u000e9AAO\u0005\u0002\t\u0001i\u0011\u0001\u0003\r\u000e\u0003!\u001dS6\u0003\u0003\f1o\n#!B\u0001\t\fE\u001b1\u0001b\u001e\n\u0003!YQV\u0004\u0003\u0002+\t)\u0011\u0001\u0003\n\u0019y\u0005\u0012Q!\u0001E\u0015#\u000e)A\u0001P\u0005\u0002\t\u0001i\u0011\u0001\u0003\u00136/\u0004)Y\u001b\u0001\u0003d\u0002E)A\u0001\u0001E\u0003+\t)\u0011\u0001#\u0002\u0012\u000b\u0011\u0005\u0001rA\u000b\u0003\u000b\u0005A1\u0001\u0007\u0004\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005AY\u0001U\u0002\u0001;/!\u0001\u0001\u0003\u0005\u000e\u000f\u0015\t\u0001BB\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0002A\u001b\t!(\u0004\u0005\u0001!IQBA\u0003\u0002\u0011\u001d\u00016!AO\b\t\u0001A)\"D\u0002\u0006\u0003!EA\u0012\u0001)\u0004\u0004u5A\u0001\u0001E\r\u001b\t)\u0011\u0001\u0003\u0006Q\u0007\t\tC\"B\u0001\t\u0005%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001#\u000eiAAB\u0005\u0002\t\u0001i\u0011\u0001C\u0006\u000e\u0003!]Q\"\u0001\u0005\r\u001b\u0005AI\"D\u0001\t\u001b\u0001"})
public final class SchemeManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends SchemesManager<T, E>
implements SafeWriteRequestor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ArrayList<T> schemes;
    private final THashMap<String, E> readOnlyExternalizableSchemes;
    private T currentScheme;
    private String currentSchemeName;
    private VirtualFile directory;
    private final String schemeExtension;
    private final boolean updateExtension;
    private final THashSet<String> filesToDelete;
    private final THashMap<E, ExternalInfo> schemeToInfo;
    private final String fileSpec;
    private final SchemeProcessor<E> processor;
    private final RoamingType roamingType;
    private final StreamProvider provider;
    private final File ioDirectory;

    static {
        $kotlinClass = Reflection.createKotlinClass(SchemeManagerImpl.class);
    }

    public void loadBundledScheme(@JetValueParameter(name="resourceName") @NotNull String resourceName, @JetValueParameter(name="requestor") @NotNull Object requestor, @JetValueParameter(name="convertor") @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull(convertor, (String)"convertor");
        try {
            URL url;
            URL uRL = url = requestor instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : DecodeDefaultsUtil.getDefaults(requestor, resourceName);
            if (url == null) {
                OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().error("Cannot read scheme from " + resourceName);
                return;
            }
            Element element = JDOMUtil.load((InputStream)URLUtil.openStream((URL)url));
            Scheme scheme = (Scheme)convertor.convert((Object)element);
            if (scheme instanceof ExternalizableScheme) {
                String fileName = PathUtilRt.getFileName((String)url.getPath());
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                String extension = this.getFileExtension(charSequence, true);
                ExternalInfo info = new ExternalInfo(KotlinPackage.substring((String)fileName, (int)0, (int)(fileName.length() - extension.length())), extension);
                info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
                info.setSchemeName(((ExternalizableScheme)scheme).getName());
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("T! cannot be cast to E");
                }
                ExternalInfo oldInfo = (ExternalInfo)this.schemeToInfo.put((Object)((ExternalizableScheme)scheme2), (Object)info);
                OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().assertTrue(oldInfo == null);
                ExternalizableScheme oldScheme = (ExternalizableScheme)this.readOnlyExternalizableSchemes.put((Object)((ExternalizableScheme)scheme).getName(), (Object)scheme);
                if (oldScheme != null) {
                    OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().warn("Duplicated scheme " + ((ExternalizableScheme)scheme).getName() + " - old: " + oldScheme + ", new " + scheme);
                }
            }
            this.schemes.add(scheme);
        }
        catch (Throwable e) {
            OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().error("Cannot read scheme from " + resourceName, e);
        }
    }

    private final String getFileExtension(@JetValueParameter(name="fileName") CharSequence fileName, @JetValueParameter(name="allowAny") boolean allowAny) {
        String string;
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.schemeExtension)) {
            string = this.schemeExtension;
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)DirectoryStorageData.DEFAULT_EXT)) {
            string = DirectoryStorageData.DEFAULT_EXT;
        } else if (allowAny) {
            string = PathUtil.getFileExtension((String)((Object)fileName).toString());
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
        }
        return string;
    }

    private final boolean isMy(@JetValueParameter(name="event") VirtualFileEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.getFile()");
        return this.isMy(virtualFile);
    }

    private final boolean isMy(@JetValueParameter(name="file") VirtualFile file) {
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)this.schemeExtension);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<E> loadSchemes() {
        int newSchemesOffset = this.schemes.size();
        if (this.provider != null && this.provider.getEnabled()) {
            this.provider.processChildren(this.fileSpec, this.roamingType, (Function1<? super String, ? extends Boolean>)((Function1)new Function1<String, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@JetValueParameter(name="it") @NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return SchemeManagerImpl.access$canRead$6(this.this$0, it);
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(1);
                }
            }), (Function3<? super String, ? super InputStream, ? super Boolean, ? extends Boolean>)((Function3)new Function3<String, InputStream, Boolean, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@JetValueParameter(name="name") @NotNull String name, @JetValueParameter(name="input") @NotNull InputStream input, @JetValueParameter(name="readOnly") boolean readOnly) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    E scheme = SchemeManagerImpl.access$loadScheme$7(this.this$0, name, input, true);
                    if (readOnly && scheme != null) {
                        SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$1(this.this$0).put((Object)OptionsPackage$SchemeManagerImpl$0799e9b5.getName((Scheme)scheme), scheme);
                    }
                    return true;
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(3);
                }
            }));
        } else {
            VirtualFile[] files;
            VirtualFile dir;
            VirtualFile virtualFile = dir = this.getDirectory();
            Object object = files = virtualFile != null ? virtualFile.getChildren() : null;
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    VirtualFile file;
                    VirtualFile virtualFile2 = file = files[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                    this.readSchemeFromFile(virtualFile2, true);
                }
            }
        }
        SmartList list = new SmartList();
        int files = newSchemesOffset;
        int n = this.schemes.size() - 1;
        if (files <= n) {
            while (true) {
                void i;
                T t = this.schemes.get((int)i);
                if (t == null) {
                    throw new TypeCastException("T! cannot be cast to E");
                }
                ExternalizableScheme scheme = (ExternalizableScheme)t;
                this.processor.initScheme(scheme);
                list.add((Object)scheme);
                if (i == n) break;
                ++i;
            }
        }
        return (Collection)list;
    }

    /*
     * Unable to fully structure code
     */
    public final void reload() {
        block6: {
            v0 = KotlinPackage.reversed((IntRange)KotlinPackage.getIndices((Collection)this.schemes));
            var1_1 = ((Number)v0.getStart()).intValue();
            var2_2 = ((Number)v0.getEnd()).intValue();
            var3_3 = ((Number)v0.getIncrement()).intValue();
            var4_4 = InternalPackage.getProgressionFinalElement((int)var1_1, (int)var2_2, (int)var3_3);
            v1 = var1_1;
            v2 = var2_2;
            if (!(var3_3 > 0 ? v1 <= v2 : v1 >= v2)) break block6;
            while (true) {
                if (!((scheme = (Scheme)this.schemes.get((int)i)) instanceof ExternalizableScheme)) ** GOTO lbl-1000
                v3 = scheme;
                if (v3 == null) {
                    throw new TypeCastException("T! cannot be cast to E");
                }
                if (Intrinsics.areEqual((Object)this.getState((ExternalizableScheme)v3), (Object)BaseSchemeProcessor.State.NON_PERSISTENT) ^ true) {
                    this.schemes.remove((int)i);
                    if (scheme == this.currentScheme) {
                        this.currentScheme = null;
                        v4 = Unit.INSTANCE$;
                    } else {
                        v4 = Unit.INSTANCE$;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    v4 = Unit.INSTANCE$;
                }
                if (i == var4_4) break;
                var1_1 = i + var3_3;
            }
        }
        this.retainExternalInfo((List)this.schemes);
        this.loadSchemes();
    }

    private final E findExternalizableSchemeByFileName(@JetValueParameter(name="fileName") String fileName) {
        for (Scheme scheme : this.schemes) {
            if (!(scheme instanceof ExternalizableScheme)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
            Intrinsics.checkExpressionValueIsNotNull((Object)externalizableScheme, (String)"scheme");
            if (!Intrinsics.areEqual((Object)fileName, (Object)stringBuilder.append(this.getFileName(externalizableScheme)).append(this.schemeExtension).toString())) continue;
            Scheme scheme2 = scheme;
            if (scheme2 == null) {
                throw new TypeCastException("T! cannot be cast to E");
            }
            return (E)((ExternalizableScheme)scheme2);
        }
        return (E)((ExternalizableScheme)null);
    }

    private final boolean isOverwriteOnLoad(@JetValueParameter(name="existingScheme") E existingScheme) {
        if ((ExternalizableScheme)this.readOnlyExternalizableSchemes.get((Object)existingScheme.getName()) == existingScheme) {
            return true;
        }
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(existingScheme);
        return info != null && Intrinsics.areEqual((Object)this.schemeExtension, (Object)info.getFileExtension()) ^ true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final E loadScheme(@JetValueParameter(name="fileName") CharSequence fileName, @JetValueParameter(name="input") InputStream input, @JetValueParameter(name="duringLoad") boolean duringLoad) {
        try {
            block16: {
                element = JDOMUtil.load((InputStream)input);
                if (this.processor instanceof BaseSchemeProcessor) {
                    v0 = ((BaseSchemeProcessor)this.processor).readScheme(element, duringLoad);
                } else {
                    v1 = element.detach();
                    if (v1 == null) {
                        throw new TypeCastException("org.jdom.Content! cannot be cast to org.jdom.Element");
                    }
                    v0 = this.processor.readScheme(new Document((Element)v1));
                }
                if (v0 == null) {
                    return (E)((ExternalizableScheme)null);
                }
                scheme = v0;
                extension = this.getFileExtension(fileName, false);
                fileNameWithoutExtension = fileName.subSequence(0, fileName.length() - extension.length()).toString();
                if (!duringLoad) break block16;
                if (KotlinPackage.isNotEmpty((Collection)((Collection)this.filesToDelete)) && this.filesToDelete.contains((Object)fileName.toString())) {
                    OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().warn("Scheme file " + fileName + " is not loaded because marked to delete");
                    return (E)((ExternalizableScheme)null);
                }
                v2 = scheme.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"scheme.getName()");
                existingScheme = this.findSchemeByName(v2);
                if (existingScheme == null) break block16;
                if (!(existingScheme instanceof ExternalizableScheme)) ** GOTO lbl-1000
                v3 = existingScheme;
                if (v3 == null) {
                    throw new TypeCastException("T? cannot be cast to E");
                }
                if (this.isOverwriteOnLoad((ExternalizableScheme)v3)) {
                    this.removeScheme(existingScheme);
                } else lbl-1000:
                // 2 sources

                {
                    OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().warn("Scheme file " + fileName + " is not loaded because defines duplicated name " + scheme.getName());
                    return (E)((ExternalizableScheme)null);
                }
            }
            if ((info = (ExternalInfo)this.schemeToInfo.get((Object)scheme)) == null) {
                info = new ExternalInfo(fileNameWithoutExtension, extension);
                this.schemeToInfo.put((Object)scheme, (Object)info);
            } else {
                info.setFileNameWithoutExtension(fileNameWithoutExtension, extension);
            }
            info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
            info.setSchemeName(scheme.getName());
            if (duringLoad) {
                v4 = scheme;
                if (v4 == null) {
                    throw new TypeCastException("E cannot be cast to T");
                }
                v5 /* !! */  = Boolean.valueOf(this.schemes.add((Scheme)v4));
            } else {
                v6 = scheme;
                if (v6 == null) {
                    throw new TypeCastException("E cannot be cast to T");
                }
                this.addScheme((Scheme)v6);
                v5 /* !! */  = Unit.INSTANCE$;
            }
            return (E)scheme;
        }
        catch (Exception e) {
            OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().error("Cannot read scheme " + fileName, (Throwable)e);
            return (E)((ExternalizableScheme)null);
        }
    }

    private final String getFileName(@JetValueParameter(name="scheme") ExternalizableScheme scheme) {
        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.get((Object)scheme);
        return externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null;
    }

    private final boolean canRead(@JetValueParameter(name="name") CharSequence name) {
        return this.updateExtension && StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)DirectoryStorageData.DEFAULT_EXT) || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)this.schemeExtension);
    }

    private final E readSchemeFromFile(@JetValueParameter(name="file") VirtualFile file, @JetValueParameter(name="duringLoad") boolean duringLoad) {
        CharSequence fileName;
        block5: {
            block4: {
                fileName = file.getNameSequence();
                if (file.isDirectory()) break block4;
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                if (this.canRead(charSequence)) break block5;
            }
            return (E)((ExternalizableScheme)null);
        }
        try {
            CharSequence charSequence = fileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.getInputStream()");
            return this.loadScheme(charSequence, inputStream, duringLoad);
        }
        catch (Throwable e) {
            OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().error("Cannot read scheme " + fileName, e);
            return (E)((ExternalizableScheme)null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void save(@JetValueParameter(name="errors") @NotNull List<Throwable> errors) {
        BaseSchemeProcessor.State state;
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList schemesToSave = new SmartList();
        for (Scheme scheme : this.schemes) {
            Unit unit;
            if (scheme instanceof ExternalizableScheme) {
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("T! cannot be cast to E");
                }
                state = this.getState((ExternalizableScheme)scheme2);
                if (state == BaseSchemeProcessor.State.NON_PERSISTENT) continue;
                hasSchemes = true;
                if (state != BaseSchemeProcessor.State.UNCHANGED) {
                    schemesToSave.add((Object)scheme);
                }
                ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
                Intrinsics.checkExpressionValueIsNotNull((Object)externalizableScheme, (String)"scheme");
                String fileName = this.getFileName(externalizableScheme);
                if (fileName != null) {
                    ExternalizableScheme externalizableScheme2 = (ExternalizableScheme)scheme;
                    Intrinsics.checkExpressionValueIsNotNull((Object)externalizableScheme2, (String)"scheme");
                    if (!this.isRenamed(externalizableScheme2)) {
                        nameGenerator.addExistingName(fileName);
                        unit = Unit.INSTANCE$;
                        continue;
                    }
                }
                unit = Unit.INSTANCE$;
                continue;
            }
            unit = Unit.INSTANCE$;
        }
        for (Scheme scheme : schemesToSave) {
            state = errors;
            try {
                Scheme scheme3 = scheme;
                Intrinsics.checkExpressionValueIsNotNull((Object)scheme3, (String)"scheme");
                SchemeManagerImpl.super.saveScheme(scheme3, nameGenerator);
            }
            catch (Throwable e) {
                void $receiver;
                $receiver.add(e);
                continue;
            }
            InlineMarker.goToTryCatchBlockEnd();
        }
        VirtualFile dir = this.getDirectory();
        this.deleteFiles(dir, (List<Throwable>)errors);
        if (!hasSchemes && dir != null) {
            this.removeDirectoryIfEmpty(dir, (List<Throwable>)errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDirectoryIfEmpty(@JetValueParameter(name="dir") VirtualFile dir, @JetValueParameter(name="errors") List<Throwable> errors) {
        VirtualFile[] virtualFileArray = dir.getChildren();
        for (int i = 0; i < virtualFileArray.length; ++i) {
            VirtualFile file = virtualFileArray[i];
            if (file.is(VFileProperty.HIDDEN)) continue;
            OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().info("Directory " + dir.getNameSequence() + " is not deleted: at least one file " + file.getNameSequence() + " exists");
            return;
        }
        OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().info("Remove schemes directory " + dir.getNameSequence());
        this.directory = null;
        AccessToken token = WriteAction.start();
        try {
            dir.delete((Object)this);
        }
        catch (Throwable e) {
            errors.add(e);
        }
        finally {
            token.finish();
        }
    }

    private final BaseSchemeProcessor.State getState(@JetValueParameter(name="scheme") E scheme) {
        BaseSchemeProcessor.State state;
        if (this.processor instanceof BaseSchemeProcessor) {
            SchemeProcessor<E> schemeProcessor = this.processor;
            if (schemeProcessor == null) {
                throw new TypeCastException("com.intellij.openapi.options.SchemeProcessor<E> cannot be cast to com.intellij.openapi.options.BaseSchemeProcessor<E>");
            }
            state = ((BaseSchemeProcessor)schemeProcessor).getState(scheme);
        } else {
            state = this.processor.shouldBeSaved(scheme) ? BaseSchemeProcessor.State.POSSIBLY_CHANGED : BaseSchemeProcessor.State.NON_PERSISTENT;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void saveScheme(@JetValueParameter(name="scheme") E scheme, @JetValueParameter(name="nameGenerator") UniqueNameGenerator nameGenerator) {
        block55: {
            block53: {
                externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme);
                currentFileNameWithoutExtension = externalInfo == null ? (String)null : externalInfo.getFileNameWithoutExtension();
                parent = this.processor.writeScheme(scheme);
                if (parent == null || parent instanceof Element) {
                    v0 = (Element)parent;
                } else {
                    v1 = parent;
                    if (v1 == null) {
                        throw new TypeCastException("org.jdom.Parent! cannot be cast to org.jdom.Document");
                    }
                    v0 = element = ((Document)v1).detachRootElement();
                }
                if (JDOMUtil.isEmpty((Element)element)) {
                    v2 = externalInfo;
                    if (v2 != null) {
                        this.scheduleDelete(v2);
                        v3 = Unit.INSTANCE$;
                    } else {
                        v3 = null;
                    }
                    return;
                }
                fileNameWithoutExtension = currentFileNameWithoutExtension;
                if (fileNameWithoutExtension == null || this.isRenamed((ExternalizableScheme)scheme)) {
                    fileNameWithoutExtension = nameGenerator.generateUniqueName(FileUtil.sanitizeName((String)scheme.getName()));
                }
                v4 = element;
                if (v4 == null) {
                    Intrinsics.throwNpe();
                }
                newHash = JDOMUtil.getTreeHash((Element)v4, (boolean)true);
                if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && newHash == externalInfo.getHash()) {
                    return;
                }
                bundledScheme = (ExternalizableScheme)this.readOnlyExternalizableSchemes.get((Object)scheme.getName());
                if (bundledScheme != null) {
                    v5 = this.schemeToInfo.get((Object)bundledScheme);
                    if (v5 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (((ExternalInfo)v5).getHash() == newHash) {
                        v6 = externalInfo;
                        if (v6 != null) {
                            this.scheduleDelete(v6);
                            v7 = Unit.INSTANCE$;
                        } else {
                            v7 = null;
                        }
                        return;
                    }
                }
                v8 = new StringBuilder();
                v9 = fileNameWithoutExtension;
                if (v9 == null) {
                    Intrinsics.throwNpe();
                }
                fileName = v8.append(v9).append(this.schemeExtension).toString();
                this.filesToDelete.remove((Object)fileName);
                byteOut = StorageUtil.writeToBytes((Parent)element, "\n");
                if (this.provider != null && this.provider.getEnabled()) {
                    providerPath = this.fileSpec + '/' + fileName;
                    if (!this.provider.isApplicable(providerPath, this.roamingType)) {
                        providerPath = null;
                    }
                } else {
                    providerPath = null;
                }
                v10 = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && nameGenerator.value(currentFileNameWithoutExtension) != false;
                if (providerPath != null) break block53;
                var14_14 = new Ref.ObjectRef();
                var14_14.element = null;
                dir = this.getDirectory();
                if (dir == null || !dir.isValid()) {
                    v11 = dir = DirectoryBasedStorage.createDir(this.ioDirectory, (Object)this);
                    if (v11 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.directory = v11;
                }
                if (renamed) {
                    v12 = externalInfo;
                    if (v12 == null) {
                        Intrinsics.throwNpe();
                    }
                    file.element = dir.findChild(v12.getFileName());
                    if ((VirtualFile)file.element != null) {
                        token = WriteAction.start();
                        try {
                            InlineMarker.goToTryCatchBlockEnd();
                        }
                        finally {
                            token.finish();
                        }
                        token = WriteAction.start();
                        try {
                            v13 = (VirtualFile)file.element;
                            if (v13 == null) {
                                Intrinsics.throwNpe();
                            }
                            v13.rename((Object)this, fileName);
                            InlineMarker.goToTryCatchBlockEnd();
                        }
                        finally {
                            token.finish();
                        }
                    }
                }
                if ((VirtualFile)file.element == null) {
                    file.element = DirectoryBasedStorage.getFile(fileName, dir, (Object)this);
                }
                token = WriteAction.start();
                try {
                    v14 = (VirtualFile)file.element;
                    if (v14 == null) {
                        Intrinsics.throwNpe();
                    }
                    var17_19 = v14.getOutputStream((Object)this);
                    closed = false;
                    try {
                        it = (OutputStream)$receiver;
                        byteOut.writeTo(it);
                        it = Unit.INSTANCE$;
                        ** try [egrp 4[TRYBLOCK] [8 : 694->726)] { 
                    }
lbl127:
                    // 1 sources

                    catch (Throwable var19_24) {
                        throw var19_24;
                    }
                    finally {
                        if (!closed) {
                            $receiver.close();
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                        }
                        catch (Exception e) {
                            closed = true;
                            try {
                                $receiver.close();
                            }
                            catch (Exception closeException) {
                                // empty catch block
                            }
                            InlineMarker.goToTryCatchBlockEnd();
                            throw (Throwable)e;
                        }
                    }
                    InlineMarker.goToTryCatchBlockEnd();
                }
                finally {
                    token.finish();
                }
                var14_14 = null;
                break block55;
            }
            if (renamed) {
                v15 = externalInfo;
                if (v15 == null) {
                    Intrinsics.throwNpe();
                }
                this.scheduleDelete(v15);
            }
            v16 = this.provider;
            if (v16 == null) {
                Intrinsics.throwNpe();
            }
            v17 = byteOut.getInternalBuffer();
            Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"byteOut.getInternalBuffer()");
            v16.saveContent(providerPath, v17, byteOut.size(), this.roamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.schemeExtension);
            this.schemeToInfo.put(scheme, (Object)externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.schemeExtension);
        }
        externalInfo.setHash(newHash);
        externalInfo.setSchemeName(scheme.getName());
    }

    private final void scheduleDelete(@JetValueParameter(name="$receiver") ExternalInfo $receiver) {
        this.filesToDelete.add((Object)$receiver.getFileName());
    }

    private final boolean isRenamed(@JetValueParameter(name="scheme") ExternalizableScheme scheme) {
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get((Object)scheme);
        return info != null && Intrinsics.areEqual((Object)scheme.getName(), (Object)info.getSchemeName()) ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void deleteFiles(@JetValueParameter(name="dir", type="?") VirtualFile dir, @JetValueParameter(name="errors") List<Throwable> errors) {
        if (this.filesToDelete.isEmpty()) {
            return;
        }
        if (this.provider != null && this.provider.getEnabled()) {
            for (String name : this.filesToDelete) {
                List<Throwable> list = errors;
                try {
                    StorageUtil.delete(this.provider, this.fileSpec + '/' + name, this.roamingType);
                }
                catch (Throwable e) {
                    void $receiver;
                    $receiver.add(e);
                    continue;
                }
                InlineMarker.goToTryCatchBlockEnd();
            }
        } else if (dir != null) {
            AccessToken token = null;
            try {
                VirtualFile[] virtualFileArray = dir.getChildren();
                for (int i = 0; i < virtualFileArray.length; ++i) {
                    VirtualFile file = virtualFileArray[i];
                    if (!this.filesToDelete.contains((Object)file.getName())) continue;
                    if (token == null) {
                        token = WriteAction.start();
                    }
                    List<Throwable> list = errors;
                    try {
                        file.delete((Object)this);
                    }
                    catch (Throwable e) {
                        void $receiver;
                        $receiver.add(e);
                    }
                    InlineMarker.goToTryCatchBlockEnd();
                    continue;
                }
            }
            finally {
                if (token != null) {
                    token.finish();
                }
            }
        }
        this.filesToDelete.clear();
    }

    private final VirtualFile getDirectory() {
        VirtualFile result = this.directory;
        if (result == null) {
            this.directory = result = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        }
        return result;
    }

    @NotNull
    public File getRootDirectory() {
        return this.ioDirectory;
    }

    /*
     * WARNING - void declaration
     */
    public void setSchemes(@JetValueParameter(name="newSchemes") @NotNull List<? extends T> newSchemes, @JetValueParameter(name="removeCondition", type="?") @Nullable Condition<T> removeCondition) {
        Intrinsics.checkParameterIsNotNull(newSchemes, (String)"newSchemes");
        if (removeCondition == null) {
            this.schemes.clear();
        } else {
            IntProgression intProgression = KotlinPackage.reversed((IntRange)KotlinPackage.getIndices((Collection)this.schemes));
            int n = ((Number)intProgression.getStart()).intValue();
            int n2 = ((Number)intProgression.getEnd()).intValue();
            int n3 = ((Number)intProgression.getIncrement()).intValue();
            int n4 = InternalPackage.getProgressionFinalElement((int)n, (int)n2, (int)n3);
            int n5 = n;
            int n6 = n2;
            if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void i;
                    if (removeCondition.value(this.schemes.get((int)i))) {
                        this.schemes.remove((int)i);
                    }
                    if (i == n4) break;
                    n = i + n3;
                }
            }
        }
        this.retainExternalInfo(newSchemes);
        this.schemes.addAll((Collection)newSchemes);
        if (this.currentSchemeName != null) {
            String string = this.currentSchemeName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.currentScheme = this.findSchemeByName(string);
            if (this.currentScheme != null) {
                return;
            }
        }
        T t = this.currentScheme = (Scheme)KotlinPackage.firstOrNull((List)this.schemes);
        this.currentSchemeName = t != null ? t.getName() : null;
    }

    private final void retainExternalInfo(@JetValueParameter(name="newSchemes") List<? extends T> newSchemes) {
        if (this.schemeToInfo.isEmpty()) {
            return;
        }
        this.schemeToInfo.retainEntries(new TObjectObjectProcedure<E, ExternalInfo>(this, newSchemes){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ List $newSchemes;

            static {
                $kotlinClass = Reflection.createKotlinClass(retainExternalInfo.1.class);
            }

            public boolean execute(@JetValueParameter(name="scheme") @NotNull E scheme, @JetValueParameter(name="info") @NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                if (Intrinsics.areEqual((Object)((ExternalizableScheme)SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$1(this.this$0).get((Object)scheme.getName())), scheme)) {
                    return true;
                }
                for (Scheme t : this.$newSchemes) {
                    if (t != scheme) continue;
                    if (KotlinPackage.isNotEmpty((Collection)((Collection)SchemeManagerImpl.access$getFilesToDelete$3(this.this$0)))) {
                        SchemeManagerImpl.access$getFilesToDelete$3(this.this$0).remove((Object)String.valueOf(info.getFileName()));
                    }
                    return true;
                }
                SchemeManagerImpl.access$scheduleDelete$11(this.this$0, info);
                return false;
            }
            {
                this.this$0 = $outer;
                this.$newSchemes = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void addNewScheme(@JetValueParameter(name="scheme") @NotNull T scheme, @JetValueParameter(name="replaceExisting") boolean replaceExisting) {
        ExternalInfo info;
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        int toReplace = -1;
        IntRange intRange = KotlinPackage.getIndices((Collection)this.schemes);
        int n = ((Number)intRange.getStart()).intValue();
        int n2 = ((Number)intRange.getEnd()).intValue();
        if (n <= n2) {
            while (true) {
                void i;
                Scheme existing;
                if (Intrinsics.areEqual((Object)(existing = (Scheme)this.schemes.get((int)i)).getName(), (Object)scheme.getName())) {
                    ExternalInfo oldInfo;
                    if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                        OptionsPackage$SchemeManagerImpl$0799e9b5.getLOG().warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
                    }
                    toReplace = i;
                    if (!replaceExisting || !(existing instanceof ExternalizableScheme) || (oldInfo = (ExternalInfo)this.schemeToInfo.remove((Object)existing)) == null || !(scheme instanceof ExternalizableScheme) || this.schemeToInfo.containsKey(scheme)) break;
                    T t = scheme;
                    if (t == null) {
                        throw new TypeCastException("T cannot be cast to E");
                    }
                    this.schemeToInfo.put((Object)((ExternalizableScheme)t), (Object)oldInfo);
                    break;
                }
                if (i == n2) break;
                ++i;
            }
        }
        if (toReplace == -1) {
            this.schemes.add(scheme);
        } else if (replaceExisting || !(scheme instanceof ExternalizableScheme)) {
            this.schemes.set(toReplace, scheme);
        } else {
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
            String string = UniqueNameGenerator.generateUniqueName((String)((ExternalizableScheme)scheme).getName(), this.collectExistingNames((Collection)this.schemes));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UniqueNameGenerator.gene\u2026ctExistingNames(schemes))");
            OptionsPackage$SchemeManagerImpl$0799e9b5.renameScheme(externalizableScheme, string);
            this.schemes.add(scheme);
        }
        if (scheme instanceof ExternalizableScheme && KotlinPackage.isNotEmpty((Collection)((Collection)this.filesToDelete)) && (info = (ExternalInfo)this.schemeToInfo.get(scheme)) != null) {
            this.filesToDelete.remove((Object)String.valueOf(info.getFileName()));
        }
    }

    private final Collection<String> collectExistingNames(@JetValueParameter(name="schemes") Collection<? extends T> schemes) {
        THashSet result = new THashSet(schemes.size());
        for (Scheme scheme : schemes) {
            result.add((Object)scheme.getName());
        }
        return (Collection)result;
    }

    public void clearAllSchemes() {
        this.schemeToInfo.forEachValue((TObjectProcedure)new TObjectProcedure<ExternalInfo>(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ SchemeManagerImpl this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(clearAllSchemes.1.class);
            }

            public boolean execute(@JetValueParameter(name="info") @NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                SchemeManagerImpl.access$scheduleDelete$11(this.this$0, info);
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        this.currentScheme = null;
        this.schemes.clear();
        this.schemeToInfo.clear();
    }

    public List<T> getAllSchemes() {
        return Collections.unmodifiableList((List)this.schemes);
    }

    @Nullable
    public T findSchemeByName(@JetValueParameter(name="schemeName") @NotNull String schemeName) {
        Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
        for (Scheme scheme : this.schemes) {
            if (!Intrinsics.areEqual((Object)scheme.getName(), (Object)schemeName)) continue;
            return (T)scheme;
        }
        return (T)((Scheme)null);
    }

    public void setCurrentSchemeName(@JetValueParameter(name="schemeName", type="?") @Nullable String schemeName) {
        this.currentSchemeName = schemeName;
        this.currentScheme = null;
    }

    @Nullable
    public T getCurrentScheme() {
        T scheme = this.currentScheme;
        if (scheme == null && this.currentSchemeName != null) {
            String string = this.currentSchemeName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((scheme = this.findSchemeByName(string)) != null) {
                this.currentScheme = scheme;
            }
        }
        return scheme;
    }

    /*
     * WARNING - void declaration
     */
    public void removeScheme(@JetValueParameter(name="scheme") @NotNull T scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        IntProgression intProgression = KotlinPackage.downTo((int)(this.schemes.size() - 1), (int)0);
        int n = ((Number)intProgression.getStart()).intValue();
        int n2 = ((Number)intProgression.getEnd()).intValue();
        int n3 = ((Number)intProgression.getIncrement()).intValue();
        int n4 = InternalPackage.getProgressionFinalElement((int)n, (int)n2, (int)n3);
        int n5 = n;
        int n6 = n2;
        if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                Scheme s = (Scheme)this.schemes.get((int)i);
                if (Intrinsics.areEqual((Object)scheme.getName(), (Object)s.getName())) {
                    if (Intrinsics.areEqual(this.currentScheme, (Object)s)) {
                        this.currentScheme = null;
                    }
                    if (s instanceof ExternalizableScheme) {
                        Unit unit;
                        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.remove((Object)s);
                        if (externalInfo != null) {
                            this.scheduleDelete(externalInfo);
                            unit = Unit.INSTANCE$;
                        } else {
                            unit = null;
                        }
                    }
                    this.schemes.remove((int)i);
                    break;
                }
                if (i == n4) break;
                n = i + n3;
            }
        }
    }

    @NotNull
    public Collection<String> getAllSchemeNames() {
        if (this.schemes.isEmpty()) {
            return KotlinPackage.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(this.schemes.size());
        for (Scheme scheme : this.schemes) {
            names.add(scheme.getName());
        }
        return names;
    }

    public boolean isMetadataEditable(@JetValueParameter(name="scheme") @NotNull E scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        return !this.readOnlyExternalizableSchemes.containsKey((Object)OptionsPackage$SchemeManagerImpl$0799e9b5.getName((Scheme)scheme));
    }

    @NotNull
    public String toString() {
        return this.fileSpec;
    }

    public SchemeManagerImpl(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="processor") @NotNull SchemeProcessor<E> processor, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType, @JetValueParameter(name="provider", type="?") @Nullable StreamProvider provider, @JetValueParameter(name="ioDirectory") @NotNull File ioDirectory) {
        VirtualFileTracker virtualFileTracker;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull((Object)ioDirectory, (String)"ioDirectory");
        this.fileSpec = fileSpec;
        this.processor = processor;
        this.roamingType = roamingType;
        this.provider = provider;
        this.ioDirectory = ioDirectory;
        this.schemes = new ArrayList();
        this.readOnlyExternalizableSchemes = new THashMap();
        this.filesToDelete = new THashSet();
        this.schemeToInfo = new THashMap(ContainerUtil.identityStrategy());
        if (this.processor instanceof SchemeExtensionProvider) {
            String string = ((SchemeExtensionProvider)this.processor).getSchemeExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processor.getSchemeExtension()");
            this.schemeExtension = string;
            this.updateExtension = ((SchemeExtensionProvider)this.processor).isUpgradeNeeded();
        } else {
            this.schemeExtension = DirectoryStorageData.DEFAULT_EXT;
            this.updateExtension = false;
        }
        VirtualFileTracker virtualFileTracker2 = virtualFileTracker = this.provider != null && this.provider.getEnabled() ? (VirtualFileTracker)null : (VirtualFileTracker)ServiceManager.getService(VirtualFileTracker.class);
        if (virtualFileTracker != null) {
            String baseDirPath = KotlinPackage.replace$default((String)this.ioDirectory.getAbsolutePath(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4);
            virtualFileTracker.addTracker(LocalFileSystem.PROTOCOL_PREFIX + baseDirPath, (VirtualFileListener)new VirtualFileAdapter(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(1.class);
                }

                public void contentsChanged(@JetValueParameter(name="event") @NotNull VirtualFileEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    if (event.getRequestor() != null || !SchemeManagerImpl.super.isMy(event)) {
                        return;
                    }
                    String string = event.getFile().getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.getFile().getName()");
                    Object scheme = SchemeManagerImpl.super.findExternalizableSchemeByFileName(string);
                    Object oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = this.getCurrentScheme();
                        Object e = scheme;
                        if (e == null) {
                            throw new TypeCastException("E? cannot be cast to T");
                        }
                        this.removeScheme((Scheme)e);
                        processor.onSchemeDeleted(scheme);
                    }
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.getFile()");
                    Object readScheme = SchemeManagerImpl.super.readSchemeFromFile(virtualFile, false);
                    if (readScheme != null) {
                        processor.initScheme(readScheme);
                        processor.onSchemeAdded(readScheme);
                        Object newCurrentScheme = this.getCurrentScheme();
                        if (oldCurrentScheme != null && newCurrentScheme == null) {
                            this.setCurrentSchemeName(readScheme.getName());
                            newCurrentScheme = this.getCurrentScheme();
                        }
                        if (oldCurrentScheme != newCurrentScheme) {
                            processor.onCurrentSchemeChanged(oldCurrentScheme);
                        }
                    }
                }

                public void fileCreated(@JetValueParameter(name="event") @NotNull VirtualFileEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    if (event.getRequestor() == null) {
                        if (event.getFile().isDirectory()) {
                            VirtualFile dir = SchemeManagerImpl.super.getDirectory();
                            if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                                VirtualFile virtualFile = dir;
                                if (virtualFile == null) {
                                    Intrinsics.throwNpe();
                                }
                                VirtualFile[] virtualFileArray = virtualFile.getChildren();
                                for (int i = 0; i < virtualFileArray.length; ++i) {
                                    VirtualFile file;
                                    VirtualFile virtualFile2 = file = virtualFileArray[i];
                                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                                    if (!SchemeManagerImpl.super.isMy(virtualFile2)) continue;
                                    VirtualFile virtualFile3 = file;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file");
                                    this.schemeCreatedExternally(virtualFile3);
                                }
                            }
                        } else if (SchemeManagerImpl.super.isMy(event)) {
                            VirtualFile virtualFile = event.getFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.getFile()");
                            this.schemeCreatedExternally(virtualFile);
                        }
                    }
                }

                private final void schemeCreatedExternally(@JetValueParameter(name="file") VirtualFile file) {
                    Object readScheme = SchemeManagerImpl.super.readSchemeFromFile(file, false);
                    if (readScheme != null) {
                        processor.initScheme(readScheme);
                        processor.onSchemeAdded(readScheme);
                    }
                }

                public void fileDeleted(@JetValueParameter(name="event") @NotNull VirtualFileEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    if (event.getRequestor() == null) {
                        if (event.getFile().isDirectory()) {
                            VirtualFile dir = directory;
                            if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                                directory = null;
                                VirtualFile virtualFile = dir;
                                if (virtualFile == null) {
                                    Intrinsics.throwNpe();
                                }
                                VirtualFile[] virtualFileArray = virtualFile.getChildren();
                                for (int i = 0; i < virtualFileArray.length; ++i) {
                                    VirtualFile file;
                                    VirtualFile virtualFile2 = file = virtualFileArray[i];
                                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                                    if (!SchemeManagerImpl.super.isMy(virtualFile2)) continue;
                                    VirtualFile virtualFile3 = file;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file");
                                    this.schemeDeletedExternally(virtualFile3);
                                }
                            }
                        } else if (SchemeManagerImpl.super.isMy(event)) {
                            VirtualFile virtualFile = event.getFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.getFile()");
                            this.schemeDeletedExternally(virtualFile);
                        }
                    }
                }

                private final void schemeDeletedExternally(@JetValueParameter(name="file") VirtualFile file) {
                    String string = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.getName()");
                    Object scheme = SchemeManagerImpl.super.findExternalizableSchemeByFileName(string);
                    Object oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = this.getCurrentScheme();
                        Object e = scheme;
                        if (e == null) {
                            throw new TypeCastException("E? cannot be cast to T");
                        }
                        this.removeScheme((Scheme)e);
                        processor.onSchemeDeleted(scheme);
                    }
                    Object newCurrentScheme = this.getCurrentScheme();
                    if (oldCurrentScheme != null && newCurrentScheme == null && !schemes.isEmpty()) {
                        this.setCurrentSchemeName(((Scheme)schemes.get(0)).getName());
                        newCurrentScheme = this.getCurrentScheme();
                    }
                    if (oldCurrentScheme != newCurrentScheme) {
                        processor.onCurrentSchemeChanged(oldCurrentScheme);
                    }
                }
            }, false, (Disposable)ApplicationManager.getApplication());
        }
    }

    @NotNull
    public static final /* synthetic */ THashMap<String, E> access$getReadOnlyExternalizableSchemes$1(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return $this.readOnlyExternalizableSchemes;
    }

    @NotNull
    public static final /* synthetic */ THashSet<String> access$getFilesToDelete$3(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return $this.filesToDelete;
    }

    public static final /* synthetic */ boolean access$canRead$6(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="name") @NotNull CharSequence name) {
        return super.canRead(name);
    }

    @Nullable
    public static final /* synthetic */ E access$loadScheme$7(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="fileName") @NotNull CharSequence fileName, @JetValueParameter(name="input") @NotNull InputStream input, @JetValueParameter(name="duringLoad") boolean duringLoad) {
        return super.loadScheme(fileName, input, duringLoad);
    }

    public static final /* synthetic */ void access$scheduleDelete$11(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="$receiver") ExternalInfo $receiver) {
        super.scheduleDelete($receiver);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0002\b)aQ\t\u001f;fe:\fG.\u00138g_*\t2k\u00195f[\u0016l\u0015M\\1hKJLU\u000e\u001d7\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&Tqa\u001c9uS>t7OC\u0002B]fTaa[8uY&t'B\u0002\u001fj]&$hH\u0003\rgS2,g*Y7f/&$\bn\\;u\u000bb$XM\\:j_:Taa\u0015;sS:<'\"\u00044jY\u0016,\u0005\u0010^3og&|gN\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT\u0001cZ3u\r&dW-\u0012=uK:\u001c\u0018n\u001c8\u000b!M,GOR5mK\u0016CH/\u001a8tS>t'\u0002\u00034jY\u0016t\u0015-\\3\u000b\u0017\u001d,GOR5mK:\u000bW.\u001a\u0006\u001cO\u0016$h)\u001b7f\u001d\u0006lWmV5uQ>,H/\u0012=uK:\u001c\u0018n\u001c8\u000b7M,GOR5mK:\u000bW.Z,ji\"|W\u000f^#yi\u0016t7/[8o\u0015\u0011A\u0017m\u001d5\u000b\u0007%sGOC\u0004hKRD\u0015m\u001d5\u000b\u000fM,G\u000fS1tQ*Q1o\u00195f[\u0016t\u0015-\\3\u000b\u001b\u001d,GoU2iK6,g*Y7f\u00155\u0019X\r^*dQ\u0016lWMT1nK*!b.Y7f/&$\bn\\;u\u000bb$XM\\:j_:T\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\tUs\u0017\u000e\u001e\u0006\ti>\u001cFO]5oOjS!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!B\u0002\u0005\u0004!\u0005A\u0002A\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\u001dQa\u0001\u0003\u0004\u0011\ra\u0001!B\u0002\u0005\u0007!)A\u0002A\u0003\u0002\u0011\u0019)!\u0001\"\u0003\t\u000e\u0015\u0011A!\u0002\u0005\u0006\u000b\r!1\u0001#\u0006\r\u0001\u0015\u0019Aa\u0001E\u000f\u0019\u0001!\u0011\u0001$\u0002\u001a\u0005\u0015\t\u0001rA\u0017\u0017\t\u0001g\u00014B\u0011\u0004\u000b\u0005AA\u0001$\u0001V\u00079)1\u0001b\u0003\n\u0003!-Qb\u0001\u0003\b\u0013\u0005AY!E\u0003\u0005\u0010%\tA\u0001A\u0007\u0002\u0011\u0017iC\u0002\u00021\u00051!\t#!B\u0001\t\t\u0011\u0002Sk\u0001\u0003\u000e\u0007\u0011E\u0011\"\u0001E\u0006[U!\u0001\u0019\u0004M\u0005C\t)\u0011\u0001\u0003\u0003V\u00079)1\u0001\"\u0003\n\u0003!-Qb\u0001\u0003\n\u0013\u0005AY!E\u0003\u0005\u0014%\tA\u0001A\u0007\u0002\u0011\u0017iS\u0003\u0002a\r1)\t#!B\u0001\t\rU\u001ba\"B\u0002\u0005\u0015%\tAQA\u0007\u0004\t-I\u0011\u0001\"\u0002\u0012\u000b\u0011]\u0011\"\u0001\u0003\u0001\u001b\u0005!)!\f\f\u0005\u00014AB\"I\u0002\u0006\u0003!!A\u0012A+\u0004\u001d\u0015\u0019A\u0001D\u0005\u0002\u0011\u0017i1\u0001\"\u0007\n\u0003!-\u0011#\u0002\u0003\u000e\u0013\u0005!\u0001!D\u0001\t\f5fB\u0001\u0001M\n;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0001u5A\u0001\u0001\u0005\u000f\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0003\t#!B\u0001\t\u000eE\u001bq\u0001b\u0005\n\u0003\u0011\u0001Q\"\u0001E\u0006\u001b\u0005AY!l\u0005\u0005\u0017ay\u0011EA\u0003\u0002\u0011\u0011\t6a\u0001\u0003\u0010\u0013\u0005AY!N\u0010\u0006=\u0011\u0019\u000f\u0001\u0007\u0003\u001e\u000e\u0011\u0001\u0001\u0012B\u0007\u0003\u000b\u0005AA\u0001U\u0002\u0001;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002G\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011\u000b\t6a\u0002\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\f5\t\u00012\u0002"})
    private static final class ExternalInfo {
        public static final /* synthetic */ KClass $kotlinClass;
        @Nullable
        private String schemeName;
        private int hash;
        @NotNull
        private String fileNameWithoutExtension;
        @Nullable
        private String fileExtension;

        static {
            $kotlinClass = Reflection.createKotlinClass(ExternalInfo.class);
        }

        @Nullable
        public final String getSchemeName() {
            return this.schemeName;
        }

        public final void setSchemeName(@JetValueParameter(name="<set-?>", type="?") @Nullable String string) {
            this.schemeName = string;
        }

        public final int getHash() {
            return this.hash;
        }

        public final void setHash(@JetValueParameter(name="<set-?>") int n) {
            this.hash = n;
        }

        @NotNull
        public final String getFileName() {
            return this.fileNameWithoutExtension + this.fileExtension;
        }

        public final void setFileNameWithoutExtension(@JetValueParameter(name="nameWithoutExtension") @NotNull String nameWithoutExtension, @JetValueParameter(name="extension") @NotNull String extension) {
            Intrinsics.checkParameterIsNotNull((Object)nameWithoutExtension, (String)"nameWithoutExtension");
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            this.fileNameWithoutExtension = nameWithoutExtension;
            this.fileExtension = extension;
        }

        @NotNull
        public String toString() {
            return this.getFileName();
        }

        @NotNull
        public final String getFileNameWithoutExtension() {
            return this.fileNameWithoutExtension;
        }

        public final void setFileNameWithoutExtension(@JetValueParameter(name="<set-?>") @NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.fileNameWithoutExtension = string;
        }

        @Nullable
        public final String getFileExtension() {
            return this.fileExtension;
        }

        public final void setFileExtension(@JetValueParameter(name="<set-?>", type="?") @Nullable String string) {
            this.fileExtension = string;
        }

        public ExternalInfo(@JetValueParameter(name="fileNameWithoutExtension") @NotNull String fileNameWithoutExtension, @JetValueParameter(name="fileExtension", type="?") @Nullable String fileExtension) {
            Intrinsics.checkParameterIsNotNull((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
            this.fileNameWithoutExtension = fileNameWithoutExtension;
            this.fileExtension = fileExtension;
        }
    }
}

