/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ConfigurableCardPanel
extends CardLayoutPanel<Configurable, Configurable, JComponent> {
    private static final Logger LOG = Logger.getInstance(ConfigurableCardPanel.class);

    @Override
    protected Configurable prepare(Configurable key) {
        try {
            ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)key);
        }
        catch (Exception unexpected) {
            LOG.error("cannot prepare configurable", (Throwable)unexpected);
        }
        return key;
    }

    @Override
    protected JComponent create(final Configurable configurable) {
        return configurable == null ? null : (JComponent)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JComponent>(){

            public JComponent compute() {
                JComponent component = null;
                try {
                    component = configurable.createComponent();
                }
                catch (Exception unexpected) {
                    LOG.error("cannot create configurable component", (Throwable)unexpected);
                }
                if (component != null) {
                    ConfigurableCardPanel.reset(configurable);
                    if (ConfigurableWrapper.cast(MasterDetails.class, (UnnamedConfigurable)configurable) == null) {
                        if (ConfigurableWrapper.cast(Configurable.NoMargin.class, (UnnamedConfigurable)configurable) == null) {
                            if (!component.getClass().equals(JPanel.class)) {
                                JPanel panel = new JPanel(new BorderLayout());
                                panel.add("Center", component);
                                component = panel;
                            }
                            component.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)10, (int)10));
                        }
                        if (ConfigurableWrapper.cast(Configurable.NoScroll.class, (UnnamedConfigurable)configurable) == null) {
                            JScrollPane scroll = ScrollPaneFactory.createScrollPane(null, (boolean)true);
                            scroll.setViewport(new GradientViewport(component, (Insets)JBUI.insetsTop((int)5), true));
                            scroll.getVerticalScrollBar().setUnitIncrement(JBUI.scale((int)10));
                            component = scroll;
                        }
                    }
                }
                return component;
            }
        });
    }

    @Override
    protected void dispose(Configurable configurable) {
        if (configurable != null) {
            try {
                configurable.disposeUIResources();
            }
            catch (Exception unexpected) {
                LOG.error("cannot dispose configurable", (Throwable)unexpected);
            }
        }
    }

    public static void reset(Configurable configurable) {
        if (configurable != null) {
            try {
                configurable.reset();
            }
            catch (Exception unexpected) {
                LOG.error("cannot reset configurable", (Throwable)unexpected);
            }
        }
    }
}

