/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

class ConfigurableEditor
extends AbstractEditor
implements AnActionListener,
AWTEventListener {
    private static final JBColor ERROR_BACKGROUND = new JBColor(0xFFBFBF, 5840671);
    private static final String RESET_NAME = "Reset";
    private static final String RESET_DESCRIPTION = "Rollback changes for this configuration element";
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("SettingsModification", 1000, false, (JComponent)this, (Disposable)this, (JComponent)this);
    private final ConfigurableCardPanel myCardPanel = new ConfigurableCardPanel(){

        @Override
        protected JComponent create(Configurable configurable) {
            JComponent content = super.create(configurable);
            return content != null ? content : ConfigurableEditor.this.createDefaultContent(configurable);
        }
    };
    private final JLabel myErrorLabel = new JLabel();
    private final AbstractAction myApplyAction = new AbstractAction(CommonBundle.getApplyButtonText()){

        @Override
        public void actionPerformed(ActionEvent event) {
            ConfigurableEditor.this.apply();
        }
    };
    private final AbstractAction myResetAction = new AbstractAction("Reset"){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ConfigurableEditor.this.myConfigurable != null) {
                ConfigurableCardPanel.reset(ConfigurableEditor.this.myConfigurable);
                ConfigurableEditor.this.updateCurrent(ConfigurableEditor.this.myConfigurable, true);
            }
        }
    };
    private Configurable myConfigurable;

    ConfigurableEditor(Disposable parent, Configurable configurable) {
        super(parent);
        this.myApplyAction.setEnabled(false);
        this.myResetAction.putValue("ShortDescription", RESET_DESCRIPTION);
        this.myResetAction.setEnabled(false);
        this.myErrorLabel.setOpaque(true);
        this.myErrorLabel.setEnabled(parent instanceof SettingsEditor);
        this.myErrorLabel.setVisible(false);
        this.myErrorLabel.setVerticalTextPosition(1);
        this.myErrorLabel.setBorder(BorderFactory.createEmptyBorder(10, 15, 15, 15));
        this.myErrorLabel.setBackground((Color)ERROR_BACKGROUND);
        this.add("South", RelativeFont.HUGE.install((Component)this.myErrorLabel));
        this.add("Center", this.myCardPanel);
        ActionManager.getInstance().addAnActionListener((AnActionListener)this, (Disposable)this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 56L);
        this.myConfigurable = configurable;
        this.myCardPanel.select(configurable, true);
        this.updateCurrent(configurable, false);
    }

    @Override
    void disposeOnce() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.myCardPanel.removeAll();
    }

    @Override
    String getHelpTopic() {
        return this.myConfigurable == null ? null : this.myConfigurable.getHelpTopic();
    }

    @Override
    Action getApplyAction() {
        return this.myApplyAction;
    }

    @Override
    Action getResetAction() {
        return this.myResetAction;
    }

    @Override
    boolean apply() {
        return this.setError(ConfigurableEditor.apply(this.myApplyAction.isEnabled() ? this.myConfigurable : null));
    }

    void openLink(Configurable configurable) {
        ShowSettingsUtil.getInstance().editConfigurable((Component)this, configurable);
    }

    public final void beforeEditorTyping(char ch, DataContext context) {
    }

    public final void beforeActionPerformed(AnAction action, DataContext context, AnActionEvent event) {
    }

    public final void afterActionPerformed(AnAction action, DataContext context, AnActionEvent event) {
        this.requestUpdate();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        JComponent preferred;
        if (this.myConfigurable instanceof BaseConfigurable && (preferred = ((BaseConfigurable)this.myConfigurable).getPreferredFocusedComponent()) != null) {
            return preferred;
        }
        return super.getPreferredFocusedComponent();
    }

    @Override
    public final void eventDispatched(AWTEvent event) {
        switch (event.getID()) {
            case 501: 
            case 502: 
            case 506: {
                MouseEvent me = (MouseEvent)event;
                if (!SwingUtilities.isDescendingFrom(me.getComponent(), this) && !this.isPopupOverEditor(me.getComponent())) break;
                this.requestUpdate();
                break;
            }
            case 401: 
            case 402: {
                KeyEvent ke = (KeyEvent)event;
                if (!SwingUtilities.isDescendingFrom(ke.getComponent(), this)) break;
                this.requestUpdate();
            }
        }
    }

    private void requestUpdate() {
        final Configurable configurable = this.myConfigurable;
        this.myQueue.queue(new Update(this){

            public void run() {
                ConfigurableEditor.this.updateIfCurrent(configurable);
            }

            public boolean isExpired() {
                return ConfigurableEditor.this.myConfigurable != configurable;
            }
        });
    }

    private boolean isPopupOverEditor(Component component) {
        Window popup;
        Window editor = UIUtil.getWindow((Component)this);
        if (editor != null && ((popup = UIUtil.getWindow((Component)component)) == editor || popup != null && editor == popup.getParent())) {
            if (popup instanceof JDialog) {
                JDialog dialog = (JDialog)popup;
                return Dialog.ModalityType.MODELESS == dialog.getModalityType();
            }
            return popup instanceof JWindow;
        }
        return false;
    }

    void updateCurrent(Configurable configurable, boolean reset) {
        boolean modified = configurable != null && configurable.isModified();
        this.myApplyAction.setEnabled(modified);
        this.myResetAction.setEnabled(modified);
        if (!modified && reset) {
            this.setError(null);
        }
    }

    final boolean updateIfCurrent(Configurable configurable) {
        if (this.myConfigurable != configurable) {
            return false;
        }
        this.updateCurrent(configurable, false);
        return true;
    }

    final ActionCallback select(final Configurable configurable) {
        ActionCallback callback = this.myCardPanel.select(configurable, false);
        callback.doWhenDone(new Runnable(){

            @Override
            public void run() {
                ConfigurableEditor.this.myConfigurable = configurable;
                ConfigurableEditor.this.updateCurrent(configurable, false);
            }
        });
        return callback;
    }

    final boolean setError(ConfigurationException exception) {
        if (exception == null) {
            this.myErrorLabel.setVisible(false);
            return true;
        }
        if (this.myErrorLabel.isEnabled()) {
            this.myErrorLabel.setText("<html><body><strong>" + exception.getTitle() + "</strong>:<br>" + exception.getMessage());
            this.myErrorLabel.setVisible(true);
        } else {
            Messages.showMessageDialog((Component)this, (String)exception.getMessage(), (String)exception.getTitle(), (Icon)Messages.getErrorIcon());
        }
        return false;
    }

    final JComponent getContent(Configurable configurable) {
        return (JComponent)this.myCardPanel.getValue(configurable, false);
    }

    final JComponent readContent(Configurable configurable) {
        return (JComponent)this.myCardPanel.getValue(configurable, true);
    }

    private JComponent createDefaultContent(Configurable configurable) {
        String description;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String key = configurable == null ? null : ConfigurableVisitor.ByID.getID(configurable) + ".settings.description";
        String string = description = key == null ? null : ConfigurableEditor.getString(configurable, key);
        if (description == null) {
            description = "Select configuration element in the tree to edit its settings";
            content.add("Center", new JLabel(description, 0));
            content.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        } else {
            content.add("North", new JLabel(description));
            if (configurable instanceof Configurable.Composite) {
                Configurable.Composite composite = (Configurable.Composite)configurable;
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                content.add("Center", panel);
                panel.add(Box.createVerticalStrut(10));
                for (final Configurable current : composite.getConfigurables()) {
                    LinkLabel label = new LinkLabel(current.getDisplayName(), null){

                        public void doClick() {
                            ConfigurableEditor.this.openLink(current);
                        }
                    };
                    label.setBorder(BorderFactory.createEmptyBorder(1, 17, 3, 1));
                    panel.add((Component)label);
                }
            }
        }
        return content;
    }

    private static String getString(Configurable configurable, String key) {
        try {
            ConfigurableWrapper wrapper;
            ResourceBundle bundle;
            if (configurable instanceof ConfigurableWrapper && (bundle = (wrapper = (ConfigurableWrapper)configurable).getExtensionPoint().findBundle()) != null) {
                return CommonBundle.message((ResourceBundle)bundle, (String)key, (Object[])new Object[0]);
            }
            return OptionsBundle.message((String)key, (Object[])new Object[0]);
        }
        catch (AssertionError error) {
            return null;
        }
    }

    static ConfigurationException apply(Configurable configurable) {
        if (configurable != null) {
            try {
                configurable.apply();
                UsageTrigger.trigger("ide.settings." + ConvertUsagesUtil.escapeDescriptorName(configurable.getDisplayName()));
            }
            catch (ConfigurationException exception) {
                return exception;
            }
        }
        return null;
    }
}

