/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkConfigurationUtil {
    private SdkConfigurationUtil() {
    }

    public static void createSdk(@Nullable Project project, final Sdk[] existingSdks, final NullableConsumer<Sdk> onSdkCreatedCallBack, final boolean createIfExists, final SdkType ... sdkTypes) {
        if (sdkTypes.length == 0) {
            onSdkCreatedCallBack.consume(null);
            return;
        }
        FileChooserDescriptor descriptor = SdkConfigurationUtil.createCompositeDescriptor(sdkTypes);
        VirtualFile suggestedDir = SdkConfigurationUtil.getSuggestedSdkRoot(sdkTypes[0]);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)suggestedDir, (Consumer)new FileChooser.FileChooserConsumer(){

            public void consume(List<VirtualFile> selectedFiles) {
                for (SdkType sdkType : sdkTypes) {
                    String path = selectedFiles.get(0).getPath();
                    if (!sdkType.isValidSdkHome(path)) continue;
                    Sdk newSdk = null;
                    if (!createIfExists) {
                        for (Sdk sdk : existingSdks) {
                            if (!path.equals(sdk.getHomePath())) continue;
                            newSdk = sdk;
                            break;
                        }
                    }
                    if (newSdk == null) {
                        newSdk = SdkConfigurationUtil.setupSdk(existingSdks, selectedFiles.get(0), sdkType, false, null, null);
                    }
                    onSdkCreatedCallBack.consume(newSdk);
                    return;
                }
                onSdkCreatedCallBack.consume(null);
            }

            public void cancelled() {
                onSdkCreatedCallBack.consume(null);
            }
        });
    }

    public static void createSdk(@Nullable Project project, Sdk[] existingSdks, NullableConsumer<Sdk> onSdkCreatedCallBack, SdkType ... sdkTypes) {
        SdkConfigurationUtil.createSdk(project, existingSdks, onSdkCreatedCallBack, true, sdkTypes);
    }

    private static FileChooserDescriptor createCompositeDescriptor(final SdkType ... sdkTypes) {
        return new FileChooserDescriptor(sdkTypes[0].getHomeChooserDescriptor()){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                if (files.length > 0) {
                    for (SdkType type : sdkTypes) {
                        if (!type.isValidSdkHome(files[0].getPath())) continue;
                        return;
                    }
                }
                String key = files.length > 0 && files[0].isDirectory() ? "sdk.configure.home.invalid.error" : "sdk.configure.home.file.invalid.error";
                throw new Exception(ProjectBundle.message((String)key, (Object[])new Object[]{sdkTypes[0].getPresentableName()}));
            }
        };
    }

    public static void addSdk(final @NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "addSdk"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable.getInstance().addJdk(sdk);
            }
        });
    }

    public static void removeSdk(final Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
        });
    }

    @Nullable
    public static Sdk setupSdk(Sdk[] allSdks, VirtualFile homeDir, SdkType sdkType, boolean silent, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        ProjectJdkImpl sdk;
        List<Sdk> sdksList = Arrays.asList(allSdks);
        try {
            String sdkPath = sdkType.sdkPath(homeDir);
            String sdkName = customSdkSuggestedName == null ? SdkConfigurationUtil.createUniqueSdkName(sdkType, sdkPath, sdksList) : SdkConfigurationUtil.createUniqueSdkName(customSdkSuggestedName, sdksList);
            sdk = new ProjectJdkImpl(sdkName, (SdkTypeId)sdkType);
            if (additionalData != null) {
                sdk.setSdkAdditionalData(additionalData);
            }
            sdk.setHomePath(sdkPath);
            sdkType.setupSdkPaths((Sdk)sdk);
        }
        catch (Exception e) {
            if (!silent) {
                Messages.showErrorDialog((String)("Error configuring SDK: " + e.getMessage() + ".\nPlease make sure that " + FileUtil.toSystemDependentName((String)homeDir.getPath()) + " is a valid home path for this SDK type."), (String)"Error Configuring SDK");
            }
            return null;
        }
        return sdk;
    }

    public static void setDirectoryProjectSdk(final @NotNull Project project, final @Nullable Sdk sdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "setDirectoryProjectSdk"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootManager.getInstance((Project)project).setProjectSdk(sdk);
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                if (modules.length > 0) {
                    ModuleRootModificationUtil.setSdkInherited((Module)modules[0]);
                }
            }
        });
    }

    public static void configureDirectoryProjectSdk(Project project, @Nullable Comparator<Sdk> preferredSdkComparator, SdkType ... sdkTypes) {
        Sdk existingSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (existingSdk != null && ArrayUtil.contains((Object)existingSdk.getSdkType(), (Object[])sdkTypes)) {
            return;
        }
        Sdk sdk = SdkConfigurationUtil.findOrCreateSdk(preferredSdkComparator, sdkTypes);
        if (sdk != null) {
            SdkConfigurationUtil.setDirectoryProjectSdk(project, sdk);
        }
    }

    @Nullable
    public static Sdk findOrCreateSdk(@Nullable Comparator<Sdk> comparator, SdkType ... sdkTypes) {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        Sdk sdk = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        if (sdk != null) {
            for (SdkType type : sdkTypes) {
                if (sdk.getSdkType() != type) continue;
                return sdk;
            }
        }
        for (SdkType type : sdkTypes) {
            List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)type);
            if (sdks.isEmpty()) continue;
            if (comparator != null) {
                Collections.sort(sdks, comparator);
            }
            return (Sdk)sdks.get(0);
        }
        for (SdkType sdkType : sdkTypes) {
            Sdk an_sdk;
            String suggestedHomePath = sdkType.suggestHomePath();
            if (suggestedHomePath == null || !sdkType.isValidSdkHome(suggestedHomePath) || (an_sdk = SdkConfigurationUtil.createAndAddSDK(suggestedHomePath, sdkType)) == null) continue;
            return an_sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk createAndAddSDK(final String path, SdkType sdkType) {
        VirtualFile sdkHome = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            }
        });
        if (sdkHome != null) {
            Sdk newSdk = SdkConfigurationUtil.setupSdk(ProjectJdkTable.getInstance().getAllJdks(), sdkHome, sdkType, true, null, null);
            if (newSdk != null) {
                SdkConfigurationUtil.addSdk(newSdk);
            }
            return newSdk;
        }
        return null;
    }

    public static String createUniqueSdkName(SdkType type, String home, Collection<Sdk> sdks) {
        return SdkConfigurationUtil.createUniqueSdkName(type.suggestSdkName(null, home), sdks);
    }

    public static String createUniqueSdkName(String suggestedName, Collection<Sdk> sdks) {
        HashSet<String> names = new HashSet<String>();
        for (Sdk jdk : sdks) {
            names.add(jdk.getName());
        }
        String newSdkName = suggestedName;
        int i = 0;
        while (names.contains(newSdkName)) {
            newSdkName = suggestedName + " (" + ++i + ")";
        }
        return newSdkName;
    }

    public static void selectSdkHome(final SdkType sdkType, final @NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "selectSdkHome"));
        }
        FileChooserDescriptor descriptor = sdkType.getHomeChooserDescriptor();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)sdkType);
            if (sdk == null) {
                throw new RuntimeException("No SDK of type " + sdkType + " found");
            }
            consumer.consume((Object)sdk.getHomePath());
            return;
        }
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, (VirtualFile)SdkConfigurationUtil.getSuggestedSdkRoot(sdkType), (Consumer)new Consumer<List<VirtualFile>>(){

            public void consume(List<VirtualFile> chosen) {
                String path = chosen.get(0).getPath();
                if (sdkType.isValidSdkHome(path)) {
                    consumer.consume((Object)path);
                    return;
                }
                String adjustedPath = sdkType.adjustSelectedSdkHome(path);
                if (sdkType.isValidSdkHome(adjustedPath)) {
                    consumer.consume((Object)adjustedPath);
                }
            }
        });
    }

    @Nullable
    public static VirtualFile getSuggestedSdkRoot(SdkType sdkType) {
        String homePath = sdkType.suggestHomePath();
        return homePath == null ? null : LocalFileSystem.getInstance().findFileByPath(homePath);
    }

    public static List<String> filterExistingPaths(SdkType sdkType, Collection<String> sdkHomes, Sdk[] sdks) {
        ArrayList<String> result = new ArrayList<String>();
        for (String sdkHome : sdkHomes) {
            if (SdkConfigurationUtil.findByPath(sdkType, sdks, sdkHome) != null) continue;
            result.add(sdkHome);
        }
        return result;
    }

    @Nullable
    private static Sdk findByPath(SdkType sdkType, Sdk[] sdks, String sdkHome) {
        for (Sdk sdk : sdks) {
            String path = sdk.getHomePath();
            if (sdk.getSdkType() != sdkType || path == null || !FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path), (String)FileUtil.toSystemIndependentName((String)sdkHome))) continue;
            return sdk;
        }
        return null;
    }
}

