/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;

public class LibraryNavigatable
implements Navigatable {
    private final Module module;
    private OrderEntry element;

    public LibraryNavigatable(@NotNull Library library, @NotNull Module module) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/libraries/LibraryNavigatable", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/libraries/LibraryNavigatable", "<init>"));
        }
        this.module = module;
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != library) continue;
            this.element = entry;
        }
    }

    public void navigate(boolean requestFocus) {
        ProjectSettingsService.getInstance(this.module.getProject()).openLibraryOrSdkSettings(this.element);
    }

    public boolean canNavigate() {
        return !this.module.isDisposed() && this.element != null;
    }

    public boolean canNavigateToSource() {
        return false;
    }
}

