/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.HeaderHidingTabbedModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesConfigurator
implements ModulesProvider,
ModuleEditor.ChangeListener {
    private static final Logger LOG = Logger.getInstance((String)("#" + ModulesConfigurator.class.getName()));
    private final Project myProject;
    private final Map<Module, ModuleEditor> myModuleEditors = new TreeMap<Module, ModuleEditor>(new Comparator<Module>(){

        @Override
        public int compare(Module o1, Module o2) {
            String n2;
            String n1 = o1.getName();
            int result = n1.compareToIgnoreCase(n2 = o2.getName());
            if (result != 0) {
                return result;
            }
            return n1.compareTo(n2);
        }
    });
    private boolean myModified = false;
    private ModifiableModuleModel myModuleModel;
    private boolean myModuleModelCommitted = false;
    private ProjectFacetsConfigurator myFacetsConfigurator;
    private StructureConfigurableContext myContext;
    private final List<ModuleEditor.ChangeListener> myAllModulesChangeListeners = new ArrayList<ModuleEditor.ChangeListener>();

    public ModulesConfigurator(Project project) {
        this.myProject = project;
        this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
    }

    public void setContext(StructureConfigurableContext context) {
        this.myContext = context;
        this.myFacetsConfigurator = this.createFacetsConfigurator();
    }

    public ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.myFacetsConfigurator;
    }

    public void disposeUIResources() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors.values()) {
                    Disposer.dispose((Disposable)moduleEditor);
                }
                ModulesConfigurator.this.myModuleEditors.clear();
                ModulesConfigurator.this.myModuleModel.dispose();
                if (ModulesConfigurator.this.myFacetsConfigurator != null) {
                    ModulesConfigurator.this.myFacetsConfigurator.disposeEditors();
                }
            }
        });
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator", "getModules"));
        }
        return moduleArray;
    }

    @Nullable
    public Module getModule(String name) {
        Module moduleByName = this.myModuleModel.findModuleByName(name);
        if (moduleByName != null) {
            return moduleByName;
        }
        return this.myModuleModel.getModuleToBeRenamed(name);
    }

    @Nullable
    public ModuleEditor getModuleEditor(Module module) {
        return this.myModuleEditors.get(module);
    }

    public ModuleRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator", "getRootModel"));
        }
        return this.getOrCreateModuleEditor(module).getRootModel();
    }

    public ModuleEditor getOrCreateModuleEditor(Module module) {
        LOG.assertTrue(this.getModule(module.getName()) != null, (Object)"Module has been deleted");
        ModuleEditor editor = this.getModuleEditor(module);
        if (editor == null) {
            editor = this.doCreateModuleEditor(module);
        }
        return editor;
    }

    private ModuleEditor doCreateModuleEditor(Module module) {
        final HeaderHidingTabbedModuleEditor moduleEditor = new HeaderHidingTabbedModuleEditor(this.myProject, this, module){

            @Override
            public ProjectFacetsConfigurator getFacetsConfigurator() {
                return ModulesConfigurator.this.myFacetsConfigurator;
            }
        };
        this.myModuleEditors.put(moduleEditor.getModule(), moduleEditor);
        moduleEditor.addChangeListener(this);
        Disposer.register((Disposable)moduleEditor, (Disposable)new Disposable(){

            public void dispose() {
                moduleEditor.removeChangeListener(ModulesConfigurator.this);
            }
        });
        return moduleEditor;
    }

    public FacetModel getFacetModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator", "getFacetModel"));
        }
        return this.myFacetsConfigurator.getOrCreateModifiableModel(module);
    }

    public void resetModuleEditors() {
        this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Module[] modules;
                if (!ModulesConfigurator.this.myModuleEditors.isEmpty()) {
                    LOG.error("module editors was not disposed");
                    ModulesConfigurator.this.myModuleEditors.clear();
                }
                if ((modules = ModulesConfigurator.this.myModuleModel.getModules()).length > 0) {
                    for (Module module : modules) {
                        ModulesConfigurator.this.getOrCreateModuleEditor(module);
                    }
                }
            }
        });
        this.myFacetsConfigurator.resetEditors();
        this.myModified = false;
    }

    @Override
    public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
        for (ModuleEditor.ChangeListener listener : this.myAllModulesChangeListeners) {
            listener.moduleStateChanged(moduleRootModel);
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, moduleRootModel.getModule()));
    }

    public void addAllModuleChangeListener(ModuleEditor.ChangeListener listener) {
        this.myAllModulesChangeListeners.add(listener);
    }

    public void apply() throws ConfigurationException {
        HashMap contentRootToModuleNameMap = new HashMap();
        HashMap srcRootsToContentRootMap = new HashMap();
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            ContentEntry[] contents;
            ModifiableRootModel rootModel = moduleEditor.getModifiableRootModel();
            for (ContentEntry contentEntry : contents = rootModel.getContentEntries()) {
                VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                String moduleName = moduleEditor.getName();
                String previousName = contentRootToModuleNameMap.put(contentRoot, moduleName);
                if (previousName != null && !previousName.equals(moduleName)) {
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.content.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), previousName, moduleName}));
                }
                for (VirtualFile srcRoot : contentEntry.getSourceFolderFiles()) {
                    String correctModule;
                    String problematicModule;
                    VirtualFile anotherContentRoot = srcRootsToContentRootMap.put(srcRoot, contentRoot);
                    if (anotherContentRoot == null) continue;
                    if (VfsUtilCore.isAncestor((VirtualFile)anotherContentRoot, (VirtualFile)contentRoot, (boolean)true)) {
                        problematicModule = (String)contentRootToModuleNameMap.get(anotherContentRoot);
                        correctModule = (String)contentRootToModuleNameMap.get(contentRoot);
                    } else {
                        problematicModule = (String)contentRootToModuleNameMap.get(contentRoot);
                        correctModule = (String)contentRootToModuleNameMap.get(anotherContentRoot);
                    }
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.source.root.error", (Object[])new Object[]{problematicModule, srcRoot.getPresentableUrl(), correctModule}));
                }
            }
        }
        for (Map.Entry entry : srcRootsToContentRootMap.entrySet()) {
            VirtualFile srcRoot = (VirtualFile)entry.getKey();
            VirtualFile correspondingContent = (VirtualFile)entry.getValue();
            String expectedModuleName = (String)contentRootToModuleNameMap.get(correspondingContent);
            for (VirtualFile candidateContent = srcRoot; candidateContent != null && !candidateContent.equals(correspondingContent); candidateContent = candidateContent.getParent()) {
                String moduleName = (String)contentRootToModuleNameMap.get(candidateContent);
                if (moduleName == null || moduleName.equals(expectedModuleName)) continue;
                throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.source.root.belongs.to.another.module.error", (Object[])new Object[]{srcRoot.getPresentableUrl(), expectedModuleName, moduleName}));
            }
        }
        final ArrayList<ModifiableRootModel> models = new ArrayList<ModifiableRootModel>(this.myModuleEditors.size());
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.canApply();
        }
        HashMap hashMap = new HashMap();
        ProjectSdksModel projectJdksModel = ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel();
        for (Map.Entry<Sdk, Sdk> entry : projectJdksModel.getProjectSdks().entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            Sdk original;
            Sdk modelSdk;
            ModifiableRootModel model = moduleEditor.apply();
            if (model == null) continue;
            if (!model.isSdkInherited() && (modelSdk = model.getSdk()) != null && (original = (Sdk)hashMap.get(modelSdk)) != null) {
                model.setSdk(original);
            }
            models.add(model);
        }
        this.myFacetsConfigurator.applyEditors();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    ModifiableRootModel[] rootModels = models.toArray(new ModifiableRootModel[models.size()]);
                    ModifiableModelCommitter.multiCommit(rootModels, ModulesConfigurator.this.myModuleModel);
                    ModulesConfigurator.this.myModuleModelCommitted = true;
                    ModulesConfigurator.this.myFacetsConfigurator.commitFacets();
                }
                finally {
                    ModuleStructureConfigurable.getInstance(ModulesConfigurator.this.myProject).getFacetEditorFacade().clearMaps(false);
                    ModulesConfigurator.this.myFacetsConfigurator = ModulesConfigurator.this.createFacetsConfigurator();
                    ModulesConfigurator.this.myModuleModel = ModuleManager.getInstance((Project)ModulesConfigurator.this.myProject).getModifiableModel();
                    ModulesConfigurator.this.myModuleModelCommitted = false;
                }
            }
        });
        this.myModified = false;
    }

    private ProjectFacetsConfigurator createFacetsConfigurator() {
        return new ProjectFacetsConfigurator(this.myContext, this.myFacetsConfigurator);
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    public ModifiableModuleModel getModuleModel() {
        return this.myModuleModel;
    }

    public boolean isModuleModelCommitted() {
        return this.myModuleModelCommitted;
    }

    public boolean deleteModule(Module module) {
        ModuleEditor moduleEditor = this.getModuleEditor(module);
        if (moduleEditor == null) {
            return true;
        }
        return this.doRemoveModule(moduleEditor);
    }

    @Nullable
    public List<Module> addModule(Component parent, boolean anImport) {
        if (this.myProject.isDefault()) {
            return null;
        }
        ProjectBuilder builder = this.runModuleWizard(parent, anImport);
        if (builder != null) {
            List<Module> commitedModules;
            final ArrayList<Module> modules = new ArrayList<Module>();
            if (builder instanceof ProjectImportBuilder) {
                ModifiableArtifactModel artifactModel = ProjectStructureConfigurable.getInstance(this.myProject).getArtifactsStructureConfigurable().getModifiableArtifactModel();
                commitedModules = ((ProjectImportBuilder)builder).commit(this.myProject, this.myModuleModel, this, artifactModel);
            } else {
                commitedModules = builder.commit(this.myProject, this.myModuleModel, (ModulesProvider)this);
            }
            if (commitedModules != null) {
                modules.addAll(commitedModules);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (Module module : modules) {
                        ModulesConfigurator.this.getOrCreateModuleEditor(module);
                    }
                }
            });
            return modules;
        }
        return null;
    }

    private Module createModule(final ModuleBuilder builder) {
        try {
            return (Module)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Module, Exception>(){

                public Module compute() throws Exception {
                    return builder.createModule(ModulesConfigurator.this.myModuleModel);
                }
            });
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)ProjectBundle.message((String)"module.add.error.message", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"module.add.error.title", (Object[])new Object[0]));
            return null;
        }
    }

    @Nullable
    public Module addModule(ModuleBuilder moduleBuilder) {
        final Module module = this.createModule(moduleBuilder);
        if (module != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ModulesConfigurator.this.getOrCreateModuleEditor(module);
                }
            });
            this.processModuleCountChanged();
        }
        return module;
    }

    @Nullable
    ProjectBuilder runModuleWizard(Component dialogParent, boolean anImport) {
        AbstractProjectWizard wizard;
        if (anImport) {
            wizard = ImportModuleAction.selectFileAndCreateWizard(this.myProject, dialogParent);
            if (wizard == null) {
                return null;
            }
            if (wizard.getStepCount() == 0) {
                ProjectBuilder builder = wizard.getProjectBuilder();
                Disposer.dispose((Disposable)wizard.getDisposable());
                return builder;
            }
        } else {
            wizard = new NewProjectWizard(this.myProject, dialogParent, this);
        }
        if (wizard.showAndGet()) {
            ProjectBuilder builder = wizard.getProjectBuilder();
            if (builder instanceof ModuleBuilder) {
                ModuleBuilder moduleBuilder = (ModuleBuilder)builder;
                if (moduleBuilder.getName() == null) {
                    moduleBuilder.setName(wizard.getProjectName());
                }
                if (moduleBuilder.getModuleFilePath() == null) {
                    moduleBuilder.setModuleFilePath(wizard.getModuleFilePath());
                }
            }
            if (!builder.validate(this.myProject, this.myProject)) {
                return null;
            }
            return wizard.getProjectBuilder();
        }
        return null;
    }

    private boolean doRemoveModule(@NotNull ModuleEditor selectedEditor) {
        if (selectedEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedEditor", "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator", "doRemoveModule"));
        }
        String question = this.myModuleEditors.size() == 1 ? ProjectBundle.message((String)"module.remove.last.confirmation", (Object[])new Object[0]) : ProjectBundle.message((String)"module.remove.confirmation", (Object[])new Object[]{selectedEditor.getModule().getName()});
        int result = Messages.showYesNoDialog((Project)this.myProject, (String)question, (String)ProjectBundle.message((String)"module.remove.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (result != 0) {
            return false;
        }
        this.myModuleEditors.remove(selectedEditor.getModule());
        Module moduleToRemove = selectedEditor.getModule();
        ArrayList<ModifiableRootModel> modifiableRootModels = new ArrayList<ModifiableRootModel>();
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            ModifiableRootModel modifiableRootModel = moduleEditor.getModifiableRootModelProxy();
            modifiableRootModels.add(modifiableRootModel);
        }
        ModuleDeleteProvider.removeModule(moduleToRemove, null, modifiableRootModels, this.myModuleModel);
        this.processModuleCountChanged();
        Disposer.dispose((Disposable)selectedEditor);
        return true;
    }

    private void processModuleCountChanged() {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.moduleCountChanged();
        }
    }

    public void processModuleCompilerOutputChanged(String baseUrl) {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.updateCompilerOutputPathChanged(baseUrl, moduleEditor.getName());
        }
    }

    public boolean isModified() {
        if (this.myModuleModel.isChanged()) {
            return true;
        }
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            if (!moduleEditor.isModified()) continue;
            return true;
        }
        return this.myModified || this.myFacetsConfigurator.isModified();
    }

    public static boolean showArtifactSettings(@NotNull Project project, final @Nullable Artifact artifact) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator", "showArtifactSettings"));
        }
        final ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

            @Override
            public void run() {
                configurable.select(artifact, true);
            }
        });
    }

    public static boolean showFacetSettingsDialog(final @NotNull Facet facet, final @Nullable String tabNameToSelect) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator", "showFacetSettingsDialog"));
        }
        Project project = facet.getModule().getProject();
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                final ModuleStructureConfigurable modulesConfig = config.getModulesConfig();
                config.select(facet, true).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        if (tabNameToSelect != null) {
                            FacetEditorImpl facetEditor = modulesConfig.getFacetConfigurator().getOrCreateEditor(facet);
                            facetEditor.setSelectedTabName(tabNameToSelect);
                        }
                    }
                });
            }
        });
    }

    public static boolean showDialog(Project project, final @Nullable String moduleToSelect, final @Nullable String editorNameToSelect) {
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                config.select(moduleToSelect, editorNameToSelect, true);
            }
        });
    }

    public void moduleRenamed(Module module, String oldName, String name) {
        ModuleEditor moduleEditor = this.myModuleEditors.get(module);
        if (moduleEditor != null) {
            moduleEditor.setModuleName(name);
            moduleEditor.updateCompilerOutputPathChanged(ProjectStructureConfigurable.getInstance(this.myProject).getProjectConfig().getCompilerOutputUrl(), name);
            this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module));
        }
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }
}

