/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleConfigurable
extends ProjectStructureElementConfigurable<Module>
implements Place.Navigator {
    private final Module myModule;
    private final ModulesConfigurator myConfigurator;
    private String myModuleName;
    private final ModuleProjectStructureElement myProjectStructureElement;
    private final StructureConfigurableContext myContext;

    public ModuleConfigurable(ModulesConfigurator modulesConfigurator, Module module, Runnable updateTree) {
        super(true, updateTree);
        this.myModule = module;
        this.myModuleName = this.myModule.getName();
        this.myConfigurator = modulesConfigurator;
        this.myContext = ModuleStructureConfigurable.getInstance(this.myModule.getProject()).getContext();
        this.myProjectStructureElement = new ModuleProjectStructureElement(this.myContext, this.myModule);
    }

    public void setDisplayName(String name) {
        name = name.trim();
        ModifiableModuleModel modifiableModuleModel = this.myConfigurator.getModuleModel();
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        if (Comparing.strEqual((String)name, (String)this.myModuleName)) {
            return;
        }
        try {
            modifiableModuleModel.renameModule(this.myModule, name);
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            // empty catch block
        }
        this.myConfigurator.moduleRenamed(this.myModule, this.myModuleName, name);
        this.myModuleName = name;
        this.myConfigurator.setModified(!Comparing.strEqual((String)this.myModuleName, (String)this.myModule.getName()));
        this.myContext.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    public Module getEditableObject() {
        return this.myModule;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.module.banner.text", (Object[])new Object[]{this.myModuleName});
    }

    public String getDisplayName() {
        return this.myModuleName;
    }

    @Override
    public Icon getIcon(boolean open) {
        return this.myModule.isDisposed() ? null : ModuleType.get((Module)this.myModule).getIcon();
    }

    public Module getModule() {
        return this.myModule;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? null : editor.getHelpTopic();
    }

    public JComponent createOptionsPanel() {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? null : editor.getPanel();
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void disposeUIResources() {
    }

    public ModuleEditor getModuleEditor() {
        return this.myConfigurator.getModuleEditor(this.myModule);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? ActionCallback.REJECTED : editor.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleConfigurable", "queryPlace"));
        }
        ModuleEditor editor = this.getModuleEditor();
        if (editor != null) {
            editor.queryPlace(place);
        }
    }

    public void setHistory(History history) {
    }
}

