/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectSetProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OpenProjectSetProcessor
extends ProjectSetProcessor {
    public String getId() {
        return "project";
    }

    public void processEntries(@NotNull List<Pair<String, String>> entries, @NotNull ProjectSetProcessor.Context context, @NotNull Runnable runNext) {
        Project project;
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        if (runNext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runNext", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        final String root = context.directory.getPath() + "/" + context.directoryName;
        for (final Pair<String, String> entry : entries) {
            if (!"project".equals(entry.getFirst())) continue;
            final Project[] projects = ProjectManager.getInstance().getOpenProjects();
            context.project = (Project)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<Project>(){

                public Project compute() {
                    return ProjectUtil.openProject(root + "/" + (String)entry.getSecond(), (Project)ArrayUtil.getFirstElement((Object[])projects), false);
                }
            });
            if (context.project != null) {
                runNext.run();
            }
            return;
        }
        VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
        if (dir != null && (project = PlatformProjectOpenProcessor.getInstance().doOpenProject(dir, null, false)) != null) {
            runNext.run();
        }
    }
}

