/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.DirtBuilderReader;
import com.intellij.openapi.vcs.changes.FilePathUnderVcs;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DirtBuilder
implements DirtBuilderReader {
    private final VcsGuess myGuess;
    private final FileTypeManager myFileTypeManager;
    private final Set<FilePathUnderVcs> myFiles;
    private final Set<FilePathUnderVcs> myDirs;
    private boolean myEverythingDirty;

    public DirtBuilder(VcsGuess guess) {
        this.myGuess = guess;
        this.myDirs = new HashSet<FilePathUnderVcs>();
        this.myFiles = new HashSet<FilePathUnderVcs>();
        this.myEverythingDirty = false;
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    public DirtBuilder(DirtBuilder builder) {
        this.myGuess = builder.myGuess;
        this.myDirs = new HashSet<FilePathUnderVcs>(builder.myDirs);
        this.myFiles = new HashSet<FilePathUnderVcs>(builder.myFiles);
        this.myEverythingDirty = builder.myEverythingDirty;
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    public void reset() {
        this.myFiles.clear();
        this.myDirs.clear();
        this.myEverythingDirty = false;
    }

    public void everythingDirty() {
        this.myEverythingDirty = true;
    }

    public void addDirtyFile(VcsRoot root) {
        if (this.myFileTypeManager.isFileIgnored(root.getPath().getName())) {
            return;
        }
        this.myFiles.add(new FilePathUnderVcs(VcsUtil.getFilePath((VirtualFile)root.getPath()), root.getVcs()));
    }

    public void addDirtyDirRecursively(VcsRoot root) {
        if (this.myFileTypeManager.isFileIgnored(root.getPath().getName())) {
            return;
        }
        this.myDirs.add(new FilePathUnderVcs(VcsUtil.getFilePath((VirtualFile)root.getPath()), root.getVcs()));
    }

    public void addDirtyFile(FilePathUnderVcs root) {
        if (this.myFileTypeManager.isFileIgnored(root.getPath().getName())) {
            return;
        }
        this.myFiles.add(root);
    }

    public void addDirtyDirRecursively(FilePathUnderVcs root) {
        if (this.myFileTypeManager.isFileIgnored(root.getPath().getName())) {
            return;
        }
        this.myDirs.add(root);
    }

    @Override
    public boolean isEverythingDirty() {
        return this.myEverythingDirty;
    }

    @Override
    public Collection<FilePathUnderVcs> getFilesForVcs() {
        return this.myFiles;
    }

    @Override
    public Collection<FilePathUnderVcs> getDirsForVcs() {
        return this.myDirs;
    }

    @Override
    public boolean isEmpty() {
        return this.myFiles.isEmpty() && this.myDirs.isEmpty();
    }
}

