/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.ShowDiffUIContext;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ShowDiffAction.class);
    private static final String ourText = ActionsBundle.actionText((String)"ChangesView.Diff");

    public ShowDiffAction() {
        super(ourText, ActionsBundle.actionDescription((String)"ChangesView.Diff"), AllIcons.Actions.Diff);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "update"));
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if ("MainMenu".equals(e.getPlace())) {
            e.getPresentation().setEnabled(project != null && changes != null && changes.length > 0);
        } else {
            e.getPresentation().setEnabled(project != null && ShowDiffAction.canShowDiff(project, changes));
        }
    }

    protected static boolean canShowDiff(@Nullable Project project, @Nullable Change[] changes) {
        if (changes == null || changes.length == 0) {
            return false;
        }
        for (Change change : changes) {
            if (!ChangeDiffRequestProducer.canCreate(project, change)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "actionPerformed"));
        }
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (project == null || !ShowDiffAction.canShowDiff(project, changes)) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        final boolean needsConversion = ShowDiffAction.checkIfThereAreFakeRevisions(project, changes);
        final List changesInList = (List)e.getData(VcsDataKeys.CHANGES_IN_LIST_KEY);
        Runnable performer = new Runnable(){

            @Override
            public void run() {
                Object[] convertedChanges = needsConversion ? ShowDiffAction.loadFakeRevisions(project, changes) : changes;
                if (convertedChanges == null || convertedChanges.length == 0) {
                    return;
                }
                Change selectedChane = null;
                List result = null;
                if (convertedChanges.length == 1) {
                    selectedChane = convertedChanges[0];
                    LocalChangeList changeList = ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)project)).getIdentityChangeList(selectedChane);
                    if (changeList != null) {
                        List list = result = changesInList != null ? changesInList : new ArrayList(changeList.getChanges());
                    }
                }
                if (result == null) {
                    result = ContainerUtil.newArrayList((Object[])convertedChanges);
                }
                int index = selectedChane == null ? 0 : Math.max(0, ContainerUtil.indexOfIdentity((List)result, (Object)selectedChane));
                ShowDiffAction.showDiffForChange(project, result, index);
            }
        };
        if (needsConversion) {
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(performer, InvokeAfterUpdateMode.BACKGROUND_CANCELLABLE, ourText, ModalityState.current());
        } else {
            performer.run();
        }
    }

    private static boolean checkIfThereAreFakeRevisions(@NotNull Project project, @NotNull Change[] changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "checkIfThereAreFakeRevisions"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "checkIfThereAreFakeRevisions"));
        }
        boolean needsConversion = false;
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(beforeRevision.getFile());
                needsConversion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(afterRevision.getFile());
            needsConversion = true;
        }
        return needsConversion;
    }

    @Nullable
    private static Change[] loadFakeRevisions(@NotNull Project project, @NotNull Change[] changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "loadFakeRevisions"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "loadFakeRevisions"));
        }
        ArrayList matchingChanges = new ArrayList();
        for (Change change : changes) {
            matchingChanges.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(ChangesUtil.getFilePath((Change)change)));
        }
        return matchingChanges.toArray(new Change[matchingChanges.size()]);
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull Iterable<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        ShowDiffAction.showDiffForChange(project, changes, 0);
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull Iterable<Change> changes, int index) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        ShowDiffAction.showDiffForChange(project, changes, index, new ShowDiffContext());
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull Iterable<Change> changes, @NotNull Condition<Change> condition, @NotNull ShowDiffContext context) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        int index = 0;
        ArrayList<ChangeDiffRequestProducer> presentables = new ArrayList<ChangeDiffRequestProducer>();
        for (Change change : changes) {
            ChangeDiffRequestProducer presentable;
            if (condition.value((Object)change)) {
                index = presentables.size();
            }
            if ((presentable = ChangeDiffRequestProducer.create(project, change, context.getChangeContext(change))) == null) continue;
            presentables.add(presentable);
        }
        ShowDiffAction.showDiffForChange(project, presentables, index, context);
    }

    public static void showDiffForChange(@Nullable Project project, @NotNull Iterable<Change> changes, int index, @NotNull ShowDiffContext context) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        int i = 0;
        int newIndex = 0;
        ArrayList<ChangeDiffRequestProducer> presentables = new ArrayList<ChangeDiffRequestProducer>();
        for (Change change : changes) {
            ChangeDiffRequestProducer presentable;
            if (i == index) {
                newIndex = presentables.size();
            }
            if ((presentable = ChangeDiffRequestProducer.create(project, change, context.getChangeContext(change))) != null) {
                presentables.add(presentable);
            }
            ++i;
        }
        ShowDiffAction.showDiffForChange(project, presentables, newIndex, context);
    }

    private static void showDiffForChange(@Nullable Project project, @NotNull List<ChangeDiffRequestProducer> presentables, int index, @NotNull ShowDiffContext context) {
        if (presentables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentables", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (presentables.isEmpty()) {
            return;
        }
        if (index < 0 || index >= presentables.size()) {
            index = 0;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(presentables);
        chain.setIndex(index);
        for (Map.Entry<Key, Object> entry : context.getChainContext().entrySet()) {
            chain.putUserData(entry.getKey(), entry.getValue());
        }
        chain.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, context.getActions());
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, context.getDialogHints());
    }

    @NotNull
    public static ShowDiffContext convertContext(@NotNull ShowDiffUIContext uiContext) {
        if (uiContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiContext", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "convertContext"));
        }
        if (uiContext.getActionsFactory() != null) {
            LOG.warn("DiffExtendUIFactory ignored");
        }
        if (uiContext.getDiffNavigationContext() != null) {
            LOG.warn("DiffNavigationContext ignored");
        }
        ShowDiffContext showDiffContext = new ShowDiffContext(uiContext.isShowFrame() ? DiffDialogHints.FRAME : DiffDialogHints.MODAL);
        if (showDiffContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "convertContext"));
        }
        return showDiffContext;
    }
}

