/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredPathPresentation;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreUnversionedDialog
extends DialogWrapper {
    private JRadioButton myIgnoreSpecifiedFileRadioButton;
    private JRadioButton myIgnoreAllFilesUnderRadioButton;
    private TextFieldWithBrowseButton myIgnoreDirectoryTextField;
    private JRadioButton myIgnoreAllFilesMatchingRadioButton;
    private JTextField myIgnoreMaskTextField;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myIgnoreFileTextField;
    private List<VirtualFile> myFilesToIgnore;
    private final Project myProject;
    private boolean myInternalChange;
    private final IgnoredPathPresentation myPresentation;

    public IgnoreUnversionedDialog(Project project) {
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPresentation = new IgnoredPathPresentation(this.myProject);
        this.setTitle(VcsBundle.message((String)"ignored.edit.title", (Object[])new Object[0]));
        this.init();
        this.myIgnoreFileTextField.addBrowseFolderListener("Select File to Ignore", "Select the file which will not be tracked for changes", project, new FileChooserDescriptor(true, false, false, true, false, false));
        this.myIgnoreFileTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!IgnoreUnversionedDialog.this.myInternalChange) {
                    IgnoreUnversionedDialog.this.myFilesToIgnore = null;
                }
            }
        });
        this.myIgnoreDirectoryTextField.addBrowseFolderListener("Select Directory to Ignore", "Select the directory which will not be tracked for changes", project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgnoreUnversionedDialog.this.updateControls();
            }
        };
        this.myIgnoreAllFilesUnderRadioButton.addActionListener(listener);
        this.myIgnoreAllFilesMatchingRadioButton.addActionListener(listener);
        this.myIgnoreSpecifiedFileRadioButton.addActionListener(listener);
        this.updateControls();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/IgnoreUnversionedDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("ignoreUnversionedFilesDialog");
    }

    private void updateControls() {
        this.myIgnoreDirectoryTextField.setEnabled(this.myIgnoreAllFilesUnderRadioButton.isSelected() && this.getDirectoriesToIgnore() <= 1);
        this.myIgnoreMaskTextField.setEnabled(this.myIgnoreAllFilesMatchingRadioButton.isSelected());
        this.myIgnoreFileTextField.setEnabled(this.myIgnoreSpecifiedFileRadioButton.isSelected() && (this.myFilesToIgnore == null || this.myFilesToIgnore.size() == 1 && !this.myFilesToIgnore.get(0).isDirectory()));
    }

    private int getDirectoriesToIgnore() {
        int result = 0;
        if (this.myFilesToIgnore != null) {
            for (VirtualFile f : this.myFilesToIgnore) {
                if (!f.isDirectory()) continue;
                ++result;
            }
        }
        return result;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFilesToIgnore(List<VirtualFile> virtualFiles) {
        assert (virtualFiles.size() > 0);
        this.myFilesToIgnore = virtualFiles;
        this.myInternalChange = true;
        try {
            if (virtualFiles.size() == 1) {
                VirtualFile projectDir = this.myProject.getBaseDir();
                String path = FileUtil.getRelativePath((File)new File(projectDir.getPresentableUrl()), (File)new File(virtualFiles.get(0).getPresentableUrl()));
                this.myIgnoreFileTextField.setText(path);
            } else {
                this.myIgnoreFileTextField.setText(VcsBundle.message((String)"ignored.edit.multiple.files", (Object[])new Object[]{virtualFiles.size()}));
            }
        }
        finally {
            this.myInternalChange = false;
        }
        int dirCount = 0;
        for (VirtualFile file : virtualFiles) {
            if (!file.isDirectory()) continue;
            this.myIgnoreAllFilesUnderRadioButton.setSelected(true);
            this.myIgnoreSpecifiedFileRadioButton.setEnabled(false);
            this.myIgnoreFileTextField.setEnabled(false);
            ++dirCount;
        }
        this.updateControls();
        VirtualFile[] ancestors = VfsUtil.getCommonAncestors((VirtualFile[])VfsUtil.toVirtualFileArray(virtualFiles));
        if (dirCount > 1) {
            this.myIgnoreDirectoryTextField.setText(VcsBundle.message((String)"ignored.edit.multiple.directories", (Object[])new Object[]{dirCount}));
        } else if (ancestors.length > 0) {
            this.myIgnoreDirectoryTextField.setText(ancestors[0].getPresentableUrl());
        } else {
            this.myIgnoreDirectoryTextField.setText(virtualFiles.get(0).getParent().getPresentableUrl());
        }
        HashSet<String> extensions = new HashSet<String>();
        for (VirtualFile vf : virtualFiles) {
            String extension = vf.getExtension();
            if (extension == null) continue;
            extensions.add(extension);
        }
        if (extensions.size() > 0) {
            String[] extensionArray = ArrayUtil.toStringArray(extensions);
            this.myIgnoreMaskTextField.setText("*." + extensionArray[0]);
        } else {
            this.myIgnoreMaskTextField.setText(virtualFiles.get(0).getPresentableName());
        }
    }

    public void setIgnoredFile(IgnoredFileBean bean) {
        String pathFromBean = bean.getPath();
        if (pathFromBean != null) {
            String path = pathFromBean.replace('/', File.separatorChar);
            if (path.endsWith(File.separator)) {
                this.myIgnoreAllFilesUnderRadioButton.setSelected(true);
                this.myIgnoreDirectoryTextField.setText(path);
            } else {
                this.myIgnoreSpecifiedFileRadioButton.setSelected(true);
                this.myIgnoreFileTextField.setText(path);
            }
        } else {
            this.myIgnoreAllFilesMatchingRadioButton.setSelected(true);
            this.myIgnoreMaskTextField.setText(bean.getMask());
        }
        this.updateControls();
    }

    public IgnoredFileBean[] getSelectedIgnoredFiles() {
        if (this.myIgnoreSpecifiedFileRadioButton.isSelected()) {
            if (this.myFilesToIgnore == null) {
                return new IgnoredFileBean[]{IgnoredBeanFactory.ignoreFile((String)this.myPresentation.alwaysRelative(this.myIgnoreFileTextField.getText()), (Project)this.myProject)};
            }
            return this.getBeansFromFilesToIgnore(false);
        }
        if (this.myIgnoreAllFilesUnderRadioButton.isSelected()) {
            if (this.getDirectoriesToIgnore() > 1) {
                return this.getBeansFromFilesToIgnore(true);
            }
            String path = this.myIgnoreDirectoryTextField.getText();
            return new IgnoredFileBean[]{IgnoredBeanFactory.ignoreUnderDirectory((String)this.myPresentation.alwaysRelative(path), (Project)this.myProject)};
        }
        if (this.myIgnoreAllFilesMatchingRadioButton.isSelected()) {
            return new IgnoredFileBean[]{IgnoredBeanFactory.withMask((String)this.myIgnoreMaskTextField.getText())};
        }
        return new IgnoredFileBean[0];
    }

    private IgnoredFileBean[] getBeansFromFilesToIgnore(boolean onlyDirs) {
        ArrayList<IgnoredFileBean> result = new ArrayList<IgnoredFileBean>();
        for (VirtualFile fileToIgnore : this.myFilesToIgnore) {
            String path = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)new File(fileToIgnore.getPath()));
            if (path == null) continue;
            path = FileUtil.toSystemIndependentName((String)path);
            if (fileToIgnore.isDirectory()) {
                result.add(IgnoredBeanFactory.ignoreUnderDirectory((String)path, (Project)this.myProject));
                continue;
            }
            if (onlyDirs) continue;
            result.add(IgnoredBeanFactory.ignoreFile((String)path, (Project)this.myProject));
        }
        return result.toArray(new IgnoredFileBean[result.size()]);
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "IgnoreUnversionedDialog";
    }

    public static void ignoreSelectedFiles(Project project, List<VirtualFile> files) {
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(project);
        dlg.setFilesToIgnore(files);
        if (!dlg.showAndGet()) {
            return;
        }
        IgnoredFileBean[] ignoredFiles = dlg.getSelectedIgnoredFiles();
        if (ignoredFiles.length > 0) {
            ChangeListManager.getInstance((Project)project).addFilesToIgnore(ignoredFiles);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myIgnoreAllFilesUnderRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/VcsBundle").getString("ignored.edit.radio.directory"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoreAllFilesMatchingRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/VcsBundle").getString("ignored.edit.radio.mask"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIgnoreDirectoryTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myIgnoreMaskTextField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myIgnoreSpecifiedFileRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/VcsBundle").getString("ignored.edit.radio.file"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoreFileTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

