/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocumentWrapper {
    private final Document myDocument;

    public DocumentWrapper(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/DocumentWrapper", "<init>"));
        }
        this.myDocument = document;
    }

    public int getLineNum(int offset) {
        return this.myDocument.getLineNumber(offset);
    }

    @NotNull
    public List<String> getLines() {
        List<String> list = this.getLines(0, DocumentWrapper.getLineCount(this.myDocument) - 1);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/DocumentWrapper", "getLines"));
        }
        return list;
    }

    @NotNull
    public List<String> getLines(int from, int to) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = from; i <= to; ++i) {
            result.add(this.getLine(i));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/DocumentWrapper", "getLines"));
        }
        return arrayList;
    }

    @NotNull
    private String getLine(int i) {
        TextRange range = new TextRange(this.myDocument.getLineStartOffset(i), this.myDocument.getLineEndOffset(i));
        if (range.getLength() < 0) assert (false) : this.myDocument;
        String string = this.myDocument.getText(range);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/DocumentWrapper", "getLine"));
        }
        return string;
    }

    private static int getLineCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/DocumentWrapper", "getLineCount"));
        }
        return Math.max(document.getLineCount(), 1);
    }
}

