/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.IntSLRUCache;
import com.intellij.util.containers.IntObjectLinkedMap;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.text.ByteArrayCharSequence;
import org.jetbrains.annotations.NotNull;

public class FileNameCache {
    private static final PersistentStringEnumerator ourNames = FSRecords.getNames();
    private static final IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>>[] ourNameCache = new IntSLRUCache[16];

    public static int storeName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "storeName"));
        }
        int idx = FSRecords.getNameId(name);
        FileNameCache.cacheData(name, idx, FileNameCache.calcStripeIdFromNameId(idx));
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static IntObjectLinkedMap.MapEntry<CharSequence> cacheData(String name, int id, int stripe) {
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> cache;
        if (name == null) {
            ourNames.markCorrupted();
            throw new RuntimeException("VFS name enumerator corrupted");
        }
        CharSequence rawName = ByteArrayCharSequence.convertToBytesIfAsciiString((String)name);
        IntObjectLinkedMap.MapEntry<CharSequence> entry = new IntObjectLinkedMap.MapEntry<CharSequence>(id, rawName);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> intSLRUCache = cache = ourNameCache[stripe];
        // MONITORENTER : intSLRUCache
        IntObjectLinkedMap.MapEntry<CharSequence> mapEntry = cache.cacheEntry(entry);
        // MONITOREXIT : intSLRUCache
        if (mapEntry != null) return mapEntry;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "cacheData"));
    }

    private static int calcStripeIdFromNameId(int id) {
        int h = id;
        h -= h << 6;
        h ^= h >> 17;
        h -= h << 9;
        h ^= h << 4;
        h -= h << 3;
        h ^= h << 10;
        h ^= h >> 15;
        return h % ourNameCache.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static CharSequence getVFileName(int nameId) {
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> cache;
        assert (nameId > 0);
        int stripe = FileNameCache.calcStripeIdFromNameId(nameId);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> intSLRUCache = cache = ourNameCache[stripe];
        synchronized (intSLRUCache) {
            IntObjectLinkedMap.MapEntry<CharSequence> entry = cache.getCachedEntry(nameId);
            if (entry != null) {
                CharSequence charSequence = (CharSequence)entry.value;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getVFileName"));
                }
                return charSequence;
            }
        }
        CharSequence charSequence = (CharSequence)FileNameCache.cacheData((String)FSRecords.getNameByNameId((int)nameId), (int)nameId, (int)stripe).value;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getVFileName"));
        }
        return charSequence;
    }

    static {
        int protectedSize = 40000 / ourNameCache.length;
        int probationalSize = 20000 / ourNameCache.length;
        for (int i = 0; i < ourNameCache.length; ++i) {
            FileNameCache.ourNameCache[i] = new IntSLRUCache(protectedSize, probationalSize);
        }
    }
}

