/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ToolbarUpdater;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.AltStateManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.PanelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ToolWindowHeader
extends JPanel
implements Disposable,
UISettingsListener {
    @NonNls
    private static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";
    @NonNls
    private static final String HIDE_ACTIVE_SIDE_WINDOW_ACTION_ID = "HideSideWindows";
    private ToolWindow myToolWindow;
    private WindowInfoImpl myInfo;
    private final ActionButton myHideButton;
    private BufferedImage myImage;
    private BufferedImage myActiveImage;
    private ToolWindowType myImageType;
    private final JPanel myButtonPanel;
    private final ActionButton myGearButton;
    private final PresentationFactory myPresentationFactory;
    private final ToolbarUpdater myUpdater;
    private final DefaultActionGroup myActionGroup;
    private List<AnAction> myVisibleActions;

    public ToolWindowHeader(final ToolWindowImpl toolWindow, @NotNull WindowInfoImpl info, final @NotNull Producer<ActionGroup> gearProducer) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowHeader", "<init>"));
        }
        if (gearProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gearProducer", "com/intellij/openapi/wm/impl/ToolWindowHeader", "<init>"));
        }
        this.myPresentationFactory = new PresentationFactory();
        this.myActionGroup = new DefaultActionGroup();
        this.myVisibleActions = ContainerUtil.newArrayListWithCapacity((int)2);
        this.setLayout(new BorderLayout());
        this.myToolWindow = toolWindow;
        this.myInfo = info;
        JPanel westPanel = new JPanel(){

            @Override
            public void doLayout() {
                if (this.getComponentCount() > 0) {
                    Rectangle r = this.getBounds();
                    Insets insets = this.getInsets();
                    Component c = this.getComponent(0);
                    Dimension size = c.getPreferredSize();
                    if (size.width < r.width - insets.left - insets.right) {
                        c.setBounds(insets.left, insets.top, size.width, r.height - insets.top - insets.bottom);
                    } else {
                        c.setBounds(insets.left, insets.top, r.width - insets.left - insets.right, r.height - insets.top - insets.bottom);
                    }
                }
            }
        };
        westPanel.setOpaque(false);
        this.add((Component)westPanel, "Center");
        westPanel.add(toolWindow.getContentUI().getTabComponent());
        toolWindow.getContentUI();
        ToolWindowContentUi.initMouseListeners(westPanel, toolWindow.getContentUI());
        JPanel eastPanel = new JPanel();
        eastPanel.setOpaque(false);
        eastPanel.setLayout(new BoxLayout(eastPanel, 0));
        eastPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.add((Component)eastPanel, "East");
        this.myGearButton = new ActionButton(new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ToolWindowHeader$2", "actionPerformed"));
                }
                InputEvent inputEvent = e.getInputEvent();
                ActionPopupMenu popupMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("ToolwindowPopup", (ActionGroup)gearProducer.produce(), new MenuItemPresentationFactory(true));
                int x = 0;
                int y = 0;
                if (inputEvent instanceof MouseEvent) {
                    x = ((MouseEvent)inputEvent).getX();
                    y = ((MouseEvent)inputEvent).getY();
                }
                popupMenu.getComponent().show(inputEvent.getComponent(), x, y);
            }
        }, AllIcons.General.Gear){

            @Override
            protected Icon getActiveHoveredIcon() {
                return AllIcons.General.GearHover;
            }
        };
        this.myHideButton = new ActionButton(new HideAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ToolWindowHeader$4", "actionPerformed"));
                }
                ToolWindowHeader.this.hideToolWindow();
            }
        }, new HideSideAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ToolWindowHeader$5", "actionPerformed"));
                }
                ToolWindowHeader.this.sideHidden();
            }
        }, AllIcons.General.HideLeft, null, null){

            @Override
            protected Icon getActiveIcon() {
                return ToolWindowHeader.getHideToolWindowIcon(ToolWindowHeader.this.myToolWindow);
            }

            @Override
            protected Icon getAlternativeIcon() {
                return ToolWindowHeader.getHideIcon(ToolWindowHeader.this.myToolWindow);
            }

            @Override
            protected Icon getActiveHoveredIcon() {
                return ToolWindowHeader.getHideToolWindowHoveredIcon(ToolWindowHeader.this.myToolWindow);
            }

            @Override
            protected Icon getAlternativeHoveredIcon() {
                return ToolWindowHeader.getHideHoveredIcon(ToolWindowHeader.this.myToolWindow);
            }
        };
        this.addDefaultActions(eastPanel);
        this.myButtonPanel = eastPanel;
        westPanel.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                toolWindow.getContentUI().showContextMenu(comp, x, y, toolWindow.getPopupGroup(), toolWindow.getContentManager().getSelectedContent());
            }
        });
        westPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                toolWindow.fireActivated();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        if (e.isAltDown()) {
                            toolWindow.fireHidden();
                        } else {
                            toolWindow.fireHiddenSide();
                        }
                    } else {
                        toolWindow.fireActivated();
                    }
                }
            }
        });
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        UISettings.getInstance().addUISettingsListener((UISettingsListener)this, (Disposable)toolWindow.getContentUI());
        this.myUpdater = new ToolbarUpdater(this){

            @Override
            protected void updateActionsImpl(boolean transparentOnly, boolean forced) {
                ToolWindowHeader.this.updateActionsImpl(transparentOnly, forced);
            }

            @Override
            protected void updateActionTooltips() {
                for (ActionButton actionButton : JBSwingUtilities.uiTraverser().preOrderTraversal((Object)ToolWindowHeader.this.myButtonPanel).filter(ActionButton.class)) {
                    actionButton.updateTooltip();
                }
            }
        };
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ToolWindowManagerImpl mgr = toolWindow.getToolWindowManager();
                mgr.setMaximized(ToolWindowHeader.this.myToolWindow, !mgr.isMaximized(ToolWindowHeader.this.myToolWindow));
                return true;
            }
        }.installOn((Component)westPanel);
        westPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(final MouseEvent e) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ToolWindowHeader.this.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, ToolWindowHeader.this));
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public void uiSettingsChanged(UISettings source) {
        this.clearCaches();
    }

    private void addDefaultActions(JPanel eastPanel) {
        eastPanel.add((Component)((Object)this.myGearButton));
        eastPanel.add(Box.createHorizontalStrut(6));
        eastPanel.add((Component)((Object)this.myHideButton));
        eastPanel.add(Box.createHorizontalStrut(1));
    }

    public void dispose() {
        this.removeAll();
        this.myToolWindow = null;
        this.myInfo = null;
    }

    public void setAdditionalTitleActions(AnAction[] actions2) {
        this.myActionGroup.removeAll();
        this.myActionGroup.addAll(actions2);
        this.myUpdater.updateActions(false, true);
    }

    private void updateActionsImpl(boolean transparentOnly, boolean forced) {
        ArrayList newVisibleActions = ContainerUtil.newArrayListWithCapacity((int)this.myVisibleActions.size());
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        Utils.expandActionGroup((ActionGroup)this.myActionGroup, newVisibleActions, this.myPresentationFactory, dataContext, "ToolwindowTitle", (ActionManager)this.myUpdater.getActionManager(), transparentOnly);
        if (forced || !newVisibleActions.equals(this.myVisibleActions)) {
            this.myVisibleActions = newVisibleActions;
            this.myButtonPanel.removeAll();
            boolean actionAdded = false;
            for (AnAction action : newVisibleActions) {
                if (action == null) continue;
                final Presentation presentation = this.myPresentationFactory.getPresentation(action);
                this.myButtonPanel.add((Component)((Object)new ActionButton(action, presentation.getIcon()){

                    @Override
                    protected Icon getActiveHoveredIcon() {
                        Icon icon = presentation.getHoveredIcon();
                        return icon != null ? icon : super.getActiveHoveredIcon();
                    }
                }));
                this.myButtonPanel.add(Box.createHorizontalStrut(9));
                actionAdded = true;
            }
            if (actionAdded) {
                this.myButtonPanel.add(new JLabel(AllIcons.General.Divider));
                this.myButtonPanel.add(Box.createHorizontalStrut(6));
            }
            this.addDefaultActions(this.myButtonPanel);
            this.revalidate();
            this.repaint();
        }
    }

    private static Icon getHideToolWindowIcon(ToolWindow toolWindow) {
        ToolWindowAnchor anchor = toolWindow.getAnchor();
        if (anchor == ToolWindowAnchor.BOTTOM) {
            return AllIcons.General.HideDownPart;
        }
        if (anchor == ToolWindowAnchor.RIGHT) {
            return AllIcons.General.HideRightPart;
        }
        return AllIcons.General.HideLeftPart;
    }

    private static Icon getHideIcon(ToolWindow toolWindow) {
        ToolWindowAnchor anchor = toolWindow.getAnchor();
        if (anchor == ToolWindowAnchor.BOTTOM) {
            return AllIcons.General.HideDown;
        }
        if (anchor == ToolWindowAnchor.RIGHT) {
            return AllIcons.General.HideRight;
        }
        return AllIcons.General.HideLeft;
    }

    private static Icon getHideToolWindowHoveredIcon(ToolWindow toolWindow) {
        ToolWindowAnchor anchor = toolWindow.getAnchor();
        if (anchor == ToolWindowAnchor.BOTTOM) {
            return AllIcons.General.HideDownPartHover;
        }
        if (anchor == ToolWindowAnchor.RIGHT) {
            return AllIcons.General.HideRightPartHover;
        }
        return AllIcons.General.HideLeftPartHover;
    }

    private static Icon getHideHoveredIcon(ToolWindow toolWindow) {
        ToolWindowAnchor anchor = toolWindow.getAnchor();
        if (anchor == ToolWindowAnchor.BOTTOM) {
            return AllIcons.General.HideDownHover;
        }
        if (anchor == ToolWindowAnchor.RIGHT) {
            return AllIcons.General.HideRightHover;
        }
        return AllIcons.General.HideLeftHover;
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage image;
        Rectangle r = this.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        Shape clip = g2d.getClip();
        ToolWindowType type = this.myToolWindow.getType();
        if (this.isActive()) {
            if (this.myActiveImage == null || type != this.myImageType) {
                this.myActiveImage = ToolWindowHeader.drawToBuffer(true, r.height, this.myToolWindow.getType() == ToolWindowType.FLOATING);
            }
            image = this.myActiveImage;
        } else {
            if (this.myImage == null || type != this.myImageType) {
                this.myImage = ToolWindowHeader.drawToBuffer(false, r.height, this.myToolWindow.getType() == ToolWindowType.FLOATING);
            }
            image = this.myImage;
        }
        this.myImageType = this.myToolWindow.getType();
        Rectangle clipBounds = clip.getBounds();
        for (int x = clipBounds.x; x < clipBounds.x + clipBounds.width; x += 150) {
            UIUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)0, null);
        }
    }

    private static BufferedImage drawToBuffer(boolean active, int height, boolean floating) {
        int width = 150;
        BufferedImage image = UIUtil.createImage((int)150, (int)height, (int)2);
        Graphics2D g = image.createGraphics();
        UIUtil.drawHeader((Graphics)g, (int)0, (int)150, (int)height, (boolean)active, (boolean)true, (!floating ? 1 : 0) != 0, (boolean)true);
        g.dispose();
        return image;
    }

    @Override
    public void setUI(PanelUI ui) {
        this.clearCaches();
        super.setUI(ui);
    }

    public void clearCaches() {
        this.myImage = null;
        this.myActiveImage = null;
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        UISettings.setupAntialiasing((Graphics)graphics);
        super.paintChildren(graphics);
        Rectangle r = this.getBounds();
        if (!this.isActive() && !UIUtil.isUnderDarcula()) {
            graphics.setColor(new Color(255, 255, 255, 30));
            graphics.fill(r);
        }
        graphics.dispose();
    }

    protected abstract boolean isActive();

    protected abstract void hideToolWindow();

    protected abstract void sideHidden();

    protected abstract void toolWindowTypeChanged(ToolWindowType var1);

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width, TabsUtil.getTabsHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        return new Dimension(size.width, TabsUtil.getTabsHeight());
    }

    private static String getToolTipTextByAction(AnAction action) {
        String text = KeymapUtil.createTooltipText((String)action.getTemplatePresentation().getText(), (AnAction)action);
        if (action instanceof HideAction) {
            text = text + String.format(" (Click with %s to Hide Side)", KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"pressed ALT")));
        }
        return text;
    }

    private abstract class HideAction
    extends AnAction
    implements DumbAware {
        @NonNls
        public static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";

        public HideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideActiveWindow"));
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/ToolWindowHeader$HideAction", "update"));
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(ToolWindowHeader.this.myInfo.isVisible());
        }
    }

    private abstract class HideSideAction
    extends AnAction
    implements DumbAware {
        @NonNls
        public static final String HIDE_ACTIVE_SIDE_WINDOW_ACTION_ID = "HideSideWindows";

        public HideSideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideSideWindows"));
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hideSide.action.name", (Object[])new Object[0]));
        }

        public abstract void actionPerformed(@NotNull AnActionEvent var1);

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/ToolWindowHeader$HideSideAction", "update"));
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(ToolWindowHeader.this.myInfo.isVisible());
        }
    }

    private class ActionButton
    extends Wrapper
    implements ActionListener,
    AltStateManager.AltListener {
        private final InplaceButton myButton;
        private final AnAction myAction;
        private final AnAction myAlternativeAction;
        private final Icon myActiveIcon;
        private final Icon myInactiveIcon;
        private final Icon myAlternativeIcon;
        private AnAction myCurrentAction;
        final /* synthetic */ ToolWindowHeader this$0;

        public ActionButton(final ToolWindowHeader toolWindowHeader, AnAction action, @NotNull AnAction alternativeAction, Icon activeIcon, Icon inactiveIcon, Icon alternativeIcon) {
            if (activeIcon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeIcon", "com/intellij/openapi/wm/impl/ToolWindowHeader$ActionButton", "<init>"));
            }
            this.this$0 = toolWindowHeader;
            this.myAction = action;
            this.myAlternativeAction = alternativeAction;
            this.myActiveIcon = activeIcon;
            this.myInactiveIcon = inactiveIcon;
            this.myAlternativeIcon = alternativeIcon;
            this.myCurrentAction = this.myAction;
            this.myButton = new InplaceButton(ToolWindowHeader.getToolTipTextByAction(action), EmptyIcon.ICON_16, this){

                public boolean isActive() {
                    return ActionButton.this.isActive();
                }
            };
            this.myButton.setHoveringEnabled(!SystemInfo.isMac);
            this.setContent((JComponent)this.myButton);
            this.setOpaque(false);
            this.setIcon(this.getActiveIcon(), this.getInactiveIcon() == null ? this.getActiveIcon() : this.getInactiveIcon(), this.getActiveHoveredIcon());
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ActionButton.this.myAlternativeAction == null) {
                        return;
                    }
                    if ("ancestor".equals(evt.getPropertyName())) {
                        if (evt.getNewValue() == null) {
                            AltStateManager.getInstance().removeListener(ActionButton.this);
                            ActionButton.this.switchAlternativeAction(false);
                        } else {
                            AltStateManager.getInstance().addListener(ActionButton.this);
                        }
                    }
                }
            };
            this.addPropertyChangeListener(listener);
        }

        public void updateTooltip() {
            this.myButton.setToolTipText(ToolWindowHeader.getToolTipTextByAction(this.myCurrentAction));
        }

        protected Icon getActiveIcon() {
            return this.myActiveIcon;
        }

        protected Icon getActiveHoveredIcon() {
            return this.myActiveIcon;
        }

        protected Icon getInactiveIcon() {
            return this.myInactiveIcon;
        }

        protected Icon getAlternativeIcon() {
            return this.myAlternativeIcon;
        }

        protected Icon getAlternativeHoveredIcon() {
            return this.myAlternativeIcon;
        }

        private void switchAlternativeAction(boolean b) {
            if (b && this.myCurrentAction == this.myAlternativeAction) {
                return;
            }
            if (!b && this.myCurrentAction != this.myAlternativeAction) {
                return;
            }
            this.setIcon(b ? this.getAlternativeIcon() : this.getActiveIcon(), b ? this.getAlternativeIcon() : (this.getInactiveIcon() == null ? this.getActiveIcon() : this.getInactiveIcon()), b ? this.getAlternativeHoveredIcon() : this.getActiveHoveredIcon());
            this.myCurrentAction = b ? this.myAlternativeAction : this.myAction;
            this.setToolTipText(ToolWindowHeader.getToolTipTextByAction(this.myCurrentAction));
            this.repaint();
        }

        public ActionButton(ToolWindowHeader toolWindowHeader, @NotNull AnAction action, Icon activeIcon, Icon inactiveIcon) {
            if (activeIcon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeIcon", "com/intellij/openapi/wm/impl/ToolWindowHeader$ActionButton", "<init>"));
            }
            this(toolWindowHeader, action, null, activeIcon, inactiveIcon, null);
        }

        public ActionButton(ToolWindowHeader toolWindowHeader, AnAction action, Icon activeIcon) {
            this(toolWindowHeader, action, activeIcon, activeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnAction action = this.myAlternativeAction != null && BitUtil.isSet((int)e.getModifiers(), (int)8) ? this.myAlternativeAction : this.myAction;
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            InputEvent inputEvent = e.getSource() instanceof InputEvent ? (InputEvent)e.getSource() : null;
            AnActionEvent event = new AnActionEvent(inputEvent, dataContext, "ToolwindowTitle", action.getTemplatePresentation(), ActionManager.getInstance(), 0);
            actionManager.fireBeforeActionPerformed(action, dataContext, event);
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component != null && !component.isShowing()) {
                return;
            }
            action.actionPerformed(event);
        }

        public boolean isActive() {
            return this.this$0.isActive();
        }

        public void setIcon(Icon active, Icon inactive, Icon hovered) {
            this.myButton.setIcons(active, inactive, hovered);
        }

        public void setToolTipText(String text) {
            this.myButton.setToolTipText(text);
        }

        @Override
        public void altPressed() {
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info != null) {
                Point p = info.getLocation();
                SwingUtilities.convertPointFromScreen(p, (Component)((Object)this));
                this.switchAlternativeAction(this.myButton.getBounds().contains(p));
            }
        }

        @Override
        public void altReleased() {
            this.switchAlternativeAction(false);
        }
    }
}

