/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HttpFileReferenceHelper
extends FileReferenceHelper {
    HttpFileReferenceHelper() {
    }

    @Override
    @Nullable
    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/HttpFileReferenceHelper", "findRoot"));
        }
        VirtualFile root = file;
        while ((parent = root.getParent()) != null) {
            root = parent;
        }
        return this.getPsiFileSystemItem(project, root);
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/HttpFileReferenceHelper", "getContexts"));
        }
        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file);
        Collection<Object> collection = item == null ? Collections.emptyList() : Collections.singleton(item);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/HttpFileReferenceHelper", "getContexts"));
        }
        return collection;
    }

    @Override
    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/HttpFileReferenceHelper", "isMine"));
        }
        return file instanceof HttpVirtualFile;
    }
}

