/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassUsageViewDescriptor;
import com.intellij.refactoring.inlineSuperClass.usageInfo.CopyDefaultConstructorUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.InlineSuperCallUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.RemoveImportUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.RemoveQualifierUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceConstructorUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceExtendsListUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceReferenceUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceStaticImportUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceWithSubtypeUsageInfo;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.memberPushDown.PushDownConflicts;
import com.intellij.refactoring.memberPushDown.PushDownProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineSuperClassRefactoringProcessor
extends FixableUsagesRefactoringProcessor {
    public static final Logger LOG = Logger.getInstance((String)("#" + InlineSuperClassRefactoringProcessor.class.getName()));
    private final PsiClass myCurrentInheritor;
    private final PsiClass mySuperClass;
    private final int myPolicy;
    private final PsiClass[] myTargetClasses;
    private final MemberInfo[] myMemberInfos;

    public InlineSuperClassRefactoringProcessor(Project project, PsiClass currentInheritor, PsiClass superClass, int policy, PsiClass ... targetClasses) {
        super(project);
        PsiClass[] psiClassArray;
        this.myCurrentInheritor = currentInheritor;
        this.mySuperClass = superClass;
        this.myPolicy = policy;
        if (currentInheritor != null) {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = currentInheritor;
        } else {
            psiClassArray = targetClasses;
        }
        this.myTargetClasses = psiClassArray;
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(this.mySuperClass, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                return !(element instanceof PsiClass) || PsiTreeUtil.isAncestor((PsiElement)InlineSuperClassRefactoringProcessor.this.mySuperClass, (PsiElement)element, (boolean)true);
            }
        });
        List members = memberInfoStorage.getClassMemberInfos(this.mySuperClass);
        for (MemberInfo member : members) {
            member.setChecked(true);
        }
        this.myMemberInfos = members.toArray(new MemberInfo[members.size()]);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor", "createUsageViewDescriptor"));
        }
        InlineSuperClassUsageViewDescriptor inlineSuperClassUsageViewDescriptor = new InlineSuperClassUsageViewDescriptor(this.mySuperClass);
        if (inlineSuperClassUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor", "createUsageViewDescriptor"));
        }
        return inlineSuperClassUsageViewDescriptor;
    }

    @Override
    protected void findUsages(final @NotNull List<FixableUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor", "findUsages"));
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        final PsiElementFactory elementFactory = facade.getElementFactory();
        final PsiResolveHelper resolveHelper = facade.getResolveHelper();
        ReferencesSearch.search((PsiElement)this.mySuperClass).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                if (element instanceof PsiJavaCodeReferenceElement) {
                    if (InlineSuperClassRefactoringProcessor.this.myCurrentInheritor != null) {
                        PsiClass inheritor;
                        PsiElement pparent;
                        PsiElement parent = element.getParent();
                        if (parent instanceof PsiReferenceList && (pparent = parent.getParent()) instanceof PsiClass && (parent.equals((inheritor = (PsiClass)pparent).getExtendsList()) || parent.equals(inheritor.getImplementsList())) && InlineSuperClassRefactoringProcessor.this.myCurrentInheritor.equals(inheritor)) {
                            usages.add(new ReplaceExtendsListUsageInfo((PsiJavaCodeReferenceElement)element, InlineSuperClassRefactoringProcessor.this.mySuperClass, inheritor));
                        }
                        return true;
                    }
                    PsiImportStaticStatement staticImportStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
                    if (staticImportStatement != null) {
                        usages.add(new ReplaceStaticImportUsageInfo(staticImportStatement, InlineSuperClassRefactoringProcessor.this.myTargetClasses));
                    } else {
                        PsiImportStatement importStatement = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class);
                        if (importStatement != null) {
                            usages.add(new RemoveImportUsageInfo(importStatement));
                        } else {
                            PsiElement parent = element.getParent();
                            if (parent instanceof PsiReferenceList) {
                                PsiClass inheritor;
                                PsiElement pparent = parent.getParent();
                                if (pparent instanceof PsiClass && (parent.equals((inheritor = (PsiClass)pparent).getExtendsList()) || parent.equals(inheritor.getImplementsList()))) {
                                    usages.add(new ReplaceExtendsListUsageInfo((PsiJavaCodeReferenceElement)element, InlineSuperClassRefactoringProcessor.this.mySuperClass, inheritor));
                                }
                            } else {
                                PsiClass targetClass = InlineSuperClassRefactoringProcessor.this.myTargetClasses[0];
                                PsiClassType targetClassType = elementFactory.createType(targetClass, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)InlineSuperClassRefactoringProcessor.this.mySuperClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                                if (parent instanceof PsiTypeElement) {
                                    PsiType superClassType = ((PsiTypeElement)parent).getType();
                                    PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                                    usages.add(new ReplaceWithSubtypeUsageInfo((PsiTypeElement)parent, elementFactory.createType(targetClass, subst), InlineSuperClassRefactoringProcessor.this.myTargetClasses));
                                } else if (parent instanceof PsiNewExpression) {
                                    PsiClassType newType = elementFactory.createType(targetClass, InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(((PsiNewExpression)parent).getType(), targetClassType, resolveHelper, targetClass));
                                    usages.add(new ReplaceConstructorUsageInfo((PsiNewExpression)parent, (PsiType)newType, InlineSuperClassRefactoringProcessor.this.myTargetClasses));
                                } else if (parent instanceof PsiJavaCodeReferenceElement) {
                                    usages.add(new ReplaceReferenceUsageInfo(((PsiJavaCodeReferenceElement)parent).getQualifier(), InlineSuperClassRefactoringProcessor.this.myTargetClasses));
                                }
                            }
                        }
                    }
                }
                return true;
            }
        });
        block0: for (PsiClass targetClass : this.myTargetClasses) {
            for (MemberInfo memberInfo : this.myMemberInfos) {
                PsiMember member = (PsiMember)memberInfo.getMember();
                for (PsiReference reference : ReferencesSearch.search((PsiElement)member, (SearchScope)member.getUseScope(), (boolean)true)) {
                    PsiElement element = reference.getElement();
                    if (!(element instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)element).getQualifierExpression() instanceof PsiSuperExpression) || !PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)element, (boolean)false)) continue;
                    usages.add(new RemoveQualifierUsageInfo((PsiReferenceExpression)element));
                }
            }
            PsiMethod[] superConstructors = this.mySuperClass.getConstructors();
            for (PsiMethod constructor : targetClass.getConstructors()) {
                PsiMethod superConstructor2;
                PsiReferenceExpression methodExpression;
                PsiExpression expression;
                PsiStatement firstConstrStatement;
                PsiCodeBlock constrBody = constructor.getBody();
                LOG.assertTrue(constrBody != null);
                PsiStatement[] statements = constrBody.getStatements();
                if (statements.length > 0 && (firstConstrStatement = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)firstConstrStatement).getExpression()) instanceof PsiMethodCallExpression && (methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression()).getText().equals("super") && (superConstructor2 = ((PsiMethodCallExpression)expression).resolveMethod()) != null && superConstructor2.getBody() != null) {
                    usages.add(new InlineSuperCallUsageInfo((PsiMethodCallExpression)expression));
                    continue;
                }
                for (PsiMethod superConstructor2 : superConstructors) {
                    if (superConstructor2.getParameterList().getParametersCount() != 0) continue;
                    PsiExpression expression2 = JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText("super()", (PsiElement)constructor);
                    usages.add(new InlineSuperCallUsageInfo((PsiMethodCallExpression)expression2, constrBody));
                }
            }
            if (targetClass.getConstructors().length != 0) continue;
            for (PsiMethod superConstructor : superConstructors) {
                if (superConstructor.getParameterList().getParametersCount() != 0) continue;
                usages.add(new CopyDefaultConstructorUsageInfo(targetClass, superConstructor));
                continue block0;
            }
        }
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor", "preprocessUsages"));
        }
        final MultiMap conflicts = new MultiMap();
        PushDownConflicts pushDownConflicts = new PushDownConflicts(this.mySuperClass, this.myMemberInfos);
        for (PsiClass targetClass : this.myTargetClasses) {
            for (MemberInfo info : this.myMemberInfos) {
                PsiMember member = (PsiMember)info.getMember();
                pushDownConflicts.checkMemberPlacementInTargetClassConflict(targetClass, member);
            }
        }
        MultiMap<PsiElement, String> conflictsMap = pushDownConflicts.getConflicts();
        for (PsiElement element : conflictsMap.keySet()) {
            conflicts.put((Object)element, conflictsMap.get((Object)element));
        }
        if (this.myCurrentInheritor != null) {
            ReferencesSearch.search((PsiElement)this.myCurrentInheritor).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiClass aClass;
                    PsiElement parent;
                    PsiElement element = reference.getElement();
                    if (element != null && (parent = element.getParent()) instanceof PsiNewExpression && (aClass = PsiUtil.resolveClassInType((PsiType)InlineSuperClassRefactoringProcessor.getPlaceExpectedType(parent))) == InlineSuperClassRefactoringProcessor.this.mySuperClass) {
                        conflicts.putValue((Object)parent, (Object)"Instance of target type is passed to a place where super class is expected.");
                        return false;
                    }
                    return true;
                }
            });
        }
        InlineSuperClassRefactoringProcessor.checkConflicts(refUsages, (MultiMap<PsiElement, String>)conflicts);
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
    }

    @Nullable
    private static PsiType getPlaceExpectedType(PsiElement parent) {
        PsiElement arg;
        PsiElement gParent;
        PsiType type = PsiTypesUtil.getExpectedTypeByParent((PsiExpression)((PsiExpression)parent));
        if (type == null && (gParent = (arg = PsiUtil.skipParenthesizedExprUp((PsiElement)parent)).getParent()) instanceof PsiExpressionList) {
            PsiMethod method;
            int i = ArrayUtilRt.find((Object[])((PsiExpressionList)gParent).getExpressions(), (Object)arg);
            PsiElement pParent = gParent.getParent();
            if (pParent instanceof PsiCallExpression && (method = ((PsiCallExpression)pParent).resolveMethod()) != null) {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (i >= parameters.length) {
                    if (method.isVarArgs()) {
                        return ((PsiEllipsisType)parameters[parameters.length - 1].getType()).getComponentType();
                    }
                } else {
                    return parameters[i].getType();
                }
            }
        }
        return type;
    }

    @Override
    protected void performRefactoring(final @NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor", "performRefactoring"));
        }
        new PushDownProcessor(this.mySuperClass.getProject(), this.myMemberInfos, this.mySuperClass, new DocCommentPolicy(this.myPolicy)){

            @Override
            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo[] usages2) {
                if (conflicts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor$4", "showConflicts"));
                }
                return true;
            }

            @Override
            protected void performRefactoring(@NotNull UsageInfo[] pushDownUsages) {
                if (pushDownUsages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushDownUsages", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor$4", "performRefactoring"));
                }
                if (InlineSuperClassRefactoringProcessor.this.myCurrentInheritor != null) {
                    this.encodeRefs();
                    this.pushDownToClass(InlineSuperClassRefactoringProcessor.this.myCurrentInheritor);
                } else {
                    super.performRefactoring(pushDownUsages);
                }
                CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
                for (UsageInfo usageInfo : usages) {
                    if (usageInfo instanceof ReplaceExtendsListUsageInfo || usageInfo instanceof RemoveImportUsageInfo) continue;
                    try {
                        ((FixableUsageInfo)usageInfo).fixUsage();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.info((Throwable)e);
                    }
                }
                InlineSuperClassRefactoringProcessor.this.replaceInnerTypeUsages();
                for (UsageInfo usage : usages) {
                    if (!(usage instanceof ReplaceExtendsListUsageInfo) && !(usage instanceof RemoveImportUsageInfo)) continue;
                    ((FixableUsageInfo)usage).fixUsage();
                }
                if (InlineSuperClassRefactoringProcessor.this.myCurrentInheritor == null) {
                    try {
                        InlineSuperClassRefactoringProcessor.this.mySuperClass.delete();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }.run();
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.mySuperClass);
        data.addElements((PsiElement[])this.myTargetClasses);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor", "getAfterData"));
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElements((PsiElement[])this.myTargetClasses);
        return data;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.inline.class";
    }

    private void replaceInnerTypeUsages() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiElementFactory elementFactory = facade.getElementFactory();
        final PsiResolveHelper resolveHelper = facade.getResolveHelper();
        HashMap replacementMap = new HashMap();
        for (final PsiClass targetClass : this.myTargetClasses) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.mySuperClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            final PsiClassType targetClassType = elementFactory.createType(targetClass, superClassSubstitutor);
            targetClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)replacementMap, elementFactory){
                final /* synthetic */ Map val$replacementMap;
                final /* synthetic */ PsiElementFactory val$elementFactory;
                {
                    this.val$replacementMap = map;
                    this.val$elementFactory = psiElementFactory;
                }

                public void visitTypeElement(PsiTypeElement typeElement) {
                    super.visitTypeElement(typeElement);
                    PsiType superClassType = typeElement.getType();
                    if (PsiUtil.resolveClassInType((PsiType)superClassType) == InlineSuperClassRefactoringProcessor.this.mySuperClass) {
                        PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                        this.val$replacementMap.put(new UsageInfo((PsiElement)typeElement), this.val$elementFactory.createTypeElement((PsiType)this.val$elementFactory.createType(targetClass, subst)));
                    }
                }

                public void visitNewExpression(PsiNewExpression expression) {
                    super.visitNewExpression(expression);
                    PsiType superClassType = expression.getType();
                    if (PsiUtil.resolveClassInType((PsiType)superClassType) == InlineSuperClassRefactoringProcessor.this.mySuperClass) {
                        PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                        try {
                            this.val$replacementMap.put(new UsageInfo((PsiElement)expression), this.val$elementFactory.createExpressionFromText("new " + this.val$elementFactory.createType(targetClass, subst).getCanonicalText() + expression.getArgumentList().getText(), (PsiElement)expression));
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            });
        }
        try {
            for (Map.Entry entry : replacementMap.entrySet()) {
                PsiElement element = ((UsageInfo)entry.getKey()).getElement();
                if (element == null) continue;
                element.replace((PsiElement)entry.getValue());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiSubstitutor getSuperClassSubstitutor(PsiType superClassType, PsiClassType targetClassType, PsiResolveHelper resolveHelper, PsiClass targetClass) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass)) {
            subst = subst.put(typeParameter, resolveHelper.getSubstitutionForTypeParameter(typeParameter, (PsiType)targetClassType, superClassType, false, PsiUtil.getLanguageLevel((PsiElement)targetClass)));
        }
        return subst;
    }

    @Override
    protected String getCommandName() {
        return "Inline Super Class";
    }
}

