/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.PackageLocalsUsageCollector;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MoveClassToInnerProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerProcessor");
    public static final Key<List<NonCodeUsageInfo>> ourNonCodeUsageKey = Key.create((String)"MoveClassToInner.NonCodeUsage");
    private PsiClass[] myClassesToMove;
    private final PsiClass myTargetClass;
    private PsiPackage[] mySourcePackage;
    private final PsiPackage myTargetPackage;
    private String[] mySourceVisibility;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final MoveCallback myMoveCallback;
    private boolean myOpenInEditor;

    public MoveClassToInnerProcessor(Project project, PsiClass[] classesToMove, @NotNull PsiClass targetClass, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "<init>"));
        }
        super(project);
        this.setClassesToMove(classesToMove);
        this.myTargetClass = targetClass;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
        this.myTargetPackage = JavaDirectoryService.getInstance().getPackage(this.myTargetClass.getContainingFile().getContainingDirectory());
    }

    private void setClassesToMove(PsiClass[] classesToMove) {
        this.myClassesToMove = classesToMove;
        this.mySourcePackage = new PsiPackage[classesToMove.length];
        this.mySourceVisibility = new String[classesToMove.length];
        for (int i = 0; i < classesToMove.length; ++i) {
            PsiClass psiClass = classesToMove[i];
            this.mySourceVisibility[i] = VisibilityUtil.getVisibilityModifier((PsiModifierList)psiClass.getModifierList());
            this.mySourcePackage[i] = JavaDirectoryService.getInstance().getPackage(psiClass.getContainingFile().getContainingDirectory());
        }
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "createUsageViewDescriptor"));
        }
        MoveMultipleElementsViewDescriptor moveMultipleElementsViewDescriptor = new MoveMultipleElementsViewDescriptor((PsiElement[])this.myClassesToMove, this.myTargetClass.getQualifiedName());
        if (moveMultipleElementsViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "createUsageViewDescriptor"));
        }
        return moveMultipleElementsViewDescriptor;
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        ArrayList usages = new ArrayList();
        for (PsiClass classToMove : this.myClassesToMove) {
            String newName = this.myTargetClass.getQualifiedName() + "." + classToMove.getName();
            Collections.addAll(usages, MoveClassesOrPackagesUtil.findUsages((PsiElement)classToMove, this.mySearchInComments, this.mySearchInNonJavaFiles, newName));
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "preprocessUsages"));
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        return this.showConflicts(this.getConflicts(usages), usages);
    }

    @Override
    protected void refreshElements(final @NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "refreshElements"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass[] classesToMove = new PsiClass[elements.length];
                for (int i = 0; i < classesToMove.length; ++i) {
                    classesToMove[i] = (PsiClass)elements[i];
                }
                MoveClassToInnerProcessor.this.setClassesToMove(classesToMove);
            }
        });
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "performRefactoring"));
        }
        if (!this.prepareWritable(usages)) {
            return;
        }
        MoveClassToInnerHandler[] handlers = (MoveClassToInnerHandler[])MoveClassToInnerHandler.EP_NAME.getExtensions();
        ArrayList<UsageInfo> usageList = new ArrayList<UsageInfo>(Arrays.asList(usages));
        ArrayList<PsiElement> importStatements = new ArrayList<PsiElement>();
        for (MoveClassToInnerHandler handler : handlers) {
            importStatements.addAll(handler.filterImports(usageList, this.myProject));
        }
        usages = usageList.toArray(new UsageInfo[usageList.size()]);
        this.saveNonCodeUsages(usages);
        HashMap<PsiElement, PsiElement> oldToNewElementsMapping = new HashMap<PsiElement, PsiElement>();
        try {
            PsiElement item;
            for (PsiClass psiClass : this.myClassesToMove) {
                MoveClassToInnerHandler handler;
                PsiClass newClass = null;
                MoveClassToInnerHandler[] moveClassToInnerHandlerArray = handlers;
                int n = moveClassToInnerHandlerArray.length;
                for (int i = 0; i < n && (newClass = (handler = moveClassToInnerHandlerArray[i]).moveClass(psiClass, this.myTargetClass)) == null; ++i) {
                }
                LOG.assertTrue(newClass != null, (Object)("There is no appropriate MoveClassToInnerHandler for " + this.myTargetClass + "; " + psiClass));
                oldToNewElementsMapping.put((PsiElement)psiClass, (PsiElement)newClass);
            }
            this.myNonCodeUsages = CommonMoveUtil.retargetUsages(usages, oldToNewElementsMapping);
            for (PsiClass psiClass : handlers) {
                psiClass.retargetNonCodeUsages(oldToNewElementsMapping, this.myNonCodeUsages);
            }
            for (PsiClass psiClass : handlers) {
                psiClass.retargetClassRefsInMoved(oldToNewElementsMapping);
            }
            for (PsiClass psiClass : handlers) {
                psiClass.removeRedundantImports(this.myTargetClass.getContainingFile());
            }
            for (PsiClass psiClass : this.myClassesToMove) {
                psiClass.delete();
            }
            for (PsiElement element : importStatements) {
                if (!element.isValid()) continue;
                element.delete();
            }
            if (this.myOpenInEditor && !oldToNewElementsMapping.isEmpty() && (item = (PsiElement)ContainerUtil.getFirstItem(oldToNewElementsMapping.values())) != null) {
                EditorHelper.openInEditor(item);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean prepareWritable(UsageInfo[] usages) {
        HashSet<Object> elementsToMakeWritable = new HashSet<Object>();
        Collections.addAll(elementsToMakeWritable, this.myClassesToMove);
        elementsToMakeWritable.add(this.myTargetClass);
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            elementsToMakeWritable.add(element);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement[])PsiUtilCore.toPsiElementArray(elementsToMakeWritable));
    }

    private void saveNonCodeUsages(UsageInfo[] usages) {
        for (PsiClass classToMove : this.myClassesToMove) {
            for (UsageInfo usageInfo : usages) {
                NonCodeUsageInfo nonCodeUsage;
                PsiElement element;
                if (!(usageInfo instanceof NonCodeUsageInfo) || (element = (nonCodeUsage = (NonCodeUsageInfo)usageInfo).getElement()) == null || !PsiTreeUtil.isAncestor((PsiElement)classToMove, (PsiElement)element, (boolean)false)) continue;
                ArrayList<NonCodeUsageInfo> list = (ArrayList<NonCodeUsageInfo>)element.getCopyableUserData(ourNonCodeUsageKey);
                if (list == null) {
                    list = new ArrayList<NonCodeUsageInfo>();
                    element.putCopyableUserData(ourNonCodeUsageKey, list);
                }
                list.add(nonCodeUsage);
            }
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
        if (this.myMoveCallback != null) {
            if (this.myMoveCallback instanceof MoveClassesOrPackagesCallback) {
                ((MoveClassesOrPackagesCallback)this.myMoveCallback).classesMovedToInner(this.myTargetClass);
            }
            this.myMoveCallback.refactoringCompleted();
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.class.to.inner.command.name", (Object[])new Object[]{(this.myClassesToMove.length > 1 ? "classes " : "class ") + StringUtil.join((Object[])this.myClassesToMove, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass psiClass) {
                return psiClass.getName();
            }
        }, (String)", "), this.myTargetClass.getQualifiedName()});
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "getElementsToWrite"));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(super.getElementsToWrite(descriptor));
        result.add(this.myTargetClass);
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor", "getElementsToWrite"));
        }
        return arrayList;
    }

    public MultiMap<PsiElement, String> getConflicts(UsageInfo[] usages) {
        MultiMap conflicts = new MultiMap();
        for (PsiClass classToMove : this.myClassesToMove) {
            PsiClass innerClass = this.myTargetClass.findInnerClassByName(classToMove.getName(), false);
            if (innerClass == null) continue;
            conflicts.putValue((Object)innerClass, (Object)RefactoringBundle.message((String)"move.to.inner.duplicate.inner.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)this.myTargetClass.getQualifiedName()), CommonRefactoringUtil.htmlEmphasize((String)classToMove.getName())}));
        }
        for (int i = 0; i < this.myClassesToMove.length; ++i) {
            boolean moveToOtherPackage;
            PsiClass classToMove = this.myClassesToMove[i];
            String classToMoveVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)classToMove.getModifierList());
            String targetClassVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myTargetClass.getModifierList());
            boolean bl = moveToOtherPackage = !Comparing.equal((Object)this.mySourcePackage[i], (Object)this.myTargetPackage);
            if (moveToOtherPackage) {
                classToMove.accept((PsiElementVisitor)new PackageLocalsUsageCollector((PsiElement[])this.myClassesToMove, new PackageWrapper(this.myTargetPackage), (MultiMap<PsiElement, String>)conflicts));
            }
            ConflictsCollector collector = new ConflictsCollector(classToMove, (MultiMap<PsiElement, String>)conflicts);
            if (moveToOtherPackage && (classToMoveVisibility.equals("packageLocal") || targetClassVisibility.equals("packageLocal")) || targetClassVisibility.equals("private")) {
                this.detectInaccessibleClassUsages(usages, collector, this.mySourceVisibility[i]);
            }
            if (!moveToOtherPackage) continue;
            this.detectInaccessibleMemberUsages(collector);
        }
        return conflicts;
    }

    private void detectInaccessibleClassUsages(UsageInfo[] usages, ConflictsCollector collector, String visibility) {
        for (UsageInfo usage : usages) {
            PsiElement element;
            if (!(usage instanceof MoveRenameUsageInfo) || usage instanceof NonCodeUsageInfo || (element = usage.getElement()) == null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null || !this.isInaccessibleFromTarget(element, visibility)) continue;
            collector.addConflict(collector.getClassToMove(), element);
        }
    }

    private boolean isInaccessibleFromTarget(PsiElement element, String visibility) {
        PsiPackage elementPackage = JavaDirectoryService.getInstance().getPackage(element.getContainingFile().getContainingDirectory());
        return !PsiUtil.isAccessible((PsiMember)this.myTargetClass, (PsiElement)element, null) || !this.myTargetClass.isInterface() && visibility.equals("packageLocal") && !Comparing.equal((Object)elementPackage, (Object)this.myTargetPackage);
    }

    private void detectInaccessibleMemberUsages(final ConflictsCollector collector) {
        PsiElement[] members;
        for (PsiElement member : members = MoveClassToInnerProcessor.collectPackageLocalMembers(collector.getClassToMove())) {
            ReferencesSearch.search((PsiElement)member).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    PsiElement element = psiReference.getElement();
                    for (PsiClass psiClass : MoveClassToInnerProcessor.this.myClassesToMove) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)psiClass, (PsiElement)element, (boolean)false)) continue;
                        return true;
                    }
                    if (MoveClassToInnerProcessor.this.isInaccessibleFromTarget(element, "packageLocal")) {
                        collector.addConflict(psiReference.resolve(), element);
                    }
                    return true;
                }
            });
        }
    }

    private static PsiElement[] collectPackageLocalMembers(PsiElement classToMove) {
        return PsiTreeUtil.collectElements((PsiElement)classToMove, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                PsiMember member;
                return element instanceof PsiMember && VisibilityUtil.getVisibilityModifier((PsiModifierList)(member = (PsiMember)element).getModifierList()) == "packageLocal";
            }
        });
    }

    public void setOpenInEditor(boolean openInEditor) {
        this.myOpenInEditor = openInEditor;
    }

    private static class ConflictsCollector {
        private final PsiClass myClassToMove;
        private final MultiMap<PsiElement, String> myConflicts;
        private final Set<PsiElement> myReportedContainers = new HashSet<PsiElement>();

        public ConflictsCollector(PsiClass classToMove, MultiMap<PsiElement, String> conflicts) {
            this.myClassToMove = classToMove;
            this.myConflicts = conflicts;
        }

        public synchronized void addConflict(PsiElement targetElement, PsiElement sourceElement) {
            PsiElement container = ConflictsUtil.getContainer(sourceElement);
            if (!this.myReportedContainers.contains(container)) {
                this.myReportedContainers.add(container);
                String targetDescription = targetElement == this.myClassToMove ? "Class " + CommonRefactoringUtil.htmlEmphasize((String)this.myClassToMove.getName()) : StringUtil.capitalize((String)RefactoringUIUtil.getDescription(targetElement, true));
                String message = RefactoringBundle.message((String)"element.will.no.longer.be.accessible", (Object[])new Object[]{targetDescription, RefactoringUIUtil.getDescription(container, true)});
                this.myConflicts.putValue((Object)targetElement, (Object)message);
            }
        }

        public PsiElement getClassToMove() {
            return this.myClassToMove;
        }
    }
}

