/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VagrantSupport {
    @Nullable
    public static VagrantSupport getInstance() {
        return (VagrantSupport)ServiceManager.getService(VagrantSupport.class);
    }

    public abstract ListenableFuture<RemoteCredentials> computeVagrantSettings(@Nullable Project var1, @NotNull String var2, @Nullable String var3);

    public static void showMissingVagrantSupportMessage(final @Nullable Project project) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)project, (String)"Enable Vagrant Support plugin", (String)"Vagrant Support Disabled");
            }
        });
    }

    @NotNull
    public abstract RemoteCredentials getCredentials(@NotNull String var1, @Nullable String var2) throws IOException;

    public abstract boolean checkVagrantRunning(@NotNull String var1, @Nullable String var2, boolean var3);

    public abstract void runVagrant(@NotNull String var1, @Nullable String var2) throws ExecutionException;

    public abstract Collection<? extends RemoteConnector> getVagrantInstancesConnectors(@NotNull Project var1);

    public abstract boolean isVagrantInstance(VirtualFile var1);

    public abstract List<String> getMachineNames(@NotNull String var1);

    public boolean isNotReadyForSsh(Throwable t) {
        return t.getMessage().contains("not yet ready for SSH");
    }

    public static class MultipleMachinesException
    extends Exception {
    }
}

