/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.LanguageTestCreators;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTestOrCodeHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.testOrCode";
    }

    @Override
    @Nullable
    protected GotoTargetHandler.GotoData getSourceAndTargetElements(final Editor editor, final PsiFile file) {
        List<PsiElement> candidates;
        PsiElement selectedElement = GotoTestOrCodeHandler.getSelectedElement(editor, file);
        PsiElement sourceElement = TestFinderHelper.findSourceElement(selectedElement);
        if (sourceElement == null) {
            return null;
        }
        SmartList actions2 = new SmartList();
        if (TestFinderHelper.isTest(selectedElement)) {
            candidates = TestFinderHelper.findClassesForTest(selectedElement);
        } else {
            candidates = TestFinderHelper.findTestsForClass(selectedElement);
            final TestCreator creator = (TestCreator)LanguageTestCreators.INSTANCE.forLanguage(file.getLanguage());
            if (creator != null && creator.isAvailable(file.getProject(), editor, file)) {
                actions2.add(new GotoTargetHandler.AdditionalAction(){

                    @Override
                    @NotNull
                    public String getText() {
                        if ("Create New Test..." == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler$1", "getText"));
                        }
                        return "Create New Test...";
                    }

                    @Override
                    public Icon getIcon() {
                        return AllIcons.Actions.IntentionBulb;
                    }

                    @Override
                    public void execute() {
                        creator.createTest(file.getProject(), editor, file);
                    }
                });
            }
        }
        return new GotoTargetHandler.GotoData(sourceElement, PsiUtilCore.toPsiElementArray(candidates), (List<GotoTargetHandler.AdditionalAction>)actions2);
    }

    @NotNull
    public static PsiElement getSelectedElement(Editor editor, PsiFile file) {
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getSelectedElement"));
        }
        return psiElement;
    }

    @Override
    protected boolean shouldSortTargets() {
        return false;
    }

    @Override
    @NotNull
    protected String getChooserTitle(PsiElement sourceElement, String name, int length) {
        if (TestFinderHelper.isTest(sourceElement)) {
            String string = CodeInsightBundle.message((String)"goto.test.chooserTitle.subject", (Object[])new Object[]{name, length});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getChooserTitle"));
            }
            return string;
        }
        String string = CodeInsightBundle.message((String)"goto.test.chooserTitle.test", (Object[])new Object[]{name, length});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getChooserTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(PsiElement sourceElement, String name, int length) {
        if (TestFinderHelper.isTest(sourceElement)) {
            String string = CodeInsightBundle.message((String)"goto.test.findUsages.subject.title", (Object[])new Object[]{name});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getFindUsagesTitle"));
            }
            return string;
        }
        String string = CodeInsightBundle.message((String)"goto.test.findUsages.test.title", (Object[])new Object[]{name});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getFindUsagesTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getNotFoundMessage"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getNotFoundMessage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getNotFoundMessage"));
        }
        String string = CodeInsightBundle.message((String)"goto.test.notFound", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getNotFoundMessage"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getAdText(PsiElement source, int length) {
        Keymap keymap;
        Shortcut[] shortcuts;
        if (length > 0 && !TestFinderHelper.isTest(source) && (shortcuts = (keymap = KeymapManager.getInstance().getActiveKeymap()).getShortcuts(DefaultRunExecutor.getRunExecutorInstance().getContextActionId())).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to run selected tests";
        }
        return null;
    }

    @Override
    protected void navigateToElement(Navigatable element) {
        if (element instanceof PsiElement) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element, true);
        } else {
            element.navigate(true);
        }
    }
}

