/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public abstract class CardLayoutPanel<K, UI, V extends Component>
extends JComponent {
    private final IdentityHashMap<K, V> myContent = new IdentityHashMap();
    private K myKey;

    protected abstract UI prepare(K var1);

    protected abstract V create(UI var1);

    protected void dispose(K key) {
    }

    public K getKey() {
        return this.myKey;
    }

    public V getValue(K key, boolean create) {
        Component value = (Component)this.myContent.get(key);
        return (V)(create && value == null && !this.myContent.containsKey(key) ? this.createValue(key, this.prepare(key)) : value);
    }

    private V createValue(K key, UI ui) {
        V value = this.create(ui);
        this.myContent.put(key, value);
        if (value != null) {
            ((Component)value).setVisible(false);
            this.add((Component)value);
        }
        return value;
    }

    public ActionCallback select(K key, boolean now) {
        this.myKey = key;
        ActionCallback callback = new ActionCallback();
        if (now) {
            this.select(callback, key, this.prepare(key));
        } else {
            this.selectLater(callback, key);
        }
        return callback;
    }

    private void select(ActionCallback callback, K key, UI ui) {
        if (this.myKey != key) {
            callback.setRejected();
        } else {
            Component value = (Component)this.myContent.get(key);
            if (value == null && !this.myContent.containsKey(key)) {
                value = this.createValue(key, ui);
            }
            for (Component component : this.getComponents()) {
                component.setVisible(component == value);
            }
            callback.setDone();
        }
    }

    private void selectLater(final ActionCallback callback, final K key) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final Object ui = CardLayoutPanel.this.prepare(key);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CardLayoutPanel.this.select(callback, key, ui);
                    }
                }, ModalityState.any());
            }
        });
    }

    @Override
    public void doLayout() {
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        for (Component component : this.getComponents()) {
            component.setBounds(bounds);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return component.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return component.getMinimumSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public void remove(int index) {
        super.remove(index);
        Iterator<Map.Entry<K, V>> it = this.myContent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            Component value = (Component)entry.getValue();
            if (value == null || this == value.getParent()) continue;
            this.dispose(entry.getKey());
            it.remove();
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        for (K key : this.myContent.keySet()) {
            this.dispose(key);
        }
        this.myContent.clear();
    }
}

