/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileContainerImpl
extends SimpleModificationTracker
implements ConfigFileContainer {
    private final Project myProject;
    private final EventDispatcher<ConfigFileListener> myDispatcher = EventDispatcher.create(ConfigFileListener.class);
    private final MultiValuesMap<ConfigFileMetaData, ConfigFile> myConfigFiles = new MultiValuesMap();
    private ConfigFile[] myCachedConfigFiles;
    private final ConfigFileMetaDataProvider myMetaDataProvider;
    private final ConfigFileInfoSetImpl myConfiguration;

    public ConfigFileContainerImpl(Project project, ConfigFileMetaDataProvider descriptorMetaDataProvider, ConfigFileInfoSetImpl configuration) {
        this.myConfiguration = configuration;
        this.myMetaDataProvider = descriptorMetaDataProvider;
        this.myProject = project;
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/descriptors/impl/ConfigFileContainerImpl$1", "propertyChanged"));
                }
                if (event.getPropertyName().equals("name")) {
                    ConfigFileContainerImpl.this.fileChanged(event.getFile());
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/descriptors/impl/ConfigFileContainerImpl$1", "fileMoved"));
                }
                ConfigFileContainerImpl.this.fileChanged(event.getFile());
            }
        }, (Disposable)this);
        this.myConfiguration.setContainer(this);
    }

    private void fileChanged(VirtualFile file) {
        for (ConfigFile descriptor : this.myConfigFiles.values()) {
            VirtualFile virtualFile = descriptor.getVirtualFile();
            if (virtualFile == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)virtualFile, (boolean)false)) continue;
            this.myConfiguration.updateConfigFile(descriptor);
            this.fireDescriptorChanged(descriptor);
        }
    }

    @Nullable
    public ConfigFile getConfigFile(ConfigFileMetaData metaData) {
        Collection descriptors = this.myConfigFiles.get((Object)metaData);
        if (descriptors == null || descriptors.isEmpty()) {
            return null;
        }
        return (ConfigFile)descriptors.iterator().next();
    }

    public ConfigFile[] getConfigFiles() {
        if (this.myCachedConfigFiles == null) {
            Collection descriptors = this.myConfigFiles.values();
            this.myCachedConfigFiles = descriptors.toArray(new ConfigFile[descriptors.size()]);
        }
        return this.myCachedConfigFiles;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void addListener(ConfigFileListener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void fireDescriptorChanged(ConfigFile descriptor) {
        this.incModificationCount();
        ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileChanged(descriptor);
    }

    public ConfigFileInfoSet getConfiguration() {
        return this.myConfiguration;
    }

    public void dispose() {
    }

    public void addListener(ConfigFileListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(ConfigFileListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.myMetaDataProvider;
    }

    public void updateDescriptors(MultiValuesMap<ConfigFileMetaData, ConfigFileInfo> descriptorsMap) {
        HashSet toDelete = new HashSet(this.myConfigFiles.values());
        HashSet<ConfigFileImpl> added = new HashSet<ConfigFileImpl>();
        for (Map.Entry entry : descriptorsMap.entrySet()) {
            ConfigFileMetaData metaData = (ConfigFileMetaData)entry.getKey();
            HashSet newDescriptors = new HashSet((Collection)entry.getValue());
            Collection oldDescriptors = this.myConfigFiles.get((Object)metaData);
            if (oldDescriptors != null) {
                for (ConfigFile descriptor : oldDescriptors) {
                    if (!newDescriptors.contains(descriptor.getInfo())) continue;
                    newDescriptors.remove(descriptor.getInfo());
                    toDelete.remove(descriptor);
                }
            }
            for (ConfigFileInfo configuration : newDescriptors) {
                ConfigFileImpl configFile = new ConfigFileImpl(this, configuration);
                Disposer.register((Disposable)this, (Disposable)configFile);
                this.myConfigFiles.put((Object)metaData, (Object)configFile);
                added.add(configFile);
            }
        }
        for (ConfigFile configFile : toDelete) {
            this.myConfigFiles.remove((Object)configFile.getMetaData(), (Object)configFile);
            Disposer.dispose((Disposable)configFile);
        }
        this.myCachedConfigFiles = null;
        for (ConfigFile configFile : added) {
            this.incModificationCount();
            ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileAdded(configFile);
        }
        for (ConfigFile configFile : toDelete) {
            this.incModificationCount();
            ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileRemoved(configFile);
        }
    }
}

