/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwingHelper {
    private static final Logger LOG = Logger.getInstance(SwingHelper.class);

    @NotNull
    public static JPanel newVerticalPanel(float childAlignmentX, Component ... children) {
        JPanel jPanel = SwingHelper.newGenericBoxPanel(true, childAlignmentX, children);
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "newVerticalPanel"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newLeftAlignedVerticalPanel(Component ... children) {
        JPanel jPanel = SwingHelper.newVerticalPanel(0.0f, children);
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "newLeftAlignedVerticalPanel"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newLeftAlignedVerticalPanel(@NotNull Collection<Component> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/util/ui/SwingHelper", "newLeftAlignedVerticalPanel"));
        }
        JPanel jPanel = SwingHelper.newVerticalPanel(0.0f, children);
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "newLeftAlignedVerticalPanel"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newVerticalPanel(float childAlignmentX, @NotNull Collection<Component> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/util/ui/SwingHelper", "newVerticalPanel"));
        }
        JPanel jPanel = SwingHelper.newVerticalPanel(childAlignmentX, children.toArray(new Component[children.size()]));
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "newVerticalPanel"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newHorizontalPanel(float childAlignmentY, Component ... children) {
        JPanel jPanel = SwingHelper.newGenericBoxPanel(false, childAlignmentY, children);
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "newHorizontalPanel"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newHorizontalPanel(float childAlignmentY, @NotNull Collection<Component> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/util/ui/SwingHelper", "newHorizontalPanel"));
        }
        JPanel jPanel = SwingHelper.newHorizontalPanel(childAlignmentY, children.toArray(new Component[children.size()]));
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "newHorizontalPanel"));
        }
        return jPanel;
    }

    private static JPanel newGenericBoxPanel(boolean verticalOrientation, float childAlignment, Component ... children) {
        JPanel panel = new JPanel();
        int axis = verticalOrientation ? 1 : 0;
        panel.setLayout(new BoxLayout(panel, axis));
        for (Component child : children) {
            panel.add(child, Float.valueOf(childAlignment));
            if (!(child instanceof JComponent)) continue;
            JComponent jChild = (JComponent)child;
            if (verticalOrientation) {
                jChild.setAlignmentX(childAlignment);
                continue;
            }
            jChild.setAlignmentY(childAlignment);
        }
        return panel;
    }

    @NotNull
    public static JPanel wrapWithoutStretch(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/SwingHelper", "wrapWithoutStretch"));
        }
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(component);
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "wrapWithoutStretch"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel wrapWithHorizontalStretch(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/SwingHelper", "wrapWithHorizontalStretch"));
        }
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)component, "North");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "wrapWithHorizontalStretch"));
        }
        return jPanel;
    }

    public static void setPreferredWidthToFitText(@NotNull TextFieldWithHistoryWithBrowseButton component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/SwingHelper", "setPreferredWidthToFitText"));
        }
        int childWidth = SwingHelper.calcWidthToFitText(((TextFieldWithHistory)component.getChildComponent()).getTextEditor(), 35);
        SwingHelper.setPreferredWidthForComponentWithBrowseButton(component, childWidth);
    }

    public static void setPreferredWidthToFitText(@NotNull TextFieldWithBrowseButton component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/SwingHelper", "setPreferredWidthToFitText"));
        }
        int childWidth = SwingHelper.calcWidthToFitText((JTextField)component.getChildComponent(), 20);
        SwingHelper.setPreferredWidthForComponentWithBrowseButton(component, childWidth);
    }

    private static <T extends JComponent> void setPreferredWidthForComponentWithBrowseButton(@NotNull ComponentWithBrowseButton<T> component, int childPrefWidth) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/SwingHelper", "setPreferredWidthForComponentWithBrowseButton"));
        }
        Dimension buttonPrefSize = component.getButton().getPreferredSize();
        SwingHelper.setPreferredWidth(component, childPrefWidth + buttonPrefSize.width);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/util/ui/SwingHelper", "setPreferredWidthToFitText"));
        }
        SwingHelper.setPreferredWidthToFitText(textField, 15);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField, int additionalWidth) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/util/ui/SwingHelper", "setPreferredWidthToFitText"));
        }
        SwingHelper.setPreferredSizeToFitText(textField, StringUtil.notNullize((String)textField.getText()), additionalWidth);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField, @NotNull String text) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/util/ui/SwingHelper", "setPreferredWidthToFitText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/ui/SwingHelper", "setPreferredWidthToFitText"));
        }
        SwingHelper.setPreferredSizeToFitText(textField, text, 15);
    }

    private static void setPreferredSizeToFitText(@NotNull JTextField textField, @NotNull String text, int additionalWidth) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/util/ui/SwingHelper", "setPreferredSizeToFitText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/ui/SwingHelper", "setPreferredSizeToFitText"));
        }
        int width = SwingHelper.calcWidthToFitText(textField, text, additionalWidth);
        SwingHelper.setPreferredWidth(textField, width);
    }

    private static int calcWidthToFitText(@NotNull JTextField textField, int additionalWidth) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/util/ui/SwingHelper", "calcWidthToFitText"));
        }
        return SwingHelper.calcWidthToFitText(textField, textField.getText(), additionalWidth);
    }

    private static int calcWidthToFitText(@NotNull JTextField textField, @NotNull String text, int additionalWidth) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/util/ui/SwingHelper", "calcWidthToFitText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/ui/SwingHelper", "calcWidthToFitText"));
        }
        return textField.getFontMetrics(textField.getFont()).stringWidth(text) + additionalWidth;
    }

    public static void adjustDialogSizeToFitPreferredSize(@NotNull DialogWrapper dialogWrapper) {
        if (dialogWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialogWrapper", "com/intellij/util/ui/SwingHelper", "adjustDialogSizeToFitPreferredSize"));
        }
        JRootPane rootPane = dialogWrapper.getRootPane();
        Dimension componentSize = rootPane.getSize();
        Dimension componentPreferredSize = rootPane.getPreferredSize();
        if (componentPreferredSize.width <= componentSize.width && componentPreferredSize.height <= componentSize.height) {
            return;
        }
        int dw = Math.max(0, componentPreferredSize.width - componentSize.width);
        int dh = Math.max(0, componentPreferredSize.height - componentSize.height);
        Dimension oldDialogSize = dialogWrapper.getSize();
        Dimension newDialogSize = new Dimension(oldDialogSize.width + dw, oldDialogSize.height + dh);
        dialogWrapper.setSize(newDialogSize.width, newDialogSize.height);
        rootPane.revalidate();
        rootPane.repaint();
        LOG.info("DialogWrapper '" + dialogWrapper.getTitle() + "' has been re-sized (added width: " + dw + ", added height: " + dh + ")");
    }

    public static <T> void updateItems(@NotNull JComboBox comboBox, @NotNull List<T> newItems, @Nullable T newSelectedItemIfSelectionCannotBePreserved) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/util/ui/SwingHelper", "updateItems"));
        }
        if (newItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItems", "com/intellij/util/ui/SwingHelper", "updateItems"));
        }
        if (!SwingHelper.shouldUpdate(comboBox, newItems)) {
            return;
        }
        Object selectedItem = comboBox.getSelectedItem();
        if (selectedItem != null && !newItems.contains(selectedItem)) {
            selectedItem = null;
        }
        if (selectedItem == null && newItems.contains(newSelectedItemIfSelectionCannotBePreserved)) {
            selectedItem = newSelectedItemIfSelectionCannotBePreserved;
        }
        comboBox.removeAllItems();
        for (T newItem : newItems) {
            comboBox.addItem(newItem);
        }
        if (selectedItem != null) {
            int count = comboBox.getItemCount();
            for (int i = 0; i < count; ++i) {
                Object item = comboBox.getItemAt(i);
                if (!selectedItem.equals(item)) continue;
                comboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    private static <T> boolean shouldUpdate(@NotNull JComboBox comboBox, @NotNull List<T> newItems) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/util/ui/SwingHelper", "shouldUpdate"));
        }
        if (newItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItems", "com/intellij/util/ui/SwingHelper", "shouldUpdate"));
        }
        int count = comboBox.getItemCount();
        if (newItems.size() != count) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            T newItem;
            Object oldItem = comboBox.getItemAt(i);
            if (ComparatorUtil.equalsNullable(oldItem, newItem = newItems.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void setNoBorderCellRendererFor(@NotNull TableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/util/ui/SwingHelper", "setNoBorderCellRendererFor"));
        }
        final TableCellRenderer previous = column.getCellRenderer();
        column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = previous != null ? previous.getTableCellRendererComponent(table, value, isSelected, false, row, column) : super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(null);
                }
                return component;
            }
        });
    }

    public static void addHistoryOnExpansion(final @NotNull TextFieldWithHistory textFieldWithHistory, final @NotNull NotNullProducer<List<String>> historyProvider) {
        if (textFieldWithHistory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithHistory", "com/intellij/util/ui/SwingHelper", "addHistoryOnExpansion"));
        }
        if (historyProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyProvider", "com/intellij/util/ui/SwingHelper", "addHistoryOnExpansion"));
        }
        textFieldWithHistory.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                List history = (List)historyProvider.produce();
                SwingHelper.setHistory(textFieldWithHistory, ContainerUtil.notNullize((List)history), true);
                textFieldWithHistory.removePopupMenuListener((PopupMenuListener)this);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public static void setHistory(@NotNull TextFieldWithHistory textFieldWithHistory, @NotNull List<String> history, boolean mergeWithPrevHistory) {
        if (textFieldWithHistory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithHistory", "com/intellij/util/ui/SwingHelper", "setHistory"));
        }
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "com/intellij/util/ui/SwingHelper", "setHistory"));
        }
        HashSet newHistorySet = ContainerUtil.newHashSet(history);
        List prevHistory = textFieldWithHistory.getHistory();
        ArrayList mergedHistory = ContainerUtil.newArrayList();
        if (mergeWithPrevHistory) {
            for (String item : prevHistory) {
                if (newHistorySet.contains(item)) continue;
                mergedHistory.add(item);
            }
        } else {
            String currentText = textFieldWithHistory.getText();
            if (StringUtil.isNotEmpty((String)currentText) && !newHistorySet.contains(currentText)) {
                mergedHistory.add(currentText);
            }
        }
        mergedHistory.addAll(history);
        textFieldWithHistory.setHistory((List)mergedHistory);
        SwingHelper.setLongestAsPrototype((JComboBox)textFieldWithHistory, mergedHistory);
    }

    private static void setLongestAsPrototype(@NotNull JComboBox comboBox, @NotNull List<String> variants) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/util/ui/SwingHelper", "setLongestAsPrototype"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/util/ui/SwingHelper", "setLongestAsPrototype"));
        }
        Object prototypeDisplayValue = comboBox.getPrototypeDisplayValue();
        String prototypeDisplayValueStr = null;
        if (prototypeDisplayValue instanceof String) {
            prototypeDisplayValueStr = (String)prototypeDisplayValue;
        } else if (prototypeDisplayValue != null) {
            return;
        }
        String longest = StringUtil.notNullize((String)prototypeDisplayValueStr);
        boolean updated = false;
        for (String s : variants) {
            if (longest.length() >= s.length()) continue;
            longest = s;
            updated = true;
        }
        if (updated) {
            comboBox.setPrototypeDisplayValue(longest);
        }
    }

    public static void installFileCompletionAndBrowseDialog(@Nullable Project project, @NotNull TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton, @NotNull String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithHistoryWithBrowseButton", "com/intellij/util/ui/SwingHelper", "installFileCompletionAndBrowseDialog"));
        }
        if (browseDialogTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browseDialogTitle", "com/intellij/util/ui/SwingHelper", "installFileCompletionAndBrowseDialog"));
        }
        if (fileChooserDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooserDescriptor", "com/intellij/util/ui/SwingHelper", "installFileCompletionAndBrowseDialog"));
        }
        SwingHelper.doInstall(project, textFieldWithHistoryWithBrowseButton, ((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).getTextEditor(), browseDialogTitle, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
    }

    public static void installFileCompletionAndBrowseDialog(@Nullable Project project, @NotNull TextFieldWithBrowseButton textFieldWithBrowseButton, @NotNull String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        if (textFieldWithBrowseButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithBrowseButton", "com/intellij/util/ui/SwingHelper", "installFileCompletionAndBrowseDialog"));
        }
        if (browseDialogTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browseDialogTitle", "com/intellij/util/ui/SwingHelper", "installFileCompletionAndBrowseDialog"));
        }
        if (fileChooserDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooserDescriptor", "com/intellij/util/ui/SwingHelper", "installFileCompletionAndBrowseDialog"));
        }
        SwingHelper.doInstall(project, textFieldWithBrowseButton, textFieldWithBrowseButton.getTextField(), browseDialogTitle, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    public static <T extends JComponent> void doInstall(@Nullable Project project, @NotNull ComponentWithBrowseButton<T> componentWithBrowseButton, @NotNull JTextField textField, @NotNull String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor, @NotNull TextComponentAccessor<T> textComponentAccessor) {
        if (componentWithBrowseButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentWithBrowseButton", "com/intellij/util/ui/SwingHelper", "doInstall"));
        }
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/util/ui/SwingHelper", "doInstall"));
        }
        if (browseDialogTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browseDialogTitle", "com/intellij/util/ui/SwingHelper", "doInstall"));
        }
        if (fileChooserDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooserDescriptor", "com/intellij/util/ui/SwingHelper", "doInstall"));
        }
        if (textComponentAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textComponentAccessor", "com/intellij/util/ui/SwingHelper", "doInstall"));
        }
        fileChooserDescriptor = fileChooserDescriptor.withShowHiddenFiles(SystemInfo.isUnix);
        componentWithBrowseButton.addBrowseFolderListener(project, new ComponentWithBrowseButton.BrowseFolderActionListener(browseDialogTitle, null, componentWithBrowseButton, project, fileChooserDescriptor, textComponentAccessor), true);
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, (Disposable)project);
    }

    @NotNull
    public static HyperlinkLabel createWebHyperlink(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ui/SwingHelper", "createWebHyperlink"));
        }
        HyperlinkLabel hyperlinkLabel = SwingHelper.createWebHyperlink(url, url);
        if (hyperlinkLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "createWebHyperlink"));
        }
        return hyperlinkLabel;
    }

    @NotNull
    public static HyperlinkLabel createWebHyperlink(@NotNull String text, @NotNull String url) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/ui/SwingHelper", "createWebHyperlink"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ui/SwingHelper", "createWebHyperlink"));
        }
        HyperlinkLabel hyperlink = new HyperlinkLabel(text);
        hyperlink.setHyperlinkTarget(url);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new OpenLinkInBrowser(url));
        actionGroup.add((AnAction)new CopyLinkAction(url));
        hyperlink.setComponentPopupMenu(ActionManager.getInstance().createActionPopupMenu("web hyperlink", (ActionGroup)actionGroup).getComponent());
        HyperlinkLabel hyperlinkLabel = hyperlink;
        if (hyperlinkLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "createWebHyperlink"));
        }
        return hyperlinkLabel;
    }

    public static void setPreferredWidth(@NotNull Component component, int width) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/SwingHelper", "setPreferredWidth"));
        }
        Dimension preferredSize = component.getPreferredSize();
        preferredSize.width = width;
        component.setPreferredSize(preferredSize);
    }

    @NotNull
    public static JEditorPane createHtmlViewer(boolean carryTextOver, @Nullable Font font, @Nullable Color background, @Nullable Color foreground) {
        JEditorPane textPane = carryTextOver ? new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 0;
                return dimension;
            }
        } : new JEditorPane();
        textPane.setFont(font != null ? font : UIUtil.getLabelFont());
        textPane.setContentType("text/html");
        textPane.setEditable(false);
        if (background != null) {
            textPane.setBackground(background);
        } else {
            textPane.setOpaque(false);
        }
        textPane.setForeground(foreground != null ? foreground : UIUtil.getLabelForeground());
        textPane.setFocusable(false);
        JEditorPane jEditorPane = textPane;
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "createHtmlViewer"));
        }
        return jEditorPane;
    }

    public static void setHtml(@NotNull JEditorPane editorPane, @NotNull String bodyInnerHtml, @Nullable Color foregroundColor) {
        if (editorPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPane", "com/intellij/util/ui/SwingHelper", "setHtml"));
        }
        if (bodyInnerHtml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyInnerHtml", "com/intellij/util/ui/SwingHelper", "setHtml"));
        }
        String html = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)editorPane.getFont(), (Color)foregroundColor, null, null), bodyInnerHtml);
        editorPane.setText(html);
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createTextFieldWithHistoryWithBrowseButton(@Nullable Project project, @NotNull String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor, @Nullable NotNullProducer<List<String>> historyProvider) {
        if (browseDialogTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browseDialogTitle", "com/intellij/util/ui/SwingHelper", "createTextFieldWithHistoryWithBrowseButton"));
        }
        if (fileChooserDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooserDescriptor", "com/intellij/util/ui/SwingHelper", "createTextFieldWithHistoryWithBrowseButton"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        if (historyProvider != null) {
            SwingHelper.addHistoryOnExpansion(textFieldWithHistory, historyProvider);
        }
        SwingHelper.installFileCompletionAndBrowseDialog(project, textFieldWithHistoryWithBrowseButton, browseDialogTitle, fileChooserDescriptor);
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "createTextFieldWithHistoryWithBrowseButton"));
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    @NotNull
    public static <C extends JComponent> ComponentWithBrowseButton<C> wrapWithInfoButton(@NotNull C component, @NotNull String infoButtonTooltip, @NotNull ActionListener listener) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/SwingHelper", "wrapWithInfoButton"));
        }
        if (infoButtonTooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoButtonTooltip", "com/intellij/util/ui/SwingHelper", "wrapWithInfoButton"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/ui/SwingHelper", "wrapWithInfoButton"));
        }
        ComponentWithBrowseButton comp = new ComponentWithBrowseButton(component, listener);
        FixedSizeButton uiHelpButton = comp.getButton();
        uiHelpButton.setToolTipText(infoButtonTooltip);
        uiHelpButton.setIcon(UIUtil.getBalloonInformationIcon());
        uiHelpButton.setHorizontalAlignment(0);
        uiHelpButton.setVerticalAlignment(0);
        ComponentWithBrowseButton componentWithBrowseButton = comp;
        if (componentWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/SwingHelper", "wrapWithInfoButton"));
        }
        return componentWithBrowseButton;
    }

    private static class OpenLinkInBrowser
    extends AnAction {
        private final String myUrl;

        private OpenLinkInBrowser(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ui/SwingHelper$OpenLinkInBrowser", "<init>"));
            }
            super("Open Link in Browser", null, PlatformIcons.WEB_ICON);
            this.myUrl = url;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(AnActionEvent e) {
            BrowserUtil.browse((String)this.myUrl);
        }
    }

    private static class CopyLinkAction
    extends AnAction {
        private final String myUrl;

        private CopyLinkAction(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ui/SwingHelper$CopyLinkAction", "<init>"));
            }
            super("Copy Link Address", null, PlatformIcons.COPY_ICON);
            this.myUrl = url;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(AnActionEvent e) {
            StringSelection content = new StringSelection(this.myUrl);
            CopyPasteManager.getInstance().setContents((Transferable)content);
        }
    }

    public static class HtmlViewerBuilder {
        private boolean myCarryTextOver;
        private String myDisabledHtml;
        private Font myFont;
        private Color myBackground;
        private Color myForeground;

        public JEditorPane create() {
            JEditorPane textPane = new JEditorPane(){
                private boolean myEnabled = true;
                private String myEnabledHtml;

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    if (HtmlViewerBuilder.this.myCarryTextOver) {
                        dimension.width = 0;
                    }
                    return dimension;
                }

                @Override
                public void setText(String t) {
                    if (HtmlViewerBuilder.this.myDisabledHtml != null && this.myEnabled) {
                        this.myEnabledHtml = t;
                    }
                    super.setText(t);
                }

                @Override
                public void setEnabled(boolean enabled) {
                    if (HtmlViewerBuilder.this.myDisabledHtml != null) {
                        this.myEnabled = enabled;
                        if (this.myEnabled) {
                            this.setText(this.myEnabledHtml);
                        } else {
                            this.setText(HtmlViewerBuilder.this.myDisabledHtml);
                        }
                        super.setEnabled(true);
                    } else {
                        super.setEnabled(enabled);
                    }
                }
            };
            textPane.setFont(this.myFont != null ? this.myFont : UIUtil.getLabelFont());
            textPane.setContentType("text/html");
            textPane.setEditable(false);
            if (this.myBackground != null) {
                textPane.setBackground(this.myBackground);
            } else {
                textPane.setOpaque(false);
            }
            textPane.setForeground(this.myForeground != null ? this.myForeground : UIUtil.getLabelForeground());
            textPane.setFocusable(false);
            return textPane;
        }

        public HtmlViewerBuilder setCarryTextOver(boolean carryTextOver) {
            this.myCarryTextOver = carryTextOver;
            return this;
        }

        public HtmlViewerBuilder setDisabledHtml(String disabledHtml) {
            this.myDisabledHtml = disabledHtml;
            return this;
        }

        public HtmlViewerBuilder setFont(Font font) {
            this.myFont = font;
            return this;
        }

        public HtmlViewerBuilder setBackground(Color background) {
            this.myBackground = background;
            return this;
        }

        public HtmlViewerBuilder setForeground(Color foreground) {
            this.myForeground = foreground;
            return this;
        }
    }
}

