/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadStartInConstructionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CallToThreadStartDuringObjectConstruction" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadStartInConstructionInspection", "getID"));
        }
        return "CallToThreadStartDuringObjectConstruction";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.start.in.construction.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadStartInConstructionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.start.in.construction.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadStartInConstructionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadStartInConstructionVisitor();
    }

    private static class ThreadStartInConstructionVisitor
    extends BaseInspectionVisitor {
        private ThreadStartInConstructionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/threading/ThreadStartInConstructionInspection$ThreadStartInConstructionVisitor", "visitMethod"));
            }
            if (method.isConstructor()) {
                method.accept((PsiElementVisitor)new ThreadStartVisitor());
            }
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/siyeh/ig/threading/ThreadStartInConstructionInspection$ThreadStartInConstructionVisitor", "visitClassInitializer"));
            }
            if (!initializer.hasModifierProperty("static")) {
                initializer.accept((PsiElementVisitor)new ThreadStartVisitor());
            }
        }

        private class ThreadStartVisitor
        extends JavaRecursiveElementVisitor {
            private ThreadStartVisitor() {
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ThreadStartInConstructionInspection$ThreadStartInConstructionVisitor$ThreadStartVisitor", "visitMethodCallExpression"));
                }
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"start".equals(methodName)) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 0) {
                    return;
                }
                PsiClass methodClass = method.getContainingClass();
                if (methodClass == null || !InheritanceUtil.isInheritor((PsiClass)methodClass, (String)"java.lang.Thread")) {
                    return;
                }
                PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression);
                if (containingClass == null || containingClass.hasModifierProperty("final")) {
                    return;
                }
                ThreadStartInConstructionVisitor.this.registerMethodCallError(expression, new Object[0]);
            }
        }
    }
}

