/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairFunction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    private static final NotNullLazyValue<OrderRootType[]> ORDER_ROOT_TYPES = new NotNullLazyValue<OrderRootType[]>(){

        @NotNull
        protected OrderRootType[] compute() {
            OrderRootType[] orderRootTypeArray;
            OrderRootType javaDocRootType = DefaultWebServerRootsProvider.getJavadocOrderRootType();
            if (javaDocRootType == null) {
                OrderRootType[] orderRootTypeArray2 = new OrderRootType[3];
                orderRootTypeArray2[0] = OrderRootType.DOCUMENTATION;
                orderRootTypeArray2[1] = OrderRootType.SOURCES;
                orderRootTypeArray = orderRootTypeArray2;
                orderRootTypeArray2[2] = OrderRootType.CLASSES;
            } else {
                OrderRootType[] orderRootTypeArray3 = new OrderRootType[4];
                orderRootTypeArray3[0] = javaDocRootType;
                orderRootTypeArray3[1] = OrderRootType.DOCUMENTATION;
                orderRootTypeArray3[2] = OrderRootType.SOURCES;
                orderRootTypeArray = orderRootTypeArray3;
                orderRootTypeArray3[3] = OrderRootType.CLASSES;
            }
            if (orderRootTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$1", "compute"));
            }
            return orderRootTypeArray;
        }
    };

    DefaultWebServerRootsProvider() {
    }

    @Nullable
    private static OrderRootType getJavadocOrderRootType() {
        try {
            return JavadocOrderRootType.getInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project) {
        Module[] modules;
        PairFunction<String, VirtualFile, VirtualFile> resolver;
        int index;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "resolve"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "resolve"));
        }
        if (PlatformUtils.isIntelliJ() && (index = path.indexOf(47)) > 0 && !path.regionMatches(!SystemInfo.isFileSystemCaseSensitive, 0, project.getName(), 0, index)) {
            Module module;
            String moduleName = path.substring(0, index);
            AccessToken token = ReadAction.start();
            try {
                module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
            }
            finally {
                token.finish();
            }
            if (module != null && !module.isDisposed()) {
                path = path.substring(index + 1);
                resolver = WebServerPathToFileManager.getInstance(project).getResolver(path);
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                PathInfo result = DefaultWebServerRootsProvider.findByRelativePath(path, moduleRootManager.getSourceRoots(), resolver, moduleName);
                if (result == null && (result = DefaultWebServerRootsProvider.findByRelativePath(path, moduleRootManager.getContentRoots(), resolver, moduleName)) == null) {
                    result = DefaultWebServerRootsProvider.findInModuleLibraries(path, module, resolver);
                }
                if (result != null) {
                    return result;
                }
            }
        }
        AccessToken token = ReadAction.start();
        try {
            modules = ModuleManager.getInstance((Project)project).getModules();
        }
        finally {
            token.finish();
        }
        resolver = WebServerPathToFileManager.getInstance(project).getResolver(path);
        PathInfo result = DefaultWebServerRootsProvider.findByRelativePath(project, path, modules, true, resolver);
        if (result == null && (result = DefaultWebServerRootsProvider.findByRelativePath(project, path, modules, false, resolver)) == null) {
            return DefaultWebServerRootsProvider.findInLibraries(project, modules, path, resolver);
        }
        return result;
    }

    @Nullable
    private static PathInfo findInModuleLibraries(@NotNull String path, @NotNull Module module, @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInModuleLibraries"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInModuleLibraries"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInModuleLibraries"));
        }
        int index = path.indexOf(47);
        if (index <= 0) {
            return null;
        }
        Ref result = Ref.create();
        DefaultWebServerRootsProvider.findInModuleLibraries(resolver, path.substring(0, index), path.substring(index + 1), (Ref<PathInfo>)result, module);
        return (PathInfo)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PathInfo findInLibraries(@NotNull Project project, @NotNull Module[] modules, @NotNull String path, @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInLibraries"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInLibraries"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInLibraries"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInLibraries"));
        }
        int index = path.indexOf(47);
        if (index < 0) {
            return null;
        }
        String libraryFileName = path.substring(0, index);
        String relativePath = path.substring(index + 1);
        AccessToken token = ReadAction.start();
        try {
            Ref result = Ref.create();
            for (Module module : modules) {
                if (module.isDisposed() || !DefaultWebServerRootsProvider.findInModuleLibraries(resolver, libraryFileName, relativePath, (Ref<PathInfo>)result, module)) continue;
                PathInfo pathInfo = (PathInfo)result.get();
                return pathInfo;
            }
            for (Module module : LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries()) {
                PathInfo pathInfo = DefaultWebServerRootsProvider.findInLibrary(libraryFileName, relativePath, (Library)module, resolver);
                if (pathInfo == null) continue;
                PathInfo pathInfo2 = pathInfo;
                return pathInfo2;
            }
        }
        finally {
            token.finish();
        }
        return null;
    }

    private static boolean findInModuleLibraries(final @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver, final @NotNull String libraryFileName, final @NotNull String relativePath, final @NotNull Ref<PathInfo> result, @NotNull Module module) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInModuleLibraries"));
        }
        if (libraryFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFileName", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInModuleLibraries"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInModuleLibraries"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInModuleLibraries"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInModuleLibraries"));
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary((Processor)new Processor<Library>(){

            public boolean process(Library library) {
                result.set((Object)DefaultWebServerRootsProvider.findInLibrary(libraryFileName, relativePath, library, (PairFunction<String, VirtualFile, VirtualFile>)resolver));
                return result.isNull();
            }
        });
        return !result.isNull();
    }

    @Nullable
    private static PathInfo findInLibrary(@NotNull String libraryFileName, @NotNull String relativePath, @NotNull Library library, @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver) {
        if (libraryFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFileName", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInLibrary"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInLibrary"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInLibrary"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findInLibrary"));
        }
        for (OrderRootType rootType : (OrderRootType[])ORDER_ROOT_TYPES.getValue()) {
            for (VirtualFile root : library.getFiles(rootType)) {
                VirtualFile file;
                if (!StringUtil.equalsIgnoreCase((CharSequence)root.getNameSequence(), (CharSequence)libraryFileName) || (file = (VirtualFile)resolver.fun((Object)relativePath, (Object)root)) == null) continue;
                return new PathInfo(file, root, null, true);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PathInfo getRoot(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "getRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "getRoot"));
        }
        AccessToken token = ReadAction.start();
        try {
            boolean isLibrary;
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(project);
            DirectoryInfo info = directoryIndex.getInfoForFile(file);
            if (!info.isExcluded() && !info.isInProject()) {
                PathInfo pathInfo = file.getFileSystem() == JarFileSystem.getInstance() ? DefaultWebServerRootsProvider.getInfoForDocJar(file, project) : null;
                return pathInfo;
            }
            VirtualFile root = info.getSourceRoot();
            if (root == null) {
                root = info.getContentRoot();
                if (root == null) {
                    root = info.getLibraryClassRoot();
                    isLibrary = true;
                    assert (root != null) : file.getPresentableUrl();
                } else {
                    isLibrary = false;
                }
            } else {
                isLibrary = info.isInLibrarySource();
            }
            Module module = info.getModule();
            if (isLibrary && module == null) {
                for (PathInfo entry : directoryIndex.getOrderEntries(info)) {
                    if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                    module = entry.getOwnerModule();
                    break;
                }
            }
            PathInfo pathInfo = new PathInfo(file, root, DefaultWebServerRootsProvider.getModuleNameQualifier(project, module), isLibrary);
            return pathInfo;
        }
        finally {
            token.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PathInfo getInfoForDocJar(final @NotNull VirtualFile file, final @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "getInfoForDocJar"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "getInfoForDocJar"));
        }
        final OrderRootType javaDocRootType = DefaultWebServerRootsProvider.getJavadocOrderRootType();
        if (javaDocRootType == null) {
            return null;
        }
        class LibraryProcessor
        implements Processor<Library> {
            PathInfo result;
            Module module;

            LibraryProcessor() {
            }

            public boolean process(Library library) {
                for (VirtualFile root : library.getFiles(javaDocRootType)) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                    this.result = new PathInfo(file, root, DefaultWebServerRootsProvider.getModuleNameQualifier(project, this.module), true);
                    return false;
                }
                return true;
            }
        }
        LibraryProcessor processor = new LibraryProcessor();
        AccessToken token = ReadAction.start();
        try {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            for (Module module : moduleManager.getModules()) {
                if (module.isDisposed()) continue;
                processor.module = module;
                ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary((Processor)processor);
                if (processor.result == null) continue;
                PathInfo pathInfo = processor.result;
                return pathInfo;
            }
            processor.module = null;
            for (Module module : LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries()) {
                if (processor.process((Library)module)) continue;
                PathInfo pathInfo = processor.result;
                return pathInfo;
            }
        }
        finally {
            token.finish();
        }
        return null;
    }

    @Nullable
    private static String getModuleNameQualifier(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "getModuleNameQualifier"));
        }
        if (module != null && PlatformUtils.isIntelliJ() && !module.getName().equalsIgnoreCase(project.getName()) && !BuiltInWebServer.compareNameAndProjectBasePath(module.getName(), project)) {
            return module.getName();
        }
        return null;
    }

    @Nullable
    private static PathInfo findByRelativePath(@NotNull String path, @NotNull VirtualFile[] roots, @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver, @Nullable String moduleName) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        for (VirtualFile root : roots) {
            VirtualFile file = (VirtualFile)resolver.fun((Object)path, (Object)root);
            if (file == null) continue;
            return new PathInfo(file, root, moduleName, false);
        }
        return null;
    }

    @Nullable
    private static PathInfo findByRelativePath(@NotNull Project project, @NotNull String path, @NotNull Module[] modules, boolean inSourceRoot, @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        for (Module module : modules) {
            if (module.isDisposed()) continue;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            PathInfo result = DefaultWebServerRootsProvider.findByRelativePath(path, inSourceRoot ? moduleRootManager.getSourceRoots() : moduleRootManager.getContentRoots(), resolver, null);
            if (result == null) continue;
            result.moduleName = DefaultWebServerRootsProvider.getModuleNameQualifier(project, module);
            return result;
        }
        return null;
    }
}

