/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.ValueGroupFactory;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Variables;

public class VariablesGroup
extends XValueGroup {
    public static final ValueGroupFactory<List<Variable>> GROUP_FACTORY = new ValueGroupFactory<List<Variable>>(){

        @Override
        public XValueGroup create(@NotNull List<Variable> variables, int start, int end, @NotNull VariableContext context) {
            if (variables == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/VariablesGroup$1", "create"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/VariablesGroup$1", "create"));
            }
            return VariablesGroup.createArrayRangeGroup(start, end, variables, context);
        }
    };
    private final int start;
    private final int end;
    private final List<Variable> variables;
    private final VariableContext context;

    public VariablesGroup(@NotNull String name, @NotNull List<Variable> variables, VariableContext context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/VariablesGroup", "<init>"));
        }
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/VariablesGroup", "<init>"));
        }
        this(0, variables.size(), variables, context, name);
    }

    private VariablesGroup(int start, int end, @NotNull List<Variable> variables, @NotNull VariableContext context, @NotNull String name) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/VariablesGroup", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/VariablesGroup", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/VariablesGroup", "<init>"));
        }
        super(name);
        this.start = start;
        this.end = end;
        this.variables = variables;
        this.context = context;
    }

    public static VariablesGroup createArrayRangeGroup(int start, int end, List<Variable> variables, VariableContext variableContext) {
        String name = "[" + variables.get(start).getName() + " \u2026 " + variables.get(end - 1).getName() + "]";
        return new VariablesGroup(start, end, variables, variableContext, name);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariablesGroup", "computeChildren"));
        }
        node.setAlreadySorted(true);
        node.addChildren(Variables.createVariablesList(this.variables, this.start, this.end, this.context, null), true);
    }
}

