/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.util.Consumer;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.Decoder;
import org.jetbrains.io.fastCgi.FastCgiService;

public class FastCgiDecoder
extends Decoder
implements Decoder.FullMessageConsumer<Void> {
    private State state;
    private int type;
    private int id;
    private int contentLength;
    private int paddingLength;
    private final TIntObjectHashMap<ByteBuf> dataBuffers;
    private final Consumer<String> errorOutputConsumer;
    private final FastCgiService responseHandler;

    public FastCgiDecoder(@NotNull Consumer<String> errorOutputConsumer, @NotNull FastCgiService responseHandler) {
        if (errorOutputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutputConsumer", "org/jetbrains/io/fastCgi/FastCgiDecoder", "<init>"));
        }
        if (responseHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "responseHandler", "org/jetbrains/io/fastCgi/FastCgiDecoder", "<init>"));
        }
        this.state = State.HEADER;
        this.dataBuffers = new TIntObjectHashMap();
        this.errorOutputConsumer = errorOutputConsumer;
        this.responseHandler = responseHandler;
    }

    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/fastCgi/FastCgiDecoder", "messageReceived"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/io/fastCgi/FastCgiDecoder", "messageReceived"));
        }
        while (true) {
            switch (this.state) {
                case HEADER: {
                    ByteBuf buffer;
                    if (this.paddingLength > 0) {
                        if (input.readableBytes() > this.paddingLength) {
                            input.skipBytes(this.paddingLength);
                            this.paddingLength = 0;
                        } else {
                            this.paddingLength -= input.readableBytes();
                            input.skipBytes(input.readableBytes());
                            return;
                        }
                    }
                    if ((buffer = this.getBufferIfSufficient(input, 8, context)) == null) {
                        return;
                    }
                    this.decodeHeader(buffer);
                    this.state = State.CONTENT;
                }
                case CONTENT: {
                    if (this.contentLength > 0) {
                        this.readContent(input, context, this.contentLength, this);
                    }
                    this.state = State.HEADER;
                }
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        try {
            if (!this.dataBuffers.isEmpty()) {
                this.dataBuffers.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<ByteBuf>(){

                    public boolean execute(int a, ByteBuf buffer) {
                        try {
                            buffer.release();
                        }
                        catch (Throwable e) {
                            FastCgiService.LOG.error(e);
                        }
                        return true;
                    }
                });
                this.dataBuffers.clear();
            }
        }
        finally {
            super.channelInactive(context);
        }
    }

    private void decodeHeader(@NotNull ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/fastCgi/FastCgiDecoder", "decodeHeader"));
        }
        buffer.skipBytes(1);
        this.type = buffer.readUnsignedByte();
        this.id = buffer.readUnsignedShort();
        this.contentLength = buffer.readUnsignedShort();
        this.paddingLength = buffer.readUnsignedByte();
        buffer.skipBytes(1);
    }

    @Override
    public Void contentReceived(@NotNull ByteBuf buffer, @NotNull ChannelHandlerContext context, boolean isCumulateBuffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/fastCgi/FastCgiDecoder", "contentReceived"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/fastCgi/FastCgiDecoder", "contentReceived"));
        }
        switch (this.type) {
            case 3: {
                int appStatus = buffer.readInt();
                short protocolStatus = buffer.readUnsignedByte();
                if (appStatus != 0 || protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) {
                    FastCgiService.LOG.warn("Protocol status " + protocolStatus);
                    this.dataBuffers.remove(this.id);
                    this.responseHandler.responseReceived(this.id, null);
                    break;
                }
                if (protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) break;
                this.responseHandler.responseReceived(this.id, (ByteBuf)this.dataBuffers.remove(this.id));
                break;
            }
            case 6: {
                ByteBuf sliced;
                ByteBuf data = (ByteBuf)this.dataBuffers.get(this.id);
                ByteBuf byteBuf = sliced = isCumulateBuffer ? buffer : buffer.slice(buffer.readerIndex(), this.contentLength);
                if (data == null) {
                    this.dataBuffers.put(this.id, (Object)sliced);
                } else if (data instanceof CompositeByteBuf) {
                    ((CompositeByteBuf)data).addComponent(sliced);
                    data.writerIndex(data.writerIndex() + sliced.readableBytes());
                } else {
                    if (sliced instanceof CompositeByteBuf) {
                        data = ((CompositeByteBuf)sliced).addComponent(0, data);
                        data.writerIndex(data.writerIndex() + data.readableBytes());
                    } else {
                        data = context.alloc().compositeBuffer(1024).addComponents(new ByteBuf[]{data, sliced});
                        data.writerIndex(data.writerIndex() + data.readableBytes() + sliced.readableBytes());
                    }
                    this.dataBuffers.put(this.id, (Object)data);
                }
                sliced.retain();
                break;
            }
            case 7: {
                try {
                    this.errorOutputConsumer.consume((Object)buffer.toString(buffer.readerIndex(), this.contentLength, CharsetUtil.UTF_8));
                }
                catch (Throwable e) {
                    FastCgiService.LOG.error(e);
                }
                break;
            }
            default: {
                FastCgiService.LOG.error("Unknown type " + this.type);
            }
        }
        return null;
    }

    public static final class RecordType {
        public static final int END_REQUEST = 3;
        public static final int STDOUT = 6;
        public static final int STDERR = 7;
    }

    private static enum ProtocolStatus {
        REQUEST_COMPLETE,
        CANT_MPX_CONN,
        OVERLOADED,
        UNKNOWN_ROLE;

    }

    private static enum State {
        HEADER,
        CONTENT;

    }
}

