/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.element;

import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import java.util.List;
import org.jetbrains.java.generate.element.Element;
import org.jetbrains.java.generate.element.FieldElement;

public class GenerationHelper {
    public static String getUniqueLocalVarName(String base, List<Element> elements, CodeStyleSettings settings) {
        boolean anyEqual;
        String id = base = settings.LOCAL_VARIABLE_NAME_PREFIX + base;
        int index = 0;
        block0: do {
            if (index > 0) {
                id = base + index;
            }
            ++index;
            anyEqual = false;
            for (Element equalsField : elements) {
                if (!id.equals(equalsField.getName())) continue;
                anyEqual = true;
                continue block0;
            }
        } while (anyEqual);
        return id;
    }

    public static String getParamName(FieldElement fieldElement, Project project) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        return codeStyleManager.propertyNameToVariableName(GenerationHelper.getPropertyName(fieldElement, project), VariableKind.PARAMETER);
    }

    public static String getPropertyName(FieldElement fieldElement, Project project) {
        String name = fieldElement.getName();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        return codeStyleManager.variableNameToPropertyName(name, fieldElement.isModifierStatic() ? VariableKind.STATIC_FIELD : VariableKind.FIELD);
    }
}

