/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class CallGenerator {
    public void genCall(@NotNull Callable callableMethod, @Nullable ResolvedCall<?> resolvedCall, boolean callDefault, @NotNull ExpressionCodegen codegen) {
        JetExpression calleeExpression;
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/CallGenerator", "genCall"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/CallGenerator", "genCall"));
        }
        if (resolvedCall != null && (calleeExpression = resolvedCall.getCall().getCalleeExpression()) != null) {
            codegen.markStartLineNumber(calleeExpression);
        }
        this.genCallInner(callableMethod, resolvedCall, callDefault, codegen);
    }

    public abstract void genCallInner(@NotNull Callable var1, @Nullable ResolvedCall<?> var2, boolean var3, @NotNull ExpressionCodegen var4);

    public abstract void genCallWithoutAssertions(@NotNull CallableMethod var1, @NotNull ExpressionCodegen var2);

    public abstract void afterParameterPut(@NotNull Type var1, StackValue var2, @NotNull ValueParameterDescriptor var3);

    public abstract void genValueAndPut(@NotNull ValueParameterDescriptor var1, @NotNull JetExpression var2, @NotNull Type var3);

    public abstract void putValueIfNeeded(@Nullable ValueParameterDescriptor var1, @NotNull Type var2, @NotNull StackValue var3);

    public abstract void putCapturedValueOnStack(@NotNull StackValue var1, @NotNull Type var2, int var3);

    public abstract void putHiddenParams();

    static class DefaultCallGenerator
    extends CallGenerator {
        private final ExpressionCodegen codegen;

        public DefaultCallGenerator(ExpressionCodegen codegen) {
            this.codegen = codegen;
        }

        @Override
        public void genCallInner(@NotNull Callable callableMethod, ResolvedCall<?> resolvedCall, boolean callDefault, @NotNull ExpressionCodegen codegen) {
            if (callableMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "genCallInner"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "genCallInner"));
            }
            if (!callDefault) {
                callableMethod.genInvokeInstruction(codegen.v);
            } else {
                ((CallableMethod)callableMethod).genInvokeDefaultInstruction(codegen.v);
            }
        }

        @Override
        public void genCallWithoutAssertions(@NotNull CallableMethod method, @NotNull ExpressionCodegen codegen) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "genCallWithoutAssertions"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "genCallWithoutAssertions"));
            }
            method.genInvokeInstruction(codegen.v);
        }

        @Override
        public void afterParameterPut(@NotNull Type type2, StackValue stackValue, @NotNull ValueParameterDescriptor valueParameterDescriptor) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "afterParameterPut"));
            }
            if (valueParameterDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "afterParameterPut"));
            }
        }

        @Override
        public void putHiddenParams() {
        }

        @Override
        public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull JetExpression argumentExpression, @NotNull Type parameterType) {
            if (valueParameterDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            if (argumentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            StackValue value2 = this.codegen.gen(argumentExpression);
            value2.put(parameterType, this.codegen.v);
        }

        @Override
        public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
            if (stackValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "putCapturedValueOnStack"));
            }
            if (valueType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "putCapturedValueOnStack"));
            }
            stackValue.put(stackValue.type, this.codegen.v);
        }

        @Override
        public void putValueIfNeeded(@Nullable ValueParameterDescriptor valueParameterDescriptor, @NotNull Type parameterType, @NotNull StackValue value2) {
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "putValueIfNeeded"));
            }
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/CallGenerator$DefaultCallGenerator", "putValueIfNeeded"));
            }
            value2.put(value2.type, this.codegen.v);
        }
    }
}

