/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.org.objectweb.asm.Type;

public class FieldInfo {
    private final Type fieldType;
    private final Type ownerType;
    private final String fieldName;
    private final boolean isStatic;

    @NotNull
    public static FieldInfo createForSingleton(@NotNull ClassDescriptor classDescriptor, @NotNull JetTypeMapper typeMapper) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/FieldInfo", "createForSingleton"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FieldInfo", "createForSingleton"));
        }
        if (!classDescriptor.getKind().isSingleton()) {
            throw new UnsupportedOperationException("Can't create singleton field for class: " + classDescriptor);
        }
        if (DescriptorUtils.isNonCompanionObject(classDescriptor) || CompanionObjectMapping.hasMappingToObject(classDescriptor)) {
            Type type2 = typeMapper.mapType(classDescriptor);
            FieldInfo fieldInfo = new FieldInfo(type2, type2, "INSTANCE$", true);
            if (fieldInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FieldInfo", "createForSingleton"));
            }
            return fieldInfo;
        }
        ClassDescriptor ownerDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class);
        assert (ownerDescriptor != null) : "Owner not found for class: " + classDescriptor;
        Type ownerType = typeMapper.mapType(ownerDescriptor);
        FieldInfo fieldInfo = new FieldInfo(ownerType, typeMapper.mapType(classDescriptor), classDescriptor.getName().asString(), true);
        if (fieldInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FieldInfo", "createForSingleton"));
        }
        return fieldInfo;
    }

    @NotNull
    public static FieldInfo deprecatedFieldForCompanionObject(@NotNull ClassDescriptor companionObject, @NotNull JetTypeMapper typeMapper) {
        if (companionObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "companionObject", "org/jetbrains/kotlin/codegen/FieldInfo", "deprecatedFieldForCompanionObject"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FieldInfo", "deprecatedFieldForCompanionObject"));
        }
        assert (DescriptorUtils.isCompanionObject(companionObject)) : "Not a companion object: " + companionObject;
        FieldInfo fieldInfo = new FieldInfo(typeMapper.mapType((ClassifierDescriptor)companionObject.getContainingDeclaration()), typeMapper.mapType(companionObject), "OBJECT$", true);
        if (fieldInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FieldInfo", "deprecatedFieldForCompanionObject"));
        }
        return fieldInfo;
    }

    @NotNull
    public static FieldInfo createForHiddenField(@NotNull Type owner, @NotNull Type fieldType, @NotNull String fieldName) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/FieldInfo", "createForHiddenField"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "org/jetbrains/kotlin/codegen/FieldInfo", "createForHiddenField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/FieldInfo", "createForHiddenField"));
        }
        FieldInfo fieldInfo = new FieldInfo(owner, fieldType, fieldName, false);
        if (fieldInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FieldInfo", "createForHiddenField"));
        }
        return fieldInfo;
    }

    private FieldInfo(@NotNull Type ownerType, @NotNull Type fieldType, @NotNull String fieldName, boolean isStatic) {
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/kotlin/codegen/FieldInfo", "<init>"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "org/jetbrains/kotlin/codegen/FieldInfo", "<init>"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/FieldInfo", "<init>"));
        }
        this.ownerType = ownerType;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    @NotNull
    public Type getFieldType() {
        Type type2 = this.fieldType;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FieldInfo", "getFieldType"));
        }
        return type2;
    }

    @NotNull
    public Type getOwnerType() {
        Type type2 = this.ownerType;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FieldInfo", "getOwnerType"));
        }
        return type2;
    }

    @NotNull
    public String getOwnerInternalName() {
        String string = this.ownerType.getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FieldInfo", "getOwnerInternalName"));
        }
        return string;
    }

    @NotNull
    public String getFieldName() {
        String string = this.fieldName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FieldInfo", "getFieldName"));
        }
        return string;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String toString() {
        return String.format("%s %s.%s : %s", this.isStatic ? "GETSTATIC" : "GETFIELD", this.ownerType.getInternalName(), this.fieldName, this.fieldType);
    }
}

