/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.JetType;

public class AnnotationDescriptorImpl
implements AnnotationDescriptor {
    private final JetType annotationType;
    private final Map<ValueParameterDescriptor, CompileTimeConstant<?>> valueArguments;

    public AnnotationDescriptorImpl(@NotNull JetType annotationType, @NotNull Map<ValueParameterDescriptor, CompileTimeConstant<?>> valueArguments2) {
        if (annotationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationType", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        this.annotationType = annotationType;
        this.valueArguments = Collections.unmodifiableMap(valueArguments2);
    }

    @Override
    @NotNull
    public JetType getType() {
        JetType jetType = this.annotationType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "getType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, CompileTimeConstant<?>> getAllValueArguments() {
        Map<ValueParameterDescriptor, CompileTimeConstant<?>> map2 = this.valueArguments;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "getAllValueArguments"));
        }
        return map2;
    }

    public String toString() {
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderAnnotation(this);
    }
}

