/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

public abstract class DeclarationDescriptorImpl
extends AnnotatedImpl
implements DeclarationDescriptor {
    @NotNull
    private final Name name;

    public DeclarationDescriptorImpl(@NotNull Annotations annotations2, @NotNull Name name2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/DeclarationDescriptorImpl", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/DeclarationDescriptorImpl", "<init>"));
        }
        super(annotations2);
        this.name = name2;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name2 = this.name;
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/DeclarationDescriptorImpl", "getName"));
        }
        return name2;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        DeclarationDescriptorImpl declarationDescriptorImpl = this;
        if (declarationDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/DeclarationDescriptorImpl", "getOriginal"));
        }
        return declarationDescriptorImpl;
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor2) {
        this.accept(visitor2, null);
    }

    public String toString() {
        return DeclarationDescriptorImpl.toString(this);
    }

    @NotNull
    static String toString(@NotNull DeclarationDescriptor descriptor2) {
        String string;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/descriptors/impl/DeclarationDescriptorImpl", "toString"));
        }
        try {
            string = DescriptorRenderer.DEBUG_TEXT.render(descriptor2) + "[" + descriptor2.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(descriptor2)) + "]";
        }
        catch (Throwable e) {
            String string2 = descriptor2.getClass().getSimpleName() + " " + descriptor2.getName();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/DeclarationDescriptorImpl", "toString"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/DeclarationDescriptorImpl", "toString"));
        }
        return string;
    }
}

