/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinResolveDataProvider;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage$KotlinCacheService$f7ac07e6;
import org.jetbrains.kotlin.idea.project.ResolveSessionForBodies;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"S\u0006)!\u0002+\u001a:GS2,\u0017I\\1msNL7oQ1dQ\u0016T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017M\u0003\u0004dC\u000eDWm\u001d\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\r\te.\u001f\u0006\u0007y%t\u0017\u000e\u001e \u000b\t\u0019LG.\u001a\u0006\b\u0015\u0016$h)\u001b7f\u0015\r\u00018/\u001b\u0006\u000fe\u0016\u001cx\u000e\u001c<f'\u0016\u001c8/[8o\u0015]\u0011Vm]8mm\u0016\u001cVm]:j_:4uN\u001d\"pI&,7OC\u0004qe>TWm\u0019;\u000b\u000b\r\f7\r[3\u000b\u000f!\u000b7\u000f['ba*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u000f\u0003:\fG._:jgJ+7/\u001e7u\u0015!\tg.\u00197zu\u0016\u0014(bB4fi\u001aKG.\u001a\u0006\u0012O\u0016$(+Z:pYZ,7+Z:tS>t'bB1oC2L(0\u001a\u0006\u0012C:\fG.\u001f>bE2,W\t\\3nK:$(B\u0003&fi\u0016cW-\\3oi*\u0011r-\u001a;B]\u0006d\u0017p]5t%\u0016\u001cX\u000f\u001c;t\u0015\u001d)G.Z7f]RTa\u0001\\8pWV\u0003\b7\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001C\u0004\u0011\u000fa\u0001!\u0002\u0002\u0005\u0003!-Qa\u0001C\u0005\u0011\u0015a\u0001!\u0002\u0002\u0005\u0004!9Qa\u0001C\u0006\u0011\u001ba\u0001!\u0002\u0002\u0005\n!)QA\u0001C\u0006\u0011\u001b)\u0011\u0001#\u0005\u0006\u0005\u0011=\u0001\"C\u0003\u0004\t!A\u0001\u0002\u0004\u0001\u0006\u0003!QQA\u0001\u0003\n\u0011+)!\u0001b\u0005\t\f\u0015\u0019AA\u0003E\n\u0019\u0001)!\u0001B\u0001\t\u0018\u0015\u0019Aa\u0003\u0005\f\u0019\u0001)!\u0001\u0002\u0005\t\u0011\u0015\u0019A\u0011\u0002\u0005\u000f\u0019\u0001)!\u0001B\u0006\t\u0017\u0015\u0011A\u0011\u0002\u0005\u000f\t\u0005a1!\u0007\u0002\u0006\u0003!!Qf\u0005\u0003b\ta=\u0011EC\u0003\u0002\u0011#I1!\u0003\u0002\u0006\u0003!U\u0011bA\u0005\u0003\u000b\u0005A9\"V\u0002\u0005\u000b\r!y!C\u0001\t\u00195zA\u0001\u0019\u0003\u0019\n\u0005\u0012Q!\u0001\u0005\u0006+\u000eAQa\u0001C\u0005\u0013\u0005Ai!D\u0002\u0005\u0019%\t\u0001RB\u0017\u0010\t\u0001$\u0001DB\u0011\u0003\u000b\u0005Aa!V\u0002\t\u000b\r!a!C\u0001\t\u000f5\u0019A\u0011D\u0005\u0002\u0011\u001di3\u0003B\u0001\u0019\u001bu5A\u0001\u0001E\u000e\u001b\t)\u0011\u0001#\u0007Q\u0007\u0001\t#!B\u0001\t\u0018E\u001bQ\u0001B\u0007\n\u0003!iQ\"\u0001E\u000e[M!\u0001\u0001'\b\u001e\u000e\u0011\u0001\u0001bD\u0007\u0003\u000b\u0005AI\u0002U\u0002\u0001C\t)\u0011\u0001c\u0006R\u0007\u0015!i\"C\u0001\t\u001b5\t\u00012D\u0017\u0015\t\u0005Az\"(\u0004\u0005\u0001!mQBA\u0003\u0002\u00113\u00016\u0001A\u0011\u0004\u000b\u0005A9\u0002$\u0001R\u0007\u0015!y\"C\u0001\t\u001b5\t\u00012D\u001b\u001f\u000bu!1\u001d\u0001\r\u0005;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001u5A\u0001\u0001\u0005\u0007\u001b\t)\u0011\u0001\u0003\u0004Q\u0007\u0003\t#!B\u0001\t\u0007E\u001bq\u0001\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001E\u0007\u001b\u0005Aq\u0001"})
public final class PerFileAnalysisCache {
    public static final /* synthetic */ KClass $kotlinClass;
    private final HashMap<PsiElement, AnalysisResult> cache;
    @NotNull
    private final JetFile file;
    @NotNull
    private final ResolveSessionForBodies resolveSession;

    static {
        $kotlinClass = Reflection.createKotlinClass(PerFileAnalysisCache.class);
    }

    private final AnalysisResult lookUp(@JetValueParameter(name="analyzableElement") JetElement analyzableElement) {
        ArrayList descendantsOfCurrent = KotlinPackage.arrayListOf((Object[])new PsiElement[0]);
        HashSet toRemove = KotlinPackage.hashSetOf((Object[])new PsiElement[0]);
        PsiElement current = (PsiElement)analyzableElement;
        AnalysisResult result2 = null;
        while (current != null) {
            AnalysisResult cached = this.cache.get(current);
            if (cached != null) {
                result2 = cached;
                toRemove.addAll(descendantsOfCurrent);
                descendantsOfCurrent.clear();
            }
            PsiElement psiElement = current;
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            descendantsOfCurrent.add(psiElement);
            PsiElement psiElement2 = current;
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            current = psiElement2.getParent();
        }
        this.cache.keySet().removeAll(toRemove);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AnalysisResult getAnalysisResults(@JetValueParameter(name="element") @NotNull JetElement element) {
        AnalysisResult analysisResult;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        boolean value2 = Intrinsics.areEqual((Object)element.getContainingJetFile(), (Object)this.file);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value2) {
            String message = "Wrong file. Expected " + this.getFile() + ", but was " + element.getContainingJetFile();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        JetElement analyzableParent = KotlinResolveDataProvider.INSTANCE$.findAnalyzableParent(element);
        PerFileAnalysisCache lock = this;
        synchronized (lock) {
            AnalysisResult analysisResult2;
            AnalysisResult cached = this.lookUp(analyzableParent);
            if (cached != null) {
                analysisResult2 = cached;
            } else {
                AnalysisResult result2 = this.analyze(analyzableParent);
                KotlinPackage.set((Map)this.cache, (Object)analyzableParent, (Object)result2);
                analysisResult2 = result2;
            }
            AnalysisResult analysisResult3 = analysisResult2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl22 : MonitorExitStatement: MONITOREXIT : lock
            analysisResult = analysisResult3;
        }
        return analysisResult;
    }

    private final AnalysisResult analyze(@JetValueParameter(name="analyzableElement") JetElement analyzableElement) {
        Project project = analyzableElement.getProject();
        if (DumbService.isDumb((Project)project)) {
            return AnalysisResult.Companion.getEMPTY();
        }
        try {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            return KotlinResolveDataProvider.INSTANCE$.analyze(project2, this.resolveSession, analyzableElement);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            DiagnosticUtils.throwIfRunningOnServer(e);
            ResolvePackage$KotlinCacheService$f7ac07e6.getLOG().error(e);
            BindingContext bindingContext2 = BindingContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"BindingContext.EMPTY");
            return AnalysisResult.Companion.error(bindingContext2, e);
        }
    }

    @NotNull
    public final JetFile getFile() {
        return this.file;
    }

    @NotNull
    public final ResolveSessionForBodies getResolveSession() {
        return this.resolveSession;
    }

    public PerFileAnalysisCache(@JetValueParameter(name="file") @NotNull JetFile file, @JetValueParameter(name="resolveSession") @NotNull ResolveSessionForBodies resolveSession) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)resolveSession, (String)"resolveSession");
        this.file = file;
        this.resolveSession = resolveSession;
        this.cache = new HashMap();
    }
}

