/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.psi.JetBlockExpression;

public class KotlinSurrounderUtils {
    public static String SURROUND_WITH = JetBundle.message("surround.with", new Object[0]);
    public static String SURROUND_WITH_ERROR = JetBundle.message("surround.with.cannot.perform.action", new Object[0]);

    private KotlinSurrounderUtils() {
    }

    public static void addStatementsInBlock(@NotNull JetBlockExpression block, @NotNull PsiElement[] statements) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "addStatementsInBlock"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "addStatementsInBlock"));
        }
        PsiElement lBrace = block.getFirstChild();
        block.addRangeAfter(statements[0], statements[statements.length - 1], lBrace);
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "showErrorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "showErrorHint"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "showErrorHint"));
        }
        CodeInsightUtils.showErrorHint(project, editor, message, SURROUND_WITH, null);
    }
}

