/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.JetType;

public class MoveDeclarationsOutHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiElement[] move(@NotNull PsiElement container2, @NotNull PsiElement[] statements, boolean generateDefaultInitializers) {
        if (container2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "move"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "move"));
        }
        if (statements.length == 0) {
            return statements;
        }
        Project project = container2.getProject();
        ArrayList<PsiElement> resultStatements = new ArrayList<PsiElement>();
        ArrayList<JetProperty> propertiesDeclarations = new ArrayList<JetProperty>();
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(project);
        PsiElement dummyFirstStatement = container2.addBefore((PsiElement)psiFactory.createExpression("dummyStatement"), statements[0]);
        try {
            LocalSearchScope scope2 = new LocalSearchScope(container2);
            int lastStatementOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            for (PsiElement statement : statements) {
                if (MoveDeclarationsOutHelper.needToDeclareOut(statement, lastStatementOffset, (SearchScope)scope2)) {
                    if (statement instanceof JetProperty && ((JetProperty)statement).getInitializer() != null) {
                        JetProperty property = (JetProperty)statement;
                        JetProperty declaration = MoveDeclarationsOutHelper.createVariableDeclaration(property, generateDefaultInitializers);
                        declaration = (JetProperty)container2.addBefore((PsiElement)declaration, dummyFirstStatement);
                        propertiesDeclarations.add(declaration);
                        container2.addAfter(psiFactory.createNewLine(), (PsiElement)declaration);
                        JetBinaryExpression assignment = MoveDeclarationsOutHelper.createVariableAssignment(property);
                        resultStatements.add(property.replace((PsiElement)assignment));
                        continue;
                    }
                    PsiElement newStatement = container2.addBefore(statement, dummyFirstStatement);
                    container2.addAfter(psiFactory.createNewLine(), newStatement);
                    container2.deleteChildRange(statement, statement);
                    continue;
                }
                resultStatements.add(statement);
            }
        }
        finally {
            dummyFirstStatement.delete();
        }
        ShortenReferences.DEFAULT.process(propertiesDeclarations);
        return PsiUtilCore.toPsiElementArray(resultStatements);
    }

    @NotNull
    private static JetBinaryExpression createVariableAssignment(@NotNull JetProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createVariableAssignment"));
        }
        String propertyName = property.getName();
        assert (propertyName != null) : "Property should have a name " + property.getText();
        JetBinaryExpression assignment = (JetBinaryExpression)PsiPackage.JetPsiFactory(property).createExpression(propertyName + " = x");
        JetExpression right = assignment.getRight();
        assert (right != null) : "Created binary expression should have a right part " + assignment.getText();
        JetExpression initializer = property.getInitializer();
        assert (initializer != null) : "Initializer should exist for property " + property.getText();
        right.replace((PsiElement)initializer);
        JetBinaryExpression jetBinaryExpression = assignment;
        if (jetBinaryExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createVariableAssignment"));
        }
        return jetBinaryExpression;
    }

    @NotNull
    private static JetProperty createVariableDeclaration(@NotNull JetProperty property, boolean generateDefaultInitializers) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createVariableDeclaration"));
        }
        JetType propertyType = MoveDeclarationsOutHelper.getPropertyType(property);
        String defaultInitializer = null;
        if (generateDefaultInitializers && property.isVar()) {
            defaultInitializer = CodeInsightUtils.defaultInitializer(propertyType);
        }
        JetProperty jetProperty = MoveDeclarationsOutHelper.createProperty(property, propertyType, defaultInitializer);
        if (jetProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createVariableDeclaration"));
        }
        return jetProperty;
    }

    @NotNull
    private static JetType getPropertyType(@NotNull JetProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "getPropertyType"));
        }
        BindingContext bindingContext2 = ResolvePackage.analyze(property, BodyResolveMode.PARTIAL);
        VariableDescriptor propertyDescriptor = bindingContext2.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null) : "Couldn't resolve property to property descriptor " + property.getText();
        JetType jetType = propertyDescriptor.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "getPropertyType"));
        }
        return jetType;
    }

    @NotNull
    private static JetProperty createProperty(@NotNull JetProperty property, @NotNull JetType propertyType, @Nullable String initializer) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createProperty"));
        }
        if (propertyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyType", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createProperty"));
        }
        JetTypeReference typeRef = property.getTypeReference();
        String typeString = null;
        if (typeRef != null) {
            typeString = typeRef.getText();
        } else if (!propertyType.isError()) {
            typeString = IdeDescriptorRenderers.SOURCE_CODE.renderType(propertyType);
        }
        JetProperty jetProperty = PsiPackage.JetPsiFactory(property).createProperty(property.getName(), typeString, property.isVar(), initializer);
        if (jetProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "createProperty"));
        }
        return jetProperty;
    }

    private static boolean needToDeclareOut(@NotNull PsiElement element, int lastStatementOffset, @NotNull SearchScope scope2) {
        PsiReference lastRef;
        PsiReference[] refs;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "needToDeclareOut"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/MoveDeclarationsOutHelper", "needToDeclareOut"));
        }
        return (element instanceof JetProperty || element instanceof JetClassOrObject || element instanceof JetFunction) && (refs = (PsiReference[])ReferencesSearch.search((PsiElement)element, (SearchScope)scope2, (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)).length > 0 && (lastRef = refs[refs.length - 1]).getElement().getTextOffset() > lastStatementOffset;
    }

    private MoveDeclarationsOutHelper() {
    }
}

