/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.RuntimeLibraryFiles;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.project.TargetPlatform;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryCoreUtil;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

public class KotlinJavaModuleConfigurator
extends KotlinWithLibraryConfigurator {
    public static final String NAME = "java";

    @Override
    public boolean isConfigured(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "isConfigured"));
        }
        return ProjectStructureUtil.isJavaKotlinModule(module);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        if ("KotlinJavaRuntime" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "getLibraryName"));
        }
        return "KotlinJavaRuntime";
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        if ("Create Kotlin Java Runtime Library" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "getDialogTitle"));
        }
        return "Create Kotlin Java Runtime Library";
    }

    @Override
    @NotNull
    protected String getLibraryCaption() {
        if ("Kotlin Java Runtime Library" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "getLibraryCaption"));
        }
        return "Kotlin Java Runtime Library";
    }

    @Override
    @NotNull
    protected String getMessageForOverrideDialog() {
        if ("Java Runtime Library Creation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "getMessageForOverrideDialog"));
        }
        return "Java Runtime Library Creation";
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if ("Java" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "getPresentableText"));
        }
        return "Java";
    }

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "getName"));
        }
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = TargetPlatform.JVM;
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "getTargetPlatform"));
        }
        return targetPlatform;
    }

    @Override
    @NotNull
    public RuntimeLibraryFiles getExistingJarFiles() {
        KotlinPaths paths = PathUtil.getKotlinPathsForIdeaPlugin();
        RuntimeLibraryFiles runtimeLibraryFiles = new RuntimeLibraryFiles(this.assertFileExists(paths.getRuntimePath()), this.assertFileExists(paths.getReflectPath()), this.assertFileExists(paths.getRuntimeSourcesPath()));
        if (runtimeLibraryFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "getExistingJarFiles"));
        }
        return runtimeLibraryFiles;
    }

    public void copySourcesToPathFromLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "copySourcesToPathFromLibrary"));
        }
        String dirToJarFromLibrary = KotlinJavaModuleConfigurator.getPathFromLibrary(library, OrderRootType.SOURCES);
        assert (dirToJarFromLibrary != null) : "Directory to file from library should be non null";
        this.copyFileToDir(this.getExistingJarFiles().getRuntimeSourcesJar(), dirToJarFromLibrary);
    }

    public boolean changeOldSourcesPathIfNeeded(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "changeOldSourcesPathIfNeeded"));
        }
        if (!KotlinJavaModuleConfigurator.removeOldSourcesRootIfNeeded(library)) {
            return false;
        }
        String parentDir = KotlinJavaModuleConfigurator.getPathFromLibrary(library, OrderRootType.CLASSES);
        assert (parentDir != null) : "Parent dir for classes jar should exists for Kotlin library";
        return KotlinJavaModuleConfigurator.addSourcesToLibraryIfNeeded(library, this.getExistingJarFiles().getRuntimeSourcesDestination(parentDir));
    }

    private static boolean removeOldSourcesRootIfNeeded(@NotNull Library library) {
        String[] librarySourceRoots;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "removeOldSourcesRootIfNeeded"));
        }
        VirtualFile runtimeJarPath = JavaRuntimePresentationProvider.getRuntimeJar(library);
        if (runtimeJarPath == null) {
            return false;
        }
        String oldLibrarySourceRoot = runtimeJarPath.getUrl() + "src";
        for (String sourceRoot : librarySourceRoots = library.getUrls(OrderRootType.SOURCES)) {
            if (!sourceRoot.equals(oldLibrarySourceRoot)) continue;
            final Library.ModifiableModel model = library.getModifiableModel();
            model.removeRoot(oldLibrarySourceRoot, OrderRootType.SOURCES);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    model.commit();
                }
            });
            ConfigureKotlinInProjectUtils.showInfoNotification("Source root '" + oldLibrarySourceRoot + "' was removed for " + library.getName() + " library");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isKotlinLibrary(@NotNull Project project, @NotNull Library library) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "isKotlinLibrary"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator", "isKotlinLibrary"));
        }
        if (super.isKotlinLibrary(project, library)) {
            return true;
        }
        LibraryScope scope2 = new LibraryScope(project, library);
        return KotlinRuntimeLibraryCoreUtil.getKotlinRuntimeMarkerClass(project, (GlobalSearchScope)scope2) != null;
    }

    KotlinJavaModuleConfigurator() {
    }
}

