/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.refactoring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.refactoring.JetNameValidator;
import org.jetbrains.kotlin.lexer.JetLexer;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPostfixExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class JetNameSuggester {
    private static final String[] COMMON_TYPE_PARAMETER_NAMES = new String[]{"T", "U", "V", "W", "X", "Y", "Z"};
    private static final String[] ACCESSOR_PREFIXES = new String[]{"get", "is", "set"};

    private JetNameSuggester() {
    }

    private static void addName(ArrayList<String> result2, @Nullable String name2, JetNameValidator validator2) {
        if (name2 == null) {
            return;
        }
        if ("class".equals(name2)) {
            name2 = "clazz";
        }
        if (!JetNameSuggester.isIdentifier(name2)) {
            return;
        }
        result2.add(validator2.validateName(name2));
    }

    @NotNull
    public static String[] suggestNames(@NotNull JetExpression expression2, @NotNull JetNameValidator validator2, @Nullable String defaultName) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNames"));
        }
        if (validator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNames"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        BindingContext bindingContext2 = ResolvePackage.analyze(expression2, BodyResolveMode.FULL);
        JetType jetType = bindingContext2.getType(expression2);
        if (jetType != null) {
            JetNameSuggester.addNamesForType(result2, jetType, validator2);
        }
        JetNameSuggester.addNamesForExpression(result2, expression2, validator2);
        if (result2.isEmpty()) {
            JetNameSuggester.addName(result2, defaultName, validator2);
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNames"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] suggestNames(@NotNull JetType type2, @NotNull JetNameValidator validator2, @Nullable String defaultName) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNames"));
        }
        if (validator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNames"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        JetNameSuggester.addNamesForType(result2, type2, validator2);
        if (result2.isEmpty()) {
            JetNameSuggester.addName(result2, defaultName, validator2);
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNames"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] suggestNamesForType(@NotNull JetType jetType, @NotNull JetNameValidator validator2) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForType"));
        }
        if (validator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForType"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        JetNameSuggester.addNamesForType(result2, jetType, validator2);
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForType"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] suggestNamesForExpression(@NotNull JetExpression expression2, @NotNull JetNameValidator validator2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForExpression"));
        }
        if (validator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForExpression"));
        }
        String[] stringArray = JetNameSuggester.suggestNamesForExpression(expression2, validator2, null);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForExpression"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] suggestNamesForExpression(@NotNull JetExpression expression2, @NotNull JetNameValidator validator2, @Nullable String defaultName) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForExpression"));
        }
        if (validator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForExpression"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        JetNameSuggester.addNamesForExpression(result2, expression2, validator2);
        if (result2.isEmpty()) {
            JetNameSuggester.addName(result2, defaultName, validator2);
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForExpression"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] suggestNamesForTypeParameters(int count, @NotNull JetNameValidator validator2) {
        if (validator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForTypeParameters"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            result2.add(validator2.validateNameWithVariants(COMMON_TYPE_PARAMETER_NAMES));
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester", "suggestNamesForTypeParameters"));
        }
        return stringArray;
    }

    private static void addNamesForType(ArrayList<String> result2, JetType jetType, JetNameValidator validator2) {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetTypeChecker typeChecker2 = JetTypeChecker.DEFAULT;
        if (ErrorUtils.containsErrorType(jetType = TypeUtils.makeNotNullable(jetType))) {
            return;
        }
        if (typeChecker2.equalTypes(builtIns.getBooleanType(), jetType)) {
            JetNameSuggester.addName(result2, "b", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getIntType(), jetType)) {
            JetNameSuggester.addName(result2, "i", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getByteType(), jetType)) {
            JetNameSuggester.addName(result2, "byte", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getLongType(), jetType)) {
            JetNameSuggester.addName(result2, "l", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getFloatType(), jetType)) {
            JetNameSuggester.addName(result2, "fl", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getDoubleType(), jetType)) {
            JetNameSuggester.addName(result2, "d", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getShortType(), jetType)) {
            JetNameSuggester.addName(result2, "sh", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getCharType(), jetType)) {
            JetNameSuggester.addName(result2, "c", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getStringType(), jetType)) {
            JetNameSuggester.addName(result2, "s", validator2);
        } else if (KotlinBuiltIns.isArray(jetType) || KotlinBuiltIns.isPrimitiveArray(jetType)) {
            JetType elementType = KotlinBuiltIns.getInstance().getArrayElementType(jetType);
            if (typeChecker2.equalTypes(builtIns.getBooleanType(), elementType)) {
                JetNameSuggester.addName(result2, "booleans", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getIntType(), elementType)) {
                JetNameSuggester.addName(result2, "ints", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getByteType(), elementType)) {
                JetNameSuggester.addName(result2, "bytes", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getLongType(), elementType)) {
                JetNameSuggester.addName(result2, "longs", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getFloatType(), elementType)) {
                JetNameSuggester.addName(result2, "floats", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getDoubleType(), elementType)) {
                JetNameSuggester.addName(result2, "doubles", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getShortType(), elementType)) {
                JetNameSuggester.addName(result2, "shorts", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getCharType(), elementType)) {
                JetNameSuggester.addName(result2, "chars", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getStringType(), elementType)) {
                JetNameSuggester.addName(result2, "strings", validator2);
            } else {
                ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(elementType);
                if (classDescriptor != null) {
                    Name className = classDescriptor.getName();
                    JetNameSuggester.addName(result2, "arrayOf" + StringUtil.capitalize((String)className.asString()) + "s", validator2);
                }
            }
        } else {
            JetNameSuggester.addForClassType(result2, jetType, validator2);
        }
    }

    private static void addForClassType(ArrayList<String> result2, JetType jetType, JetNameValidator validator2) {
        Name className;
        ClassifierDescriptor descriptor2 = jetType.getConstructor().getDeclarationDescriptor();
        if (descriptor2 != null && !(className = descriptor2.getName()).isSpecial()) {
            JetNameSuggester.addCamelNames(result2, className.asString(), validator2);
        }
    }

    private static void addCamelNames(ArrayList<String> result2, String name2, JetNameValidator validator2) {
        if (name2 == "") {
            return;
        }
        String s = JetNameSuggester.deleteNonLetterFromString(name2);
        for (String prefix : ACCESSOR_PREFIXES) {
            int len;
            if (!s.startsWith(prefix) || (len = prefix.length()) >= s.length() || !Character.isUpperCase(s.charAt(len))) continue;
            s = s.substring(len);
            break;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (i == 0) {
                JetNameSuggester.addName(result2, StringUtil.decapitalize((String)s), validator2);
                continue;
            }
            if (s.charAt(i) < 'A' || s.charAt(i) > 'Z') continue;
            JetNameSuggester.addName(result2, StringUtil.decapitalize((String)s.substring(i)), validator2);
        }
    }

    private static String deleteNonLetterFromString(String s) {
        Pattern pattern = Pattern.compile("[^a-zA-Z]");
        Matcher matcher = pattern.matcher(s);
        return matcher.replaceAll("");
    }

    private static void addNamesForExpression(final ArrayList<String> result2, @Nullable JetExpression expression2, final JetNameValidator validator2) {
        if (expression2 == null) {
            return;
        }
        expression2.accept(new JetVisitorVoid(){

            @Override
            public void visitQualifiedExpression(@NotNull JetQualifiedExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester$1", "visitQualifiedExpression"));
                }
                JetExpression selectorExpression = expression2.getSelectorExpression();
                JetNameSuggester.addNamesForExpression(result2, selectorExpression, validator2);
            }

            @Override
            public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester$1", "visitSimpleNameExpression"));
                }
                String referenceName = expression2.getReferencedName();
                if (referenceName.equals(referenceName.toUpperCase())) {
                    JetNameSuggester.addName(result2, referenceName, validator2);
                } else {
                    JetNameSuggester.addCamelNames(result2, referenceName, validator2);
                }
            }

            @Override
            public void visitCallExpression(@NotNull JetCallExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester$1", "visitCallExpression"));
                }
                JetNameSuggester.addNamesForExpression(result2, expression2.getCalleeExpression(), validator2);
            }

            @Override
            public void visitPostfixExpression(@NotNull JetPostfixExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/refactoring/JetNameSuggester$1", "visitPostfixExpression"));
                }
                JetNameSuggester.addNamesForExpression(result2, expression2.getBaseExpression(), validator2);
            }
        });
    }

    public static boolean isIdentifier(@Nullable String name2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (name2 == null || name2.isEmpty()) {
            return false;
        }
        JetLexer lexer = new JetLexer();
        lexer.start(name2, 0, name2.length());
        if (lexer.getTokenType() != JetTokens.IDENTIFIER) {
            return false;
        }
        lexer.advance();
        return lexer.getTokenType() == null;
    }
}

