/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.VariablesCollector;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetProperty;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class DebuggerPackage$KotlinFrameExtraVariablesProvider$086028fa {
    @NotNull
    public static final Set<TextWithImports> findAdditionalExpressions(@JetValueParameter(name="position") @NotNull SourcePosition position) {
        int endOffset;
        int startOffset;
        PsiElement containingElement;
        PsiElement elem;
        Document doc;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        int line = position.getLine();
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : (Document)null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return KotlinPackage.emptySet();
        }
        int offset = doc.getLineStartOffset(line);
        if (offset < 0) {
            return KotlinPackage.emptySet();
        }
        PsiElement psiElement = elem = file.findElementAt(offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"elem");
        JetElement jetElement = DebuggerPackage$KotlinFrameExtraVariablesProvider$086028fa.getContainingElement(psiElement);
        PsiElement psiElement2 = containingElement = jetElement != null ? (PsiElement)jetElement : elem;
        if (containingElement == null) {
            return KotlinPackage.emptySet();
        }
        TextRange limit = DebuggerPackage$KotlinFrameExtraVariablesProvider$086028fa.getLineRangeForElement(containingElement, doc);
        int startLine = Math.max(limit.getStartOffset(), line);
        while (startLine - 1 > limit.getStartOffset()) {
            PsiFile psiFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            if (!DebuggerPackage$KotlinFrameExtraVariablesProvider$086028fa.shouldSkipLine(psiFile, doc, startLine - 1)) break;
            --startLine;
        }
        int endLine = Math.min(limit.getEndOffset(), line);
        while (endLine + 1 < limit.getEndOffset()) {
            PsiFile psiFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            if (!DebuggerPackage$KotlinFrameExtraVariablesProvider$086028fa.shouldSkipLine(psiFile, doc, endLine + 1)) break;
            ++endLine;
        }
        if ((startOffset = doc.getLineStartOffset(startLine)) >= (endOffset = doc.getLineEndOffset(endLine))) {
            return KotlinPackage.emptySet();
        }
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (lineRange.isEmpty()) {
            return KotlinPackage.emptySet();
        }
        LinkedHashSet expressions = new LinkedHashSet();
        VariablesCollector variablesCollector = new VariablesCollector(lineRange, expressions);
        containingElement.accept((PsiElementVisitor)variablesCollector);
        return expressions;
    }

    @Nullable
    public static final JetElement getContainingElement(@JetValueParameter(name="element") @NotNull PsiElement element) {
        PsiElement parent;
        JetElement contElement;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        JetDeclaration jetDeclaration = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, JetDeclaration.class);
        JetElement jetElement = contElement = jetDeclaration != null ? (JetElement)jetDeclaration : (JetElement)PsiTreeUtil.getParentOfType((PsiElement)element, JetElement.class);
        if (contElement instanceof JetProperty && ((JetProperty)contElement).isLocal() && (parent = ((JetProperty)contElement).getParent()) != null) {
            return DebuggerPackage$KotlinFrameExtraVariablesProvider$086028fa.getContainingElement(parent);
        }
        if (contElement instanceof JetDeclarationWithBody) {
            return ((JetDeclarationWithBody)contElement).getBodyExpression();
        }
        return contElement;
    }

    @NotNull
    public static final TextRange getLineRangeForElement(@JetValueParameter(name="containingElement") @NotNull PsiElement containingElement, @JetValueParameter(name="doc") @NotNull Document doc) {
        Intrinsics.checkParameterIsNotNull((Object)containingElement, (String)"containingElement");
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        TextRange elemRange = containingElement.getTextRange();
        return new TextRange(doc.getLineNumber(elemRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
    }

    public static final boolean shouldSkipLine(@JetValueParameter(name="file") @NotNull PsiFile file, @JetValueParameter(name="doc") @NotNull Document doc, @JetValueParameter(name="line") int line) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        int start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \n\t");
        int end = doc.getLineEndOffset(line);
        if (start >= end) {
            return true;
        }
        PsiElement elemAtOffset = file.findElementAt(start);
        PsiElement topmostElementAtOffset = CodeInsightUtils.getTopmostElementAtOffset(elemAtOffset, start);
        return !(topmostElementAtOffset instanceof JetDeclaration);
    }
}

